/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.lang.NamedType;
import hec.model.PairedValuesExt;
import hec.rss.model.Junction;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSystem;
import hec.rss.plugins.montecarlo.client.MCInputPanel;
import hec.rss.plugins.montecarlo.client.MCRatingCurveLocationWizardPanel$1;
import hec.rss.plugins.montecarlo.client.MCVariableLocationWizardPanelImpl;
import hec.rss.plugins.montecarlo.client.MCVariableWizardDialog;
import hec.rss.plugins.montecarlo.model.MCInputRatingCurveVariable;
import hec.rss.plugins.montecarlo.model.MCInputStochasticVariableImpl;
import hec.rss.plugins.montecarlo.model.MCInputVariableImpl;
import java.util.List;
import java.util.Vector;
import javax.swing.table.TableModel;

public class MCRatingCurveLocationWizardPanel
extends MCVariableLocationWizardPanelImpl {
    public static final String PANEL_NAME = "Rating Curve Location";
    private Junction _selectedJunction = null;
    private String _selectedName = null;
    private RssAlt _alt;

    public MCRatingCurveLocationWizardPanel(MCInputPanel mCInputPanel, MCVariableWizardDialog mCVariableWizardDialog) {
        super(mCInputPanel, mCVariableWizardDialog);
        this.buildPanel();
    }

    private void buildPanel() {
        MCRatingCurveLocationWizardPanel mCRatingCurveLocationWizardPanel = this;
        super.buildPanel(mCRatingCurveLocationWizardPanel, "Rating Curves", new String[]{"Location"});
        this._variableTable.getSelectionModel().addListSelectionListener(new MCRatingCurveLocationWizardPanel$1(this));
    }

    @Override
    public void setVariableName(String string) {
        this._variableNameField.setText(string);
    }

    @Override
    public String getVariableName() {
        return this._variableNameField.getText();
    }

    @Override
    public String getPanelName() {
        return PANEL_NAME;
    }

    public void fillPanel(NamedType namedType) {
    }

    @Override
    public boolean fillCurrentPanel(RssAlt object, MCInputVariableImpl[] mCInputVariableImplArray) {
        if (mCInputVariableImplArray == null) {
            mCInputVariableImplArray = new MCInputStochasticVariableImpl[1];
        }
        this._alt = object;
        if ((object = object.getSystem()) == null) {
            return true;
        }
        this._variableTable.clearSelection();
        this._variableTable.setNumRows(0);
        this._variableTable.deleteCells();
        if (object != null) {
            object = MCInputRatingCurveVariable.getJunctionsWithRatingCurves((RssSystem)object);
            for (int i = 0; i < mCInputVariableImplArray.length; ++i) {
                this.fillList((List<Junction>)object, mCInputVariableImplArray[i]);
            }
        }
        return mCInputVariableImplArray == null || mCInputVariableImplArray[0] == null || !(mCInputVariableImplArray[0] instanceof MCInputRatingCurveVariable);
    }

    private void fillList(List<Junction> list, MCInputVariableImpl mCInputVariableImpl) {
        for (int i = 0; i < list.size(); ++i) {
            Junction junction = list.get(i);
            if (this.existsInTable(3, junction.getName(), "Stage") && (mCInputVariableImpl == null || !junction.getName().equals(mCInputVariableImpl.getLocation()) || !"Stage".equals(mCInputVariableImpl.getParameter())) || this.existsInLocationTable(junction.getName())) continue;
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(Boolean.FALSE);
            vector.add(junction.getName());
            this._variableTable.appendRow(vector);
            if (mCInputVariableImpl == null || !junction.getName().equals(mCInputVariableImpl.getLocation()) || !"Flow".equals(mCInputVariableImpl.getParameter()) && !"Stage".equals(mCInputVariableImpl.getParameter())) continue;
            this._variableTable.setSelectedIndices(new int[]{this._variableTable.getRowCount() - 1});
            this._variableTable.setValueAt((Object)Boolean.TRUE, this._variableTable.getSelectedRow(), 0);
        }
    }

    private boolean existsInLocationTable(String string) {
        for (int i = 0; i < this._variableTable.getRowCount(); ++i) {
            if (!this._variableTable.getValueAt(i, 1).equals(string)) continue;
            return true;
        }
        return false;
    }

    public void fillEditPanel(String string) {
        this._variableNameField.setText(string);
    }

    public Junction getSelectedJunction() {
        int n;
        for (n = 0; n < this._variableTable.getNumRows() && !((Boolean)this._variableTable.getValueAt(n, 0)).booleanValue(); ++n) {
        }
        this._selectedJunction = MCInputRatingCurveVariable.getJunctionByName((String)this._variableTable.getValueAt(n, 1), this._alt);
        return this._selectedJunction;
    }

    public void setSelectedJunctionName(String string) {
        this._selectedName = string;
    }

    private String getSelectedJunctionName() {
        return this._selectedName;
    }

    public int getParamID() {
        return this.getSelectedJunction().getRatingObject().getRatingCurve().getParamYId();
    }

    public TableModel getVariableTable() {
        return this._variableTable.getModel();
    }

    @Override
    public Double[] getDefaultValue(String string, String object) {
        Double[] doubleArray;
        object = MCInputRatingCurveVariable.getJunctionsWithRatingCurves(this._alt.getSystem());
        PairedValuesExt pairedValuesExt = null;
        object = object.iterator();
        while (object.hasNext()) {
            doubleArray = (Double[])object.next();
            if (!string.contains(doubleArray.getName())) continue;
            pairedValuesExt = MCInputRatingCurveVariable.getFlowVsStageCurves((Junction)doubleArray).clone();
            break;
        }
        object = pairedValuesExt.getYArray();
        doubleArray = new Double[pairedValuesExt.getYArray().length];
        for (int i = 0; i < doubleArray.length; ++i) {
            doubleArray[i] = (double)object[i];
        }
        return doubleArray;
    }

    public Double[] getDefaultValue(String string, String object, int n) {
        Double[] doubleArray;
        object = MCInputRatingCurveVariable.getJunctionsWithRatingCurves(this._alt.getSystem());
        PairedValuesExt pairedValuesExt = null;
        object = object.iterator();
        while (object.hasNext()) {
            doubleArray = (Double[])object.next();
            if (!string.contains(doubleArray.getName())) continue;
            pairedValuesExt = MCInputRatingCurveVariable.getFlowVsStageCurves((Junction)doubleArray).clone();
            break;
        }
        double[][] dArray = pairedValuesExt.getYData();
        object = dArray;
        doubleArray = new Double[dArray.length];
        for (int i = 0; i < ((Object)object).length; ++i) {
            doubleArray[i] = (double)object[i][n];
        }
        return doubleArray;
    }

    @Override
    public Double[] getDefaultValue() {
        MCRatingCurveLocationWizardPanel mCRatingCurveLocationWizardPanel = this;
        return ((MCVariableLocationWizardPanelImpl)mCRatingCurveLocationWizardPanel).getDefaultValue(((MCVariableLocationWizardPanelImpl)mCRatingCurveLocationWizardPanel).getCurrentVariableLocation(), ((MCVariableLocationWizardPanelImpl)this).getCurrentVariableParameter());
    }

    @Override
    public String getCurrentVariableLocation() {
        return (String)this.getCurrentVariableVector().get(1);
    }

    @Override
    public String getCurrentVariableParameter() {
        return (String)this.getCurrentVariableVector().get(2);
    }
}

