/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.data.Parameter;
import hec.heclib.util.HecTime;
import hec.rss.model.IndependentVariable;
import hec.rss.model.OpRule;
import hec.rss.model.OpSet;
import hec.rss.model.ReleaseFuncOpRule;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssAlt;
import hec.rss.model.StorageZone;
import hec.rss.model.TandemOpRule;
import hec.rss.plugins.montecarlo.client.MCInputPanel;
import hec.rss.plugins.montecarlo.client.MCResRuleLocationWizardPanel$1;
import hec.rss.plugins.montecarlo.client.MCVariableLocationWizardPanelImpl;
import hec.rss.plugins.montecarlo.client.MCVariableWizardDialog;
import hec.rss.plugins.montecarlo.model.MCInputResRuleVariable;
import hec.rss.plugins.montecarlo.model.MCInputStochasticVariableImpl;
import hec.rss.plugins.montecarlo.model.MCInputVariable;
import hec.rss.plugins.montecarlo.model.MCInputVariableImpl;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class MCResRuleLocationWizardPanel
extends MCVariableLocationWizardPanelImpl {
    public static final String PANEL_NAME = "Reservior Rule Parameter";
    private Vector _ruleIndex;
    private Vector _resIndex;
    private Vector _paramTypes;
    private Vector _paramIDs;
    private Vector _controllerOpIDS;
    private int _resID;
    private int _ruleID;
    private int _paramType;
    private int _controllerOpID;
    private int _paramID;
    private RssAlt _alt;
    private MCVariableWizardDialog _parent;

    public MCResRuleLocationWizardPanel(MCInputPanel mCInputPanel, MCVariableWizardDialog mCVariableWizardDialog) {
        super(mCInputPanel, mCVariableWizardDialog);
        this.buildPanel();
        this._parent = mCVariableWizardDialog;
    }

    private void buildPanel() {
        MCResRuleLocationWizardPanel mCResRuleLocationWizardPanel = this;
        super.buildPanel(mCResRuleLocationWizardPanel, "Reservoir Rule Parameters", new String[]{"Reservoir", "Rule", "Randomized Parameter"});
        this._variableTable.getSelectionModel().addListSelectionListener(new MCResRuleLocationWizardPanel$1(this));
    }

    public int getParamID() {
        return this._paramID;
    }

    public String[] getSelectedRuleParam() {
        int n = this._variableTable.getSelectedRow();
        String[] stringArray = new String[2];
        if (this._variableTable.getValueAt(n, 0) != null && this._variableTable.getValueAt(n, 0) instanceof String) {
            stringArray[0] = (String)this._variableTable.getValueAt(n, 0);
        }
        if (this._variableTable.getValueAt(n, 1) != null && this._variableTable.getValueAt(n, 1) instanceof String) {
            stringArray[0] = stringArray[0] + " - " + (String)this._variableTable.getValueAt(n, 1);
        }
        if (this._variableTable.getValueAt(n, 1) != null && this._variableTable.getValueAt(n, 1) instanceof String) {
            stringArray[1] = (String)this._variableTable.getValueAt(n, 1);
        }
        this._resID = (Integer)this._resIndex.get(n);
        this._ruleID = (Integer)this._ruleIndex.get(n);
        this._paramType = (Integer)this._paramTypes.get(n);
        this._paramID = (Integer)this._paramIDs.get(n);
        this._controllerOpID = (Integer)this._controllerOpIDS.get(n);
        return stringArray;
    }

    public int[] getSelectedIndices() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this._variableTable.getRowCount(); ++i) {
            if (!((Boolean)this._variableTable.getValueAt(i, 0)).booleanValue()) continue;
            arrayList.add(i);
        }
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        return nArray;
    }

    @Override
    public String getPanelName() {
        return PANEL_NAME;
    }

    public int getReserviorID() {
        return this._resID;
    }

    public int getReserviorID(int n) {
        return (Integer)this._resIndex.get(n);
    }

    public int getRuleID() {
        return this._ruleID;
    }

    public int getRuleID(int n) {
        this._ruleID = (Integer)this._ruleIndex.get(n);
        return this._ruleID;
    }

    public void setReserviorID(int n) {
        this._resID = n;
    }

    public void setRuleID(int n) {
        this._ruleID = n;
    }

    public int getParamType() {
        return this._paramType;
    }

    public int getParamType(int n) {
        return (Integer)this._paramTypes.get(n);
    }

    public int getControllerOpID() {
        return this._controllerOpID;
    }

    public int getControllerOpID(int n) {
        return (Integer)this._controllerOpIDS.get(n);
    }

    public void setControllerOpID(int n) {
        this._controllerOpID = n;
    }

    @Override
    public boolean fillCurrentPanel(RssAlt rssAlt, MCInputVariableImpl[] mCInputVariableImplArray) {
        int n;
        int n2;
        this._alt = rssAlt;
        Object object = rssAlt.getSystem();
        this._variableTable.clearSelection();
        this._variableTable.setNumRows(0);
        this._variableTable.deleteCells();
        if (object == null) {
            this._variableTable.setNumRows(0);
            return true;
        }
        if (mCInputVariableImplArray == null) {
            mCInputVariableImplArray = new MCInputStochasticVariableImpl[1];
        } else {
            this._paramID = mCInputVariableImplArray[0].getParamId();
        }
        object = object.getElementVectorByClass("hec.rss.model.ReservoirElement");
        new ArrayList();
        this._resIndex = new Vector();
        this._ruleIndex = new Vector();
        this._paramTypes = new Vector();
        this._paramIDs = new Vector();
        this._controllerOpIDS = new Vector();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n3 = 0;
        for (n2 = 0; n2 < ((Vector)object).size(); ++n2) {
            if (!(((Vector)object).get(n2) instanceof ReservoirElement)) continue;
            ReservoirElement reservoirElement = (ReservoirElement)((Vector)object).get(n2);
            int n4 = rssAlt.getResOpSetSelection(reservoirElement._index);
            OpSet opSet = reservoirElement.getReservoirOp().getOperationSet(n4);
            AbstractList abstractList = opSet.getZoneVector();
            for (n = 0; n < ((Vector)abstractList).size(); ++n) {
                ((StorageZone)((Vector)abstractList).get(n)).initializeCompute();
            }
            abstractList = new ArrayList();
            if (opSet != null) {
                opSet.getRules((List)abstractList);
            }
            for (n = 0; n < abstractList.size(); ++n) {
                boolean bl = false;
                boolean bl2 = false;
                OpRule opRule = (OpRule)abstractList.get(n);
                if (this.existsInTable(1, reservoirElement.getName(), opRule.getDisplayName())) {
                    if (mCInputVariableImplArray[0] == null) continue;
                    int n5 = 0;
                    for (int i = 0; i < mCInputVariableImplArray.length; ++i) {
                        if (!reservoirElement.getName().equals(mCInputVariableImplArray[i].getLocation()) || !mCInputVariableImplArray[i].getParameter().contains(opRule.getDisplayName())) continue;
                        ++n5;
                    }
                    if (n5 == 0) continue;
                }
                if (!opRule.isDnstrmRule() && !(opRule instanceof ReleaseFuncOpRule) || opRule instanceof TandemOpRule) continue;
                Object object2 = ((ReleaseFuncOpRule)opRule).getIndependentVariable();
                if (object2 != null) {
                    n3 = object2.getModelVariable().getParamId();
                    d3 = ((ReleaseFuncOpRule)opRule).getLargestLimitValue();
                    if (object2.getType() == 2 || object2.getType() == 3 || object2.getModelVariable().getType() == 3) {
                        if (IndependentVariable.TS_FUNCTION_STRINGS[2].equals(object2.getTimeSeriesFunction())) {
                            bl = true;
                            d = -object2.getTimeSeriesLag();
                        }
                        if (IndependentVariable.TS_FUNCTION_STRINGS[3].equals(object2.getTimeSeriesFunction())) {
                            bl2 = true;
                            d2 = object2.getTimeSeriesPeriod();
                        }
                    }
                }
                object2 = new Vector<Boolean>();
                ((Vector)object2).addElement(Boolean.FALSE);
                ((Vector)object2).addElement(reservoirElement.getName());
                this._resIndex.add(reservoirElement.getIndex());
                ((Vector)object2).addElement(opRule.getName());
                this._ruleIndex.add(opRule.getIndex());
                this._controllerOpIDS.add(opRule.getController().getIndex());
                ((Vector)object2).addElement("Table Values, Max Value = " + d3);
                this._variableTable.appendRow((Vector)object2);
                this._paramTypes.add(-1);
                this._paramIDs.add(n3);
                if (bl) {
                    object2 = new Vector<Boolean>();
                    ((Vector)object2).addElement(Boolean.FALSE);
                    ((Vector)object2).addElement(reservoirElement.getName());
                    ((Vector)object2).addElement(opRule.getName());
                    ((Vector)object2).addElement("TS Offset = " + d);
                    this._resIndex.add(reservoirElement.getIndex());
                    this._ruleIndex.add(opRule.getIndex());
                    this._controllerOpIDS.add(opRule.getController().getIndex());
                    this._paramTypes.add(2);
                    this._paramIDs.add(Parameter.PARAMID_TIMING_OFFSET);
                    this._variableTable.appendRow((Vector)object2);
                }
                if (!bl2) continue;
                object2 = new Vector<Boolean>();
                ((Vector)object2).addElement(Boolean.FALSE);
                ((Vector)object2).addElement(reservoirElement.getName());
                ((Vector)object2).addElement(opRule.getName());
                ((Vector)object2).addElement("TS Per Avg = " + d2);
                this._resIndex.add(reservoirElement.getIndex());
                this._ruleIndex.add(opRule.getIndex());
                this._controllerOpIDS.add(opRule.getController().getIndex());
                this._paramTypes.add(3);
                this._variableTable.appendRow((Vector)object2);
                this._paramIDs.add(Parameter.PARAMID_TIMING_PERIOD);
            }
        }
        for (n2 = 0; n2 < mCInputVariableImplArray.length; ++n2) {
            for (n = 0; n < this._variableTable.getRowCount(); ++n) {
                if (mCInputVariableImplArray[n2] == null || !this._variableTable.getValueAt(n, 1).equals(mCInputVariableImplArray[n2].getLocation()) || !this._variableTable.getValueAt(n, 2).equals(mCInputVariableImplArray[n2].getParameter())) continue;
                this._variableTable.setSelectedIndices(new int[]{n});
                this._variableTable.setValueAt((Object)Boolean.TRUE, this._variableTable.getSelectedRow(), 0);
            }
        }
        return mCInputVariableImplArray == null || mCInputVariableImplArray[0] == null || !(mCInputVariableImplArray[0] instanceof MCInputResRuleVariable);
    }

    private void setSelectedRule(String string) {
        for (int i = 0; i < this._variableTable.getRowCount(); ++i) {
            Object object = this._variableTable.getRow(i);
            if (!string.startsWith((String)(object = (String)((Vector)object).get(1)))) continue;
            int n = i;
            this._variableTable.setRowSelectionInterval(n, n, true);
        }
    }

    public void fillEditPanel(MCInputVariable mCInputVariable, String string) {
        if (mCInputVariable.getType() == 1) {
            this._variableNameField.setText(string);
            this._paramID = ((MCInputResRuleVariable)mCInputVariable).getParamId();
            this.setRuleID(((MCInputResRuleVariable)mCInputVariable).getRuleID());
            this.setReserviorID(((MCInputResRuleVariable)mCInputVariable).getReserviorID());
            this.setSelectedRule(mCInputVariable.getParameter());
        }
    }

    @Override
    public Double[] getDefaultValue() {
        MCResRuleLocationWizardPanel mCResRuleLocationWizardPanel = this;
        return mCResRuleLocationWizardPanel.getDefaultValue(((MCVariableLocationWizardPanelImpl)mCResRuleLocationWizardPanel).getCurrentVariableLocation(), ((MCVariableLocationWizardPanelImpl)this).getCurrentVariableParameter(), null);
    }

    @Override
    public Double[] getDefaultValue(String string, String string2) {
        return this.getDefaultValue(string, string2, null);
    }

    public Double[] getDefaultValue(String string, String string2, HecTime hecTime) {
        Object object = this._alt.getSystem();
        object = object.getElementVectorByClass("hec.rss.model.ReservoirElement");
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            if (!(((Vector)object).get(i) instanceof ReservoirElement)) continue;
            ReservoirElement reservoirElement = (ReservoirElement)((Vector)object).get(i);
            int n = this._alt.getResOpSetSelection(reservoirElement._index);
            OpSet opSet = reservoirElement.getReservoirOp().getOperationSet(n);
            if (opSet != null) {
                opSet.getRules(arrayList);
            }
            for (int j = 0; j < arrayList.size(); ++j) {
                IndependentVariable independentVariable;
                opSet = (OpRule)arrayList.get(j);
                if (!opSet.isDnstrmRule() && !(opSet instanceof ReleaseFuncOpRule) || opSet instanceof TandemOpRule || (independentVariable = ((ReleaseFuncOpRule)opSet).getIndependentVariable()) == null) continue;
                double d = hecTime == null ? ((ReleaseFuncOpRule)opSet).getLargestLimitValue() : ((ReleaseFuncOpRule)opSet).getSeasonalRecord().interpolate(hecTime);
                if (!string.equals(reservoirElement.getName()) || !string2.equals(opSet.getName()) && (!string2.contains(":") || !string2.substring(0, string2.indexOf(":")).equals(opSet.getName()))) continue;
                return new Double[]{d};
            }
        }
        return null;
    }

    @Override
    public String getCurrentVariableLocation() {
        return (String)this.getCurrentVariableVector().get(1);
    }

    @Override
    public String getCurrentVariableParameter() {
        return (String)this.getCurrentVariableVector().get(2);
    }

    public Double[] getDefaultValue(HecTime hecTime) {
        MCResRuleLocationWizardPanel mCResRuleLocationWizardPanel = this;
        return mCResRuleLocationWizardPanel.getDefaultValue(((MCVariableLocationWizardPanelImpl)mCResRuleLocationWizardPanel).getCurrentVariableLocation(), ((MCVariableLocationWizardPanelImpl)this).getCurrentVariableParameter(), hecTime);
    }
}

