/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.data.Parameter;
import hec.gui.WizardPanel;
import hec.rss.model.IndependentVariable;
import hec.rss.model.OpRule;
import hec.rss.model.ReleaseFuncOpRule;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssAlt;
import hec.rss.model.StorageZone;
import hec.rss.model.TandemOpRule;
import hec.rss.plugins.montecarlo.client.MCResRuleParameterWizPanel$1;
import hec.rss.plugins.montecarlo.model.MCInputResRuleVariable;
import hec.rss.plugins.montecarlo.model.MCInputVariable;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;

public class MCResRuleParameterWizPanel
extends WizardPanel {
    public static final String PANEL_NAME = "Reservior Rule Parameter";
    private RmaJTextField _variableNameField;
    private RmaJTable _ruleTable;
    private Vector _ruleIndex;
    private Vector _resIndex;
    private Vector _paramTypes;
    private Vector _paramIDs;
    private Vector _controllerOpIDS;
    private int _resID;
    private int _ruleID;
    private int _paramType;
    private int _controllerOpID;
    private int _paramID;

    public MCResRuleParameterWizPanel() {
        super((LayoutManager)new GridBagLayout());
        this.buildPanel();
    }

    private void buildPanel() {
        JLabel jLabel = new JLabel("Select Reservior Rule Parameter");
        jLabel.setFont(new Font(jLabel.getFont().getName(), 1, jLabel.getFont().getSize()));
        new GridBagConstraints();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add(jLabel, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        new GridBagConstraints();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add(jPanel, gridBagConstraints);
        jLabel = new JLabel("Variable");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._variableNameField = new RmaJTextField();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)this._variableNameField, gridBagConstraints);
        this._variableNameField.setEnabled(false);
        jLabel = new JLabel("Reservoir Rule Parameters");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5500;
        this.add(jLabel, gridBagConstraints);
        this._ruleTable = new RmaJTable((Component)((Object)this), (Object[])new String[]{"Reservior", "Rule", "Randomized Parameter"});
        this._ruleTable.setColumnSelectionAllowed(false);
        this._ruleTable.setCellSelectionEnabled(false);
        this._ruleTable.setRowSelectionAllowed(true);
        this._ruleTable.getSelectionModel().setSelectionMode(2);
        this._ruleTable.setAddRemoveEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5500;
        MCResRuleParameterWizPanel mCResRuleParameterWizPanel = this;
        mCResRuleParameterWizPanel.add(mCResRuleParameterWizPanel._ruleTable.getScrollPane(), gridBagConstraints);
        this._ruleTable.getSelectionModel().addListSelectionListener(new MCResRuleParameterWizPanel$1(this));
    }

    public void setVariableName(String string) {
        this._variableNameField.setText(string);
    }

    public String getVariableName() {
        return this._variableNameField.getText();
    }

    public int getParamID() {
        return this._paramID;
    }

    public String[] getSelectedRuleParam() {
        int n = this._ruleTable.getSelectedRow();
        String[] stringArray = new String[2];
        if (this._ruleTable.getValueAt(n, 0) != null && this._ruleTable.getValueAt(n, 0) instanceof String) {
            stringArray[0] = (String)this._ruleTable.getValueAt(n, 0);
        }
        if (this._ruleTable.getValueAt(n, 1) != null && this._ruleTable.getValueAt(n, 1) instanceof String) {
            stringArray[0] = stringArray[0] + " - " + (String)this._ruleTable.getValueAt(n, 1);
        }
        if (this._ruleTable.getValueAt(n, 1) != null && this._ruleTable.getValueAt(n, 1) instanceof String) {
            stringArray[1] = (String)this._ruleTable.getValueAt(n, 1);
        }
        this._resID = (Integer)this._resIndex.get(n);
        this._ruleID = (Integer)this._ruleIndex.get(n);
        this._paramType = (Integer)this._paramTypes.get(n);
        this._paramID = (Integer)this._paramIDs.get(n);
        this._controllerOpID = (Integer)this._controllerOpIDS.get(n);
        return stringArray;
    }

    public String getPanelName() {
        return PANEL_NAME;
    }

    public int getReserviorID() {
        return this._resID;
    }

    public int getRuleID() {
        return this._ruleID;
    }

    public void setReserviorID(int n) {
        this._resID = n;
    }

    public void setRuleID(int n) {
        this._ruleID = n;
    }

    public boolean isValidPanel() {
        return true;
    }

    public int getParamType() {
        return this._paramType;
    }

    public int getControllerOpID() {
        return this._controllerOpID;
    }

    public void setControllerOpID(int n) {
        this._controllerOpID = n;
    }

    public void fillPanel(RssAlt rssAlt) {
        Object object = rssAlt.getSystem();
        this._ruleTable.clearSelection();
        this._ruleTable.setNumRows(0);
        this._ruleTable.deleteCells();
        if (object == null) {
            this._ruleTable.setNumRows(0);
            return;
        }
        object = object.getElementVectorByClass("hec.rss.model.ReservoirElement");
        ArrayList arrayList = new ArrayList();
        this._resIndex = new Vector();
        this._ruleIndex = new Vector();
        this._paramTypes = new Vector();
        this._paramIDs = new Vector();
        this._controllerOpIDS = new Vector();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 0;
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            int n2;
            if (!(((Vector)object).get(i) instanceof ReservoirElement)) continue;
            ReservoirElement reservoirElement = (ReservoirElement)((Vector)object).get(i);
            int n3 = rssAlt.getResOpSetSelection(reservoirElement._index);
            Object object2 = reservoirElement.getReservoirOp().getOperationSet(n3);
            Vector vector = object2.getZoneVector();
            for (n2 = 0; n2 < vector.size(); ++n2) {
                ((StorageZone)vector.get(n2)).initializeCompute();
            }
            if (object2 != null) {
                object2.getRules(arrayList);
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                boolean bl = false;
                boolean bl2 = false;
                vector = (OpRule)arrayList.get(n2);
                if (!vector.isDnstrmRule() && !(vector instanceof ReleaseFuncOpRule) || vector instanceof TandemOpRule) continue;
                object2 = ((ReleaseFuncOpRule)vector).getIndependentVariable();
                if (object2 != null) {
                    n = object2.getModelVariable().getParamId();
                    d3 = ((ReleaseFuncOpRule)vector).getLargestLimitValue();
                    if (object2.getType() == 2 || object2.getType() == 3 || object2.getModelVariable().getType() == 3) {
                        if (IndependentVariable.TS_FUNCTION_STRINGS[2].equals(object2.getTimeSeriesFunction())) {
                            bl = true;
                            d = -object2.getTimeSeriesLag();
                        }
                        if (IndependentVariable.TS_FUNCTION_STRINGS[3].equals(object2.getTimeSeriesFunction())) {
                            bl2 = true;
                            d2 = object2.getTimeSeriesPeriod();
                        }
                    }
                }
                object2 = new Vector<String>();
                ((Vector)object2).addElement(reservoirElement.getName());
                this._resIndex.add(reservoirElement.getIndex());
                ((Vector)object2).addElement(vector.getName());
                this._ruleIndex.add(vector.getIndex());
                this._controllerOpIDS.add(vector.getController().getIndex());
                ((Vector)object2).addElement("Table Values, Max Value = " + d3);
                this._ruleTable.appendRow((Vector)object2);
                this._ruleTable.setRowEnabled(false, this._ruleTable.getRowCount() - 1);
                this._paramTypes.add(-1);
                this._paramIDs.add(n);
                if (bl) {
                    object2 = new Vector<String>();
                    ((Vector)object2).addElement(reservoirElement.getName());
                    ((Vector)object2).addElement(vector.getName());
                    ((Vector)object2).addElement("TS Offset = " + d);
                    this._resIndex.add(reservoirElement.getIndex());
                    this._ruleIndex.add(vector.getIndex());
                    this._controllerOpIDS.add(vector.getController().getIndex());
                    this._paramTypes.add(2);
                    this._paramIDs.add(Parameter.PARAMID_TIMING_OFFSET);
                    this._ruleTable.appendRow((Vector)object2);
                    this._ruleTable.setRowEnabled(false, this._ruleTable.getRowCount() - 1);
                }
                if (!bl2) continue;
                object2 = new Vector<String>();
                ((Vector)object2).addElement(reservoirElement.getName());
                ((Vector)object2).addElement(vector.getName());
                ((Vector)object2).addElement("TS Per Avg = " + d2);
                this._resIndex.add(reservoirElement.getIndex());
                this._ruleIndex.add(vector.getIndex());
                this._controllerOpIDS.add(vector.getController().getIndex());
                this._paramTypes.add(3);
                this._ruleTable.appendRow((Vector)object2);
                this._paramIDs.add(Parameter.PARAMID_TIMING_PERIOD);
                this._ruleTable.setRowEnabled(false, this._ruleTable.getRowCount() - 1);
            }
        }
    }

    private void setSelectedRule(String string) {
        for (int i = 0; i < this._ruleTable.getRowCount(); ++i) {
            Object object = this._ruleTable.getRow(i);
            if (!string.startsWith((String)(object = (String)((Vector)object).get(1)))) continue;
            int n = i;
            this._ruleTable.setRowSelectionInterval(n, n, true);
        }
    }

    public void fillEditPanel(MCInputVariable mCInputVariable) {
        if (mCInputVariable.getType() == 1) {
            this._variableNameField.setText(mCInputVariable.getParameterEqualString());
            this._paramID = ((MCInputResRuleVariable)mCInputVariable).getParamId();
            this.setRuleID(((MCInputResRuleVariable)mCInputVariable).getRuleID());
            this.setReserviorID(((MCInputResRuleVariable)mCInputVariable).getReserviorID());
            this.setSelectedRule(mCInputVariable.getParameter());
        }
    }
}

