/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.rss.client.AbstractScriptBuilderPanel;
import hec.rss.model.RssAlt;
import hec.rss.plugins.montecarlo.client.MCSampleScriptDialog$1;
import hec.rss.plugins.montecarlo.client.MCSampleScriptDialog$2;
import hec.rss.plugins.montecarlo.client.MCSampleScriptDialog$3;
import hec.rss.plugins.montecarlo.client.MCSampleScriptDialog$4;
import hec.rss.plugins.montecarlo.client.MCSampleScriptDialog$5;
import hec.rss.plugins.montecarlo.client.MCSampleScriptDialog$6;
import hec.rss.plugins.montecarlo.client.MCSampleScriptDialog$7;
import hec.rss.plugins.montecarlo.client.MCSampleScriptDialog$8;
import hec.rss.plugins.montecarlo.model.MCAltPluginData;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RecordableTextAction;
import rma.swing.RmaInsets;
import rma.swing.RmaJButton;
import rma.swing.RmaJDialog;
import rma.swing.event.ReflectMultiListener;

public class MCSampleScriptDialog
extends RmaJDialog {
    private JTabbedPane _tabbedPane;
    private AbstractScriptBuilderPanel _initScriptPanel;
    private AbstractScriptBuilderPanel _mainScriptPanel;
    private AbstractScriptBuilderPanel _cleanupScriptPanel;
    private boolean _preSample;
    private String _title;
    private JMenuItem _undoMenuItem;
    private JMenuItem _cutMenuItem;
    private JMenuItem _copyMenuItem;
    private JMenuItem _pasteMenuItem;
    private ReflectMultiListener _listener;
    private MCAltPluginData _data;
    private RmaJDialog _parent;
    private RmaJButton _okButton;
    private RmaJButton _applyButton;
    private RmaJButton _cancelButton;

    public MCSampleScriptDialog(RmaJDialog rmaJDialog, boolean bl, boolean bl2) {
        super((Dialog)rmaJDialog, bl);
        this._parent = rmaJDialog;
        this._preSample = bl2;
        this.setDefaultCloseOperation(0);
        this.buildControls();
    }

    private void buildControls() {
        this._listener = new ReflectMultiListener();
        this._title = this._preSample ? "Monte Carlo Script Editor (Pre-Sample): " : "Monte Carlo Script Editor (Post-Sample): ";
        MCSampleScriptDialog mCSampleScriptDialog = this;
        mCSampleScriptDialog.setTitle(mCSampleScriptDialog._title);
        this.getContentPane().setLayout(new GridBagLayout());
        this._tabbedPane = new JTabbedPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._tabbedPane, gridBagConstraints);
        this._initScriptPanel = new AbstractScriptBuilderPanel();
        this._tabbedPane.addTab("Initialization", (Component)this._initScriptPanel);
        this._mainScriptPanel = new AbstractScriptBuilderPanel();
        this._tabbedPane.addTab("Main", (Component)this._mainScriptPanel);
        this._cleanupScriptPanel = new AbstractScriptBuilderPanel();
        this._tabbedPane.addTab("CleanUp", (Component)this._cleanupScriptPanel);
        this._tabbedPane.setToolTipTextAt(0, "The script that is run during compute initialzation.");
        this._tabbedPane.setToolTipTextAt(1, "The script that is run during compute.");
        this._tabbedPane.setToolTipTextAt(2, "The script that is run during compute cleanup.");
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        this._okButton = new RmaJButton("OK");
        this._okButton.setEnabled(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._okButton, gridBagConstraints);
        this._applyButton = new RmaJButton("Apply");
        this._applyButton.setEnabled(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._applyButton, gridBagConstraints);
        this._cancelButton = new RmaJButton("Cancel");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._cancelButton, gridBagConstraints);
        this.buildMenus();
        this.addActionListeners();
        this.pack();
    }

    protected void buildMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Edit");
        jMenu.setMnemonic('E');
        jMenuBar.add(jMenu);
        jMenu.addMenuListener(new MCSampleScriptDialog$1());
        this._undoMenuItem = new JMenuItem("Undo", 85);
        this._undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        MCSampleScriptDialog mCSampleScriptDialog = this;
        this._undoMenuItem.addActionListener((ActionListener)this._listener.add((Object)mCSampleScriptDialog, (Object)mCSampleScriptDialog._undoMenuItem, "undoText"));
        jMenu.add(this._undoMenuItem);
        jMenu.addSeparator();
        this._cutMenuItem = new JMenuItem("Cut", 116);
        this._cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        MCSampleScriptDialog mCSampleScriptDialog2 = this;
        this._cutMenuItem.addActionListener((ActionListener)this._listener.add((Object)mCSampleScriptDialog2, (Object)mCSampleScriptDialog2._cutMenuItem, "cutText"));
        jMenu.add(this._cutMenuItem);
        this._copyMenuItem = new JMenuItem("Copy", 67);
        this._copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        MCSampleScriptDialog mCSampleScriptDialog3 = this;
        this._copyMenuItem.addActionListener((ActionListener)this._listener.add((Object)mCSampleScriptDialog3, (Object)mCSampleScriptDialog3._copyMenuItem, "copyText"));
        jMenu.add(this._copyMenuItem);
        this._pasteMenuItem = new JMenuItem("Paste", 80);
        this._pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        MCSampleScriptDialog mCSampleScriptDialog4 = this;
        this._pasteMenuItem.addActionListener((ActionListener)this._listener.add((Object)mCSampleScriptDialog4, (Object)mCSampleScriptDialog4._pasteMenuItem, "pasteText"));
        jMenu.add(this._pasteMenuItem);
        this.setJMenuBar(jMenuBar);
        this.updateMenus();
    }

    private void addActionListeners() {
        this._okButton.addActionListener((ActionListener)new MCSampleScriptDialog$2(this));
        this._applyButton.addActionListener((ActionListener)new MCSampleScriptDialog$3(this));
        this._cancelButton.addActionListener((ActionListener)new MCSampleScriptDialog$4(this));
        this.addWindowListener(new MCSampleScriptDialog$5(this));
        this._initScriptPanel.getScriptTextArea().addPropertyChangeListener((PropertyChangeListener)new MCSampleScriptDialog$6(this));
        this._mainScriptPanel.getScriptTextArea().addPropertyChangeListener((PropertyChangeListener)new MCSampleScriptDialog$7(this));
        this._cleanupScriptPanel.getScriptTextArea().addPropertyChangeListener((PropertyChangeListener)new MCSampleScriptDialog$8(this));
    }

    private void updateButtons() {
        if (this._data != null) {
            if (!(this._data.getMCScripts(this._preSample).getInitScript().equals(this._initScriptPanel.getScriptText()) && this._data.getMCScripts(this._preSample).getMainScript().equals(this._mainScriptPanel.getScriptText()) && this._data.getMCScripts(this._preSample).getCleanupScript().equals(this._cleanupScriptPanel.getScriptText()))) {
                this._okButton.setEnabled(true);
                this._applyButton.setEnabled(true);
                return;
            }
            this._okButton.setEnabled(false);
            this._applyButton.setEnabled(false);
        }
    }

    public void okButtonAction() {
        this.saveForm();
        this.dispose();
    }

    public void applyAction() {
        this.saveForm();
    }

    public void cancelAction() {
        this.closeEditor();
    }

    public void closeEditor() {
        if (!(this._data.getMCScripts(this._preSample).getInitScript().equals(this._initScriptPanel.getScriptText()) && this._data.getMCScripts(this._preSample).getMainScript().equals(this._mainScriptPanel.getScriptText()) && this._data.getMCScripts(this._preSample).getCleanupScript().equals(this._cleanupScriptPanel.getScriptText()))) {
            int n = JOptionPane.showConfirmDialog((Component)((Object)this), "Save Changes?", "Save Changes", 1);
            if (n == 2) {
                return;
            }
            if (n == 0) {
                this.saveForm();
            } else if (n == 1) {
                this.setModified(false);
            }
        }
        this.setVisible(false);
    }

    public void cutText() {
        AbstractScriptBuilderPanel abstractScriptBuilderPanel = (AbstractScriptBuilderPanel)this._tabbedPane.getSelectedComponent();
        abstractScriptBuilderPanel.cut();
    }

    public void copyText() {
        AbstractScriptBuilderPanel abstractScriptBuilderPanel = (AbstractScriptBuilderPanel)this._tabbedPane.getSelectedComponent();
        abstractScriptBuilderPanel.copy();
    }

    public void pasteText() {
        AbstractScriptBuilderPanel abstractScriptBuilderPanel = (AbstractScriptBuilderPanel)this._tabbedPane.getSelectedComponent();
        abstractScriptBuilderPanel.paste();
    }

    private void updateMenus() {
        AbstractScriptBuilderPanel abstractScriptBuilderPanel = (AbstractScriptBuilderPanel)this._tabbedPane.getSelectedComponent();
        abstractScriptBuilderPanel.getScriptTextArea();
        RecordableTextAction recordableTextAction = RTextArea.getAction((int)6);
        this._undoMenuItem.setAction((Action)recordableTextAction);
        boolean bl = abstractScriptBuilderPanel.getScriptTextArea().getSelectedText() != null;
        this._cutMenuItem.setEnabled(bl);
        this._copyMenuItem.setEnabled(bl);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        boolean bl2 = clipboard.getContents(null) != null;
        this._pasteMenuItem.setEnabled(bl2);
    }

    public void fillPanel(MCAltPluginData mCAltPluginData, RssAlt rssAlt) {
        this._data = mCAltPluginData;
        String string = null;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        for (int i = 0; i < this._tabbedPane.getComponentCount(); ++i) {
            if (rssAlt == null) {
                ((DefaultTreeModel)((AbstractScriptBuilderPanel)this._tabbedPane.getComponentAt(i)).getTree().getModel()).setRoot(defaultMutableTreeNode);
                return;
            }
            ((AbstractScriptBuilderPanel)this._tabbedPane.getComponentAt(i)).setNetwork(rssAlt.getSystem());
            ((AbstractScriptBuilderPanel)this._tabbedPane.getComponentAt(i)).loadTree("hec/rss/plugins/montecarlo/client/MCScriptTree.xml");
            if (this._tabbedPane.getTitleAt(i).equals("Initialization")) {
                string = mCAltPluginData.getMCScripts(this._preSample).getInitScript();
            } else if (this._tabbedPane.getTitleAt(i).equals("Main")) {
                string = mCAltPluginData.getMCScripts(this._preSample).getMainScript();
            } else if (this._tabbedPane.getTitleAt(i).equals("CleanUp")) {
                string = mCAltPluginData.getMCScripts(this._preSample).getCleanupScript();
            }
            ((AbstractScriptBuilderPanel)this._tabbedPane.getComponent(i)).setScriptText(string);
        }
        this.updateMenus();
    }

    protected void saveForm() {
        String string = this._initScriptPanel.getScriptText();
        String string2 = this._mainScriptPanel.getScriptText();
        String string3 = this._cleanupScriptPanel.getScriptText();
        this._data.setMCScripts(string, string2, string3, this._preSample);
        this._okButton.setEnabled(false);
        this._applyButton.setEnabled(false);
        this.setModified(false);
        this._parent.setModified(true);
    }
}

