/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.heclib.util.HecTime;
import hec.model.SeasonalPairedValues;
import hec.model.SeasonalRecord;
import hec.rss.model.DownstreamCntrlOpRule;
import hec.rss.model.IndependentVariable;
import hec.rss.model.OpRule;
import hec.rss.model.ReleaseFuncOpRule;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssAlt;
import hec.rss.model.TandemOpRule;
import hec.rss.plugins.montecarlo.client.MCContinuousDistributionWizardPanelImpl;
import hec.rss.plugins.montecarlo.client.MCVariableWizardDialog;
import hec.rss.plugins.montecarlo.model.MCInputClippedDataVariable;
import hec.rss.plugins.montecarlo.model.MCInputLookbackVariable;
import hec.rss.plugins.montecarlo.model.MCInputResRuleVariable;
import hec.rss.plugins.montecarlo.model.MCInputStochasticVariableImpl;
import hec.rss.plugins.montecarlo.model.MCInputTSMultiplierVariable;
import hec.rss.plugins.montecarlo.model.MCInputVariable;
import hec.rss.plugins.montecarlo.model.MCInputVariableImpl;
import hec.rss.plugins.montecarlo.model.SeasonalContinuousDistribution;
import hec.statistics.AbstractContDist;
import hec.statistics.ClipDist;
import hec.statistics.EmpiricalClipDist;
import hec.statistics.EmpiricalDist;
import hec.statistics.GammaDist;
import hec.statistics.Log10NormalB17BDist;
import hec.statistics.LogNormalDist;
import hec.statistics.NormalDist;
import hec.statistics.TriangDist;
import hec.statistics.UnifDist;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class MCScalarDistributionWizardPanel
extends MCContinuousDistributionWizardPanelImpl {
    public static final String PANEL_NAME = "LookbackDistribution";

    public MCScalarDistributionWizardPanel(MCVariableWizardDialog mCVariableWizardDialog) {
        super(mCVariableWizardDialog);
        this._parent = mCVariableWizardDialog;
    }

    public String getPanelName() {
        return PANEL_NAME;
    }

    public boolean isValidPanel() {
        return true;
    }

    public int getDistributionType() {
        String string = (String)this._distributionType.getSelectedItem();
        if ((string = this._distMap.get(string).getDistribution()) instanceof SeasonalContinuousDistribution) {
            string = ((SeasonalContinuousDistribution)((Object)string)).getDist();
        }
        if (string instanceof NormalDist) {
            return 1;
        }
        if (string instanceof UnifDist) {
            return 2;
        }
        if (string instanceof TriangDist) {
            return 3;
        }
        if (string instanceof LogNormalDist) {
            return 4;
        }
        if (string instanceof Log10NormalB17BDist) {
            return 7;
        }
        if (string instanceof GammaDist) {
            return 5;
        }
        if (string instanceof EmpiricalDist) {
            if (((EmpiricalDist)string).getInterpType() == EmpiricalDist.InterpType.LINEAR) {
                return 6;
            }
            return 0;
        }
        return 0;
    }

    public MCInputVariable[] getInputVariable(List<String> object) {
        MCInputVariable[] mCInputVariableArray = new MCInputClippedDataVariable[object.size()];
        int n = -1;
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            ++n;
            Object object2 = string;
            object2 = ((String)object2).substring(((String)object2).indexOf("-") + 1, ((String)object2).length());
            String string2 = ((String)object2).substring(0, ((String)object2).indexOf(":"));
            string2 = string2.trim();
            String string3 = object2;
            object2 = string3.substring(string3.indexOf(":") + 1, ((String)object2).length());
            if (((String)object2).contains(":")) {
                object2 = ((String)object2).substring(0, ((String)object2).indexOf(":"));
            }
            object2 = ((String)object2).trim();
            object2 = ((String)object2).trim();
            if (string.contains("Lookback")) {
                object2 = new MCInputLookbackVariable(string2, (String)object2, this.getDistributionType());
            } else if (string.contains("Reservoir")) {
                if (((String)object2).contains(",")) {
                    object2 = ((String)object2).substring(0, ((String)object2).indexOf(44));
                }
                int n2 = this._parent.getMCResRulePanel().getSelectedIndices()[n];
                object2 = new MCInputResRuleVariable(string2, (String)object2, this.getDistributionType());
                ((MCInputResRuleVariable)object2).setReserviorID(this._parent.getMCResRulePanel().getReserviorID(n2));
                ((MCInputResRuleVariable)object2).setRuleID(this._parent.getMCResRulePanel().getRuleID(n2));
                ((MCInputResRuleVariable)object2).setParamType(this._parent.getMCResRulePanel().getParamType(n2));
                ((MCInputResRuleVariable)object2).setControllerOpID(this._parent.getMCResRulePanel().getControllerOpID(n2));
            } else {
                object2 = new MCInputTSMultiplierVariable(string2, (String)object2, this.getDistributionType());
            }
            ((MCInputVariableImpl)object2).setParamId(this._paramID);
            ((MCInputVariableImpl)object2).setParameterEqualString(string);
            String string4 = (String)this._distributionType.getSelectedItem();
            if (string4.equals(this._normalPanel.getName())) {
                ((MCInputClippedDataVariable)object2).setClipDist((ClipDist)this._normalPanel.getDistribution());
                ((MCInputStochasticVariableImpl)object2).setDistributionType(1);
                ((MCInputVariableImpl)object2).setDependentVariableNames(this._normalPanel.getDependentVariableNames());
            } else if (string4.equals(this._uniformPanel.getName())) {
                ((MCInputClippedDataVariable)object2).setClipDist((ClipDist)this._uniformPanel.getDistribution());
                ((MCInputStochasticVariableImpl)object2).setDistributionType(2);
                ((MCInputVariableImpl)object2).setDependentVariableNames(this._uniformPanel.getDependentVariableNames());
            } else if (string4.equals(this._logNormal10Panel.getName())) {
                ((MCInputClippedDataVariable)object2).setClipDist((ClipDist)this._logNormal10Panel.getDistribution());
                ((MCInputStochasticVariableImpl)object2).setDistributionType(7);
                ((MCInputVariableImpl)object2).setDependentVariableNames(this._logNormal10Panel.getDependentVariableNames());
            } else if (string4.equals(this._triangularPanel.getName())) {
                ((MCInputClippedDataVariable)object2).setClipDist((ClipDist)this._triangularPanel.getDistribution());
                ((MCInputStochasticVariableImpl)object2).setDistributionType(3);
                ((MCInputVariableImpl)object2).setDependentVariableNames(this._triangularPanel.getDependentVariableNames());
            } else if (string4.equals(this._logNormalPanel.getName())) {
                ((MCInputClippedDataVariable)object2).setClipDist((ClipDist)this._logNormalPanel.getDistribution());
                ((MCInputStochasticVariableImpl)object2).setDistributionType(4);
                ((MCInputVariableImpl)object2).setDependentVariableNames(this._logNormalPanel.getDependentVariableNames());
            } else if (string4.equals(this._gammaPanel.getName())) {
                ((MCInputClippedDataVariable)object2).setClipDist((ClipDist)this._gammaPanel.getDistribution());
                ((MCInputStochasticVariableImpl)object2).setDistributionType(5);
                ((MCInputVariableImpl)object2).setDependentVariableNames(this._gammaPanel.getDependentVariableNames());
            } else if (string4.equals(this._empiricalPanel.getName())) {
                if (this._empiricalPanel.getDistribution() instanceof SeasonalContinuousDistribution) {
                    ((MCInputClippedDataVariable)object2).setClipDist((SeasonalContinuousDistribution)this._empiricalPanel.getDistribution());
                    ((MCInputStochasticVariableImpl)object2).setDistributionType(6);
                } else {
                    string = (EmpiricalDist)this._empiricalPanel.getDistribution();
                    string2 = new EmpiricalClipDist();
                    string2.setInterpType(string.getInterpType());
                    string2.setCumProbs(string.getCumProbs());
                    string2.setValues(string.getValues());
                    ((MCInputClippedDataVariable)object2).setClipDist((ClipDist)string2);
                    ((MCInputStochasticVariableImpl)object2).setDistributionType(6);
                }
            } else if (string4.equals(this._discretePanel.getName())) {
                if (this._discretePanel.getDistribution() instanceof SeasonalContinuousDistribution) {
                    ((MCInputClippedDataVariable)object2).setClipDist((SeasonalContinuousDistribution)this._discretePanel.getDistribution());
                    ((MCInputStochasticVariableImpl)object2).setDistributionType(0);
                } else {
                    string = (EmpiricalDist)this._discretePanel.getDistribution();
                    string2 = new EmpiricalClipDist();
                    string2.setInterpType(string.getInterpType());
                    string2.setCumProbs(string.getCumProbs());
                    string2.setValues(string.getValues());
                    ((MCInputClippedDataVariable)object2).setClipDist((ClipDist)string2);
                    ((MCInputStochasticVariableImpl)object2).setDistributionType(0);
                }
            }
            ((MCInputStochasticVariableImpl)object2).setReference(this._isRelative);
            ((MCInputStochasticVariableImpl)object2).setSeasonality(this.isSeasonal());
            if (mCInputVariableArray.length > 1) {
                ((MCInputVariableImpl)object2).setGroupNumber(Integer.valueOf(this._variableNameField.getText().substring(this._variableNameField.getText().indexOf(":") + 1, this._variableNameField.getText().length())));
            } else {
                ((MCInputVariableImpl)object2).setGroupNumber(0);
            }
            mCInputVariableArray[n] = object2;
        }
        return mCInputVariableArray;
    }

    public void fillEditPanel(MCInputStochasticVariableImpl mCInputStochasticVariableImpl, String object) {
        this._variableNameField.setText((String)object);
        if (mCInputStochasticVariableImpl != null && mCInputStochasticVariableImpl instanceof MCInputClippedDataVariable) {
            object = (MCInputClippedDataVariable)mCInputStochasticVariableImpl;
            this._paramID = ((MCInputVariableImpl)object).getParamId();
            if (mCInputStochasticVariableImpl instanceof MCInputResRuleVariable) {
                this._parent.getMCResRulePanel().setRuleID(((MCInputResRuleVariable)mCInputStochasticVariableImpl).getRuleID());
                this._parent.getMCResRulePanel().setReserviorID(((MCInputResRuleVariable)mCInputStochasticVariableImpl).getReserviorID());
                this._parent.getMCResRulePanel().setControllerOpID(((MCInputResRuleVariable)mCInputStochasticVariableImpl).getControllerOpID());
            }
            if (mCInputStochasticVariableImpl.getDistributionType() == 1) {
                this._distributionType.setSelectedItem(this._normalPanel.getName());
                this._normalPanel.fillPanel((AbstractContDist)((MCInputClippedDataVariable)object).getClipDist(), ((MCInputVariableImpl)object).getParamId(), ((MCInputVariableImpl)object).getInputVariableNames());
                return;
            }
            if (mCInputStochasticVariableImpl.getDistributionType() == 2) {
                this._distributionType.setSelectedItem(this._uniformPanel.getName());
                this._uniformPanel.fillPanel((AbstractContDist)((MCInputClippedDataVariable)object).getClipDist(), ((MCInputVariableImpl)object).getParamId(), ((MCInputVariableImpl)object).getInputVariableNames());
                return;
            }
            if (mCInputStochasticVariableImpl.getDistributionType() == 3) {
                this._distributionType.setSelectedItem(this._triangularPanel.getName());
                this._triangularPanel.fillPanel((AbstractContDist)((MCInputClippedDataVariable)object).getClipDist(), ((MCInputVariableImpl)object).getParamId(), ((MCInputVariableImpl)object).getInputVariableNames());
                return;
            }
            if (mCInputStochasticVariableImpl.getDistributionType() == 7) {
                this._distributionType.setSelectedItem(this._logNormal10Panel.getName());
                this._logNormal10Panel.fillPanel((AbstractContDist)((MCInputClippedDataVariable)object).getClipDist(), ((MCInputVariableImpl)object).getParamId(), ((MCInputVariableImpl)object).getInputVariableNames());
                return;
            }
            if (mCInputStochasticVariableImpl.getDistributionType() == 4) {
                this._distributionType.setSelectedItem(this._logNormalPanel.getName());
                this._logNormalPanel.fillPanel((AbstractContDist)((MCInputClippedDataVariable)object).getClipDist(), ((MCInputVariableImpl)object).getParamId(), ((MCInputVariableImpl)object).getInputVariableNames());
                return;
            }
            if (mCInputStochasticVariableImpl.getDistributionType() == 5) {
                this._distributionType.setSelectedItem(this._gammaPanel.getName());
                this._gammaPanel.fillPanel((AbstractContDist)((MCInputClippedDataVariable)object).getClipDist(), ((MCInputVariableImpl)object).getParamId(), ((MCInputVariableImpl)object).getInputVariableNames());
                return;
            }
            if (mCInputStochasticVariableImpl.getDistributionType() == 6 || mCInputStochasticVariableImpl.getDistributionType() == 0) {
                if (mCInputStochasticVariableImpl.getDist() instanceof SeasonalContinuousDistribution) {
                    if (((EmpiricalDist)((SeasonalContinuousDistribution)mCInputStochasticVariableImpl.getDist()).getDist()).getInterpType() == EmpiricalDist.InterpType.LINEAR) {
                        this._empiricalPanel.fillPanel(mCInputStochasticVariableImpl.getDist(), mCInputStochasticVariableImpl.getParamId(), new HashMap<Integer, String>());
                        this._distributionType.setSelectedItem(this._empiricalPanel.getName());
                        return;
                    }
                    this._discretePanel.fillPanel(mCInputStochasticVariableImpl.getDist(), mCInputStochasticVariableImpl.getParamId(), new HashMap<Integer, String>());
                    this._distributionType.setSelectedItem(this._discretePanel.getName());
                    return;
                }
                if (((EmpiricalDist)mCInputStochasticVariableImpl.getDist()).getInterpType() == EmpiricalDist.InterpType.LINEAR) {
                    this._distributionType.setSelectedItem(this._empiricalPanel.getName());
                    object = (EmpiricalDist)mCInputStochasticVariableImpl.getDist();
                    EmpiricalDist empiricalDist = new EmpiricalDist();
                    empiricalDist.setInterpType(object.getInterpType());
                    empiricalDist.setCumProbs(object.getCumProbs());
                    empiricalDist.setValues(object.getValues());
                    this._empiricalPanel.fillPanel((AbstractContDist)empiricalDist, mCInputStochasticVariableImpl.getParamId(), new HashMap<Integer, String>());
                    return;
                }
                this._distributionType.setSelectedItem(this._discretePanel.getName());
                object = (EmpiricalDist)mCInputStochasticVariableImpl.getDist();
                EmpiricalDist empiricalDist = new EmpiricalDist();
                empiricalDist.setInterpType(object.getInterpType());
                empiricalDist.setCumProbs(object.getCumProbs());
                empiricalDist.setValues(object.getValues());
                this._discretePanel.fillPanel((AbstractContDist)empiricalDist, mCInputStochasticVariableImpl.getParamId(), new HashMap<Integer, String>());
            }
        }
    }

    public HecTime[] getDates(List<String> hecTimeArray, RssAlt object) {
        int n;
        block17: {
            hecTimeArray = hecTimeArray.get(0);
            String string = hecTimeArray;
            string = hecTimeArray.substring(string.indexOf("-") + 1, string.length());
            String string2 = string.substring(0, string.indexOf(":"));
            string2.trim();
            String string3 = string;
            string = string3.substring(string3.indexOf(":") + 1, string.length());
            if (string.contains(":")) {
                string = string.substring(0, string.indexOf(":"));
            }
            if ((string = string.trim()).contains("=")) {
                string = string.substring(0, string.indexOf("="));
            }
            string.trim();
            if (hecTimeArray.contains("Lookback")) {
                hecTimeArray = new HecTime[]{new HecTime(1440, 11)};
            } else if (hecTimeArray.contains("Reservoir")) {
                hecTimeArray = new HecTime[]{new HecTime(1440, 11)};
                object = object.getSystem().getElementVectorByClass(ReservoirElement.class);
                int n2 = this._parent.getMCResRulePanel().getSelectedIndices()[0];
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    IndependentVariable independentVariable;
                    ReservoirElement reservoirElement = (ReservoirElement)((Vector)object).get(i);
                    if (reservoirElement == null || reservoirElement.getIndex() != this._parent.getMCResRulePanel().getReserviorID(n2) || (reservoirElement = reservoirElement.getReservoirOp()) == null || (reservoirElement = reservoirElement.getController(this._parent.getMCResRulePanel().getControllerOpID(n2))) == null || (reservoirElement = reservoirElement.getRule(this._parent.getMCResRulePanel().getRuleID(n2))) == null || !reservoirElement.isDnstrmRule() && !(reservoirElement instanceof ReleaseFuncOpRule) || reservoirElement instanceof TandemOpRule || (independentVariable = ((ReleaseFuncOpRule)reservoirElement).getIndependentVariable()) == null) continue;
                    if (this._parent.getMCResRulePanel().getParamType(n2) == 2 || this._parent.getMCResRulePanel().getParamType(n2) == 3) break;
                    switch (independentVariable.getType()) {
                        case 0: 
                        case 1: {
                            object = ((ReleaseFuncOpRule)reservoirElement).getSeasonalRecord();
                            hecTimeArray = new HecTime[object.getTimeArray().length];
                            for (n2 = 0; n2 < object.getTimeArray().length; ++n2) {
                                hecTimeArray[n2] = new HecTime(object.getTimeArray()[n2], 11);
                            }
                            break block17;
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            object = ((ReleaseFuncOpRule)reservoirElement).getFunctionRelease();
                            hecTimeArray = new HecTime[object.getTimeArray().length];
                            for (n2 = 0; n2 < object.getTimeArray().length; ++n2) {
                                hecTimeArray[n2] = new HecTime(object.getTimeArray()[n2], 11);
                            }
                        }
                        default: {
                            break;
                        }
                    }
                    break;
                }
            } else {
                hecTimeArray = new HecTime[]{new HecTime(1440, 11)};
            }
        }
        object = new ArrayList();
        boolean bl = false;
        for (n = 0; n < hecTimeArray.length; ++n) {
            for (int i = 0; i < object.size(); ++i) {
                if (hecTimeArray[n].day() == ((HecTime)object.get(i)).day() && hecTimeArray[n].month() == ((HecTime)object.get(i)).month()) {
                    bl = true;
                    break;
                }
                bl = false;
            }
            if (bl) continue;
            object.add(hecTimeArray[n]);
        }
        hecTimeArray = new HecTime[object.size()];
        for (n = 0; n < object.size(); ++n) {
            hecTimeArray[n] = (HecTime)object.get(n);
            hecTimeArray[n].showTimeAsBeginningOfDay(true);
        }
        return hecTimeArray;
    }

    public Double[] getDefaultValues(String string, RssAlt object, HecTime[] hecTimeArray) {
        Double[] doubleArray;
        block19: {
            String string2;
            doubleArray = null;
            String string3 = string2 = string;
            string3 = string2.substring(string3.indexOf("-") + 1, string3.length());
            String string4 = string3.substring(0, string3.indexOf(":"));
            string4 = string4.trim();
            String string5 = string3;
            String string6 = string5.substring(string5.indexOf(":") + 1, string3.length());
            if (string6.contains(":")) {
                string6 = string6.substring(0, string6.indexOf(":"));
            }
            string6 = string6.trim();
            string6 = string6.trim();
            if (string2.contains("Lookback")) {
                String string7 = string3;
                object = string7.substring(string7.indexOf(":") + 1, string3.length());
                object = ((String)object).substring(((String)object).indexOf(":") + 1, ((String)object).length()).trim();
                doubleArray = new Double[]{Double.valueOf((String)object)};
            } else if (string2.contains("Reservoir")) {
                object = object.getSystem().getElementVectorByClass(ReservoirElement.class);
                int n = this._parent.getMCResRulePanel().getIndexByName(string);
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    int n2;
                    string3 = (ReservoirElement)((Vector)object).get(i);
                    if (string3 == null || !string3.getName().equals(string4)) continue;
                    int n3 = this._parent._alt.getResOpSetSelection(((ReservoirElement)string3)._index);
                    string3 = string3.getReservoirOp().getOperationSet(n3);
                    ArrayList arrayList = new ArrayList();
                    if (string3 != null) {
                        string3.getRules(arrayList);
                    }
                    string3 = null;
                    Object object2 = null;
                    for (n2 = 0; !(n2 >= arrayList.size() || (object2 = (string3 = (OpRule)arrayList.get(n2)).isDnstrmRule() ? ((DownstreamCntrlOpRule)string3).getIndependentVariable() : (string3 instanceof ReleaseFuncOpRule ? ((ReleaseFuncOpRule)string3).getIndependentVariable() : null)) != null && string6.equals(string3.getName())); ++n2) {
                    }
                    if (string3 == null || !string3.isDnstrmRule() && !(string3 instanceof ReleaseFuncOpRule) || string3 instanceof TandemOpRule || object2 == null) continue;
                    if (this._parent.getMCResRulePanel().getParamType(n) == 2) {
                        doubleArray = new Double[hecTimeArray.length];
                        for (n2 = 0; n2 < hecTimeArray.length; ++n2) {
                            doubleArray[n2] = object2.getTimeSeriesLag();
                        }
                        break;
                    }
                    if (this._parent.getMCResRulePanel().getParamType(n) == 3) {
                        doubleArray = new Double[hecTimeArray.length];
                        for (n2 = 0; n2 < hecTimeArray.length; ++n2) {
                            doubleArray[n2] = object2.getTimeSeriesLag();
                        }
                        break;
                    }
                    switch (object2.getType()) {
                        case 0: 
                        case 1: {
                            SeasonalRecord seasonalRecord = string3.isDnstrmRule() ? ((DownstreamCntrlOpRule)string3).getSeasonalRecord() : ((ReleaseFuncOpRule)string3).getSeasonalRecord();
                            doubleArray = new Double[hecTimeArray.length];
                            for (n = 0; n < hecTimeArray.length; ++n) {
                                doubleArray[n] = seasonalRecord.interpolate(hecTimeArray[n]);
                            }
                            break block19;
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            SeasonalPairedValues seasonalPairedValues = string3.isDnstrmRule() ? ((DownstreamCntrlOpRule)string3).getFunctionRelease() : ((ReleaseFuncOpRule)string3).getFunctionRelease();
                            doubleArray = new Double[hecTimeArray.length];
                            double[][] dArray = seasonalPairedValues.getYData();
                            for (int j = 0; j < hecTimeArray.length; ++j) {
                                double d = Double.NEGATIVE_INFINITY;
                                for (i = 0; i < dArray[0].length; ++i) {
                                    if (!(d < seasonalPairedValues.interpolate(hecTimeArray[j], seasonalPairedValues.getXValue(i)))) continue;
                                    d = seasonalPairedValues.interpolate(hecTimeArray[j], seasonalPairedValues.getXValue(i));
                                }
                                doubleArray[j] = d;
                            }
                        }
                    }
                    break;
                }
            } else {
                doubleArray = new Double[]{1.0};
            }
        }
        return doubleArray;
    }
}

