/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.clientapp.model.TSRecordProxy;
import hec.lang.NamedType;
import hec.rss.model.HindcastData;
import hec.rss.model.Junction;
import hec.rss.model.OpRule;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssAlt;
import hec.rss.model.RssModelVariableSet;
import hec.rss.plugins.montecarlo.client.MCInputPanel;
import hec.rss.plugins.montecarlo.client.MCScriptLocationWizardPanel$1;
import hec.rss.plugins.montecarlo.client.MCScriptLocationWizardPanel$2;
import hec.rss.plugins.montecarlo.client.MCScriptLocationWizardPanel$3;
import hec.rss.plugins.montecarlo.client.MCVariableLocationWizardPanelImpl;
import hec.rss.plugins.montecarlo.client.MCVariableWizardDialog;
import hec.rss.plugins.montecarlo.model.MCAltPluginData;
import hec.rss.plugins.montecarlo.model.MCInputRatingCurveVariable;
import hec.rss.plugins.montecarlo.model.MCInputScriptVariable;
import hec.rss.plugins.montecarlo.model.MCInputVariable;
import hec.rss.plugins.montecarlo.model.MCInputVariableImpl;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJLabel;
import rma.swing.RmaJPanel;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;

public class MCScriptLocationWizardPanel
extends MCVariableLocationWizardPanelImpl {
    public static final String PANEL_NAME = "Script Location";
    int _paramID;
    private RmaJTextField _variableTypeField;
    private RmaJComboBox<String> _variableLocationField;
    private RmaJComboBox<String> _variableParameterField;
    private HashMap<String, List<String>> _locationsMap;
    private Map<String, List<String>> _parametersMap;
    private MCVariableWizardDialog _parent;
    private MCInputVariableImpl _variable;

    public MCScriptLocationWizardPanel(MCInputPanel mCInputPanel, MCVariableWizardDialog mCVariableWizardDialog) {
        super(mCInputPanel, mCVariableWizardDialog);
        this._parent = mCVariableWizardDialog;
        this.buildPanel();
        this.addActionListeners();
    }

    private void buildPanel() {
        this._variableTable = new RmaJTable();
        this._variableTable.clear();
        JLabel jLabel = new JLabel("Select Location and Parameter");
        jLabel.setFont(new Font(jLabel.getFont().getName(), 1, jLabel.getFont().getSize()));
        new GridBagConstraints();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add(jLabel, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add(jPanel, gridBagConstraints);
        jLabel = new JLabel("Variable");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._variableNameField = new RmaJTextField();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)this._variableNameField, gridBagConstraints);
        this._variableNameField.setEnabled(false);
        jLabel = new JLabel("Script");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5500;
        this.add(jLabel, gridBagConstraints);
        jLabel = new RmaJPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5500;
        this.add(jLabel, gridBagConstraints);
        jPanel = new RmaJLabel("Script Name:");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        jLabel.add(jPanel, gridBagConstraints);
        this._variableTypeField = new RmaJTextField();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        jLabel.add((Component)this._variableTypeField, gridBagConstraints);
        jPanel = new RmaJLabel("Location:");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        jLabel.add(jPanel, gridBagConstraints);
        this._variableLocationField = new RmaJComboBox();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        jLabel.add((Component)this._variableLocationField, gridBagConstraints);
        jPanel = new RmaJLabel("Parameter:");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        jLabel.add(jPanel, gridBagConstraints);
        this._variableParameterField = new RmaJComboBox();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        jLabel.add((Component)this._variableParameterField, gridBagConstraints);
    }

    private void addActionListeners() {
        this._variableTypeField.addFocusListener((FocusListener)new MCScriptLocationWizardPanel$1(this));
        this._variableLocationField.addActionListener((ActionListener)new MCScriptLocationWizardPanel$2(this));
        this._variableParameterField.addActionListener((ActionListener)new MCScriptLocationWizardPanel$3(this));
    }

    /*
     * Unable to fully structure code
     */
    private void checkValidity() {
        if (this.getVariableParameter() == null || this.getVariableParameter().equals("") || this.getVariableLocation() == null || this.getVariableLocation().equals("") || this.getDescription() == null || this.getDescription().equals("")) ** GOTO lbl-1000
        v0 = this;
        if (v0.isUniqueDescription(v0.getDescription())) {
            this._isValid = true;
        } else lbl-1000:
        // 2 sources

        {
            this._isValid = false;
        }
        this._parent.setValidPanelControlsNextButton(true);
    }

    private boolean isUniqueDescription(String string) {
        boolean bl = true;
        Object object = ((MCAltPluginData)this._parent._alt.getAltPluginData("Monte Carlo")).getInputVariables();
        object = object.iterator();
        while (object.hasNext()) {
            MCInputVariableImpl mCInputVariableImpl = (MCInputVariableImpl)object.next();
            if (!(mCInputVariableImpl instanceof MCInputScriptVariable) || !((MCInputScriptVariable)mCInputVariableImpl).getDescription().equals(string) || ((MCInputScriptVariable)this._variable).getDescription().equals(string)) continue;
            bl = false;
        }
        return bl;
    }

    private void resetVariableName() {
        String string = "Script - " + this._variableTypeField.getText() + ":" + String.valueOf(this._variableLocationField.getSelectedItem()) + ":" + String.valueOf(this._variableParameterField.getSelectedItem());
        this.setVariableName(string);
    }

    private void updateParameterComboBox() {
        Iterator<String> iterator = (String)this._variableLocationField.getSelectedItem();
        String string = (String)this._variableParameterField.getSelectedItem();
        String string222 = null;
        if (this._locationsMap != null && this._parametersMap != null) {
            for (String object2 : this._locationsMap.keySet()) {
                if (!this._locationsMap.get(object2).contains(iterator)) continue;
                string222 = object2;
                break;
            }
            HashSet hashSet = new HashSet();
            if (string222 != null) {
                if (string222.equals("junctions")) {
                    hashSet.add("ratingPars");
                } else if (!string222.equals("reaches")) {
                    if (string222.equals("reservoirs")) {
                        hashSet.add("rulePars");
                        hashSet.add("lookbackPars");
                    } else if (string222.equals("tsLocations")) {
                        hashSet.add("timeSeriesPars");
                    }
                }
                this._variableParameterField.removeAllItems();
                this._variableParameterField.addItem((Object)"");
                Iterator iterator2 = hashSet.iterator();
                while (iterator2.hasNext()) {
                    iterator = (String)iterator2.next();
                    for (String string222 : this._parametersMap.get(iterator)) {
                        this._variableParameterField.addItem((Object)string222);
                    }
                }
                this._variableParameterField.setSelectedItem((Object)string);
                return;
            }
            hashSet.add("rulePars");
            hashSet.add("lookbackPars");
            hashSet.add("timeSeriesPars");
            hashSet.add("ratingPars");
            this._variableParameterField.removeAllItems();
            this._variableParameterField.addItem((Object)"");
            Iterator iterator3 = hashSet.iterator();
            while (iterator3.hasNext()) {
                iterator = (String)iterator3.next();
                for (String string222 : this._parametersMap.get(iterator)) {
                    this._variableParameterField.addItem((Object)string222);
                }
            }
            this._variableParameterField.setSelectedItem((Object)string);
        }
    }

    private void updateLocationComboBox() {
        Iterator<String> iterator = (String)this._variableParameterField.getSelectedItem();
        String string = (String)this._variableLocationField.getSelectedItem();
        String string222 = null;
        if (this._parametersMap != null && this._locationsMap != null) {
            for (String object2 : this._parametersMap.keySet()) {
                if (!this._parametersMap.get(object2).contains(iterator)) continue;
                string222 = object2;
                break;
            }
            HashSet hashSet = new HashSet();
            if (string222 != null) {
                if (string222.equals("ratingPars")) {
                    hashSet.add("junctions");
                } else if (string222.equals("rulePars") || string222.equals("lookbackPars")) {
                    hashSet.add("reservoirs");
                } else if (string222.equals("timeSeriesPars")) {
                    hashSet.add("tsLocations");
                }
                this._variableLocationField.removeAllItems();
                this._variableLocationField.addItem((Object)"");
                Iterator iterator2 = hashSet.iterator();
                while (iterator2.hasNext()) {
                    iterator = (String)iterator2.next();
                    for (String string222 : this._locationsMap.get(iterator)) {
                        this._variableLocationField.addItem((Object)string222);
                    }
                }
                this._variableLocationField.setSelectedItem((Object)string);
                return;
            }
            hashSet.add("junctions");
            hashSet.add("reservoirs");
            hashSet.add("tsLocations");
            hashSet.add("reaches");
            this._variableLocationField.removeAllItems();
            this._variableLocationField.addItem((Object)"");
            Iterator iterator3 = hashSet.iterator();
            while (iterator3.hasNext()) {
                iterator = (String)iterator3.next();
                for (String string222 : this._locationsMap.get(iterator)) {
                    this._variableLocationField.addItem((Object)string222);
                }
            }
            this._variableLocationField.setSelectedItem((Object)string);
        }
    }

    @Override
    public String getPanelName() {
        return PANEL_NAME;
    }

    public void fillPanel(NamedType namedType) {
    }

    public int getParamID() {
        return this._paramID;
    }

    @Override
    public boolean fillCurrentPanel(RssAlt rssAlt, MCInputVariableImpl[] mCInputVariableImplArray) {
        this._variable = mCInputVariableImplArray != null ? mCInputVariableImplArray[0] : null;
        this._locationsMap = this.getLocations(rssAlt);
        this._variableLocationField.addItem((Object)"");
        for (String string : this._locationsMap.keySet()) {
            for (String string2 : this._locationsMap.get(string)) {
                this._variableLocationField.addItem((Object)string2);
            }
        }
        this._parametersMap = this.getParameters(rssAlt);
        this._variableParameterField.addItem((Object)"");
        for (String string : this._parametersMap.keySet()) {
            for (String string2 : this._parametersMap.get(string)) {
                this._variableParameterField.addItem((Object)string2);
            }
        }
        if (mCInputVariableImplArray != null && mCInputVariableImplArray[0] != null && mCInputVariableImplArray[0] instanceof MCInputScriptVariable) {
            this._variableTypeField.setText(((MCInputScriptVariable)mCInputVariableImplArray[0]).getDescription());
            this._variableLocationField.setSelectedItem((Object)mCInputVariableImplArray[0].getLocation());
            this._variableParameterField.setSelectedItem((Object)mCInputVariableImplArray[0].getParameter());
        }
        return mCInputVariableImplArray == null || mCInputVariableImplArray[0] == null || !(mCInputVariableImplArray[0] instanceof MCInputScriptVariable);
    }

    private Map<String, List<String>> getParameters(RssAlt rssAlt) {
        int n;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        Cloneable cloneable = rssAlt.getSystem().getElementVectorByClass("hec.rss.model.ReservoirElement");
        for (int i = 0; i < ((Vector)cloneable).size(); ++i) {
            if (!(((Vector)cloneable).get(i) instanceof ReservoirElement)) continue;
            object = (ReservoirElement)((Vector)cloneable).get(i);
            int n2 = rssAlt.getResOpSetSelection(((ReservoirElement)object)._index);
            object = object.getReservoirOp().getOperationSet(n2);
            ArrayList arrayList2 = new ArrayList();
            if (object == null) continue;
            object.getRules(arrayList2);
            for (n = 0; n < arrayList2.size(); ++n) {
                arrayList.add(((OpRule)arrayList2.get(n)).getDisplayName());
            }
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        object = MCInputRatingCurveVariable.getJunctionsWithRatingCurves(rssAlt.getSystem());
        if (object.size() > 0) {
            arrayList3.add("Stage");
        }
        ArrayList<String> arrayList4 = new ArrayList<String>();
        object = rssAlt.getHindcastData();
        if (object != null) {
            int n3 = ((Vector)object).size();
            for (n = 0; n < n3; ++n) {
                cloneable = (HindcastData)((Vector)object).elementAt(n);
                if (cloneable.getType() != 1) continue;
                arrayList4.add(RssModelVariableSet.getVariableName((int)cloneable.getVariableId()));
            }
        }
        ArrayList<String> arrayList5 = new ArrayList<String>();
        Vector vector = rssAlt.getSystem().getActiveTSProxies(null, 1);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                rssAlt = (TSRecordProxy)vector.elementAt(i);
                if (rssAlt == null) continue;
                arrayList5.add(RssModelVariableSet.getVariableName((int)rssAlt.getVariableId()));
            }
        }
        cloneable = new HashMap<String, ArrayList<String>>();
        cloneable.put("ratingPars", arrayList3);
        cloneable.put("rulePars", arrayList);
        cloneable.put("lookbackPars", arrayList4);
        cloneable.put("timeSeriesPars", arrayList5);
        return cloneable;
    }

    private HashMap<String, List<String>> getLocations(RssAlt object) {
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object3 = MCInputRatingCurveVariable.getJunctionsWithRatingCurves(object.getSystem());
        object3 = object3.iterator();
        while (object3.hasNext()) {
            object2 = (Junction)object3.next();
            arrayList.add(object2.getName());
        }
        object3 = object.getSystem().getReachNames();
        object2 = new ArrayList();
        for (int i = 0; i < ((String[])object3).length; ++i) {
            object2.add(object3[i]);
        }
        String[] stringArray = object.getSystem().getReservoirNames();
        object3 = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            object3.add(stringArray[i]);
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if ((object = object.getSystem().getActiveTSProxies(null, 1)) != null) {
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                TSRecordProxy tSRecordProxy = (TSRecordProxy)((Vector)object).elementAt(i);
                arrayList2.add(tSRecordProxy.getName());
            }
        }
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        hashMap.put("junctions", arrayList);
        hashMap.put("reaches", (List<String>)object2);
        hashMap.put("reservoirs", (List<String>)object3);
        hashMap.put("tsLocations", arrayList2);
        return hashMap;
    }

    public void fillEditPanel(MCInputVariable mCInputVariable, String string) {
    }

    @Override
    public String getCurrentVariableLocation() {
        return null;
    }

    @Override
    public String getCurrentVariableParameter() {
        return null;
    }

    @Override
    public Double[] getDefaultValue() {
        return null;
    }

    @Override
    public Double[] getDefaultValue(String string, String string2) {
        return null;
    }

    public String getVariableParameter() {
        return (String)this._variableParameterField.getSelectedItem();
    }

    public String getVariableLocation() {
        return (String)this._variableLocationField.getSelectedItem();
    }

    public String getDescription() {
        return this._variableTypeField.getText();
    }
}

