/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.gui.WizardPanel;
import hec.rss.model.RssAlt;
import hec.rss.plugins.montecarlo.client.MCVariableScriptBuilderPanel;
import hec.rss.plugins.montecarlo.client.MCVariableWizardDialog;
import hec.rss.plugins.montecarlo.model.MCInputScriptVariable;
import hec.rss.plugins.montecarlo.model.MCInputVariableImpl;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import mil.army.usace.hec.script.gui.AbstractScriptBuilderPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJLabel;
import rma.swing.RmaJTextField;

public class MCScriptWizardPanel
extends WizardPanel {
    public static final String PANEL_NAME = "Script Writer Panel";
    private JTabbedPane _tabbedPane;
    private MCVariableScriptBuilderPanel _initScriptPanel;
    private MCVariableScriptBuilderPanel _mainScriptPanel;
    private MCVariableScriptBuilderPanel _cleanupScriptPanel;
    private RmaJTextField _variableParameterField;
    private RmaJTextField _variableLocationField;
    private RmaJTextField _variableTypeField;
    private int _paramId;
    private MCVariableWizardDialog _parent;

    public MCScriptWizardPanel(MCVariableWizardDialog mCVariableWizardDialog) {
        this._parent = mCVariableWizardDialog;
        this.buildControls();
    }

    private void buildControls() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add(jPanel, gridBagConstraints);
        RmaJLabel rmaJLabel = new RmaJLabel("Script Variable:");
        rmaJLabel.setFont(new Font(rmaJLabel.getFont().getName(), 1, rmaJLabel.getFont().getSize()));
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)rmaJLabel, gridBagConstraints);
        rmaJLabel = new RmaJLabel("Script Name:");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)rmaJLabel, gridBagConstraints);
        this._variableTypeField = new RmaJTextField();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)this._variableTypeField, gridBagConstraints);
        this._variableTypeField.setEnabled(false);
        rmaJLabel = new RmaJLabel("Location:");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)rmaJLabel, gridBagConstraints);
        this._variableLocationField = new RmaJTextField();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)this._variableLocationField, gridBagConstraints);
        this._variableLocationField.setEnabled(false);
        rmaJLabel = new RmaJLabel("Parameter:");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)rmaJLabel, gridBagConstraints);
        this._variableParameterField = new RmaJTextField();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)this._variableParameterField, gridBagConstraints);
        this._variableParameterField.setEnabled(false);
        this._tabbedPane = new JTabbedPane();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        MCScriptWizardPanel mCScriptWizardPanel = this;
        mCScriptWizardPanel.add(mCScriptWizardPanel._tabbedPane, gridBagConstraints);
        this._initScriptPanel = new MCVariableScriptBuilderPanel();
        this._tabbedPane.addTab("Initialization", (Component)((Object)this._initScriptPanel));
        this._mainScriptPanel = new MCVariableScriptBuilderPanel();
        this._tabbedPane.addTab("Main", (Component)((Object)this._mainScriptPanel));
        this._cleanupScriptPanel = new MCVariableScriptBuilderPanel();
        this._tabbedPane.addTab("CleanUp", (Component)((Object)this._cleanupScriptPanel));
    }

    public void cutText() {
        MCVariableScriptBuilderPanel mCVariableScriptBuilderPanel = (MCVariableScriptBuilderPanel)((Object)this._tabbedPane.getSelectedComponent());
        mCVariableScriptBuilderPanel.cut();
    }

    public void copyText() {
        MCVariableScriptBuilderPanel mCVariableScriptBuilderPanel = (MCVariableScriptBuilderPanel)((Object)this._tabbedPane.getSelectedComponent());
        mCVariableScriptBuilderPanel.copy();
    }

    public void pasteText() {
        MCVariableScriptBuilderPanel mCVariableScriptBuilderPanel = (MCVariableScriptBuilderPanel)((Object)this._tabbedPane.getSelectedComponent());
        mCVariableScriptBuilderPanel.paste();
    }

    public void fillPanel(RssAlt rssAlt) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        for (int i = 0; i < this._tabbedPane.getComponentCount(); ++i) {
            if (rssAlt == null) {
                ((DefaultTreeModel)((MCVariableScriptBuilderPanel)((Object)this._tabbedPane.getComponentAt(i))).getTree().getModel()).setRoot(defaultMutableTreeNode);
                return;
            }
            ((MCVariableScriptBuilderPanel)((Object)this._tabbedPane.getComponentAt(i))).setNetwork(rssAlt.getSystem());
            ((MCVariableScriptBuilderPanel)((Object)this._tabbedPane.getComponentAt(i))).loadTree("hec/rss/plugins/montecarlo/client/MCScriptTree.xml");
            if (i == 0) {
                ((MCVariableScriptBuilderPanel)((Object)this._tabbedPane.getComponent(i))).setScriptText(this.getInitInitialText());
                continue;
            }
            if (i == 1) {
                ((MCVariableScriptBuilderPanel)((Object)this._tabbedPane.getComponent(i))).setScriptText(this.getMainInitialText());
                continue;
            }
            ((MCVariableScriptBuilderPanel)((Object)this._tabbedPane.getComponent(i))).setScriptText(this.getCleanupInitialText());
        }
        this._tabbedPane.setSelectedIndex(1);
    }

    public void fillEditPanel(RssAlt rssAlt, MCInputScriptVariable mCInputScriptVariable) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        for (int i = 0; i < this._tabbedPane.getComponentCount(); ++i) {
            if (rssAlt == null) {
                ((DefaultTreeModel)((MCVariableScriptBuilderPanel)((Object)this._tabbedPane.getComponentAt(i))).getTree().getModel()).setRoot(defaultMutableTreeNode);
                return;
            }
            ((MCVariableScriptBuilderPanel)((Object)this._tabbedPane.getComponentAt(i))).setNetwork(rssAlt.getSystem());
            if (i > 0) {
                ((MCVariableScriptBuilderPanel)((Object)this._tabbedPane.getComponentAt(i))).setTree((AbstractScriptBuilderPanel.DraggableTree)((MCVariableScriptBuilderPanel)((Object)this._tabbedPane.getComponentAt(i - 1))).getTree());
            } else {
                ((MCVariableScriptBuilderPanel)((Object)this._tabbedPane.getComponentAt(i))).loadTree("hec/rss/plugins/montecarlo/client/MCScriptTree.xml");
            }
            ((MCVariableScriptBuilderPanel)((Object)this._tabbedPane.getComponent(i))).setScriptText(mCInputScriptVariable.getScript(i));
        }
        this.setVariableName(mCInputScriptVariable.getParameter());
        this.setVariableLocation(mCInputScriptVariable.getLocation());
        this.setVariableType(mCInputScriptVariable.getDescription());
        this._tabbedPane.setSelectedIndex(1);
    }

    private void replaceStringInScript(String string, String string2) {
        for (int i = 0; i < this._tabbedPane.getComponentCount(); ++i) {
            String string3 = ((MCVariableScriptBuilderPanel)((Object)this._tabbedPane.getComponent(i))).getScriptText();
            int n = string3.indexOf(string + " = ") + string.length() + 4;
            string3 = string3.substring(n, string3.length());
            string3 = string3.substring(0, string3.indexOf("\""));
            int n2 = n + string3.length();
            Object object = ((MCVariableScriptBuilderPanel)((Object)this._tabbedPane.getComponent(i))).getScriptText();
            object = ((String)object).substring(0, n) + string2 + ((String)object).substring(n2, ((String)object).length());
            ((MCVariableScriptBuilderPanel)((Object)this._tabbedPane.getComponent(i))).setScriptText((String)object);
        }
    }

    private String getMainInitialText() {
        String string = "# runScript() script is the entry point that is called during the compute\n#\n# randomValue is the standard uniform number sampled in the ResSim compute\n\ndef runScript(randomVal, mcData) :\n\t\n\t#name, location and parameter\n\tname = \"\"\n\tlocation = \"\"\n\tparameter = \"\"\n\t\n\t#add your code here\n\t\n\t\n\t\n\t#change the scriptVal to the desired output\n\tscriptVal = randomVal\n\t\n\t#return the operation value\n\treturn scriptVal\n";
        return "# runScript() script is the entry point that is called during the compute\n#\n# randomValue is the standard uniform number sampled in the ResSim compute\n\ndef runScript(randomVal, mcData) :\n\t\n\t#name, location and parameter\n\tname = \"\"\n\tlocation = \"\"\n\tparameter = \"\"\n\t\n\t#add your code here\n\t\n\t\n\t\n\t#change the scriptVal to the desired output\n\tscriptVal = randomVal\n\t\n\t#return the operation value\n\treturn scriptVal\n";
    }

    private String getInitInitialText() {
        String string = "# runScript() script is performed prior to sampling in the MC compute\n#\n\ndef runScript(mcData) :\n\t\n\t#name, location and parameter\n\tname = \"\"\n\tlocation = \"\"\n\tparameter = \"\"\n\t\n\t#add your code here\n\t\n";
        return "# runScript() script is performed prior to sampling in the MC compute\n#\n\ndef runScript(mcData) :\n\t\n\t#name, location and parameter\n\tname = \"\"\n\tlocation = \"\"\n\tparameter = \"\"\n\t\n\t#add your code here\n\t\n";
    }

    private String getCleanupInitialText() {
        String string = "# runScript() script is performed after the all of the sampling in the MC compute\n#\ndef runScript(mcData) :\n\t\n\t#name, location and parameter\n\tname = \"\"\n\tlocation = \"\"\n\tparameter = \"\"\n\t\n\t#add your code here\n\t\n";
        return "# runScript() script is performed after the all of the sampling in the MC compute\n#\ndef runScript(mcData) :\n\t\n\t#name, location and parameter\n\tname = \"\"\n\tlocation = \"\"\n\tparameter = \"\"\n\t\n\t#add your code here\n\t\n";
    }

    public boolean isValidPanel() {
        return true;
    }

    public String getPanelName() {
        return PANEL_NAME;
    }

    public void setVariableNames(List<String> list) {
        if (list.size() == 1) {
            this._variableParameterField.setText(list.get(0));
            return;
        }
        this._variableParameterField.setText("Multiple Variables");
    }

    public void setVariableLocation(String string) {
        this.replaceStringInScript("location", string);
        this._variableLocationField.setText(string);
    }

    public void setVariableType(String string) {
        this.replaceStringInScript("name", string);
        this._variableTypeField.setText(string);
    }

    public void setVariableName(String string) {
        this.replaceStringInScript("parameter", string);
        this._variableParameterField.setText(string);
    }

    public String getVariableName() {
        return this._variableParameterField.getText();
    }

    public MCInputVariableImpl[] getInputVariable(RssAlt object) {
        MCInputVariableImpl[] mCInputVariableImplArray = new MCInputScriptVariable[1];
        MCInputVariableImpl[] mCInputVariableImplArray2 = mCInputVariableImplArray;
        mCInputVariableImplArray[0] = new MCInputScriptVariable(this._variableLocationField.getText(), this._variableParameterField.getText(), this._paramId, (RssAlt)object);
        mCInputVariableImplArray2[0].setDescription(this._variableTypeField.getText().substring(this._variableTypeField.getText().indexOf(":") + 1, this._variableTypeField.getText().length()));
        object = object.getDataSetPath();
        String string = ((String)object).substring(((String)object).lastIndexOf("/") + 1).substring(((String)object).lastIndexOf("\\") + 1);
        object = ((String)object).substring(0, ((String)object).indexOf(string));
        mCInputVariableImplArray2[0].setSavePath((String)object);
        mCInputVariableImplArray2[0].setInitScript(this._initScriptPanel.getScriptText());
        mCInputVariableImplArray2[0].setMainScript(this._mainScriptPanel.getScriptText());
        mCInputVariableImplArray2[0].setCleanupScript(this._cleanupScriptPanel.getScriptText());
        return mCInputVariableImplArray2;
    }

    public Object getVariableLocation() {
        return this._variableLocationField.getText();
    }

    public Object getVariableDescription() {
        return this._variableTypeField.getText();
    }
}

