/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.clientapp.model.TSRecordProxy;
import hec.rss.model.RssAlt;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssSystem;
import hec.rss.plugins.montecarlo.client.MCInputPanel;
import hec.rss.plugins.montecarlo.client.MCVariableLocationWizardPanelImpl;
import hec.rss.plugins.montecarlo.client.MCVariableWizardDialog;
import hec.rss.plugins.montecarlo.model.MCInputStochasticVariableImpl;
import hec.rss.plugins.montecarlo.model.MCInputTSVariable;
import hec.rss.plugins.montecarlo.model.MCInputVariableImpl;
import java.lang.invoke.CallSite;
import java.util.Vector;

public class MCTSLocationWizardPanel
extends MCVariableLocationWizardPanelImpl {
    public static final String PANEL_NAME = "TS Location and Parameter";

    public MCTSLocationWizardPanel(MCInputPanel mCInputPanel, MCVariableWizardDialog mCVariableWizardDialog) {
        super(mCInputPanel, mCVariableWizardDialog);
        this.buildPanel();
    }

    private void buildPanel() {
        MCTSLocationWizardPanel mCTSLocationWizardPanel = this;
        super.buildPanel(mCTSLocationWizardPanel, "Time Series", new String[]{"Location", "Variable"});
    }

    @Override
    public String getPanelName() {
        return PANEL_NAME;
    }

    @Override
    public boolean fillCurrentPanel(RssAlt object, MCInputVariableImpl[] mCInputVariableImplArray) {
        int n;
        RssSystem rssSystem = object.getSystem();
        if (rssSystem == null) {
            return true;
        }
        if (object.getInputTSDataSet() == null) {
            return true;
        }
        object.getInputTSDataSet();
        this._variableTable.clearSelection();
        this._variableTable.setNumRows(0);
        this._variableTable.deleteCells();
        if (rssSystem == null) {
            this._variableTable.setNumRows(0);
            return true;
        }
        object = rssSystem.getActiveTSProxies(null, 1);
        if (object == null) {
            return true;
        }
        if (mCInputVariableImplArray == null) {
            mCInputVariableImplArray = new MCInputStochasticVariableImpl[1];
        }
        Vector<CallSite> vector = new Vector<CallSite>();
        for (n = 0; n < ((Vector)object).size(); ++n) {
            Object object2 = (TSRecordProxy)((Vector)object).elementAt(n);
            if (object2 == null) continue;
            Vector<Object> vector2 = new Vector<Object>();
            vector2.addElement(Boolean.FALSE);
            String string = rssSystem.getNameForKeyString(object2.getName());
            object2 = RssModelVariableSet.getVariableName((int)object2.getVariableId());
            String string2 = string + "-" + (String)object2;
            if (vector.contains(string2) || this.existsInTable(0, string, (String)object2) || this.existsInTable(4, string, (String)object2)) {
                int n2;
                if (mCInputVariableImplArray[0] == null) continue;
                for (n2 = 0; n2 < mCInputVariableImplArray.length && string.equals(mCInputVariableImplArray[n2].getLocation()) && ((String)object2).equals(mCInputVariableImplArray[n2].getParameter()); ++n2) {
                }
                if (n2 != mCInputVariableImplArray.length) continue;
            }
            vector2.addElement(string);
            vector2.addElement(object2);
            vector.addElement((CallSite)((Object)string2));
            this._variableTable.appendRow(vector2);
        }
        for (n = 0; n < mCInputVariableImplArray.length; ++n) {
            for (int i = 0; i < this._variableTable.getRowCount(); ++i) {
                if (mCInputVariableImplArray[n] == null || !this._variableTable.getValueAt(i, 1).equals(mCInputVariableImplArray[n].getLocation()) || !this._variableTable.getValueAt(i, 2).equals(mCInputVariableImplArray[n].getParameter())) continue;
                this._variableTable.setSelectedIndices(new int[]{i});
                this._variableTable.setValueAt((Object)Boolean.TRUE, this._variableTable.getSelectedRow(), 0);
            }
        }
        return mCInputVariableImplArray == null || mCInputVariableImplArray[0] == null || !(mCInputVariableImplArray[0] instanceof MCInputTSVariable);
    }

    public void fillEditPanel(MCInputStochasticVariableImpl mCInputStochasticVariableImpl) {
        if (mCInputStochasticVariableImpl.getDistributionType() == 0) {
            this._variableNameField.setText(((MCInputVariableImpl)mCInputStochasticVariableImpl).getParameterEqualString());
        }
    }

    @Override
    public Double[] getDefaultValue() {
        return null;
    }

    @Override
    public Double[] getDefaultValue(String string, String string2) {
        return null;
    }

    @Override
    public String getCurrentVariableLocation() {
        return null;
    }

    @Override
    public String getCurrentVariableParameter() {
        return null;
    }
}

