/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.rss.model.InflowLocationFactor;
import hec.rss.model.JunctionElement;
import hec.rss.model.RssAlt;
import hec.rss.plugins.montecarlo.client.MCInputPanel;
import hec.rss.plugins.montecarlo.client.MCTSMultiplierLocationWizardPanel$1;
import hec.rss.plugins.montecarlo.client.MCVariableLocationWizardPanelImpl;
import hec.rss.plugins.montecarlo.client.MCVariableWizardDialog;
import hec.rss.plugins.montecarlo.model.MCInputStochasticVariableImpl;
import hec.rss.plugins.montecarlo.model.MCInputTSMultiplierVariable;
import hec.rss.plugins.montecarlo.model.MCInputVariableImpl;
import java.util.List;
import java.util.Vector;

public class MCTSMultiplierLocationWizardPanel
extends MCVariableLocationWizardPanelImpl {
    public static final String PANEL_NAME = "TS Multiplier Location and Parameter";
    private int _paramID;
    private RssAlt _alt;

    public MCTSMultiplierLocationWizardPanel(MCInputPanel mCInputPanel, MCVariableWizardDialog mCVariableWizardDialog) {
        super(mCInputPanel, mCVariableWizardDialog);
        this.buildPanel();
    }

    private void buildPanel() {
        MCTSMultiplierLocationWizardPanel mCTSMultiplierLocationWizardPanel = this;
        super.buildPanel(mCTSMultiplierLocationWizardPanel, "Time Series Multiplier", new String[]{"Location", "Time Series", "Value"});
        this._variableTable.getSelectionModel().addListSelectionListener(new MCTSMultiplierLocationWizardPanel$1(this));
    }

    @Override
    public String getPanelName() {
        return PANEL_NAME;
    }

    @Override
    public boolean fillCurrentPanel(RssAlt rssAlt, MCInputVariableImpl[] mCInputVariableImplArray) {
        int n;
        this._alt = rssAlt;
        this._variableTable.clearSelection();
        this._variableTable.setNumRows(0);
        this._variableTable.deleteCells();
        if (mCInputVariableImplArray == null || mCInputVariableImplArray[0] == null) {
            mCInputVariableImplArray = new MCInputStochasticVariableImpl[1];
        } else {
            this._paramID = mCInputVariableImplArray[0].getParamId();
        }
        List list = rssAlt.getLocationInflowFactors();
        for (n = 0; n < list.size() + 1; ++n) {
            String string;
            String string2;
            Object object;
            InflowLocationFactor inflowLocationFactor = null;
            if (n < list.size()) {
                inflowLocationFactor = (InflowLocationFactor)list.get(n);
                object = rssAlt.getSystem().getObjectForKeyString(inflowLocationFactor.getJunctionId());
                if (object == null) continue;
                string2 = ((JunctionElement)object).getName();
                string = inflowLocationFactor.getLocalFlowName();
            } else {
                string2 = "GlobalInflowMultiplier";
                string = "GlobalInflowMultiplier";
            }
            if (this.existsInTable(4, string2, string) && !this.existInVariableArray(mCInputVariableImplArray, string2, string)) continue;
            object = new Vector<Boolean>();
            ((Vector)object).addElement(Boolean.FALSE);
            ((Vector)object).addElement(string2);
            ((Vector)object).addElement(string);
            if (n == list.size()) {
                ((Vector)object).addElement(String.valueOf(rssAlt.getGlobalInflowFactor()));
            } else {
                ((Vector)object).addElement(String.valueOf(inflowLocationFactor.getFactor()));
            }
            this._variableTable.appendRow((Vector)object);
        }
        for (n = 0; n < mCInputVariableImplArray.length; ++n) {
            for (int i = 0; i < this._variableTable.getRowCount(); ++i) {
                if (mCInputVariableImplArray[n] == null || !this._variableTable.getValueAt(i, 1).equals(mCInputVariableImplArray[n].getLocation()) || !this._variableTable.getValueAt(i, 2).equals(mCInputVariableImplArray[n].getParameter())) continue;
                this._variableTable.setSelectedIndices(new int[]{i});
                this._variableTable.setValueAt((Object)Boolean.TRUE, this._variableTable.getSelectedRow(), 0);
            }
        }
        return mCInputVariableImplArray == null || mCInputVariableImplArray[0] == null || !(mCInputVariableImplArray[0] instanceof MCInputTSMultiplierVariable);
    }

    private boolean existInVariableArray(MCInputVariableImpl[] mCInputVariableImplArray, String string, String string2) {
        if (mCInputVariableImplArray == null || mCInputVariableImplArray[0] == null) {
            return false;
        }
        for (int i = 0; i < mCInputVariableImplArray.length; ++i) {
            if (!mCInputVariableImplArray[i].getLocation().equals(string) || !mCInputVariableImplArray[i].getParameter().equals(string2)) continue;
            return true;
        }
        return false;
    }

    public void fillEditPanel(MCInputStochasticVariableImpl mCInputStochasticVariableImpl, String string) {
        this._variableNameField.setText(string);
    }

    public int getParamID() {
        return this._paramID;
    }

    @Override
    public Double[] getDefaultValue() {
        String string = ((MCVariableLocationWizardPanelImpl)this).getCurrentVariableLocation();
        String string2 = ((MCVariableLocationWizardPanelImpl)this).getCurrentVariableParameter();
        Double[] doubleArray = new Double[1];
        if (string.equals("GlobalInflowMultiplier")) {
            doubleArray[0] = this._alt.getGlobalInflowFactor();
        } else {
            Object object = this._alt.getLocationInflowFactors();
            object = object.iterator();
            while (object.hasNext()) {
                InflowLocationFactor inflowLocationFactor = (InflowLocationFactor)object.next();
                Object object2 = this._alt.getSystem().getObjectForKeyString(inflowLocationFactor.getJunctionId());
                if (object2 == null) continue;
                object2 = ((JunctionElement)object2).getName();
                String string3 = inflowLocationFactor.getLocalFlowName();
                if (!string.equals(object2) || !string2.equals(string3)) continue;
                doubleArray[0] = inflowLocationFactor.getFactor();
            }
        }
        return doubleArray;
    }

    @Override
    public String getCurrentVariableLocation() {
        return (String)this.getCurrentVariableVector().get(1);
    }

    @Override
    public String getCurrentVariableParameter() {
        return (String)this.getCurrentVariableVector().get(2);
    }

    @Override
    public Double[] getDefaultValue(String string, String string2) {
        Double[] doubleArray = new Double[1];
        if (string.equals("GlobalInflowMultiplier")) {
            doubleArray[0] = this._alt.getGlobalInflowFactor();
        } else {
            Object object = this._alt.getLocationInflowFactors();
            object = object.iterator();
            while (object.hasNext()) {
                InflowLocationFactor inflowLocationFactor = (InflowLocationFactor)object.next();
                String string3 = ((JunctionElement)this._alt.getSystem().getObjectForKeyString(inflowLocationFactor.getJunctionId())).getName();
                String string4 = inflowLocationFactor.getLocalFlowName();
                if (!string.equals(string3) || !string2.equals(string4)) continue;
                doubleArray[0] = inflowLocationFactor.getFactor();
            }
        }
        return doubleArray;
    }
}

