/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.gui.WizardPanel;
import hec.lang.NamedType;
import hec.model.ModelVariable;
import hec.rss.model.HindcastData;
import hec.rss.model.RssAlt;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssSystem;
import hec.rss.plugins.montecarlo.client.MCVarLookbackLocationWizPanel$1;
import hec.rss.plugins.montecarlo.model.MCInputVariable;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;

public class MCVarLookbackLocationWizPanel
extends WizardPanel {
    public static final String PANEL_NAME = "Lookback Location and Parameter";
    private RmaJTextField _variableNameField;
    private RmaJTable _tsTable;
    private RssSystem _system;
    int _paramID;
    private Vector _paramIDS;

    public MCVarLookbackLocationWizPanel() {
        super((LayoutManager)new GridBagLayout());
        this.buildPanel();
    }

    private void buildPanel() {
        JLabel jLabel = new JLabel("Select Location and Parameter");
        jLabel.setFont(new Font(jLabel.getFont().getName(), 1, jLabel.getFont().getSize()));
        new GridBagConstraints();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add(jLabel, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        new GridBagConstraints();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add(jPanel, gridBagConstraints);
        jLabel = new JLabel("Variable");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._variableNameField = new RmaJTextField();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)this._variableNameField, gridBagConstraints);
        this._variableNameField.setEnabled(false);
        jLabel = new JLabel("Lookback Values");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5500;
        this.add(jLabel, gridBagConstraints);
        this._tsTable = new RmaJTable((Component)((Object)this), (Object[])new String[]{"Location", "Variable", "Default Value"});
        this._tsTable.setColumnSelectionAllowed(false);
        this._tsTable.setCellSelectionEnabled(false);
        this._tsTable.setRowSelectionAllowed(true);
        this._tsTable.getSelectionModel().setSelectionMode(2);
        this._tsTable.setAddRemoveEnabled(false);
        this._tsTable.setColumnEnabled(false, 0);
        this._tsTable.setColumnEnabled(false, 1);
        this._tsTable.setDoubleCellEditor(2);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5500;
        MCVarLookbackLocationWizPanel mCVarLookbackLocationWizPanel = this;
        mCVarLookbackLocationWizPanel.add(mCVarLookbackLocationWizPanel._tsTable.getScrollPane(), gridBagConstraints);
        this._tsTable.getSelectionModel().addListSelectionListener(new MCVarLookbackLocationWizPanel$1(this));
    }

    public void setVariableName(String string) {
        this._variableNameField.setText(string);
    }

    public String getVariableName() {
        return this._variableNameField.getText();
    }

    public String[] getSelectedTimeSeries() {
        int n = this._tsTable.getSelectedRow();
        String[] stringArray = new String[2];
        if (this._tsTable.getValueAt(n, 0) != null && this._tsTable.getValueAt(n, 0) instanceof String) {
            stringArray[0] = (String)this._tsTable.getValueAt(n, 0);
        }
        if (this._tsTable.getValueAt(n, 1) != null && this._tsTable.getValueAt(n, 1) instanceof String) {
            stringArray[1] = (String)this._tsTable.getValueAt(n, 1);
        }
        if (this._tsTable.getValueAt(n, 2) != null && this._tsTable.getValueAt(n, 2) instanceof String) {
            stringArray[1] = stringArray[1] + "=" + (String)this._tsTable.getValueAt(n, 2);
        }
        return stringArray;
    }

    public String getPanelName() {
        return PANEL_NAME;
    }

    public boolean isValidPanel() {
        return true;
    }

    public void fillPanel(NamedType namedType) {
    }

    public int getParamID() {
        return this._paramID;
    }

    public void fillPanel(RssAlt object) {
        RssSystem rssSystem = object.getSystem();
        this._paramIDS = new Vector();
        if (rssSystem == null) {
            return;
        }
        if (object.getHindcastData() == null) {
            return;
        }
        this._tsTable.clearSelection();
        this._tsTable.setNumRows(0);
        this._tsTable.deleteCells();
        if (rssSystem == null) {
            return;
        }
        if ((object = object.getHindcastData()) == null) {
            return;
        }
        int n = ((Vector)object).size();
        for (int i = 0; i < n; ++i) {
            HindcastData hindcastData = (HindcastData)((Vector)object).elementAt(i);
            if (hindcastData == null || hindcastData.getType() != 1) continue;
            Vector<String> vector = new Vector<String>();
            vector.addElement(rssSystem.getNameForKeyString(hindcastData.getObjectKey()));
            vector.addElement(RssModelVariableSet.getVariableName((int)hindcastData.getVariableId()));
            ModelVariable modelVariable = RssModelVariableSet.getModelVariable((int)hindcastData.getVariableId());
            this._paramIDS.add(modelVariable.getParamId());
            vector.addElement(hindcastData.getValueString());
            this._tsTable.appendRow(vector);
        }
        this._tsTable.setColumnEnabled(false, 2);
    }

    public void fillEditPanel(MCInputVariable mCInputVariable) {
        if (mCInputVariable.getType() == 2) {
            this._variableNameField.setText(mCInputVariable.getParameterEqualString());
        }
    }
}

