/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.rss.plugins.montecarlo.client.MCVariableDependencySelectionDialog$1;
import hec.rss.plugins.montecarlo.client.MCVariableDependencySelectionDialog$SymWindow;
import hec.rss.plugins.montecarlo.model.MCInputVariableImpl;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;

public class MCVariableDependencySelectionDialog
extends RmaJDialog
implements ButtonCmdPanelListener {
    private RmaJTable _variableTable;
    private ButtonCmdPanel cmdPanel = new ButtonCmdPanel(2060);
    private boolean _canceled;
    private String _paramEqualString;
    private boolean _remove = false;
    private List<String> _variableNameList = new ArrayList<String>();

    public MCVariableDependencySelectionDialog(Dialog dialog, boolean bl, List<MCInputVariableImpl> list, Vector<String> vector, boolean bl2) {
        super(dialog, bl);
        this.buildControls(list, vector);
        this.cmdPanel.setButtonEnable(2048, bl2);
        this.cmdPanel.setButtonEnable(8, false);
    }

    private void buildControls(List<MCInputVariableImpl> object, Vector<String> vector) {
        this.buildTable((List<MCInputVariableImpl>)object, vector);
        this.setSize(350, 280);
        this.setTitle("Variable Dependency");
        this.getContentPane().setLayout(new GridBagLayout());
        object = new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0);
        this._variableTable.setCellRenderer();
        this.getContentPane().add((Component)this._variableTable.getScrollPane(), object);
        object = new RmaGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 16, 2, new Insets(5, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)this.cmdPanel, object);
        this.setPrintLocations(true);
        this.cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)this);
        object = new MCVariableDependencySelectionDialog$SymWindow(this);
        this.addWindowListener((WindowListener)object);
        this.setLocation();
    }

    private void buildTable(List<MCInputVariableImpl> list, Vector<String> vector) {
        this._variableTable = new RmaJTable((Component)((Object)this), (Object[])new String[]{"Type", "Location", "Parameter"});
        this._variableTable.setColumnSelectionAllowed(false);
        this._variableTable.setCellSelectionEnabled(false);
        this._variableTable.setRowSelectionAllowed(true);
        this._variableTable.getSelectionModel().setSelectionMode(0);
        this._variableTable.setAddRemoveEnabled(false);
        this._variableTable.clearSelection();
        this._variableTable.setNumRows(0);
        this._variableTable.deleteCells();
        for (int i = 0; i < list.size(); ++i) {
            Vector<String> vector2 = new Vector<String>();
            vector2.add(list.get(i).getVariableName());
            vector2.add(list.get(i).getLocation());
            vector2.add(list.get(i).getParameter());
            if (vector2.get(0).equals("Rating Curve") || list.get(i).getShortName().equals(vector.get(0))) continue;
            this._variableTable.appendRow(vector2);
            this._variableNameList.add(list.get(i).getShortName());
            this._variableTable.setRowEnabled(false, this._variableTable.getRowCount() - 1);
        }
        this._variableTable.getSelectionModel().addListSelectionListener(new MCVariableDependencySelectionDialog$1(this, list));
    }

    public static List<MCInputVariableImpl> getEffectiveVariables(List<MCInputVariableImpl> list, String string) {
        ArrayList<MCInputVariableImpl> arrayList = new ArrayList<MCInputVariableImpl>();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getVariableName().equals("Rating Curve") || list.get(i).getShortName().equals(string)) continue;
            arrayList.add(list.get(i));
        }
        return arrayList;
    }

    public void buttonCmdActionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getID() == 8) {
            this.cmdOK_Action();
            return;
        }
        if (actionEvent.getID() == 2048) {
            this.cmdRemove_Action();
            return;
        }
        if (actionEvent.getID() == 4) {
            this.cmdCancel_Action();
        }
    }

    public void cmdOK_Action() {
        if (!this.saveForm()) {
            this._canceled = true;
            this.dispose();
            return;
        }
        this._canceled = false;
        this.setModified(true);
        this.setVisible(false);
        this.dispose();
    }

    public void cmdRemove_Action() {
        this.setRemoved(true);
        this.dispose();
    }

    private boolean saveForm() {
        if (this.getCurrentVariableName().equals("")) {
            return false;
        }
        this._paramEqualString = this.getCurrentVariableName();
        return true;
    }

    String getCurrentVariableName() {
        if (this._variableTable.getSelectedRow() < 0 || this._variableTable.getSelectedRow() > this._variableTable.getNumRows()) {
            return "";
        }
        return this._variableNameList.get(this._variableTable.getSelectedRow());
    }

    public void cmdCancel_Action() {
        this._canceled = true;
        this.setVisible(false);
        this.dispose();
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public String getVariableName() {
        return this._paramEqualString;
    }

    public boolean isRemoved() {
        return this._remove;
    }

    public void setRemoved(boolean bl) {
        this._remove = bl;
    }
}

