/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.clientapp.model.TSRecordProxy;
import hec.gui.WizardPanel;
import hec.rss.model.RssAlt;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssSystem;
import hec.rss.plugins.montecarlo.client.MCInputPanel;
import hec.rss.plugins.montecarlo.client.MCVariableLocationWizardPanel$1;
import hec.rss.plugins.montecarlo.model.MCInputStochasticVariableImpl;
import hec.rss.plugins.montecarlo.model.MCInputVariableImpl;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.lang.invoke.CallSite;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;

public class MCVariableLocationWizardPanel
extends WizardPanel {
    public static final String PANEL_NAME = "TS Multiplier Location and Parameter";
    private RmaJTextField _variableNameField;
    private RmaJTable _tsTable;

    public MCVariableLocationWizardPanel(MCInputPanel mCInputPanel) {
        super((LayoutManager)new GridBagLayout());
        this.buildPanel();
    }

    private void buildPanel() {
        JLabel jLabel = new JLabel("Select Location and Parameter");
        jLabel.setFont(new Font(jLabel.getFont().getName(), 1, jLabel.getFont().getSize()));
        new GridBagConstraints();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add(jLabel, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add(jPanel, gridBagConstraints);
        jLabel = new JLabel("Variable");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._variableNameField = new RmaJTextField();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)this._variableNameField, gridBagConstraints);
        this._variableNameField.setEnabled(false);
        jLabel = new JLabel("Input Time Series");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5500;
        this.add(jLabel, gridBagConstraints);
        this._tsTable = new RmaJTable((Component)((Object)this), (Object[])new String[]{"Location", "Variable"});
        this._tsTable.setColumnSelectionAllowed(false);
        this._tsTable.setCellSelectionEnabled(false);
        this._tsTable.setRowSelectionAllowed(true);
        this._tsTable.getSelectionModel().setSelectionMode(2);
        this._tsTable.setAddRemoveEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5500;
        MCVariableLocationWizardPanel mCVariableLocationWizardPanel = this;
        mCVariableLocationWizardPanel.add(mCVariableLocationWizardPanel._tsTable.getScrollPane(), gridBagConstraints);
        this._tsTable.getSelectionModel().addListSelectionListener(new MCVariableLocationWizardPanel$1(this));
    }

    public void setVariableName(String string) {
        this._variableNameField.setText(string);
    }

    public String getVariableName() {
        return this._variableNameField.getText();
    }

    public String[] getSelectedTimeSeries() {
        int n = this._tsTable.getSelectedRow();
        String[] stringArray = new String[2];
        if (this._tsTable.getValueAt(n, 0) != null && this._tsTable.getValueAt(n, 0) instanceof String) {
            stringArray[0] = (String)this._tsTable.getValueAt(n, 0);
        }
        if (this._tsTable.getValueAt(n, 1) != null && this._tsTable.getValueAt(n, 1) instanceof String) {
            stringArray[1] = (String)this._tsTable.getValueAt(n, 1);
        }
        return stringArray;
    }

    public String getPanelName() {
        return PANEL_NAME;
    }

    public boolean isValidPanel() {
        return true;
    }

    public void fillPanel(RssAlt object) {
        RssSystem rssSystem = object.getSystem();
        if (rssSystem == null) {
            return;
        }
        if (object.getInputTSDataSet() == null) {
            return;
        }
        object.getInputTSDataSet();
        this._tsTable.clearSelection();
        this._tsTable.setNumRows(0);
        this._tsTable.deleteCells();
        if (rssSystem == null) {
            this._tsTable.setNumRows(0);
            return;
        }
        object = rssSystem.getActiveTSProxies(null, 1);
        if (object == null) {
            return;
        }
        Vector<CallSite> vector = new Vector<CallSite>();
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            Object object2 = (TSRecordProxy)((Vector)object).elementAt(i);
            if (object2 == null) continue;
            Vector<String> vector2 = new Vector<String>();
            String string = rssSystem.getNameForKeyString(object2.getName());
            String string2 = string + "-" + (String)(object2 = RssModelVariableSet.getVariableName((int)object2.getVariableId()));
            if (vector.contains(string2)) continue;
            vector2.addElement(string);
            vector2.addElement((String)object2);
            vector.addElement((CallSite)((Object)string2));
            this._tsTable.appendRow(vector2);
            this._tsTable.setRowEnabled(false, i);
        }
    }

    public void fillEditPanel(MCInputStochasticVariableImpl mCInputStochasticVariableImpl) {
        if (mCInputStochasticVariableImpl.getDistributionType() == 0) {
            this._variableNameField.setText(((MCInputVariableImpl)mCInputStochasticVariableImpl).getParameterEqualString());
        }
    }
}

