/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.gui.WizardPanel;
import hec.rss.plugins.montecarlo.client.MCVariableModalityWizardPanel$1;
import hec.rss.plugins.montecarlo.client.MCVariableModalityWizardPanel$2;
import hec.rss.plugins.montecarlo.client.MCVariableModalityWizardPanel$3;
import hec.rss.plugins.montecarlo.client.MCVariableModalityWizardPanel$4;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import rma.swing.RmaInsets;
import rma.swing.RmaJPanel;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTextField;

public class MCVariableModalityWizardPanel
extends WizardPanel {
    private RmaJTextField _variableNameField;
    private RmaJRadioButton _absoluteButton;
    private RmaJRadioButton _relativeButton;
    private RmaJPanel _referenceDependencyPanel;
    private RmaJPanel _timeDepencyPanel;
    private RmaJRadioButton _constantButton;
    private RmaJRadioButton _seasonalButton;
    private boolean _isRelative = false;
    private boolean _isSeasonal = false;
    private int _type;
    public static final String PANEL_NAME = "Variable Parameter Modality";

    public MCVariableModalityWizardPanel() {
        super((LayoutManager)new GridBagLayout());
        this.buildPanel();
        this.addActionListeners();
    }

    private void addActionListeners() {
        this._absoluteButton.addActionListener((ActionListener)new MCVariableModalityWizardPanel$1(this));
        this._relativeButton.addActionListener((ActionListener)new MCVariableModalityWizardPanel$2(this));
        this._constantButton.addItemListener((ItemListener)new MCVariableModalityWizardPanel$3(this));
        this._seasonalButton.addItemListener((ItemListener)new MCVariableModalityWizardPanel$4(this));
    }

    public void buildPanel() {
        Serializable serializable = new JLabel("Select Variable Parameters Modality");
        ((JComponent)serializable).setFont(new Font(((Component)serializable).getFont().getName(), 1, ((Component)serializable).getFont().getSize()));
        new GridBagConstraints();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)serializable, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        new GridBagConstraints();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add(jPanel, gridBagConstraints);
        serializable = new JLabel("Variable");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)serializable, gridBagConstraints);
        this._variableNameField = new RmaJTextField();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)this._variableNameField, gridBagConstraints);
        this._variableNameField.setEnabled(false);
        this._referenceDependencyPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        this._referenceDependencyPanel.setBorder((Border)BorderFactory.createTitledBorder("Reference-Dependency"));
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5500;
        MCVariableModalityWizardPanel mCVariableModalityWizardPanel = this;
        mCVariableModalityWizardPanel.add((Component)mCVariableModalityWizardPanel._referenceDependencyPanel, gridBagConstraints);
        this._absoluteButton = new RmaJRadioButton("Absolute Distribution Parameters (one variable)");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this._referenceDependencyPanel.add((Component)this._absoluteButton, (Object)gridBagConstraints);
        this._absoluteButton.setSelected(true);
        this._relativeButton = new RmaJRadioButton("Relative Distribution Parameters (one or more variables)");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this._referenceDependencyPanel.add((Component)this._relativeButton, (Object)gridBagConstraints);
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add((AbstractButton)this._absoluteButton);
        ((ButtonGroup)serializable).add((AbstractButton)this._relativeButton);
        this._timeDepencyPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        this._timeDepencyPanel.setBorder((Border)BorderFactory.createTitledBorder("Time-Dependency"));
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5500;
        MCVariableModalityWizardPanel mCVariableModalityWizardPanel2 = this;
        mCVariableModalityWizardPanel2.add((Component)mCVariableModalityWizardPanel2._timeDepencyPanel, gridBagConstraints);
        this._constantButton = new RmaJRadioButton("Constant Distribution Parameters");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this._timeDepencyPanel.add((Component)this._constantButton, (Object)gridBagConstraints);
        this._constantButton.setSelected(true);
        this._seasonalButton = new RmaJRadioButton("Seasonal Distribution Parameters");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this._timeDepencyPanel.add((Component)this._seasonalButton, (Object)gridBagConstraints);
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add((AbstractButton)this._constantButton);
        ((ButtonGroup)serializable).add((AbstractButton)this._seasonalButton);
        this.addActionListeners();
    }

    public boolean isValidPanel() {
        return true;
    }

    public String getPanelName() {
        return PANEL_NAME;
    }

    public void setVariableNames(List<String> list) {
        if (list.size() == 1) {
            this._variableNameField.setText(list.get(0));
            return;
        }
        this._variableNameField.setText("Multiple Variables");
    }

    public void setVariableName(String string) {
        this._variableNameField.setText(string);
    }

    public void setVariableType(int n) {
        this._type = n;
    }

    public void setVariableNames(String string) {
        this._variableNameField.setText(string);
    }

    public String getVariableName() {
        return this._variableNameField.getText();
    }

    private void referenceRadioButtonAction() {
        if (this._absoluteButton.isSelected()) {
            this.setRelative(false);
            return;
        }
        if (this._relativeButton.isSelected()) {
            this.setRelative(true);
        }
    }

    private void seasonalityRadioButtonAction() {
        if (this._constantButton.isSelected()) {
            this.setSeasonal(false);
            if (this._type == 3) {
                this._absoluteButton.setEnabled(true);
                return;
            }
        } else if (this._seasonalButton.isSelected()) {
            this.setSeasonal(true);
            if (this._type == 3) {
                this._absoluteButton.setEnabled(false);
            }
        }
    }

    private void setSeasonal(boolean bl) {
        this._isSeasonal = bl;
    }

    public RmaJRadioButton getAbsoluteButton() {
        return this._absoluteButton;
    }

    public RmaJRadioButton getRelativeButton() {
        return this._relativeButton;
    }

    public boolean isRelative() {
        return (this._isRelative || this._relativeButton.isSelected()) && !this._absoluteButton.isSelected();
    }

    protected void setRelative(boolean bl) {
        this._isRelative = bl;
    }

    public boolean isSeasonal() {
        return this._isSeasonal;
    }

    public RmaJRadioButton getSeasonalButton() {
        return this._seasonalButton;
    }

    public RmaJRadioButton getConstantButton() {
        return this._constantButton;
    }
}

