/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.gui.WizardDialog;
import hec.gui.WizardPanel;
import hec.heclib.util.HecTime;
import hec.rss.model.RssAlt;
import hec.rss.plugins.montecarlo.client.MCContinuousDistributionWizardPanelImpl;
import hec.rss.plugins.montecarlo.client.MCDiscreteDistributionWizardPanel;
import hec.rss.plugins.montecarlo.client.MCInputPanel;
import hec.rss.plugins.montecarlo.client.MCLookbackLocationWizardPanel;
import hec.rss.plugins.montecarlo.client.MCRatingCurveLocationWizardPanel;
import hec.rss.plugins.montecarlo.client.MCResRuleLocationWizardPanel;
import hec.rss.plugins.montecarlo.client.MCScalarDistributionWizardPanel;
import hec.rss.plugins.montecarlo.client.MCScriptLocationWizardPanel;
import hec.rss.plugins.montecarlo.client.MCScriptWizardPanel;
import hec.rss.plugins.montecarlo.client.MCTSLocationWizardPanel;
import hec.rss.plugins.montecarlo.client.MCTSMultiplierLocationWizardPanel;
import hec.rss.plugins.montecarlo.client.MCVariableDistributionWizardPanelImpl;
import hec.rss.plugins.montecarlo.client.MCVariableLocationWizardPanelImpl;
import hec.rss.plugins.montecarlo.client.MCVariableModalityWizardPanel;
import hec.rss.plugins.montecarlo.client.MCVariableTypeWizardPanel;
import hec.rss.plugins.montecarlo.client.MCVariableWizardDialog$1;
import hec.rss.plugins.montecarlo.client.MCVariableWizardDialog$2;
import hec.rss.plugins.montecarlo.client.MCVariableWizardDialog$WindowListener;
import hec.rss.plugins.montecarlo.client.MCVectorDistributionWizardPanel;
import hec.rss.plugins.montecarlo.model.MCInputClippedDataVariable;
import hec.rss.plugins.montecarlo.model.MCInputRatingCurveVariable;
import hec.rss.plugins.montecarlo.model.MCInputScriptVariable;
import hec.rss.plugins.montecarlo.model.MCInputStochasticVariableImpl;
import hec.rss.plugins.montecarlo.model.MCInputTSVariable;
import hec.rss.plugins.montecarlo.model.MCInputVariableImpl;
import hec.rss.plugins.montecarlo.model.SeasonalContinuousDistribution;
import hec.statistics.AbstractContDist;
import hec.statistics.EmpiricalDist;
import hec.statistics.GammaClipDist;
import hec.statistics.Log10NormalB17BClipDist;
import hec.statistics.Log10NormalClipDist;
import hec.statistics.LogNormalClipDist;
import hec.statistics.NormalClipDist;
import hec.statistics.TriangClipDist;
import hec.statistics.UnifClipDist;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;

public class MCVariableWizardDialog
extends WizardDialog {
    private static String a = "Input Random Variable Wizard - Step X of 4";
    int _wizardPanelCount = 4;
    private MCVariableTypeWizardPanel _typePanel;
    private MCTSLocationWizardPanel _tsLocationPanel;
    protected MCVariableModalityWizardPanel _modalityPanel;
    private MCDiscreteDistributionWizardPanel _tsDistributionPanel;
    private MCLookbackLocationWizardPanel _lookbackLocationPanel;
    protected MCScalarDistributionWizardPanel _lookbackDistPanel;
    protected MCRatingCurveLocationWizardPanel _ratingLocationPanel;
    private MCVectorDistributionWizardPanel _ratingDistPanel;
    private MCResRuleLocationWizardPanel _ruleParamPanel;
    private MCTSMultiplierLocationWizardPanel _tsMultiplierLocationPanel;
    private MCVariableWizardDialog$WindowListener _windowListener;
    public MCInputStochasticVariableImpl _variable;
    private boolean _canceled = true;
    private MCInputPanel _inputPanel;
    private boolean _edit = false;
    private boolean _isActive = false;
    private Dialog _parent;
    private MCScriptWizardPanel _scriptWriterPanel;
    private MCScriptLocationWizardPanel _scriptLocationPanel;
    RssAlt _alt;
    private DocumentListener _documentListener;
    private static String b;

    public MCVariableWizardDialog(Dialog dialog, boolean bl, MCInputPanel mCInputPanel) {
        super(dialog, bl);
        this._parent = dialog;
        this.buildControls(mCInputPanel);
    }

    protected void buildControls(MCInputPanel mCInputPanel) {
        this._inputPanel = mCInputPanel;
        this._typePanel = new MCVariableTypeWizardPanel(this);
        this._typePanel.setNextPanelName("TS Multiplier Location and Parameter");
        MCVariableWizardDialog mCVariableWizardDialog = this;
        mCVariableWizardDialog.addWizardPanel(mCVariableWizardDialog._typePanel);
        this._modalityPanel = new MCVariableModalityWizardPanel();
        MCVariableWizardDialog mCVariableWizardDialog2 = this;
        mCVariableWizardDialog2.addWizardPanel(mCVariableWizardDialog2._modalityPanel);
        this._tsMultiplierLocationPanel = new MCTSMultiplierLocationWizardPanel(this._inputPanel, this);
        this._tsMultiplierLocationPanel.setNextPanelName("Variable Parameter Modality");
        this._tsMultiplierLocationPanel.setBackPanelName("Variable Type");
        MCVariableWizardDialog mCVariableWizardDialog3 = this;
        mCVariableWizardDialog3.addWizardPanel(mCVariableWizardDialog3._tsMultiplierLocationPanel);
        this._tsLocationPanel = new MCTSLocationWizardPanel(this._inputPanel, this);
        this._tsLocationPanel.setNextPanelName("Variable Parameter Modality");
        this._tsLocationPanel.setBackPanelName("Variable Type");
        MCVariableWizardDialog mCVariableWizardDialog4 = this;
        mCVariableWizardDialog4.addWizardPanel(mCVariableWizardDialog4._tsLocationPanel);
        this._tsDistributionPanel = new MCDiscreteDistributionWizardPanel(this._inputPanel.getAlt());
        this._tsDistributionPanel.setBackPanelName("Variable Parameter Modality");
        MCVariableWizardDialog mCVariableWizardDialog5 = this;
        mCVariableWizardDialog5.addWizardPanel(mCVariableWizardDialog5._tsDistributionPanel);
        this._lookbackLocationPanel = new MCLookbackLocationWizardPanel(this._inputPanel, this);
        this._lookbackLocationPanel.setNextPanelName("Variable Parameter Modality");
        this._lookbackLocationPanel.setBackPanelName("Variable Type");
        MCVariableWizardDialog mCVariableWizardDialog6 = this;
        mCVariableWizardDialog6.addWizardPanel(mCVariableWizardDialog6._lookbackLocationPanel);
        this._lookbackDistPanel = new MCScalarDistributionWizardPanel(this);
        this._lookbackDistPanel.setBackPanelName("Variable Parameter Modality");
        MCVariableWizardDialog mCVariableWizardDialog7 = this;
        mCVariableWizardDialog7.addWizardPanel(mCVariableWizardDialog7._lookbackDistPanel);
        this._ruleParamPanel = new MCResRuleLocationWizardPanel(this._inputPanel, this);
        this._ruleParamPanel.setNextPanelName("Variable Parameter Modality");
        this._ruleParamPanel.setBackPanelName("Variable Type");
        MCVariableWizardDialog mCVariableWizardDialog8 = this;
        mCVariableWizardDialog8.addWizardPanel(mCVariableWizardDialog8._ruleParamPanel);
        this._ratingLocationPanel = new MCRatingCurveLocationWizardPanel(this._inputPanel, this);
        this._ratingLocationPanel.setNextPanelName("Variable Parameter Modality");
        this._ratingLocationPanel.setBackPanelName("Variable Type");
        MCVariableWizardDialog mCVariableWizardDialog9 = this;
        mCVariableWizardDialog9.addWizardPanel(mCVariableWizardDialog9._ratingLocationPanel);
        this._ratingDistPanel = new MCVectorDistributionWizardPanel(this);
        this._ratingDistPanel.setBackPanelName("Variable Parameter Modality");
        MCVariableWizardDialog mCVariableWizardDialog10 = this;
        mCVariableWizardDialog10.addWizardPanel(mCVariableWizardDialog10._ratingDistPanel);
        this._scriptWriterPanel = new MCScriptWizardPanel(this);
        this._scriptWriterPanel.setBackPanelName("Script Location");
        MCVariableWizardDialog mCVariableWizardDialog11 = this;
        mCVariableWizardDialog11.addWizardPanel(mCVariableWizardDialog11._scriptWriterPanel);
        this._scriptLocationPanel = new MCScriptLocationWizardPanel(this._inputPanel, this);
        this._scriptLocationPanel.setBackPanelName("Variable Type");
        this._scriptLocationPanel.setNextPanelName("Script Writer Panel");
        MCVariableWizardDialog mCVariableWizardDialog12 = this;
        mCVariableWizardDialog12.addWizardPanel(mCVariableWizardDialog12._scriptLocationPanel);
        this._windowListener = new MCVariableWizardDialog$WindowListener(this);
        MCVariableWizardDialog mCVariableWizardDialog13 = this;
        mCVariableWizardDialog13.addWindowListener(mCVariableWizardDialog13._windowListener);
        this.setSize(700, 500);
        super.setTitle(a);
        MCVariableWizardDialog mCVariableWizardDialog14 = this;
        mCVariableWizardDialog14.setLocationRelativeTo(mCVariableWizardDialog14.getParent());
        this._inputPanel.addWarningCheckListener(this);
    }

    public void fillPanels(RssAlt rssAlt, MCInputVariableImpl[] mCInputVariableImplArray) {
        this._alt = rssAlt;
        if (mCInputVariableImplArray == null || mCInputVariableImplArray[0] instanceof MCInputScriptVariable) {
            this._variable = null;
            if (mCInputVariableImplArray != null && mCInputVariableImplArray[0] instanceof MCInputScriptVariable) {
                a = "Input Random Variable Wizard - Step X of 3";
            }
        } else {
            this._variable = (MCInputStochasticVariableImpl)mCInputVariableImplArray[0];
        }
        this._tsMultiplierLocationPanel.fillPanel(rssAlt, mCInputVariableImplArray);
        this._tsLocationPanel.fillPanel(rssAlt, mCInputVariableImplArray);
        this._lookbackLocationPanel.fillPanel(rssAlt, mCInputVariableImplArray);
        this._ruleParamPanel.fillPanel(rssAlt, mCInputVariableImplArray);
        this._ratingLocationPanel.fillPanel(rssAlt, mCInputVariableImplArray);
        this._scriptLocationPanel.fillPanel(rssAlt, mCInputVariableImplArray);
        this._ratingDistPanel.setAlterantive(rssAlt);
        if (this._variable != null) {
            this._edit = true;
            this._isActive = this._variable.isActive();
            this._typePanel.setSelectedInput(((MCInputVariableImpl)this._variable).getType());
            if (mCInputVariableImplArray[0].getGroupNumber() > 0) {
                this._modalityPanel.getAbsoluteButton().setEnabled(false);
            }
            if (mCInputVariableImplArray[0].getUncertaintyType() == 0) {
                this._typePanel.getEpistemicUncertaintyRadioButton().setSelected(true);
            }
            if (((MCInputVariableImpl)this._variable).getType() == 4) {
                ((MCInputVariableImpl)this._variable).setParameterEqualString(((MCInputVariableImpl)this._variable).getParameterEqualString());
                MCVariableWizardDialog mCVariableWizardDialog = this;
                this._lookbackDistPanel.setDefaultValue(mCVariableWizardDialog.getDefaultValue(((MCInputVariableImpl)mCVariableWizardDialog._variable).getType(), this._variable.getLocation(), this._variable.getParameter()));
                if (!this._lookbackDistPanel.getDefaultValue().equals(Double.valueOf(((MCInputVariableImpl)this._variable).getParameterEqualString().substring(((MCInputVariableImpl)this._variable).getParameterEqualString().lastIndexOf(":") + 1)))) {
                    ((MCInputVariableImpl)this._variable).setParameterEqualString(((MCInputVariableImpl)this._variable).getParameterEqualString().substring(0, ((MCInputVariableImpl)this._variable).getParameterEqualString().lastIndexOf(":") + 1) + this._lookbackDistPanel.getDefaultValue());
                }
                this._lookbackDistPanel.buildPanel(this._variable.isRelative(), this._variable.isSeasonal(), this._lookbackLocationPanel.getParamID());
                if (mCInputVariableImplArray.length > 1) {
                    this._lookbackDistPanel.fillEditPanel(this._variable, this._variable.getGroupLabel());
                } else {
                    this._lookbackDistPanel.fillEditPanel(this._variable, ((MCInputVariableImpl)this._variable).getParameterEqualString());
                }
                if (mCInputVariableImplArray.length > 1) {
                    this._tsMultiplierLocationPanel.fillEditPanel(this._variable, this._variable.getGroupLabel());
                } else {
                    this._tsMultiplierLocationPanel.fillEditPanel(this._variable, ((MCInputVariableImpl)this._variable).getParameterEqualString());
                }
                this._typePanel.setSelectedInput(4);
                this.setCurrentPanel("LookbackDistribution");
                if (mCInputVariableImplArray.length > 1) {
                    this._modalityPanel.setVariableNames(this._variable.getGroupLabel());
                } else {
                    this._modalityPanel.setVariableNames(((MCInputVariableImpl)this._variable).getParameterEqualString());
                }
                this._modalityPanel.getAbsoluteButton().setEnabled(true);
                this._modalityPanel.getRelativeButton().setEnabled(true);
                this._modalityPanel.getRelativeButton().setSelected(this._lookbackDistPanel.isRelative());
                this._modalityPanel.getSeasonalButton().setSelected(this._variable.isSeasonal());
                this._modalityPanel.setNextPanelName("LookbackDistribution");
                this._modalityPanel.setBackPanelName("TS Multiplier Location and Parameter");
                return;
            }
            if (((MCInputVariableImpl)this._variable).getType() == 0) {
                this._tsDistributionPanel.fillEditPanel((MCInputTSVariable)this._variable);
                this._tsLocationPanel.fillEditPanel(this._variable);
                this._typePanel.setSelectedInput(0);
                this.setCurrentPanel("Distribution");
                if (mCInputVariableImplArray.length > 1) {
                    this._modalityPanel.setVariableNames(this._variable.getGroupLabel());
                } else {
                    this._modalityPanel.setVariableNames(((MCInputVariableImpl)this._variable).getParameterEqualString());
                }
                this._modalityPanel.getAbsoluteButton().setEnabled(true);
                this._modalityPanel.getAbsoluteButton().setSelected(true);
                this._modalityPanel.getRelativeButton().setEnabled(false);
                this._modalityPanel.getSeasonalButton().setSelected(this._variable.isSeasonal());
                this._modalityPanel.setNextPanelName("Distribution");
                this._modalityPanel.setBackPanelName("TS Location and Parameter");
                return;
            }
            if (((MCInputVariableImpl)this._variable).getType() == 2) {
                ((MCInputVariableImpl)this._variable).setParameterEqualString(((MCInputVariableImpl)this._variable).getParameterEqualString());
                MCVariableWizardDialog mCVariableWizardDialog = this;
                this._lookbackDistPanel.setDefaultValue(mCVariableWizardDialog.getDefaultValue(((MCInputVariableImpl)mCVariableWizardDialog._variable).getType(), this._variable.getLocation(), this._variable.getParameter()));
                if (!this._lookbackDistPanel.getDefaultValue().equals(Double.valueOf(((MCInputVariableImpl)this._variable).getParameterEqualString().substring(((MCInputVariableImpl)this._variable).getParameterEqualString().lastIndexOf(":") + 1)))) {
                    ((MCInputVariableImpl)this._variable).setParameterEqualString(((MCInputVariableImpl)this._variable).getParameterEqualString().substring(0, ((MCInputVariableImpl)this._variable).getParameterEqualString().lastIndexOf(":") + 1) + this._lookbackDistPanel.getDefaultValue());
                }
                this._lookbackDistPanel.buildPanel(this._variable.isRelative(), this._variable.isSeasonal(), this._lookbackLocationPanel.getParamID());
                if (mCInputVariableImplArray.length > 1) {
                    this._lookbackDistPanel.fillEditPanel(this._variable, this._variable.getGroupLabel());
                } else {
                    this._lookbackDistPanel.fillEditPanel(this._variable, ((MCInputVariableImpl)this._variable).getParameterEqualString());
                }
                if (mCInputVariableImplArray.length > 1) {
                    this._lookbackLocationPanel.fillEditPanel(this._variable, this._variable.getGroupLabel());
                } else {
                    this._lookbackLocationPanel.fillEditPanel(this._variable, ((MCInputVariableImpl)this._variable).getParameterEqualString());
                }
                this._typePanel.setSelectedInput(2);
                this.setCurrentPanel("LookbackDistribution");
                this._modalityPanel.getRelativeButton().setEnabled(true);
                this._modalityPanel.getRelativeButton().setSelected(this._lookbackDistPanel.isRelative());
                this._modalityPanel.getSeasonalButton().setSelected(this._variable.isSeasonal());
                if (mCInputVariableImplArray.length > 1) {
                    this._modalityPanel.setVariableNames(this._variable.getGroupLabel());
                } else {
                    this._modalityPanel.setVariableNames(((MCInputVariableImpl)this._variable).getParameterEqualString());
                }
                this._modalityPanel.setNextPanelName("LookbackDistribution");
                this._modalityPanel.setBackPanelName("Lookback Location and Parameter");
                return;
            }
            if (((MCInputVariableImpl)this._variable).getType() == 1) {
                ((MCInputVariableImpl)this._variable).setParameterEqualString(((MCInputVariableImpl)this._variable).getParameterEqualString());
                MCVariableWizardDialog mCVariableWizardDialog = this;
                this._lookbackDistPanel.setDefaultValue(mCVariableWizardDialog.getDefaultValue(((MCInputVariableImpl)mCVariableWizardDialog._variable).getType(), this._variable.getLocation(), this._variable.getParameter()));
                if (!this._lookbackDistPanel.getDefaultValue().equals(Double.valueOf(((MCInputVariableImpl)this._variable).getParameterEqualString().substring(((MCInputVariableImpl)this._variable).getParameterEqualString().lastIndexOf("=") + 1)))) {
                    ((MCInputVariableImpl)this._variable).setParameterEqualString(((MCInputVariableImpl)this._variable).getParameterEqualString().substring(0, ((MCInputVariableImpl)this._variable).getParameterEqualString().lastIndexOf("=") + 1) + " " + this._lookbackDistPanel.getDefaultValue());
                }
                this._lookbackDistPanel.buildPanel(this._variable.isRelative(), this._variable.isSeasonal(), this._lookbackLocationPanel.getParamID());
                if (mCInputVariableImplArray.length > 1) {
                    this._lookbackDistPanel.fillEditPanel(this._variable, this._variable.getGroupLabel());
                } else {
                    this._lookbackDistPanel.fillEditPanel(this._variable, ((MCInputVariableImpl)this._variable).getParameterEqualString());
                }
                if (mCInputVariableImplArray.length > 1) {
                    this._ruleParamPanel.fillEditPanel(this._variable, this._variable.getGroupLabel());
                } else {
                    this._ruleParamPanel.fillEditPanel(this._variable, ((MCInputVariableImpl)this._variable).getParameterEqualString());
                }
                this._typePanel.setSelectedInput(1);
                this.setCurrentPanel("LookbackDistribution");
                if (mCInputVariableImplArray.length > 1) {
                    this._modalityPanel.setVariableNames(this._variable.getGroupLabel());
                } else {
                    this._modalityPanel.setVariableNames(((MCInputVariableImpl)this._variable).getParameterEqualString());
                }
                this._modalityPanel.getRelativeButton().setEnabled(true);
                this._modalityPanel.getRelativeButton().setSelected(this._lookbackDistPanel.isRelative());
                this._modalityPanel.getSeasonalButton().setSelected(this._variable.isSeasonal());
                this._modalityPanel.setNextPanelName("LookbackDistribution");
                this._modalityPanel.setBackPanelName("Reservior Rule Parameter");
                return;
            }
            if (((MCInputVariableImpl)this._variable).getType() == 3) {
                MCVariableWizardDialog mCVariableWizardDialog = this;
                ((MCInputVariableImpl)this._variable).setParameterEqualString(((MCInputVariableImpl)this._variable).getParameterEqualString().substring(0, ((MCInputVariableImpl)this._variable).getParameterEqualString().indexOf(":") + 1) + mCVariableWizardDialog.getDefaultValue(((MCInputVariableImpl)mCVariableWizardDialog._variable).getType(), this._variable.getLocation(), this._variable.getParameter())[0]);
                this._ratingDistPanel.buildPanel(this._variable.isRelative(), this._variable.isSeasonal(), this._variable.getParamId());
                this._typePanel.setSelectedInput(3);
                this.setCurrentPanel("RatingCurveDistribution");
                if (mCInputVariableImplArray.length > 1) {
                    this._ratingDistPanel.fillEditPanel((MCInputRatingCurveVariable)this._variable, this._variable.getGroupLabel());
                } else {
                    this._ratingDistPanel.fillEditPanel((MCInputRatingCurveVariable)this._variable, "Rating Curves - " + this._variable.getLocation());
                }
                if (mCInputVariableImplArray.length > 1) {
                    this._ratingLocationPanel.fillEditPanel(this._variable.getGroupLabel());
                } else {
                    this._ratingLocationPanel.fillEditPanel("Rating Curves - " + this._variable.getLocation());
                }
                this._modalityPanel.getRelativeButton().setSelected(this._ratingDistPanel.isRelative());
                this._modalityPanel.getSeasonalButton().setEnabled(false);
                if (mCInputVariableImplArray.length > 1) {
                    this._modalityPanel.setVariableNames(this._variable.getGroupLabel());
                } else {
                    this._modalityPanel.setVariableNames("Rating Curves - " + this._variable.getLocation());
                }
                this._modalityPanel.setNextPanelName("RatingCurveDistribution");
                this._modalityPanel.setBackPanelName("Rating Curve Location");
                return;
            }
        } else if (mCInputVariableImplArray != null && mCInputVariableImplArray[0] instanceof MCInputScriptVariable) {
            this._edit = true;
            this._scriptLocationPanel.enableMultiSelection(false);
            this._scriptWriterPanel.fillEditPanel(rssAlt, (MCInputScriptVariable)mCInputVariableImplArray[0]);
            this._scriptLocationPanel.fillCurrentPanel(rssAlt, mCInputVariableImplArray);
            this.setCurrentPanel("Script Writer Panel");
            this._scriptWriterPanel.setBackPanelName("Script Location");
            this._typePanel.setSelectedInput(5);
        }
    }

    public MCResRuleLocationWizardPanel getMCResRulePanel() {
        return this._ruleParamPanel;
    }

    public TableModel getMCRatingTable() {
        return this._ratingLocationPanel.getVariableTable();
    }

    public void setTitle(String string) {
        string = String.valueOf(this.getCurrentStep());
        string = a.replace('X', string.charAt(0));
        super.setTitle(string);
    }

    protected int getCurrentStep() {
        WizardPanel wizardPanel = this.getCurrentPanel();
        if (wizardPanel == this._typePanel) {
            return 1;
        }
        if (wizardPanel == this._tsMultiplierLocationPanel || wizardPanel == this._tsLocationPanel || wizardPanel == this._lookbackLocationPanel || wizardPanel == this._ruleParamPanel || wizardPanel == this._ratingLocationPanel || wizardPanel == this._scriptLocationPanel) {
            return 2;
        }
        if (wizardPanel == this._modalityPanel || wizardPanel == this._scriptWriterPanel) {
            return 3;
        }
        return 4;
    }

    protected void dialogCanceled() {
        this._canceled = true;
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this._inputPanel.removeWarningCheckListener(this);
    }

    protected void changingPanels(String string) {
        WizardPanel wizardPanel = this.getCurrentPanel();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (wizardPanel == this._typePanel) {
                if (this._typePanel.getType() == 4) {
                    this._tsMultiplierLocationPanel.setVariableName("Time Series Multiplier - ");
                    this._tsMultiplierLocationPanel.setSelection();
                    this._tsMultiplierLocationPanel.enableMultiSelection(true);
                    this.setValidPanelControlsNextButton(true);
                } else if (this._typePanel.getType() == 0) {
                    this._tsLocationPanel.setVariableName("Time Series - ");
                    this._tsLocationPanel.setSelection();
                    this._tsLocationPanel.enableMultiSelection(false);
                    this.setValidPanelControlsNextButton(true);
                } else if (this._typePanel.getType() == 1) {
                    this._ruleParamPanel.setVariableName("Rule Parameter - ");
                    this._ruleParamPanel.setSelection();
                    this._ruleParamPanel.enableMultiSelection(true);
                    this.setValidPanelControlsNextButton(true);
                } else if (this._typePanel.getType() == 3) {
                    ((MCVariableLocationWizardPanelImpl)this._ratingLocationPanel).setVariableName("Rating Curve - ");
                    this._ratingLocationPanel.setSelection();
                    this._ratingLocationPanel.enableMultiSelection(true);
                    this.setValidPanelControlsNextButton(true);
                } else if (this._typePanel.getType() == 2) {
                    this._lookbackLocationPanel.setVariableName("Lookback Value - ");
                    ((MCVariableLocationWizardPanelImpl)this._lookbackLocationPanel).setSelection();
                    this._lookbackLocationPanel.enableMultiSelection(true);
                    this.setValidPanelControlsNextButton(true);
                } else if (this._typePanel.getType() == 5) {
                    this._scriptLocationPanel.setVariableName("Script - ");
                    this.setValidPanelControlsNextButton(true);
                    a = "Input Random Variable Wizard - Step X of 3";
                }
            } else if (wizardPanel instanceof MCVariableLocationWizardPanelImpl) {
                this._modalityPanel.setVariableType(this._typePanel.getType());
                if (this._typePanel.getType() == 4) {
                    if (!this._modalityPanel.getVariableName().equals(this._tsMultiplierLocationPanel.getVariableName())) {
                        this._modalityPanel.getAbsoluteButton().setEnabled(true);
                        this._modalityPanel.getAbsoluteButton().setSelected(true);
                        this._modalityPanel.getRelativeButton().setEnabled(true);
                        this._modalityPanel.getRelativeButton().setSelected(false);
                        this._modalityPanel.getConstantButton().setEnabled(true);
                        this._modalityPanel.getSeasonalButton().setEnabled(true);
                        this._modalityPanel.getConstantButton().setSelected(true);
                    }
                    if (this._tsMultiplierLocationPanel.getVariableNames().size() > 1) {
                        this._modalityPanel.getRelativeButton().setSelected(true);
                        this._modalityPanel.getAbsoluteButton().setEnabled(false);
                    }
                    this._modalityPanel.setVariableName(this._tsMultiplierLocationPanel.getVariableName());
                    this._modalityPanel.setNextPanelName("LookbackDistribution");
                    this._modalityPanel.setBackPanelName("TS Multiplier Location and Parameter");
                    this.setValidPanelControlsNextButton(true);
                } else if (this._typePanel.getType() == 0) {
                    if (!this._modalityPanel.getVariableName().equals(this._tsLocationPanel.getVariableName())) {
                        this._modalityPanel.getAbsoluteButton().setEnabled(true);
                        this._modalityPanel.getRelativeButton().setEnabled(false);
                        this._modalityPanel.getAbsoluteButton().setSelected(true);
                        this._modalityPanel.getConstantButton().setEnabled(true);
                        this._modalityPanel.getSeasonalButton().setEnabled(true);
                        this._modalityPanel.getConstantButton().setSelected(true);
                    }
                    this._modalityPanel.setVariableName(this._tsLocationPanel.getVariableName());
                    this._tsLocationPanel.setSelection();
                    this._modalityPanel.setNextPanelName("Distribution");
                    this._modalityPanel.setBackPanelName("TS Location and Parameter");
                    this.setValidPanelControlsNextButton(true);
                } else if (this._typePanel.getType() == 1) {
                    if (!this._modalityPanel.getVariableName().equals(this._ruleParamPanel.getVariableName())) {
                        this._modalityPanel.getRelativeButton().setEnabled(true);
                        this._modalityPanel.getRelativeButton().setSelected(true);
                        if (this._ruleParamPanel.getVariableNames().size() > 1) {
                            this._modalityPanel.getAbsoluteButton().setEnabled(false);
                        } else {
                            this._modalityPanel.getAbsoluteButton().setEnabled(true);
                            this._modalityPanel.getAbsoluteButton().setSelected(true);
                        }
                        this._modalityPanel.getConstantButton().setEnabled(true);
                        this._modalityPanel.getSeasonalButton().setEnabled(true);
                        this._modalityPanel.getConstantButton().setSelected(true);
                    }
                    this._modalityPanel.setVariableName(this._ruleParamPanel.getVariableName());
                    this._ruleParamPanel.setSelection();
                    this._modalityPanel.setNextPanelName("LookbackDistribution");
                    this._modalityPanel.setBackPanelName("Reservior Rule Parameter");
                    this.setValidPanelControlsNextButton(true);
                } else if (this._typePanel.getType() == 3) {
                    if (!this._modalityPanel.getVariableName().equals(((MCVariableLocationWizardPanelImpl)this._ratingLocationPanel).getVariableName())) {
                        this._modalityPanel.getRelativeButton().setEnabled(true);
                        this._modalityPanel.getRelativeButton().setSelected(true);
                        if (this._ratingLocationPanel.getVariableNames().size() > 1) {
                            this._modalityPanel.getAbsoluteButton().setEnabled(false);
                        } else {
                            this._modalityPanel.getAbsoluteButton().setEnabled(true);
                            this._modalityPanel.getAbsoluteButton().setSelected(true);
                            this._modalityPanel.getRelativeButton().setSelected(false);
                        }
                        this._modalityPanel.getSeasonalButton().setEnabled(false);
                        this._modalityPanel.getConstantButton().setEnabled(true);
                        this._modalityPanel.getConstantButton().setSelected(true);
                    }
                    this._modalityPanel.setVariableName(((MCVariableLocationWizardPanelImpl)this._ratingLocationPanel).getVariableName());
                    this._modalityPanel.setNextPanelName("RatingCurveDistribution");
                    this._modalityPanel.setBackPanelName("Rating Curve Location");
                    this.setValidPanelControlsNextButton(true);
                } else if (this._typePanel.getType() == 2) {
                    if (!this._modalityPanel.getVariableName().equals(this._lookbackLocationPanel.getVariableName())) {
                        this._modalityPanel.getRelativeButton().setEnabled(true);
                        this._modalityPanel.getRelativeButton().setSelected(true);
                        if (this._lookbackLocationPanel.getVariableNames().size() > 1) {
                            this._modalityPanel.getAbsoluteButton().setEnabled(false);
                        } else {
                            this._modalityPanel.getAbsoluteButton().setEnabled(true);
                            this._modalityPanel.getAbsoluteButton().setSelected(true);
                        }
                        this._modalityPanel.getSeasonalButton().setEnabled(true);
                        this._modalityPanel.getConstantButton().setEnabled(true);
                        this._modalityPanel.getConstantButton().setSelected(true);
                    }
                    this._modalityPanel.setVariableName(this._lookbackLocationPanel.getVariableName());
                    this._modalityPanel.setNextPanelName("LookbackDistribution");
                    this._modalityPanel.setBackPanelName("Lookback Location and Parameter");
                    this.setValidPanelControlsNextButton(true);
                } else if (this._typePanel.getType() == 5) {
                    if (this._scriptWriterPanel.getVariableName() == null || this._scriptWriterPanel.getVariableName().equals("")) {
                        this._scriptWriterPanel.fillPanel(this._alt);
                    }
                    this._scriptWriterPanel.setVariableName(this._scriptLocationPanel.getVariableParameter());
                    this._scriptWriterPanel.setVariableLocation(this._scriptLocationPanel.getVariableLocation());
                    this._scriptWriterPanel.setVariableType(this._scriptLocationPanel.getDescription());
                }
            } else if (wizardPanel == this._modalityPanel && this._typePanel.getType() == 4) {
                if (!this._lookbackDistPanel.getVariableName().equals(this._modalityPanel.getVariableName()) || this._modalityPanel.isRelative() != this._lookbackDistPanel.isRelative() || this._modalityPanel.isSeasonal() != this._lookbackDistPanel.isSeasonal()) {
                    this._lookbackDistPanel.setDefaultValue(((MCVariableLocationWizardPanelImpl)this._tsMultiplierLocationPanel).getDefaultValue());
                    this._lookbackDistPanel.buildPanel(this._modalityPanel.isRelative(), this._modalityPanel.isSeasonal(), this._tsMultiplierLocationPanel.getParamID());
                }
                this._lookbackDistPanel.setVariableName(this._modalityPanel.getVariableName());
                this._tsLocationPanel.enableMultiSelection(true);
                this._tsLocationPanel.setVariableName(this._modalityPanel.getVariableName());
            } else if (wizardPanel == this._modalityPanel && this._typePanel.getType() == 0) {
                if (!this._tsDistributionPanel.getVariableName().equals(this._modalityPanel.getVariableName()) || this._modalityPanel.isSeasonal() != this._tsDistributionPanel.isSeasonal()) {
                    this._tsDistributionPanel.buildPanel(this._modalityPanel.isSeasonal());
                }
                this._tsDistributionPanel.setVariableName(this._modalityPanel.getVariableName());
                this._tsLocationPanel.enableMultiSelection(false);
                this._tsLocationPanel.setVariableName(this._modalityPanel.getVariableName());
            } else if (wizardPanel == this._modalityPanel && this._typePanel.getType() == 1) {
                if (!this._lookbackDistPanel.getVariableName().equals(this._modalityPanel.getVariableName()) || this._modalityPanel.isRelative() != this._lookbackDistPanel.isRelative() || this._modalityPanel.isSeasonal() != this._lookbackDistPanel.isSeasonal()) {
                    this._lookbackDistPanel.setDefaultValue(((MCVariableLocationWizardPanelImpl)this._ruleParamPanel).getDefaultValue());
                    this._lookbackDistPanel.buildPanel(this._modalityPanel.isRelative(), this._modalityPanel.isSeasonal(), this._ruleParamPanel.getParamID());
                }
                this._lookbackDistPanel.setVariableName(this._modalityPanel.getVariableName());
                this._ruleParamPanel.enableMultiSelection(true);
                this._ruleParamPanel.setVariableName(this._modalityPanel.getVariableName());
            } else if (wizardPanel == this._modalityPanel && this._typePanel.getType() == 2) {
                if (!this._lookbackDistPanel.getVariableName().equals(this._modalityPanel.getVariableName()) || this._modalityPanel.isRelative() != this._lookbackDistPanel.isRelative() || this._modalityPanel.isSeasonal() != this._lookbackDistPanel.isSeasonal()) {
                    this._lookbackDistPanel.setDefaultValue(((MCVariableLocationWizardPanelImpl)this._lookbackLocationPanel).getDefaultValue());
                    this._lookbackDistPanel.buildPanel(this._modalityPanel.isRelative(), this._modalityPanel.isSeasonal(), this._lookbackLocationPanel.getParamID());
                }
                this._lookbackDistPanel.setVariableName(this._modalityPanel.getVariableName());
                this._lookbackLocationPanel.enableMultiSelection(true);
                this._lookbackLocationPanel.setVariableName(this._modalityPanel.getVariableName());
            } else if (wizardPanel == this._modalityPanel && this._typePanel.getType() == 3) {
                if (!this._ratingDistPanel.getVariableName().equals(this._modalityPanel.getVariableName()) || this._modalityPanel.isRelative() != this._ratingDistPanel.isRelative()) {
                    this._ratingDistPanel.buildPanel(this._modalityPanel.isRelative(), this._modalityPanel.isSeasonal(), this._ratingLocationPanel.getParamID());
                }
                if (!(this._ratingDistPanel.getVariableName().equals(this._modalityPanel.getVariableName()) || string.equals("Variable Type") || this._modalityPanel.isRelative())) {
                    ((MCVariableDistributionWizardPanelImpl)this._ratingDistPanel).setVariableName(this._modalityPanel.getVariableName());
                    this._ratingDistPanel.setJunction(this._ratingLocationPanel.getSelectedJunction());
                }
                ((MCVariableDistributionWizardPanelImpl)this._ratingDistPanel).setVariableName(this._modalityPanel.getVariableName());
                ((MCVariableLocationWizardPanelImpl)this._ratingLocationPanel).setVariableName(this._modalityPanel.getVariableName());
            }
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected void dialogFinished() {
        Cursor cursor = this.getCursor();
        boolean bl = true;
        Object object = null;
        if (this.getCurrentPanel() instanceof MCContinuousDistributionWizardPanelImpl) {
            ((MCContinuousDistributionWizardPanelImpl)this.getCurrentPanel()).stopTableEditing();
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.getCurrentPanel() == this._tsDistributionPanel && this._tsDistributionPanel.getDistributionType() == 0 && this._tsDistributionPanel.isTotalWeightZero()) {
                object = "Total weight for discrete distribution is zero.";
            }
            MCInputVariableImpl[] mCInputVariableImplArray = this.getInputVariable();
            int[] nArray = this._edit ? this._inputPanel.getGroupRows(mCInputVariableImplArray[0].getGroupNumber()) : new int[]{};
            int n = 0;
            MCInputVariableImpl[] mCInputVariableImplArray2 = mCInputVariableImplArray;
            int n2 = mCInputVariableImplArray.length;
            for (int i = 0; i < n2; ++i) {
                MCInputVariableImpl mCInputVariableImpl = mCInputVariableImplArray2[i];
                if (mCInputVariableImpl instanceof MCInputClippedDataVariable) {
                    if (this.isEmpirical(mCInputVariableImpl)) {
                        object = MCVariableWizardDialog.getFinalWarningMessages();
                        if (((String)object).trim().isEmpty()) {
                            object = null;
                        }
                    } else {
                        MCInputClippedDataVariable mCInputClippedDataVariable = (MCInputClippedDataVariable)mCInputVariableImpl;
                        if (mCInputClippedDataVariable.getClipDist().getClipData().hasMinClip() && mCInputClippedDataVariable.getClipDist().getClipData().hasMaxClip()) {
                            if (mCInputClippedDataVariable.getClipDist().getClipData().getMinVal() > mCInputClippedDataVariable.getClipDist().getClipData().getMaxVal()) {
                                object = "Clipped Min can not be larger than Clipped Max.";
                            }
                        } else if (mCInputClippedDataVariable.getClipDist().getClipData().hasMinClip()) {
                            if (mCInputClippedDataVariable.getClipDist() instanceof UnifClipDist) {
                                if (((UnifClipDist)mCInputClippedDataVariable.getClipDist()).getRight() < mCInputClippedDataVariable.getClipDist().getClipData().getMinVal() || mCInputClippedDataVariable.getClipDist().getClipData().getMinVal() < ((UnifClipDist)mCInputClippedDataVariable.getClipDist()).getLeft()) {
                                    object = "The Clipped Min must fall between the Left and Right values.";
                                }
                            } else if (mCInputClippedDataVariable.getClipDist() instanceof TriangClipDist) {
                                if (((TriangClipDist)mCInputClippedDataVariable.getClipDist()).getRight() < mCInputClippedDataVariable.getClipDist().getClipData().getMinVal() || mCInputClippedDataVariable.getClipDist().getClipData().getMinVal() < ((TriangClipDist)mCInputClippedDataVariable.getClipDist()).getLeft()) {
                                    object = "The Clipped Min must fall between the Left and Right values.";
                                }
                            } else if ((mCInputClippedDataVariable.getClipDist() instanceof LogNormalClipDist || mCInputClippedDataVariable.getClipDist() instanceof Log10NormalClipDist) && 0.0 >= mCInputClippedDataVariable.getClipDist().getClipData().getMinVal()) {
                                object = "The Clipped Min must be greater than or equal to 0 (zero).  ";
                            }
                        } else if (mCInputClippedDataVariable.getClipDist().getClipData().hasMaxClip()) {
                            if (mCInputClippedDataVariable.getClipDist() instanceof UnifClipDist) {
                                if (((UnifClipDist)mCInputClippedDataVariable.getClipDist()).getRight() < mCInputClippedDataVariable.getClipDist().getClipData().getMaxVal() || mCInputClippedDataVariable.getClipDist().getClipData().getMaxVal() < ((UnifClipDist)mCInputClippedDataVariable.getClipDist()).getLeft()) {
                                    object = "The Clipped Max must fall between the Left and Right values.";
                                }
                            } else if (mCInputClippedDataVariable.getClipDist() instanceof TriangClipDist) {
                                if (((TriangClipDist)mCInputClippedDataVariable.getClipDist()).getRight() < mCInputClippedDataVariable.getClipDist().getClipData().getMaxVal() || mCInputClippedDataVariable.getClipDist().getClipData().getMaxVal() < ((TriangClipDist)mCInputClippedDataVariable.getClipDist()).getLeft()) {
                                    object = "The Clipped Max must fall between the Left and Right values.";
                                }
                            } else if ((mCInputClippedDataVariable.getClipDist() instanceof LogNormalClipDist || mCInputClippedDataVariable.getClipDist() instanceof Log10NormalClipDist) && 0.0 > mCInputClippedDataVariable.getClipDist().getClipData().getMaxVal()) {
                                object = "The Clipped Max must be greater than or equal to 0 (zero).  ";
                            }
                        }
                        if (mCInputClippedDataVariable.getClipDist() instanceof UnifClipDist) {
                            if (((UnifClipDist)mCInputClippedDataVariable.getClipDist()).getLeft() > ((UnifClipDist)mCInputClippedDataVariable.getClipDist()).getRight()) {
                                object = "The Left value must be less than or equal to Right value.";
                            }
                        } else if (mCInputClippedDataVariable.getClipDist() instanceof TriangClipDist && ((TriangClipDist)mCInputClippedDataVariable.getClipDist()).getLeft() > ((TriangClipDist)mCInputClippedDataVariable.getClipDist()).getRight()) {
                            object = "The Left value must be less than or equal to Right value.";
                        }
                    }
                }
                if (object != null) {
                    int n3 = JOptionPane.showConfirmDialog((Component)((Object)this), object = (String)object + "\nRes-Sim will be unable to simulate this alternative.\nDo you still want to save?", "Data Consistency Error", 1);
                    if (n3 == 1) {
                        bl = false;
                    } else if (n3 == 2) {
                        return;
                    }
                }
                if (mCInputVariableImpl == null || !bl) continue;
                if (this._edit) {
                    if (nArray.length != mCInputVariableImplArray.length) {
                        Arrays.sort(nArray);
                        if (n == 0) {
                            for (int j = nArray.length - 1; j >= 0; --j) {
                                this._inputPanel.deleteVariable(nArray[j]);
                            }
                        }
                        if (mCInputVariableImpl instanceof MCInputStochasticVariableImpl) {
                            this._inputPanel.addVariable(-1, (MCInputStochasticVariableImpl)mCInputVariableImpl);
                        } else {
                            this._inputPanel.addVariable(-1, (MCInputScriptVariable)mCInputVariableImpl);
                        }
                    } else if (mCInputVariableImpl instanceof MCInputStochasticVariableImpl) {
                        this._inputPanel.addVariable(nArray[n], (MCInputStochasticVariableImpl)mCInputVariableImpl);
                    } else {
                        this._inputPanel.addVariable(nArray[n], (MCInputScriptVariable)mCInputVariableImpl);
                    }
                    ++n;
                    continue;
                }
                if (mCInputVariableImpl instanceof MCInputStochasticVariableImpl) {
                    this._inputPanel.addVariable(-1, (MCInputStochasticVariableImpl)mCInputVariableImpl);
                    continue;
                }
                this._inputPanel.addVariable(-1, (MCInputScriptVariable)mCInputVariableImpl);
            }
        }
        finally {
            this.setCursor(cursor);
            this._inputPanel.removeWarningCheckListener(this);
        }
        this.setVisible(false);
        this._parent.setFocusable(true);
        this._inputPanel.setModified(true);
        this.dispose();
    }

    public static String getFinalWarningMessages() {
        return b;
    }

    public static void setFinalWarningMessages(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0 && stringArray[0] != null) {
            b = stringArray[0];
        }
    }

    private boolean isEmpirical(MCInputVariableImpl mCInputVariableImpl) {
        if ((mCInputVariableImpl = ((MCInputStochasticVariableImpl)((MCInputClippedDataVariable)mCInputVariableImpl)).getDist()) instanceof EmpiricalDist) {
            return true;
        }
        return mCInputVariableImpl instanceof SeasonalContinuousDistribution && ((SeasonalContinuousDistribution)((Object)mCInputVariableImpl)).getDist() instanceof EmpiricalDist;
    }

    public MCInputVariableImpl[] getInputVariable() {
        MCInputVariableImpl[] mCInputVariableImplArray = null;
        if (this.getCurrentPanel() instanceof MCDiscreteDistributionWizardPanel) {
            MCInputVariableImpl[] mCInputVariableImplArray2 = new MCInputStochasticVariableImpl[1];
            mCInputVariableImplArray = mCInputVariableImplArray2;
            mCInputVariableImplArray2[0] = (MCInputTSVariable)this._tsDistributionPanel.getInputVariable();
        } else if (this.getCurrentPanel() instanceof MCScalarDistributionWizardPanel) {
            if (this._typePanel.getType() == 4) {
                mCInputVariableImplArray = (MCInputStochasticVariableImpl[])this._lookbackDistPanel.getInputVariable(this._tsMultiplierLocationPanel.getVariableNames());
            }
            if (this._typePanel.getType() == 2) {
                mCInputVariableImplArray = (MCInputStochasticVariableImpl[])this._lookbackDistPanel.getInputVariable(this._lookbackLocationPanel.getVariableNames());
            }
            if (this._typePanel.getType() == 1) {
                mCInputVariableImplArray = (MCInputStochasticVariableImpl[])this._lookbackDistPanel.getInputVariable(this._ruleParamPanel.getVariableNames());
            }
        } else if (this.getCurrentPanel() instanceof MCVectorDistributionWizardPanel) {
            mCInputVariableImplArray = this._ratingDistPanel.getInputVariable(this._ratingLocationPanel.getVariableNames());
        } else if (this.getCurrentPanel() instanceof MCScriptWizardPanel) {
            mCInputVariableImplArray = this._scriptWriterPanel.getInputVariable(this._alt);
        }
        for (int i = 0; i < mCInputVariableImplArray.length; ++i) {
            if (mCInputVariableImplArray[i] == null) continue;
            mCInputVariableImplArray[i].setActive(true);
            mCInputVariableImplArray[i].setUncertaintyType(this._typePanel.getUncertaintyType());
        }
        return mCInputVariableImplArray;
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public List<MCInputVariableImpl> getAvailableInputVariables() {
        return this._inputPanel.getInputVariableList();
    }

    private void addActionListeners() {
        this._modalityPanel.getAbsoluteButton().addActionListener((ActionListener)new MCVariableWizardDialog$1(this));
        this._modalityPanel.getRelativeButton().addActionListener((ActionListener)new MCVariableWizardDialog$2(this));
    }

    protected void refreshWarnings() {
        this._lookbackDistPanel.checkWarnings();
        ((MCContinuousDistributionWizardPanelImpl)this._ratingDistPanel).checkWarnings();
    }

    private void radioButtonAction() {
        if (this._modalityPanel.getAbsoluteButton().isSelected()) {
            this._lookbackDistPanel.setRelative(false);
            this._ratingDistPanel.setRelative(false);
            return;
        }
        if (this._modalityPanel.getRelativeButton().isSelected()) {
            this._lookbackDistPanel.setRelative(true);
            this._ratingDistPanel.setRelative(true);
        }
    }

    public Double[] getDefaultValue(int n, String string, String string2) {
        if (n == 4) {
            return ((MCVariableLocationWizardPanelImpl)this._tsMultiplierLocationPanel).getDefaultValue(string, string2);
        }
        if (n == 2) {
            return ((MCVariableLocationWizardPanelImpl)this._lookbackLocationPanel).getDefaultValue(string, string2);
        }
        if (n == 1) {
            return ((MCVariableLocationWizardPanelImpl)this._ruleParamPanel).getDefaultValue(string, string2);
        }
        if (n == 3) {
            return ((MCVariableLocationWizardPanelImpl)this._ratingLocationPanel).getDefaultValue(string, string2);
        }
        return null;
    }

    public Double[] getDefaultValue(int n, String string, String string2, int n2) {
        if (n == 3) {
            return this._ratingLocationPanel.getDefaultValue(string, string2, n2);
        }
        return null;
    }

    public HecTime[] getDates() {
        HecTime[] hecTimeArray = null;
        if (this._variable != null && this._variable.getDist() instanceof SeasonalContinuousDistribution) {
            hecTimeArray = ((SeasonalContinuousDistribution)this._variable.getDist()).getHecTimes();
            hecTimeArray = hecTimeArray.toArray(new HecTime[hecTimeArray.size()]);
        } else {
            if (this._typePanel.getType() == 4) {
                hecTimeArray = this._lookbackDistPanel.getDates(this._tsMultiplierLocationPanel.getVariableNames(), this._alt);
            }
            if (this._typePanel.getType() == 2) {
                hecTimeArray = this._lookbackDistPanel.getDates(this._lookbackLocationPanel.getVariableNames(), this._alt);
            }
            if (this._typePanel.getType() == 1) {
                hecTimeArray = this._lookbackDistPanel.getDates(this._ruleParamPanel.getVariableNames(), this._alt);
            }
        }
        return hecTimeArray;
    }

    public AbstractContDist[] getDists(Class<? extends AbstractContDist> clazz, HecTime[] hecTimeArray) {
        int n;
        Double[] doubleArray = this.getDefaultValues(hecTimeArray);
        if (this._modalityPanel.isRelative()) {
            for (n = 0; n < doubleArray.length; ++n) {
                doubleArray[n] = 100.0;
            }
        }
        hecTimeArray = new AbstractContDist[doubleArray.length];
        for (n = 0; n < doubleArray.length; ++n) {
            LogNormalClipDist logNormalClipDist;
            if (clazz.toString().contains("LogNormal")) {
                if (doubleArray[n] <= 0.0) {
                    logNormalClipDist = new LogNormalClipDist();
                    logNormalClipDist.setParametrizationNumber(1);
                    logNormalClipDist.setParams2(new double[]{0.001, 0.001});
                    hecTimeArray[n] = logNormalClipDist;
                    continue;
                }
                logNormalClipDist = new LogNormalClipDist();
                logNormalClipDist.setParametrizationNumber(1);
                logNormalClipDist.setParams2(new double[]{doubleArray[n], doubleArray[n] * 0.5});
                hecTimeArray[n] = logNormalClipDist;
                continue;
            }
            if (clazz.toString().contains("Log10Normal")) {
                if (doubleArray[n] <= 0.0) {
                    logNormalClipDist = new Log10NormalB17BClipDist();
                    logNormalClipDist.setParametrizationNumber(1);
                    logNormalClipDist.setParams2(new double[]{0.001, 0.001});
                    hecTimeArray[n] = logNormalClipDist;
                    continue;
                }
                logNormalClipDist = new Log10NormalB17BClipDist();
                logNormalClipDist.setParametrizationNumber(1);
                logNormalClipDist.setParams2(new double[]{doubleArray[n], doubleArray[n] * 0.5});
                hecTimeArray[n] = logNormalClipDist;
                continue;
            }
            if (clazz.toString().contains("Unif")) {
                hecTimeArray[n] = new UnifClipDist(doubleArray[n] * 0.5, doubleArray[n] * 1.5);
                continue;
            }
            if (clazz.toString().contains("Triang")) {
                hecTimeArray[n] = new TriangClipDist(doubleArray[n] * 0.5, doubleArray[n].doubleValue(), doubleArray[n] * 1.5);
                continue;
            }
            if (clazz.toString().contains("Normal")) {
                hecTimeArray[n] = new NormalClipDist(doubleArray[n].doubleValue(), 1.0);
                continue;
            }
            if (clazz.toString().contains("Gamma")) {
                hecTimeArray[n] = new GammaClipDist(2.0, doubleArray[n] / 2.0);
                continue;
            }
            if (!clazz.toString().contains("Empirical")) continue;
            hecTimeArray[n] = new EmpiricalDist();
        }
        return hecTimeArray;
    }

    protected Double[] getDefaultValues(HecTime[] hecTimeArray) {
        int n;
        Double[] doubleArray = null;
        if (this._typePanel.getType() == 4) {
            if (this._lookbackDistPanel.isRelative()) {
                doubleArray = new Double[hecTimeArray.length];
                for (n = 0; n < doubleArray.length; ++n) {
                    doubleArray[n] = 100.0;
                }
            } else {
                doubleArray = ((MCVariableLocationWizardPanelImpl)this._tsMultiplierLocationPanel).getDefaultValue();
            }
        }
        if (this._typePanel.getType() == 2) {
            if (this._lookbackDistPanel.isRelative()) {
                doubleArray = new Double[hecTimeArray.length];
                for (n = 0; n < doubleArray.length; ++n) {
                    doubleArray[n] = 100.0;
                }
            } else {
                doubleArray = this._lookbackDistPanel.getDefaultValues(this._lookbackLocationPanel.getVariableNames().get(0), this._alt, hecTimeArray);
            }
        }
        if (this._typePanel.getType() == 1) {
            if (this._lookbackDistPanel.isRelative()) {
                doubleArray = new Double[hecTimeArray.length];
                for (n = 0; n < doubleArray.length; ++n) {
                    doubleArray[n] = 100.0;
                }
            } else {
                doubleArray = this._lookbackDistPanel.getDefaultValues(this._ruleParamPanel.getVariableNames().get(0), this._alt, hecTimeArray);
            }
        }
        return doubleArray;
    }

    public Double[] getDefaultValues(HecTime[] hecTimeArray, String string) {
        Double[] doubleArray = new Double[1];
        if (this._typePanel.getType() == 4) {
            doubleArray = ((MCVariableLocationWizardPanelImpl)this._tsMultiplierLocationPanel).getDefaultValue();
        }
        if (this._typePanel.getType() == 2) {
            doubleArray = this._lookbackDistPanel.getDefaultValues(string, this._alt, hecTimeArray);
        }
        if (this._typePanel.getType() == 1) {
            doubleArray = this._lookbackDistPanel.getDefaultValues(string, this._alt, hecTimeArray);
        }
        return doubleArray;
    }

    public Double[] getDefaultValues(List<HecTime> list, String string) {
        HecTime[] hecTimeArray = new HecTime[list.size()];
        for (int i = 0; i < hecTimeArray.length; ++i) {
            hecTimeArray[i] = list.get(i);
        }
        return this.getDefaultValues(hecTimeArray, string);
    }

    public boolean isSeasonal() {
        return this._modalityPanel.isSeasonal();
    }

    public Double[] getDefaultValue() {
        if (this._typePanel.getType() == 4) {
            return ((MCVariableLocationWizardPanelImpl)this._tsMultiplierLocationPanel).getDefaultValue();
        }
        if (this._typePanel.getType() == 2) {
            return ((MCVariableLocationWizardPanelImpl)this._lookbackLocationPanel).getDefaultValue();
        }
        if (this._typePanel.getType() == 1) {
            return ((MCVariableLocationWizardPanelImpl)this._ruleParamPanel).getDefaultValue();
        }
        if (this._typePanel.getType() == 3) {
            return ((MCVariableLocationWizardPanelImpl)this._ratingLocationPanel).getDefaultValue();
        }
        return null;
    }

    public Double[] getDefaultValue(HecTime hecTime) {
        if (this._typePanel.getType() == 4) {
            return ((MCVariableLocationWizardPanelImpl)this._tsMultiplierLocationPanel).getDefaultValue();
        }
        if (this._typePanel.getType() == 2) {
            return ((MCVariableLocationWizardPanelImpl)this._lookbackLocationPanel).getDefaultValue();
        }
        if (this._typePanel.getType() == 1) {
            return this._ruleParamPanel.getDefaultValue(hecTime);
        }
        if (this._typePanel.getType() == 3) {
            return ((MCVariableLocationWizardPanelImpl)this._ratingLocationPanel).getDefaultValue();
        }
        return null;
    }

    public void setNumberOfSteps(int n) {
        a = "Input Random Variable Wizard - Step X of " + n;
    }
}

