/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.model.PairedValuesExt;
import hec.rss.model.Junction;
import hec.rss.model.RssAlt;
import hec.rss.plugins.montecarlo.client.DistributionPanel;
import hec.rss.plugins.montecarlo.client.MCContinuousDistributionWizardPanelImpl;
import hec.rss.plugins.montecarlo.client.MCVariableWizardDialog;
import hec.rss.plugins.montecarlo.client.MCVectorDistributionWizardPanel$1;
import hec.rss.plugins.montecarlo.client.MCVectorDistributionWizardPanel$2;
import hec.rss.plugins.montecarlo.client.MCVectorDistributionWizardPanel$3;
import hec.rss.plugins.montecarlo.client.rating.RatingCurveEditPanel;
import hec.rss.plugins.montecarlo.model.MCInputRatingCurveVariable;
import hec.rss.plugins.montecarlo.model.MCInputStochasticVariableImpl;
import hec.rss.plugins.montecarlo.model.MCInputVariableImpl;
import hec.statistics.AbstractContDist;
import hec.statistics.EmpiricalDist;
import hec.statistics.GammaClipDist;
import hec.statistics.LogNormalClipDist;
import hec.statistics.NormalClipDist;
import hec.statistics.TriangClipDist;
import hec.statistics.UnifClipDist;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import rma.swing.RmaInsets;
import rma.swing.RmaJTextArea;
import rma.swing.RmaJTextField;

public class MCVectorDistributionWizardPanel
extends MCContinuousDistributionWizardPanelImpl {
    public static final String PANEL_NAME = "RatingCurveDistribution";
    private MCVariableWizardDialog _parent;
    private RssAlt _alt;
    private RatingCurveEditPanel curveEditPanel;
    private RmaJTextArea _warningText;

    public MCVectorDistributionWizardPanel(MCVariableWizardDialog mCVariableWizardDialog) {
        super(mCVariableWizardDialog);
        this.setVisible(true);
        this._parent = mCVariableWizardDialog;
    }

    @Override
    protected void buildPanel(boolean bl, boolean bl2, int n) {
        this.removeAll();
        this.setRelative(bl);
        this.setSeasonal(bl2);
        if (this.isRelative()) {
            MCVectorDistributionWizardPanel mCVectorDistributionWizardPanel = this;
            super.buildPanel(mCVectorDistributionWizardPanel.isRelative(), this.isSeasonal(), n);
            return;
        }
        JComponent jComponent = new JLabel("Select Distribution Parameters");
        jComponent.setFont(new Font(jComponent.getFont().getName(), 1, jComponent.getFont().getSize()));
        new GridBagConstraints();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add(jComponent, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        new GridBagConstraints();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add(jPanel, gridBagConstraints);
        jComponent = new JLabel("Variable");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)jComponent, gridBagConstraints);
        this._variableNameField = new RmaJTextField();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)this._variableNameField, gridBagConstraints);
        this._variableNameField.setEnabled(false);
        this._normalPanel = new DistributionPanel((AbstractContDist)new NormalClipDist(), this._parent, false, false, n, this);
        this._triangularPanel = new DistributionPanel((AbstractContDist)new TriangClipDist(), this._parent, false, false, n, this);
        this._distMap = new HashMap<String, DistributionPanel>();
        this._distMap.put(this._normalPanel.getName(), this._normalPanel);
        this._distMap.put(this._triangularPanel.getName(), this._triangularPanel);
        this.curveEditPanel = new RatingCurveEditPanel(this);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        MCVectorDistributionWizardPanel mCVectorDistributionWizardPanel = this;
        mCVectorDistributionWizardPanel.add((Component)((Object)mCVectorDistributionWizardPanel.curveEditPanel), gridBagConstraints);
        this._warningText = new RmaJTextArea();
        this._warningText.setEditable(false);
        this._warningText.setEnabled(false);
        this._warningText.setForeground(Color.RED);
        jComponent = new JScrollPane((Component)this._warningText, 20, 30);
        jComponent.setPreferredSize(new Dimension(10, 10));
        jComponent.setBorder(BorderFactory.createTitledBorder("Input Variable Warnings"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add(jComponent, gridBagConstraints);
    }

    private String getWarnings() {
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "";
        MCVectorDistributionWizardPanel mCVectorDistributionWizardPanel = this;
        MCInputStochasticVariableImpl[] mCInputStochasticVariableImplArray = mCVectorDistributionWizardPanel.getInputVariable(mCVectorDistributionWizardPanel._parent._ratingLocationPanel.getVariableNames());
        ((MCInputVariableImpl)mCInputStochasticVariableImplArray[0]).checkWarnings(stringArray2, this._parent._alt);
        if (stringArray2[0].equals("")) {
            stringArray2[0] = "No warnings to report";
            this.curveEditPanel.unhighlightResetValuesButtonColor();
        } else {
            this.curveEditPanel.highlightResetValuesButtonColor();
        }
        return stringArray2[0];
    }

    @Override
    public void setVariableName(String string) {
        this._variableNameField.setText(string);
    }

    public String getPanelName() {
        return PANEL_NAME;
    }

    public boolean isValidPanel() {
        return true;
    }

    public void setAlterantive(RssAlt rssAlt) {
        this._alt = rssAlt;
    }

    public MCInputStochasticVariableImpl[] getInputVariable(List<String> mCInputStochasticVariableImplArray) {
        if (this.isRelative()) {
            ArrayList<MCInputRatingCurveVariable> arrayList = new ArrayList<MCInputRatingCurveVariable>();
            Object object = MCInputRatingCurveVariable.getJunctionsWithRatingCurves(this._alt.getSystem());
            object = object.iterator();
            while (object.hasNext()) {
                Junction junction = (Junction)object.next();
                for (String string : mCInputStochasticVariableImplArray) {
                    int n;
                    if (!string.contains(junction.getName())) continue;
                    String string2 = junction.getName();
                    if (this.isRelative()) {
                        MCVectorDistributionWizardPanel mCVectorDistributionWizardPanel = this;
                        n = mCVectorDistributionWizardPanel.convertDistNameToType((String)mCVectorDistributionWizardPanel._distributionType.getSelectedItem());
                    } else {
                        n = this.curveEditPanel.getDistributionType();
                    }
                    PairedValuesExt pairedValuesExt = MCInputRatingCurveVariable.getFlowVsStageCurves(junction).clone();
                    this.convertToDist(pairedValuesExt);
                    double[][] dArray = pairedValuesExt.getYData();
                    double[][] dArray2 = new double[dArray[0].length][dArray.length];
                    for (int i = 0; i < dArray.length; ++i) {
                        for (int j = 0; j < dArray[i].length; ++j) {
                            dArray2[j][i] = dArray[i][j];
                        }
                    }
                    PairedValuesExt pairedValuesExt2 = pairedValuesExt;
                    pairedValuesExt2.setArrays(pairedValuesExt2.getXArray(), dArray2);
                    String[] stringArray = new String[]{junction.getRatingCurve().getCurveLabel()};
                    MCInputRatingCurveVariable mCInputRatingCurveVariable = new MCInputRatingCurveVariable(string2, n, pairedValuesExt, stringArray);
                    mCInputRatingCurveVariable.setReference(true);
                    mCInputRatingCurveVariable.setDist(this._distMap.get(mCInputRatingCurveVariable.getDistributionName()).getDistribution());
                    arrayList.add(mCInputRatingCurveVariable);
                }
            }
            if (arrayList.size() > 1) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    ((MCInputVariableImpl)((MCInputStochasticVariableImpl)arrayList.get(i))).setParameterEqualString(this._variableNameField.getText());
                    ((MCInputStochasticVariableImpl)arrayList.get(i)).setGroupNumber(Integer.valueOf(this._variableNameField.getText().substring(this._variableNameField.getText().indexOf(":") + 1, this._variableNameField.getText().length())));
                }
            } else {
                ((MCInputVariableImpl)((MCInputStochasticVariableImpl)arrayList.get(0))).setParameterEqualString(this._variableNameField.getText());
                ((MCInputStochasticVariableImpl)arrayList.get(0)).setGroupNumber(0);
            }
            ArrayList<MCInputRatingCurveVariable> arrayList2 = arrayList;
            mCInputStochasticVariableImplArray = arrayList2.toArray(new MCInputStochasticVariableImpl[arrayList2.size()]);
        } else {
            String string;
            mCInputStochasticVariableImplArray = new MCInputStochasticVariableImpl[1];
            String string2 = string = this._variableNameField.getText();
            String string3 = string.substring(string2.indexOf("-") + 1, string2.length());
            string2 = string3;
            string2 = string3;
            string2 = string3.trim();
            MCInputRatingCurveVariable mCInputRatingCurveVariable = this.curveEditPanel.buildRCVariable(string2);
            ((MCInputVariableImpl)mCInputRatingCurveVariable).setParameterEqualString(string);
            Junction junction = MCInputRatingCurveVariable.getJunctionByName(string2, this._alt);
            if (junction != null) {
                mCInputRatingCurveVariable.setLocationIndex(junction.getIndex());
            }
            MCVectorDistributionWizardPanel mCVectorDistributionWizardPanel = this;
            mCInputRatingCurveVariable.setDist(this._distMap.get(mCVectorDistributionWizardPanel.convertDistTypeToName(mCVectorDistributionWizardPanel.curveEditPanel.getDistributionType())).getDistribution());
            mCInputStochasticVariableImplArray[0] = mCInputRatingCurveVariable;
        }
        return mCInputStochasticVariableImplArray;
    }

    private int convertDistNameToType(String string) {
        if (string == this._normalPanel.getName()) {
            return 1;
        }
        if (string == this._uniformPanel.getName()) {
            return 2;
        }
        if (string == this._triangularPanel.getName()) {
            return 3;
        }
        if (string == this._logNormalPanel.getName()) {
            return 4;
        }
        if (string == this._gammaPanel.getName()) {
            return 5;
        }
        if (string == this._empiricalPanel.getName()) {
            return 6;
        }
        return 0;
    }

    private String convertDistTypeToName(int n) {
        if (n == 1) {
            return this._normalPanel.getName();
        }
        if (n == 2) {
            return this._uniformPanel.getName();
        }
        if (n == 3) {
            return this._triangularPanel.getName();
        }
        if (n == 4) {
            return this._logNormalPanel.getName();
        }
        if (n == 5) {
            return this._gammaPanel.getName();
        }
        if (n == 6) {
            return this._empiricalPanel.getName();
        }
        return null;
    }

    protected void fillEditPanel(MCInputRatingCurveVariable mCInputRatingCurveVariable, String object) {
        this.setRelative(mCInputRatingCurveVariable.isRelative());
        this._paramID = mCInputRatingCurveVariable.getParamId();
        this._variableNameField.setText((String)object);
        if (mCInputRatingCurveVariable.isRelative()) {
            if (mCInputRatingCurveVariable.getDistributionType() == 1) {
                this._distributionType.setSelectedItem(this._normalPanel.getName());
                double[][] dArray = mCInputRatingCurveVariable.getValues().getYData();
                object = dArray;
                double d = dArray[0][0];
                Object object2 = object[1][0];
                this._normalPanel.fillPanel((AbstractContDist)new NormalClipDist(d, (double)object2), mCInputRatingCurveVariable.getParamId(), mCInputRatingCurveVariable.getInputVariableNames());
                return;
            }
            if (mCInputRatingCurveVariable.getDistributionType() == 2) {
                this._distributionType.setSelectedItem(this._uniformPanel.getName());
                this._uniformPanel.fillPanel((AbstractContDist)((UnifClipDist)mCInputRatingCurveVariable.getDist()), mCInputRatingCurveVariable.getParamId(), mCInputRatingCurveVariable.getInputVariableNames());
                return;
            }
            if (mCInputRatingCurveVariable.getDistributionType() == 3) {
                this._distributionType.setSelectedItem(this._triangularPanel.getName());
                double[][] dArray = mCInputRatingCurveVariable.getValues().getYData();
                object = dArray;
                double d = dArray[0][0];
                Object object3 = object[1][0];
                Object object4 = object[2][0];
                this._triangularPanel.fillPanel((AbstractContDist)new TriangClipDist(d, (double)object3, (double)object4), mCInputRatingCurveVariable.getParamId(), mCInputRatingCurveVariable.getInputVariableNames());
                return;
            }
            if (mCInputRatingCurveVariable.getDistributionType() == 4) {
                this._distributionType.setSelectedItem(this._logNormalPanel.getName());
                this._logNormalPanel.fillPanel((AbstractContDist)((LogNormalClipDist)mCInputRatingCurveVariable.getDist()), mCInputRatingCurveVariable.getParamId(), mCInputRatingCurveVariable.getInputVariableNames());
                return;
            }
            if (mCInputRatingCurveVariable.getDistributionType() == 5) {
                this._distributionType.setSelectedItem(this._gammaPanel.getName());
                this._gammaPanel.fillPanel((AbstractContDist)((GammaClipDist)mCInputRatingCurveVariable.getDist()), mCInputRatingCurveVariable.getParamId(), mCInputRatingCurveVariable.getInputVariableNames());
                return;
            }
            if (mCInputRatingCurveVariable.getDistributionType() == 6) {
                this._distributionType.setSelectedItem(this._empiricalPanel.getName());
                object = (EmpiricalDist)mCInputRatingCurveVariable.getDist();
                EmpiricalDist empiricalDist = new EmpiricalDist();
                empiricalDist.setInterpType(object.getInterpType());
                empiricalDist.setCumProbs(object.getCumProbs());
                empiricalDist.setValues(object.getValues());
                this._empiricalPanel.fillPanel((AbstractContDist)empiricalDist, mCInputRatingCurveVariable.getParamId(), new HashMap<Integer, String>());
                return;
            }
        } else {
            this.curveEditPanel.fillForm(mCInputRatingCurveVariable.clone(), false);
            ((MCContinuousDistributionWizardPanelImpl)this).checkWarnings();
            this.curveEditPanel.getPVETableModel().addTableModelListener(new MCVectorDistributionWizardPanel$1(this));
        }
    }

    public void setJunction(Junction junction) {
        this.curveEditPanel.fillForm(junction, true);
        ((MCContinuousDistributionWizardPanelImpl)this).checkWarnings();
        this.curveEditPanel.getPVETableModel().addTableModelListener(new MCVectorDistributionWizardPanel$2(this));
    }

    private void convertToDist(PairedValuesExt pairedValuesExt) {
        Object object = this._distMap.get(this._distributionType.getSelectedItem());
        double[][] dArray = pairedValuesExt.getYData();
        double[] dArray2 = pairedValuesExt.getXArray();
        object = object.getDistribution().getParamVals();
        double[][] dArray3 = new double[dArray[0].length][((DistributionPanel)object).length * dArray.length];
        for (int i = 0; i < dArray[0].length; ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                for (int k = 0; k < ((DistributionPanel)object).length; ++k) {
                    dArray3[i][((DistributionPanel)object).length * j + k] = (double)object[k];
                }
            }
        }
        pairedValuesExt.setArrays(dArray2, dArray3);
    }

    public void resetTableDefaultValues() {
        this.curveEditPanel.fillForm(true);
        ((MCContinuousDistributionWizardPanelImpl)this).checkWarnings();
        this.curveEditPanel.getPVETableModel().addTableModelListener(new MCVectorDistributionWizardPanel$3(this));
    }

    @Override
    public void checkWarnings() {
        if (this._warningText == null) {
            return;
        }
        this._warningText.setText(this.getWarnings());
        this._warningText.setCaretPosition(0);
        this._warningText.repaint();
        this._warningText.revalidate();
    }
}

