/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.clientapp.client.ClientApp;
import hec.gui.AbstractEditorPanel;
import hec.lang.NamedType;
import hec.model.AltItem;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.AlternativePanel;
import hec.rss.client.RSimSimulationMode;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSystem;
import hec.rss.plugins.ResSimPluginModelPanel;
import hec.rss.plugins.factories.AltPluginDataFactory;
import hec.rss.plugins.model.AltPluginData;
import hec.rss.plugins.montecarlo.client.MCControlPanel;
import hec.rss.plugins.montecarlo.client.MCConvergencePanel;
import hec.rss.plugins.montecarlo.client.MCInputPanel;
import hec.rss.plugins.montecarlo.client.MCOutputPanel;
import hec.rss.plugins.montecarlo.client.MCPanel;
import hec.rss.plugins.montecarlo.model.MCAltPluginData;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import rma.swing.RmaInsets;
import rma.util.RMAIO;

public class MonteCarloPanel
extends AbstractEditorPanel
implements AlternativePanel,
ResSimPluginModelPanel {
    private JTabbedPane _tabbedPane;
    private MCInputPanel _inputVariablePanel;
    private MCConvergencePanel _convergenceVariablePanel;
    private MCOutputPanel _outputVariablesPanel;
    private MCControlPanel _mcControlPanel;
    private MCPanel _currentTab;

    public MonteCarloPanel() {
        super((LayoutManager)new GridBagLayout());
        this.buildControls();
        this.addListeners();
    }

    public void setEnabled(boolean bl) {
    }

    protected void buildControls() {
        this.setBorder(BorderFactory.createTitledBorder("Monte Carlo"));
        JComponent jComponent = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add(jComponent, gridBagConstraints);
        this._tabbedPane = new JTabbedPane();
        jComponent = new JScrollPane(this._tabbedPane);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add(jComponent, gridBagConstraints);
        this._inputVariablePanel = new MCInputPanel(this);
        this._convergenceVariablePanel = new MCConvergencePanel(this);
        MonteCarloPanel monteCarloPanel = this;
        this._outputVariablesPanel = new MCOutputPanel(monteCarloPanel, monteCarloPanel._convergenceVariablePanel);
        this._mcControlPanel = new MCControlPanel(this);
        this._tabbedPane.add("Input Variables", (Component)((Object)this._inputVariablePanel));
        this._tabbedPane.add("Output Variables", (Component)((Object)this._outputVariablesPanel));
        this._tabbedPane.add("MC Controls", (Component)((Object)this._mcControlPanel));
        this._currentTab = this._inputVariablePanel;
    }

    public MCInputPanel getInputVariablePanel() {
        return this._inputVariablePanel;
    }

    public MCOutputPanel getOutputVariablePanel() {
        return this._outputVariablesPanel;
    }

    protected void addListeners() {
        this._tabbedPane.addChangeListener(changeEvent -> this.tabPanelChanged(changeEvent));
    }

    private void tabPanelChanged(ChangeEvent serializable) {
        serializable = this._tabbedPane.getSelectedComponent();
        if (this._currentTab instanceof MCPanel) {
            this._currentTab.switchedFrom();
        }
        if (serializable instanceof MCPanel) {
            ((MCPanel)((Object)serializable)).switchedTo();
            this._currentTab = (MCPanel)((Object)serializable);
        }
    }

    public String getTabname() {
        return "Monte Carlo";
    }

    public void setSystem(RssSystem rssSystem) {
    }

    public void clearPanel() {
        this._mcControlPanel.clear();
        this._inputVariablePanel.clear();
        this._outputVariablesPanel.clear();
    }

    public boolean createPluginAlternative(RssAlt rssAlt) {
        return true;
    }

    public void deleteAltManager(RssAlt rssAlt) {
    }

    public boolean updateAltItemList(Vector<AltItem> vector) {
        return false;
    }

    public void fillPanel(NamedType namedType) {
        if (namedType instanceof RssAlt) {
            Object object = (namedType = (RssAlt)namedType).getAltPluginData(AltPluginDataFactory.MC);
            if (object instanceof MCAltPluginData) {
                object = (MCAltPluginData)((Object)object);
                this.fillPanel(((MCAltPluginData)((Object)object)).clone(), (RssAlt)namedType);
                return;
            }
            this._mcControlPanel.setAlt((RssAlt)namedType);
            this._inputVariablePanel.setAlt((RssAlt)namedType);
            this._outputVariablesPanel.setAlt((RssAlt)namedType);
        }
    }

    public void fillPanel(MCAltPluginData mCAltPluginData, RssAlt rssAlt) {
        this._mcControlPanel.fillPanel(mCAltPluginData, rssAlt);
        this._inputVariablePanel.fillPanel(mCAltPluginData, rssAlt);
        this._outputVariablesPanel.fillPanel(mCAltPluginData, rssAlt);
    }

    public boolean savePanel(NamedType namedType) {
        if (namedType instanceof RssAlt) {
            return this.savePanel((RssAlt)namedType);
        }
        return true;
    }

    public boolean savePanel(RssAlt object) {
        Object object2;
        this.setIgnoreModifiedEvents(true);
        if (object == null) {
            return false;
        }
        Object object3 = object.getAltPluginData(AltPluginDataFactory.MC);
        if (!(object3 instanceof MCAltPluginData)) {
            object3 = new MCAltPluginData();
            object.addAltPluginData((AltPluginData)object3);
        } else {
            object3 = (MCAltPluginData)((Object)object3);
        }
        if (!((MCAltPluginData)((Object)object3)).hasAlt()) {
            object2 = (RssAlt)object.clone();
            object3.setAlt(object2);
            this._inputVariablePanel.setAlt((RssAlt)object2);
            this._outputVariablesPanel.setAlt((RssAlt)object2);
            this._mcControlPanel.setAlt((RssAlt)object2);
        }
        if ((object2 = SwingUtilities.windowForComponent((Component)((Object)this))) instanceof AlternativeEditor) {
            object2 = (AlternativeEditor)object2;
            ((MCAltPluginData)((Object)object3)).setUseCompute(object2.getRunControlPanel().isPluginRadioSelected(AltPluginDataFactory.MC));
        }
        object2 = object.getIdentifier().getPath();
        String string = RMAIO.getFileNameNoExtension((String)object2) + ".mcscript";
        object2 = RMAIO.getDirectoryFromPath((String)object2);
        object2 = (String)object2 + "/" + string;
        object = object.getRelativePath((String)object2);
        ((MCAltPluginData)((Object)object3)).setScriptFileName((String)object);
        this._inputVariablePanel.savePanel((MCAltPluginData)((Object)object3));
        this._outputVariablesPanel.savePanel((MCAltPluginData)((Object)object3));
        boolean bl = this._mcControlPanel.savePanel((MCAltPluginData)((Object)object3));
        this.setModified(false);
        this.setIgnoreModifiedEvents(false);
        return bl;
    }

    public void switchedFrom(Component component) {
        component = this._tabbedPane.getSelectedComponent();
        if (component == this._inputVariablePanel) {
            this._inputVariablePanel.switchedFrom();
            return;
        }
        if (component == this._outputVariablesPanel) {
            this._outputVariablesPanel.switchedFrom();
        }
    }

    public void switchedTo() {
        Component component = this._tabbedPane.getSelectedComponent();
        if (component == this._inputVariablePanel) {
            this._inputVariablePanel.switchedTo();
            return;
        }
        if (component == this._outputVariablesPanel) {
            this._outputVariablesPanel.switchedTo();
        }
    }

    public void setClearResultsRadio() {
        this._mcControlPanel.setClearResultsRadio();
    }

    public boolean isClearResultsRadioSelected() {
        return this._mcControlPanel.isClearResultsRadioSelected();
    }

    protected void tellUserClearSelected(String string) {
        if (ClientApp.frame().getCurrentMode() instanceof RSimSimulationMode && !this.isClearResultsRadioSelected()) {
            JOptionPane.showMessageDialog(SwingUtilities.windowForComponent((Component)((Object)this)), "<html>Monte Carlo " + string + " data has changed, the <b>Clear Previous Monte Carlo Results and start first iteration</b> option will be selected</html>", "Restarting Monte Carlo Results", 1);
            this.setClearResultsRadio();
        }
    }
}

