/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.clientapp.model.TSRecordProxy;
import hec.gui.WizardPanel;
import hec.model.ModelVariable;
import hec.model.TSLocation;
import hec.rss.client.TimeSeriesOptionsPanel;
import hec.rss.model.Element;
import hec.rss.model.Function;
import hec.rss.model.OpRule;
import hec.rss.model.OpSet;
import hec.rss.model.RssAlt;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssNode;
import hec.rss.model.RssSystem;
import hec.rss.plugins.montecarlo.client.OutputVarLocationWizardPanel$1;
import hec.rss.plugins.montecarlo.client.OutputVarLocationWizardPanel$2;
import hec.rss.plugins.montecarlo.client.OutputVarLocationWizardPanel$3;
import hec.rss.plugins.montecarlo.client.OutputVarLocationWizardPanel$4;
import hec.rss.plugins.montecarlo.client.OutputVarLocationWizardPanel$5;
import hec.rss.plugins.montecarlo.client.OutputVarLocationWizardPanel$6;
import hec.rss.plugins.montecarlo.client.OutputVarLocationWizardPanel$TableModel;
import hec.rss.plugins.montecarlo.model.MCOutputVariable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.list.RmaListModel;
import rma.swing.table.RmaTableModel;
import rma.swing.table.RmaTableSorter;

public class OutputVarLocationWizardPanel
extends WizardPanel {
    public static final String PANEL_NAME = "Location and Variable";
    private RssAlt _alt;
    private String[] COLNAMES = new String[]{"Name", "Element Type", "Parameter"};
    private RmaJComboBox<String> _nameFilterCombo;
    private RmaJComboBox<String> _typeFilterCombo;
    private RmaJComboBox<String> _variableFilterCombo;
    private RmaJTable _elementTable;
    private RmaJTextField _selectedValueTxt;
    private TimeSeriesOptionsPanel _tsOptionsPanel;
    private RmaTableSorter _sorter;
    private OutputVarLocationWizardPanel$TableModel _tableModel;
    private OutputVarLocationWizardPanel$TableModel _currentTableModel;
    private ActionListener _al;
    private ItemListener _il;
    private String _selectedElement;
    private ModelVariable _selectedModelVariable;
    private TSRecordProxy _selectedTSProxy;
    private Object _variable;

    public OutputVarLocationWizardPanel(String string) {
        super((LayoutManager)new GridBagLayout());
        this.buildControls(string);
    }

    protected void buildControls(String object) {
        Serializable serializable = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this.add((Component)serializable, gridBagConstraints);
        object = new JLabel((String)object);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        serializable.add((Component)object, gridBagConstraints);
        this._selectedValueTxt = new RmaJTextField();
        this._selectedValueTxt.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)0, (int)5, (int)5);
        serializable.add((Component)this._selectedValueTxt, gridBagConstraints);
        object = new JLabel("Filter");
        ((JLabel)object).setDisplayedMnemonic('F');
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add((Component)object, gridBagConstraints);
        serializable = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this.add((Component)serializable, gridBagConstraints);
        this._nameFilterCombo = new RmaJComboBox();
        this._nameFilterCombo.setEditable(true);
        ((JLabel)object).setLabelFor((Component)this._nameFilterCombo);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        serializable.add((Component)this._nameFilterCombo, gridBagConstraints);
        this._typeFilterCombo = new RmaJComboBox();
        this._typeFilterCombo.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        serializable.add((Component)this._typeFilterCombo, gridBagConstraints);
        this._variableFilterCombo = new RmaJComboBox();
        this._variableFilterCombo.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        serializable.add((Component)this._variableFilterCombo, gridBagConstraints);
        OutputVarLocationWizardPanel outputVarLocationWizardPanel = this;
        this._elementTable = new OutputVarLocationWizardPanel$1(outputVarLocationWizardPanel, (Component)((Object)outputVarLocationWizardPanel));
        this._tableModel = new OutputVarLocationWizardPanel$TableModel(this);
        this._tableModel.getDataVector().clear();
        this._currentTableModel = this._tableModel;
        this._elementTable.setModel((TableModel)((Object)this._tableModel));
        this._elementTable.setEditable(false);
        this._elementTable.setAddRemoveEnabled(false);
        this._elementTable.setSelectionMode(0);
        this._elementTable.setColumnSelectionAllowed(false);
        this._elementTable.setCellSelectionEnabled(false);
        this._elementTable.setRowSelectionAllowed(true);
        this._sorter = new RmaTableSorter(this._elementTable.getModel());
        this._elementTable.setModel((TableModel)this._sorter);
        this._sorter.addMouseListenerToHeaderInTable((JTable)this._elementTable);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        OutputVarLocationWizardPanel outputVarLocationWizardPanel2 = this;
        outputVarLocationWizardPanel2.add(outputVarLocationWizardPanel2._elementTable.getScrollPane(), gridBagConstraints);
        this._elementTable.getSelectionModel().addListSelectionListener(new OutputVarLocationWizardPanel$2(this));
        object = new OutputVarLocationWizardPanel$3(this);
        serializable = new OutputVarLocationWizardPanel$4(this);
        this._nameFilterCombo.getActionMap().put("filter", (Action)((Object)serializable));
        this._nameFilterCombo.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "filter");
        this._typeFilterCombo.getActionMap().put("filter", (Action)((Object)serializable));
        this._typeFilterCombo.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "filter");
        this._variableFilterCombo.getActionMap().put("filter", (Action)((Object)serializable));
        this._variableFilterCombo.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "filter");
        this._al = new OutputVarLocationWizardPanel$5(this);
        this._il = new OutputVarLocationWizardPanel$6(this);
        this._nameFilterCombo.addFocusListener((FocusListener)object);
        this._typeFilterCombo.addFocusListener((FocusListener)object);
        this._variableFilterCombo.addFocusListener((FocusListener)object);
        this._nameFilterCombo.addActionListener(this._al);
        this._typeFilterCombo.addActionListener(this._al);
        this._variableFilterCombo.addActionListener(this._al);
        this._nameFilterCombo.addItemListener(this._il);
        this._typeFilterCombo.addItemListener(this._il);
        this._variableFilterCombo.addItemListener(this._il);
    }

    void setSelectedValueTxt() {
        if (this._selectedTSProxy == null || this._selectedModelVariable == null) {
            this._selectedValueTxt.setText("");
            return;
        }
        this._selectedValueTxt.setText(this._selectedElement + " - " + this._alt.getSystem().getNameForKeyString(this._selectedTSProxy.getName()) + " : " + this._selectedModelVariable.toString());
    }

    void setSelectedValueTxt(String string) {
        this._selectedValueTxt.setText(string);
    }

    void filterTable(Object object) {
        String string = null;
        String string2 = null;
        String string3 = null;
        if (object == this._nameFilterCombo) {
            object = this._nameFilterCombo.getSelectedItem();
            if (object != null) {
                string = object.toString();
            }
            string2 = (String)this._typeFilterCombo.getSelectedItem();
            string3 = (String)this._variableFilterCombo.getSelectedItem();
        } else if (object == this._typeFilterCombo) {
            object = this._typeFilterCombo.getSelectedItem();
            if (object != null) {
                string2 = object.toString();
            }
            string3 = (String)this._variableFilterCombo.getSelectedItem();
            string = (String)this._nameFilterCombo.getSelectedItem();
        } else if (object == this._variableFilterCombo) {
            object = this._variableFilterCombo.getSelectedItem();
            if (object != null) {
                string3 = object.toString();
            }
            string = (String)this._nameFilterCombo.getSelectedItem();
            string2 = (String)this._typeFilterCombo.getSelectedItem();
        }
        this.fillForm(string, string2, string3);
    }

    void clearPanel() {
        this._elementTable.deleteCells();
        this._nameFilterCombo.setModel((ComboBoxModel)new RmaListModel(false));
        this._typeFilterCombo.setModel((ComboBoxModel)new RmaListModel(false));
        this._variableFilterCombo.setModel((ComboBoxModel)new RmaListModel(false));
        this._selectedValueTxt.setText("");
        this._selectedElement = null;
        this._selectedTSProxy = null;
        this._selectedModelVariable = null;
        this._tsOptionsPanel.clearPanel();
    }

    public void setSelectedModelVariable(ModelVariable modelVariable) {
        this._selectedModelVariable = modelVariable;
        if (this._selectedModelVariable != null) {
            this._variableFilterCombo.setSelectedItem((Object)this._selectedModelVariable.toString());
        } else {
            this._variableFilterCombo.setSelectedItem((Object)"");
        }
        this.setSelectedValueTxt();
    }

    public void setTimeSeriesOptions(String string, double d, double d2) {
        this._tsOptionsPanel.setTimeSeriesOptions(string, d, d2);
    }

    public String getSelectedElement() {
        return this._selectedElement;
    }

    public TSRecordProxy getSelectedTSProxy() {
        return this._selectedTSProxy;
    }

    public ModelVariable getSelectedModelVariable() {
        return this._selectedModelVariable;
    }

    void setElement(Element element) {
        if (element == null) {
            this._nameFilterCombo.setSelectedItem((Object)"");
        } else {
            this._nameFilterCombo.setSelectedItem((Object)element.getFullName());
        }
        this._typeFilterCombo.setSelectedItem((Object)"");
        this._variableFilterCombo.setSelectedItem((Object)"");
    }

    private String getFilterString(String string) {
        if (string != null) {
            return string.toLowerCase();
        }
        return "";
    }

    public Element getElementForTSProxy(TSRecordProxy tSRecordProxy) {
        if (tSRecordProxy == null) {
            return null;
        }
        TSLocation tSLocation = tSRecordProxy.getParent();
        if (tSLocation == null) {
            return null;
        }
        if (tSLocation instanceof Element) {
            tSRecordProxy = (Element)tSLocation;
        } else if (tSLocation instanceof Function) {
            tSRecordProxy = ((Function)tSLocation).getElement();
        } else {
            if (tSLocation instanceof RssNode) {
                tSRecordProxy = ((RssNode)tSLocation).getUpstreamElement();
                if (tSRecordProxy != null && tSRecordProxy.isNodeComputed((RssNode)tSLocation)) {
                    return tSRecordProxy;
                }
                tSRecordProxy = ((RssNode)tSLocation).getDownstreamElement();
                if (tSRecordProxy != null) {
                    return tSRecordProxy;
                }
                return null;
            }
            if (tSLocation instanceof OpRule) {
                tSRecordProxy = ((OpRule)tSLocation).getController();
                if (tSRecordProxy == null) {
                    return null;
                }
                return tSRecordProxy.getReleaseElement();
            }
            if (tSLocation instanceof OpSet) {
                return (Element)((OpSet)tSLocation).getElementOp().getOperationsElement();
            }
            tSRecordProxy = null;
        }
        return tSRecordProxy;
    }

    private void fillForm(String string, String string2, String string3) {
        this._tableModel.getDataVector().clear();
        if (this._alt.getSystem() == null) {
            this._nameFilterCombo.setModel((ComboBoxModel)new RmaListModel(false));
            this._typeFilterCombo.setModel((ComboBoxModel)new RmaListModel(false));
            this._variableFilterCombo.setModel((ComboBoxModel)new RmaListModel(false));
            return;
        }
        String string4 = this.getFilterString(string);
        String string5 = this.getFilterString(string2);
        String string6 = this.getFilterString(string3);
        RmaListModel rmaListModel = new RmaListModel(false);
        rmaListModel.addElement((Object)"");
        RmaListModel rmaListModel2 = new RmaListModel(false);
        rmaListModel2.addElement((Object)"");
        RmaListModel rmaListModel3 = new RmaListModel(false);
        rmaListModel3.addElement((Object)"");
        RmaTableModel rmaTableModel = (RmaTableModel)this._sorter.getModel();
        Vector vector = new Vector();
        this._elementTable.deleteCells();
        this._alt.getSystem().updateTSProxyList();
        vector = this._alt.getSystem().getActiveTSProxies(vector, 0);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            TSRecordProxy tSRecordProxy = (TSRecordProxy)vector.elementAt(i);
            if (tSRecordProxy == null) continue;
            boolean bl = true;
            Element element = this.getElementForTSProxy(tSRecordProxy);
            if (element == null) continue;
            element = element.getTopParent();
            String string7 = element.getElementType();
            String string8 = this._alt.getSystem().getNameForKeyString(tSRecordProxy.getName());
            tSRecordProxy.setFullName(string8);
            int n2 = tSRecordProxy.getVariableId();
            ModelVariable modelVariable = RssModelVariableSet.getModelVariable((int)n2);
            if (!this.passesFilter(string8, string4)) {
                bl = false;
            }
            if (!this.passesFilter(string7, string5) || !bl || !this.passesFilter(modelVariable.toString(), string6)) continue;
            Vector<Object> vector2 = new Vector<Object>(3);
            vector2.add(tSRecordProxy);
            vector2.add(string7);
            vector2.add(modelVariable);
            this.addToList(rmaListModel3, modelVariable.toString());
            rmaTableModel.addRow(vector2);
            this.addToList(rmaListModel, string8);
            this.addToList(rmaListModel2, string7);
        }
        this._sorter.reallocateIndexes();
        this._sorter.fireTableDataChanged();
        this._nameFilterCombo.removeActionListener(this._al);
        this._typeFilterCombo.removeActionListener(this._al);
        this._variableFilterCombo.removeActionListener(this._al);
        this._nameFilterCombo.removeItemListener(this._il);
        this._typeFilterCombo.removeItemListener(this._il);
        this._variableFilterCombo.removeItemListener(this._il);
        this._nameFilterCombo.setModel((ComboBoxModel)rmaListModel);
        this._typeFilterCombo.setModel((ComboBoxModel)rmaListModel2);
        this._variableFilterCombo.setModel((ComboBoxModel)rmaListModel3);
        this._nameFilterCombo.setSelectedItem((Object)string);
        this._typeFilterCombo.setSelectedItem((Object)string2);
        this._variableFilterCombo.setSelectedItem((Object)string3);
        this._nameFilterCombo.addActionListener(this._al);
        this._typeFilterCombo.addActionListener(this._al);
        this._variableFilterCombo.addActionListener(this._al);
        this._nameFilterCombo.addItemListener(this._il);
        this._typeFilterCombo.addItemListener(this._il);
        this._variableFilterCombo.addItemListener(this._il);
    }

    private void addSubElements(Element element, RmaTableModel rmaTableModel, RmaListModel rmaListModel, RmaListModel rmaListModel2, RmaListModel rmaListModel3, String string, String string2, String string3) {
        Vector vector = element.getElementVector();
        Vector vector2 = new Vector();
        String string4 = "Flow";
        for (int i = 0; i < vector.size(); ++i) {
            Vector<Object> vector3;
            String string5;
            Element element2 = (Element)vector.get(i);
            String string6 = element2.getFullName();
            if (!this.passesFilter(string6, string)) continue;
            vector2.clear();
            element2.getModelVariables(vector2);
            if (vector2.size() == 0) {
                string5 = element2.getElementType();
                if (string5 == null || string5.length() == 0) {
                    string5 = element.getElementType();
                }
                if (!this.passesFilter(string5, string2) || !this.passesFilter(string4, string3)) continue;
                vector3 = new Vector<Object>(3);
                vector3.add(element2);
                vector3.add(string5);
                vector3.add(string4);
                this.addToList(rmaListModel, string6);
                this.addToList(rmaListModel2, string5);
                this.addToList(rmaListModel3, string4);
                rmaTableModel.addRow(vector3);
                continue;
            }
            for (int j = 0; j < vector2.size(); ++j) {
                Object e = vector2.get(j);
                if (!this.passesFilter(e.toString(), string3)) continue;
                string5 = element2.getElementType();
                if (string5 == null || string5.length() == 0) {
                    string5 = element.getElementType();
                }
                if (!this.passesFilter(string5, string2)) continue;
                vector3 = new Vector<String>(3);
                vector3.add(string6);
                vector3.add(string5);
                vector3.add(e);
                this.addToList(rmaListModel, string6);
                this.addToList(rmaListModel2, string5);
                this.addToList(rmaListModel3, e.toString());
                rmaTableModel.addRow(vector3);
            }
        }
    }

    private void addToList(RmaListModel rmaListModel, String string) {
        if (!rmaListModel.contains((Object)string)) {
            rmaListModel.addElement((Object)string);
        }
    }

    private boolean passesFilter(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return string.toLowerCase().startsWith(string2);
    }

    public boolean isValidForm() {
        String string = null;
        if (this._selectedElement == null) {
            string = "No Element Selected";
        } else if (this._selectedTSProxy == null) {
            string = "No Time Series Record Selected";
        } else if (this._selectedModelVariable == null) {
            string = "No Variable Selected";
        }
        if (string != null) {
            JOptionPane.showMessageDialog((Component)((Object)this), string, "Incomplete Form", 1);
        }
        return string == null;
    }

    public String getVariableName() {
        return this._selectedValueTxt.getText();
    }

    public Object getVariable() {
        if (this._selectedTSProxy != null) {
            if (this._variable == null) {
                return null;
            }
            if (this._variable instanceof MCOutputVariable) {
                ((MCOutputVariable)this._variable).setParamId(this._selectedModelVariable.getParamId());
                ((MCOutputVariable)this._variable).setModelVariableId(this._selectedModelVariable.getType());
                ((MCOutputVariable)this._variable).setProxyName(this._selectedTSProxy.getName());
            }
        }
        return this._variable;
    }

    public void setVariable(Object object) {
        this._variable = object;
    }

    public String getPanelName() {
        return PANEL_NAME;
    }

    public boolean isValidPanel() {
        return true;
    }

    public void fillPanel(RssAlt rssAlt) {
        RssSystem rssSystem = rssAlt.getSystem();
        if (rssSystem == null) {
            return;
        }
        if (rssAlt.getInputTSDataSet() == null) {
            return;
        }
        this._alt = rssAlt;
        this.fillForm(null, null, null);
    }
}

