/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.gui.WizardPanel;
import hec.rss.model.Element;
import hec.rss.model.RssAlt;
import hec.rss.model.RssModelVariableSet;
import hec.rss.plugins.montecarlo.client.OutputVarTestWizardPanel$1;
import hec.rss.plugins.montecarlo.client.OutputVarTestWizardPanel$2;
import hec.rss.plugins.montecarlo.client.OutputVarTestWizardPanel$3;
import hec.rss.plugins.montecarlo.client.OutputVarWizardDialog;
import hec.rss.plugins.montecarlo.model.MCOutputVariable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.util.DoubleArray;

public class OutputVarTestWizardPanel
extends WizardPanel {
    public static final String PANEL_NAME = "Test Criterion";
    private RmaJDecimalField _testValueField;
    private JComboBox<String> _statComboBox;
    private JComboBox<String> _testComboBox;
    private JCheckBox _flagCheckBox;
    private RmaJLabel _valueLabel;
    private RmaJTextField _variableNameField;
    private RmaJDecimalField _confidenceField;
    private RmaJDecimalField _toleranceField;
    private RmaJTable _valuesTable;
    private JCheckBox _convergenceCheckBox;
    private MCOutputVariable _variable;
    private OutputVarWizardDialog _parent;

    public OutputVarTestWizardPanel(OutputVarWizardDialog outputVarWizardDialog) {
        super((LayoutManager)new GridBagLayout());
        this._parent = outputVarWizardDialog;
        this.buildControls();
    }

    private void buildControls() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this.add(jPanel, gridBagConstraints);
        JLabel jLabel = new JLabel("Variable");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._variableNameField = new RmaJTextField();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)this._variableNameField, gridBagConstraints);
        this._variableNameField.setEnabled(false);
        jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this.add(jPanel, gridBagConstraints);
        jLabel = new JLabel("Statistic");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._statComboBox = new JComboBox<String>(new String[]{"Maximum", "Minimum", "Mean"});
        this._statComboBox.addActionListener(new OutputVarTestWizardPanel$1(this));
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        jPanel.add(this._statComboBox, gridBagConstraints);
        this._flagCheckBox = new JCheckBox("Flag");
        this._flagCheckBox.addActionListener(new OutputVarTestWizardPanel$2(this));
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        OutputVarTestWizardPanel outputVarTestWizardPanel = this;
        outputVarTestWizardPanel.add(outputVarTestWizardPanel._flagCheckBox, gridBagConstraints);
        jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Flag Condition"));
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5500;
        this.add(jPanel, gridBagConstraints);
        jLabel = new JLabel("Test");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._testComboBox = new JComboBox<String>(new String[]{"<", ">", "="});
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        jPanel.add(this._testComboBox, gridBagConstraints);
        this._valueLabel = new RmaJLabel("Threshold (%S)");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        jPanel.add((Component)this._valueLabel, gridBagConstraints);
        this._testValueField = new RmaJDecimalField();
        this._valueLabel.setLabelFor((Component)this._testValueField);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        jPanel.add((Component)this._testValueField, gridBagConstraints);
        this._convergenceCheckBox = new JCheckBox("Convergence");
        this._convergenceCheckBox.addActionListener(new OutputVarTestWizardPanel$3(this));
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        OutputVarTestWizardPanel outputVarTestWizardPanel2 = this;
        outputVarTestWizardPanel2.add(outputVarTestWizardPanel2._convergenceCheckBox, gridBagConstraints);
        jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Convergence Condition"));
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5500;
        this.add(jPanel, gridBagConstraints);
        jLabel = new JLabel("Confidence (%)");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._confidenceField = new RmaJDecimalField();
        this._confidenceField.setMaxValue(100.0);
        this._confidenceField.setMinValue(0.0);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        jPanel.add((Component)this._confidenceField, gridBagConstraints);
        jLabel = new JLabel("Tolerence (%)");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._toleranceField = new RmaJDecimalField();
        this._toleranceField.setMaxValue(100.0);
        this._toleranceField.setMinValue(0.0);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        jPanel.add((Component)this._toleranceField, gridBagConstraints);
        jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Values of Interest"));
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 200);
        this.add(jPanel, gridBagConstraints);
        this._valuesTable = new RmaJTable((Component)((Object)this), (Object[])new String[]{"Flow (%S)"});
        this._valuesTable.setDoubleCellEditor(0);
        this._valuesTable.setUnitsHeaderRenderer();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._valuesTable.getScrollPane(), gridBagConstraints);
        this._valuesTable.appendRows(10);
    }

    public void setVariableName(String string) {
        this._variableNameField.setText(string);
    }

    public void setVariable(Object object) {
        if (object == null) {
            this._variable = new MCOutputVariable(this._parent.getLocationPanel().getSelectedTSProxy().getName(), this._parent.getLocationPanel().getSelectedModelVariable().getType(), this._parent.getLocationPanel().getSelectedModelVariable().getParamId());
            OutputVarTestWizardPanel outputVarTestWizardPanel = this;
            outputVarTestWizardPanel.fillPanel(outputVarTestWizardPanel._variable);
            return;
        }
        if (object instanceof MCOutputVariable) {
            this._variable = (MCOutputVariable)object;
            OutputVarTestWizardPanel outputVarTestWizardPanel = this;
            outputVarTestWizardPanel.fillPanel(outputVarTestWizardPanel._variable);
        }
    }

    public void fillPanel(MCOutputVariable mCOutputVariable) {
        if (mCOutputVariable == null) {
            return;
        }
        this._flagCheckBox.setSelected(mCOutputVariable.hasTest());
        this._statComboBox.setSelectedItem(mCOutputVariable.getStatistic());
        this._testComboBox.setSelectedItem(mCOutputVariable.getTestOp());
        this._testValueField.clearPerformed();
        Object object = new ParamDouble();
        object.setValue(mCOutputVariable.getTestVal());
        object.setParameterId(mCOutputVariable.getParamId());
        object.setUnitSystem(ClientApp.Workspace().getUnitSystem());
        this._testValueField.setValue(object);
        this._testValueField.setDisplayUnitsSystem(ClientApp.frame().getDisplayUnitSystem());
        this._valueLabel.setDisplayUnitsSystem(ClientApp.frame().getDisplayUnitSystem());
        if (RssModelVariableSet.getParamName((int)mCOutputVariable.getModelVariableId()).contains("Flow") || RssModelVariableSet.getParamName((int)mCOutputVariable.getModelVariableId()).contains("Power")) {
            if (this._statComboBox.getItemCount() != 4) {
                this._statComboBox.addItem("Volume");
            }
        } else if (this._statComboBox.getItemCount() == 4) {
            this._statComboBox.removeItem("Volume");
        }
        this.flagCheckAction();
        this._convergenceCheckBox.setSelected(mCOutputVariable.hasConv());
        this._toleranceField.setValue(mCOutputVariable.getRelTol());
        this._confidenceField.setValue(mCOutputVariable.getConfidence());
        this.convergenceCheckAction();
        this._valuesTable.setColumnLabel(0, RssModelVariableSet.getParamName((int)mCOutputVariable.getModelVariableId()) + " (%S)");
        object = new int[]{mCOutputVariable.getParamId()};
        this._valuesTable.setColumnParameters((int[])object);
        this._valuesTable.setDisplayUnitsSystem(ClientApp.frame().getDisplayUnitSystem());
        this.setTableValues(mCOutputVariable.getUsrCdfVals(), mCOutputVariable.getParamId());
    }

    public String getPanelName() {
        return PANEL_NAME;
    }

    public boolean isValidPanel() {
        return true;
    }

    public void flagCheckAction() {
        if (this._flagCheckBox.isSelected()) {
            this._testComboBox.setEnabled(true);
            this._testValueField.setEnabled(true);
            return;
        }
        this._testComboBox.setEnabled(false);
        this._testValueField.setEnabled(false);
    }

    public void convergenceCheckAction() {
        if (this._convergenceCheckBox.isSelected()) {
            this._toleranceField.setEnabled(true);
            this._confidenceField.setEnabled(true);
            return;
        }
        this._toleranceField.setEnabled(false);
        this._confidenceField.setEnabled(false);
    }

    private void statComboBoxAction() {
        if (this._testValueField.getParamValue() != null) {
            this._variable.setTestVal(this._testValueField.getParamValue().getValue());
        }
        int n = this._variable.getParamId();
        if (this._statComboBox.getSelectedItem() == "Volume") {
            if (RssModelVariableSet.getParamName((int)this._variable.getModelVariableId()).contains("Flow")) {
                n = Parameter.PARAMID_STOR;
            } else if (RssModelVariableSet.getParamName((int)this._variable.getModelVariableId()).contains("Power")) {
                n = Parameter.PARAMID_ENERGY;
            }
        }
        ParamDouble paramDouble = new ParamDouble();
        paramDouble.setValue(this._variable.getTestVal());
        paramDouble.setParameterId(n);
        paramDouble.setUnitSystem(ClientApp.Workspace().getUnitSystem());
        this._testValueField.setValue(paramDouble);
        this._testValueField.setDisplayUnitsSystem(ClientApp.frame().getDisplayUnitSystem());
        this._valueLabel.setDisplayUnitsSystem(ClientApp.frame().getDisplayUnitSystem());
    }

    public MCOutputVariable getOutputVariable() {
        if (this._variable == null) {
            return null;
        }
        this._variable.setStatistic((String)this._statComboBox.getSelectedItem());
        this._variable.setTest(this._flagCheckBox.isSelected());
        this._variable.setTestOp((String)this._testComboBox.getSelectedItem());
        this._variable.setTestVal(this._testValueField.getParamValue().getValue());
        this._variable.setConv(this._convergenceCheckBox.isSelected());
        this._variable.setRelTol(this._toleranceField.getValue());
        this._variable.setConfidence(this._confidenceField.getValue());
        this._variable.setUsrCdfVals(this.getTableValues());
        return this._variable;
    }

    public String getVariableName() {
        return this._variableNameField.getText();
    }

    private double[] getTableValues() {
        this._valuesTable.commitEdit(true);
        DoubleArray doubleArray = new DoubleArray();
        for (int i = 0; i < this._valuesTable.getRowCount(); ++i) {
            if (this._valuesTable.getValueAt(i, 0) == null) continue;
            if (this._valuesTable.getValueAt(i, 0) instanceof String) {
                String string = (String)this._valuesTable.getValueAt(i, 0);
                if ((string = string.trim()).isEmpty() || Double.parseDouble(string) == Double.NEGATIVE_INFINITY) continue;
                doubleArray.add(Double.parseDouble(string));
                continue;
            }
            if (!(this._valuesTable.getValueAt(i, 0) instanceof ParamDouble) || ((ParamDouble)this._valuesTable.getValueAt(i, 0)).getValue() == Double.NEGATIVE_INFINITY) continue;
            doubleArray.add(((ParamDouble)this._valuesTable.getValueAt(i, 0)).doubleValue());
        }
        doubleArray.trimToSize();
        double[] dArray = doubleArray.toArray();
        Arrays.sort(dArray);
        return dArray;
    }

    private void setTableValues(double[] dArray, int n) {
        for (int i = 0; i < dArray.length; ++i) {
            this._valuesTable.setValueAt((Object)new ParamDouble(dArray[i], n, ClientApp.frame().getDisplayUnitSystem(), 2), i, 0);
        }
    }

    public void fillEditPanel(MCOutputVariable mCOutputVariable, RssAlt rssAlt) {
        if (mCOutputVariable != null) {
            this._variable = mCOutputVariable;
            if (rssAlt != null) {
                Element element = this._parent.getLocationPanel().getElementForTSProxy(rssAlt.getSystem().getTSRecordProxy(mCOutputVariable.getProxyName(), mCOutputVariable.getModelVariableId()));
                String string = element.getElementType();
                if (string.isEmpty() && element.getTopParent() != null) {
                    string = element.getTopParent().getElementType();
                }
                this._variableNameField.setText(string + " - " + rssAlt.getSystem().getNameForKeyString(mCOutputVariable.getProxyName()) + " : " + RssModelVariableSet.getParamName((int)mCOutputVariable.getModelVariableId()));
            }
            this.fillPanel(mCOutputVariable);
        }
    }
}

