/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.data.Parameter;
import hec.heclib.util.HecTime;
import hec.io.TextContainer;
import hec.rss.plugins.montecarlo.client.MCVariableWizardDialog;
import hec.rss.plugins.montecarlo.client.ParameterValueReportDialog$ParameterValueReportTextDialog;
import hec.rss.plugins.montecarlo.model.MCInputRatingCurveVariable;
import hec.rss.plugins.montecarlo.model.MCInputStochasticVariableImpl;
import hec.rss.plugins.montecarlo.model.MCInputVariableImpl;
import hec.rss.plugins.montecarlo.model.SeasonalContinuousDistribution;
import hec.statistics.AbstractContDist;
import hec.statistics.ClipDist;
import hec.statistics.EmpiricalDist;
import hec.statistics.MultiParametrizadDist;
import java.awt.Component;
import java.io.BufferedWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import rma.swing.RmaJDialog;
import rma.swing.SearchableJEditorPane;

public class ParameterValueReportDialog
extends RmaJDialog {
    private MCInputStochasticVariableImpl[] _variable;
    private MCVariableWizardDialog _parent;
    private int _width = 350;
    private JMenuItem _exportButton;

    public ParameterValueReportDialog(MCInputStochasticVariableImpl[] mCInputStochasticVariableImplArray, MCVariableWizardDialog mCVariableWizardDialog) {
        this._variable = mCInputStochasticVariableImplArray;
        this._parent = mCVariableWizardDialog;
        this.buildControls();
    }

    public void buildControls() {
        ParameterValueReportDialog parameterValueReportDialog = this;
        Object object = new ParameterValueReportDialog$ParameterValueReportTextDialog(parameterValueReportDialog, (JDialog)((Object)parameterValueReportDialog), false);
        TextContainer textContainer = new TextContainer();
        new TextContainer().fullName = "Relative Input Variable Report";
        textContainer.text = this.generateReport();
        object.initialize(textContainer, false);
        object.setSize(this._width, 400);
        object.setLocationRelativeTo((Component)((Object)this._parent));
        object.setAlwaysOnTop(true);
        object.setVisible(true);
        object = (JScrollPane)object.getContentPane().getComponent(0);
        ((SearchableJEditorPane)((JScrollPane)object).getViewport().getView()).setCaretPosition(0);
    }

    private String generateReport() {
        String string = "Monte Carlo Relative Input Variable Report";
        string = "Monte Carlo Relative Input Variable Report".concat(System.getProperty("line.separator"));
        for (int i = 0; i < this._variable.length; ++i) {
            Object object;
            int n;
            int n2;
            AbstractContDist abstractContDist;
            Double[] doubleArray;
            string = string.concat(System.getProperty("line.separator"));
            string = string.concat("##########################################");
            string = string.concat(System.getProperty("line.separator"));
            string = string.concat("Variable Name: " + ((MCInputVariableImpl)this._variable[i]).getVariableName());
            string = string.concat(System.getProperty("line.separator"));
            string = string.concat("Variable Location: " + this._variable[i].getLocation());
            string = string.concat(System.getProperty("line.separator"));
            string = string.concat("Variable Parameter: " + this._variable[i].getParameter());
            string = string.concat(System.getProperty("line.separator"));
            if (this._parent.isSeasonal()) {
                doubleArray = this._parent.getDefaultValues(((SeasonalContinuousDistribution)this._variable[i].getDist()).getHecTimes(), ((MCInputVariableImpl)this._variable[i]).getParameterEqualString());
            } else if (this._variable[i] instanceof MCInputRatingCurveVariable && ((MCInputRatingCurveVariable)this._variable[i]).getCurvesLabels().length > 1) {
                abstractContDist = ((MCInputRatingCurveVariable)this._variable[i]).getCurvesLabels();
                n2 = this._parent.getDefaultValue(((MCInputVariableImpl)this._variable[i]).getType(), this._variable[i].getLocation(), this._variable[i].getParameter()).length;
                doubleArray = new Double[n2 * ((String[])abstractContDist).length];
                for (n = 0; n < n2; ++n) {
                    object = this._parent.getDefaultValue(((MCInputVariableImpl)this._variable[i]).getType(), this._variable[i].getLocation(), this._variable[i].getParameter(), n);
                    for (int j = 0; j < ((AbstractContDist)object).length; ++j) {
                        doubleArray[n * ((AbstractContDist)object).length + j] = object[j];
                    }
                }
            } else {
                doubleArray = this._parent.getDefaultValue(((MCInputVariableImpl)this._variable[i]).getType(), this._variable[i].getLocation(), this._variable[i].getParameter());
            }
            string = string.concat("Original variable value = ");
            for (int j = 0; j < doubleArray.length; ++j) {
                if ((double)(j / 10) == (double)j / 10.0 && j != 0) {
                    string = string.concat(System.getProperty("line.separator"));
                }
                string = string.concat(new DecimalFormat("#.##").format(doubleArray[j]) + " ");
            }
            if (this._variable[i] instanceof MCInputRatingCurveVariable && ((MCInputRatingCurveVariable)this._variable[i]).getCurvesLabels().length > 1) {
                doubleArray = new Double[this._parent.getDefaultValue(((MCInputVariableImpl)this._variable[i]).getType(), this._variable[i].getLocation(), this._variable[i].getParameter()).length];
            }
            string = string.concat(System.getProperty("line.separator"));
            string = string.concat("Distribution Type: " + this._variable[i].getDistributionName());
            string = string.concat(System.getProperty("line.separator"));
            string = string.concat(System.getProperty("line.separator"));
            abstractContDist = this._variable[i].getDist();
            if (!(abstractContDist instanceof EmpiricalDist)) {
                int n3;
                double[] dArray;
                String[] stringArray;
                if (abstractContDist instanceof MultiParametrizadDist && ((MultiParametrizadDist)abstractContDist).getParametrizationNumber() == 2) {
                    stringArray = ((MultiParametrizadDist)abstractContDist).getParamNames2();
                    dArray = ((MultiParametrizadDist)abstractContDist).getParams2();
                } else if (abstractContDist instanceof SeasonalContinuousDistribution) {
                    object = ((SeasonalContinuousDistribution)abstractContDist).getDist();
                    if (object instanceof MultiParametrizadDist && ((MultiParametrizadDist)object).getParametrizationNumber() == 2) {
                        stringArray = ((MultiParametrizadDist)object).getParamNames2();
                        dArray = ((MultiParametrizadDist)object).getParams2();
                    } else {
                        stringArray = object.getParamNames();
                        dArray = object.getParamVals();
                    }
                } else {
                    stringArray = abstractContDist.getParamNames();
                    dArray = abstractContDist.getParamVals();
                }
                if (abstractContDist instanceof SeasonalContinuousDistribution) {
                    SeasonalContinuousDistribution seasonalContinuousDistribution = (SeasonalContinuousDistribution)abstractContDist;
                    var11_34 = seasonalContinuousDistribution.getHecTimes();
                    string = string.concat("           ");
                    for (n3 = 0; n3 < var11_34.size(); ++n3) {
                        object = String.format("%0" + (int)Math.ceil(21.0 / 2.0) + "d", 0).replace("0", " ");
                        String string2 = String.format("%0" + (int)Math.floor(21.0 / 2.0) + "d", 0).replace("0", " ") + " ";
                        string = string.concat((String)object + ((HecTime)var11_34.get(n3)).date(14).substring(0, 5) + string2);
                    }
                    string = string.concat(System.getProperty("line.separator"));
                    string = string.concat("             ");
                    for (n3 = 0; n3 < var11_34.size(); ++n3) {
                        string = string.concat("RELATIVE     ABSOLUTE     ");
                    }
                    this._width = var11_34.size() * 200 + 150;
                } else if (this._variable[i] instanceof MCInputRatingCurveVariable && ((MCInputRatingCurveVariable)this._variable[i]).getCurvesLabels().length > 1) {
                    MCInputRatingCurveVariable mCInputRatingCurveVariable = (MCInputRatingCurveVariable)this._variable[i];
                    var11_34 = mCInputRatingCurveVariable.getCurvesLabels();
                    string = string.concat("           ");
                    for (n3 = 0; n3 < var11_34.length; ++n3) {
                        int n4 = 26 - ((MCInputRatingCurveVariable)this._variable[i]).getCurvesLabels()[n3].toString().length();
                        object = String.format("%0" + (int)Math.ceil((double)n4 / 2.0) + "d", 0).replace("0", " ");
                        String string3 = String.format("%0" + (int)Math.floor((double)n4 / 2.0) + "d", 0).replace("0", " ") + " ";
                        string = string.concat((String)object + var11_34[n3] + string3);
                    }
                    string = string.concat(System.getProperty("line.separator"));
                    string = string.concat("             ");
                    for (n3 = 0; n3 < var11_34.length; ++n3) {
                        string = string.concat("RELATIVE     ABSOLUTE     ");
                    }
                    this._width = var11_34.length * 200 + 150;
                } else {
                    string = string.concat("             RELATIVE     ABSOLUTE");
                }
                string = string.concat(System.getProperty("line.separator"));
                for (int j = 0; j < stringArray.length; ++j) {
                    string = string.concat(stringArray[j] + String.format("%0" + (13 - stringArray[j].length()) + "d", 0).replace("0", " "));
                    for (int k = 0; k < doubleArray.length; ++k) {
                        int n5;
                        String string4;
                        object = this._variable[i].getParamId() >= 0 ? Parameter.getUnitsStringForSystem((int)this._variable[i].getParamId(), (int)1) : "";
                        if (abstractContDist instanceof SeasonalContinuousDistribution) {
                            if (k != 0) continue;
                            for (n3 = 0; n3 < ((SeasonalContinuousDistribution)abstractContDist).getHecTimes().size(); ++n3) {
                                AbstractContDist abstractContDist2 = ((SeasonalContinuousDistribution)abstractContDist).getDist(n3);
                                dArray = abstractContDist2 instanceof MultiParametrizadDist && ((MultiParametrizadDist)abstractContDist2).getParametrizationNumber() == 2 ? ((MultiParametrizadDist)abstractContDist2).getParams2() : abstractContDist2.getParamVals();
                                string4 = String.format("%.1f", dArray[j]);
                                n5 = string4.length();
                                string = stringArray[j].equals("Shape") ? (n3 == 0 ? string.concat(String.format("%0" + (7 - n5) + "d", 0).replace("0", " ") + "N/A    ") : string.concat(String.format("%0" + (8 - n5) + "d", 0).replace("0", " ") + "N/A    ")) : (n3 == 0 ? string.concat(String.format("%0" + (7 - n5) + "d", 0).replace("0", " ") + string4 + "%   ") : string.concat(String.format("%0" + (8 - n5) + "d", 0).replace("0", " ") + string4 + "%   "));
                                string4 = doubleArray.length > 1 ? (stringArray[j].equals("Shape") ? String.format("%.1f", dArray[j]) : String.format("%.1f", doubleArray[n3] * dArray[j] / 100.0)) : (stringArray[j].equals("Shape") ? String.format("%.1f", dArray[j]) : String.format("%.1f", doubleArray[0] * dArray[j] / 100.0));
                                n5 = string4.toString().length();
                                string = string.concat(String.format("%0" + (10 - n5) + "d", 0).replace("0", " ") + string4 + " " + (String)object + "   ");
                            }
                            string = string.concat(System.getProperty("line.separator"));
                            continue;
                        }
                        if (this._variable[i] instanceof MCInputRatingCurveVariable && ((MCInputRatingCurveVariable)this._variable[i]).getCurvesLabels().length > 1) {
                            if (k > 0) {
                                string = string.concat(String.format("%013d", 0).replace("0", " "));
                            }
                            Double[] doubleArray2 = this._parent.getDefaultValue(((MCInputVariableImpl)this._variable[i]).getType(), this._variable[i].getLocation(), this._variable[i].getParameter(), k);
                            for (int i2 = 0; i2 < ((MCInputRatingCurveVariable)this._variable[i]).getCurvesLabels().length; ++i2) {
                                string4 = String.format("%.1f", dArray[j]);
                                n5 = string4.length();
                                string = stringArray[j].equals("Shape") ? (i2 == 0 ? string.concat(String.format("%0" + (7 - n5) + "d", 0).replace("0", " ") + "N/A    ") : string.concat(String.format("%0" + (8 - n5) + "d", 0).replace("0", " ") + string4 + "    ")) : (i2 == 0 ? string.concat(String.format("%0" + (7 - n5) + "d", 0).replace("0", " ") + string4 + "%   ") : string.concat(String.format("%0" + (8 - n5) + "d", 0).replace("0", " ") + string4 + "%   "));
                                string4 = stringArray[j].equals("Shape") ? String.format("%.1f", Double.valueOf(string4)) : String.format("%.1f", doubleArray2[i2] * Double.valueOf(string4) / 100.0);
                                n5 = string4.toString().length();
                                string = string.concat(String.format("%0" + (10 - n5) + "d", 0).replace("0", " ") + string4 + " " + (String)object + "   ");
                            }
                            string = string.concat(System.getProperty("line.separator"));
                            continue;
                        }
                        if (k > 0) {
                            string = string.concat(String.format("%013d", 0).replace("0", " "));
                        }
                        if ((string4 = String.format("%.1f", dArray[j])).length() > 7) {
                            string4 = string4.substring(0, 6);
                        }
                        n5 = string4.length();
                        if (stringArray[j].equals("Shape")) {
                            string = string.concat(String.format("%0" + (7 - n5) + "d", 0).replace("0", " ") + "N/A    ");
                            string4 = String.format("%.1f", Double.valueOf(string4));
                        } else {
                            string = string.concat(String.format("%0" + (7 - n5) + "d", 0).replace("0", " ") + string4 + "%   ");
                            string4 = String.format("%.1f", doubleArray[k] * Double.valueOf(string4) / 100.0);
                        }
                        if (string4.length() > 9) {
                            string4 = string4.substring(0, 8);
                        }
                        n5 = string4.toString().length();
                        string = string.concat(String.format("%0" + (10 - n5) + "d", 0).replace("0", " ") + string4 + " " + (String)object);
                        string = string.concat(System.getProperty("line.separator"));
                    }
                }
            }
            string = string.concat(System.getProperty("line.separator"));
            string = string.concat(System.getProperty("line.separator"));
            if (abstractContDist instanceof ClipDist && ((ClipDist)abstractContDist).getClipData().hasMinClip()) {
                string = string.concat("Clip Min Zero: enabled");
                string = string.concat(System.getProperty("line.separator"));
                if (abstractContDist instanceof SeasonalContinuousDistribution) {
                    int n6;
                    SeasonalContinuousDistribution seasonalContinuousDistribution = (SeasonalContinuousDistribution)abstractContDist;
                    List<HecTime> list = seasonalContinuousDistribution.getHecTimes();
                    string = string.concat("                              ");
                    for (n6 = 0; n6 < list.size(); ++n6) {
                        String string5 = String.format("%0" + (int)Math.ceil(5.0 / 2.0) + "d", 0).replace("0", " ");
                        String string6 = String.format("%0" + (int)Math.floor(5.0 / 2.0) + "d", 0).replace("0", " ") + " ";
                        string = string.concat(string5 + list.get(n6).date(14).substring(0, 5) + string6);
                    }
                    string = string.concat(System.getProperty("line.separator"));
                    string = string.concat("     probability clipped out = ");
                    for (n6 = 0; n6 < ((SeasonalContinuousDistribution)abstractContDist).getHecTimes().size(); ++n6) {
                        string = string.concat(String.format("%.4f", ((ClipDist)((SeasonalContinuousDistribution)abstractContDist).getDist(n6)).getClipData().getMinProb()) + "    ");
                    }
                } else if (this._variable[i] instanceof MCInputRatingCurveVariable && ((MCInputRatingCurveVariable)this._variable[i]).getCurvesLabels().length > 1) {
                    string = string.concat("                              ");
                    for (n2 = 0; n2 < ((MCInputRatingCurveVariable)this._variable[i]).getCurvesLabels().length; ++n2) {
                        n = 10 - ((MCInputRatingCurveVariable)this._variable[i]).getCurvesLabels()[n2].toString().length();
                        object = String.format("%0" + (int)Math.ceil((double)n / 2.0) + "d", 0).replace("0", " ");
                        String string7 = String.format("%0" + (int)Math.floor((double)n / 2.0) + "d", 0).replace("0", " ") + " ";
                        string = string.concat((String)object + ((MCInputRatingCurveVariable)this._variable[i]).getCurvesLabels()[n2] + string7);
                    }
                    string = string.concat(System.getProperty("line.separator"));
                    string = string.concat("     probability clipped out = ");
                    for (n2 = 0; n2 < ((MCInputRatingCurveVariable)this._variable[i]).getCurvesLabels().length; ++n2) {
                        string = string.concat(String.format("%.4f", ((ClipDist)abstractContDist).getClipData().getMinProb()) + "    ");
                    }
                } else {
                    string = string.concat("     probability clipped out = " + String.format("%.4f", ((ClipDist)abstractContDist).getClipData().getMinProb()));
                }
            } else {
                string = string.concat("Clip Min Zero: disabled");
                string = string.concat(System.getProperty("line.separator"));
            }
            string = string.concat(System.getProperty("line.separator"));
            if (abstractContDist instanceof ClipDist && ((ClipDist)abstractContDist).getClipData().hasMaxClip()) {
                string = string.concat("Clip Max Zero: enabled");
                string = string.concat(System.getProperty("line.separator"));
                if (abstractContDist instanceof SeasonalContinuousDistribution) {
                    int n7;
                    SeasonalContinuousDistribution seasonalContinuousDistribution = (SeasonalContinuousDistribution)abstractContDist;
                    List<HecTime> list = seasonalContinuousDistribution.getHecTimes();
                    string = string.concat("                              ");
                    for (n7 = 0; n7 < list.size(); ++n7) {
                        String string8 = String.format("%0" + (int)Math.ceil(5.0 / 2.0) + "d", 0).replace("0", " ");
                        String string9 = String.format("%0" + (int)Math.floor(5.0 / 2.0) + "d", 0).replace("0", " ") + " ";
                        string = string.concat(string8 + list.get(n7).date(14).substring(0, 5) + string9);
                    }
                    string = string.concat(System.getProperty("line.separator"));
                    string = string.concat("     probability clipped out = ");
                    for (n7 = 0; n7 < ((SeasonalContinuousDistribution)abstractContDist).getHecTimes().size(); ++n7) {
                        string = string.concat(String.format("%.4f", ((ClipDist)((SeasonalContinuousDistribution)abstractContDist).getDist(n7)).getClipData().getMaxProb()) + "    ");
                    }
                } else if (this._variable[i] instanceof MCInputRatingCurveVariable && ((MCInputRatingCurveVariable)this._variable[i]).getCurvesLabels().length > 1) {
                    int n8;
                    string = string.concat("                              ");
                    for (n8 = 0; n8 < ((MCInputRatingCurveVariable)this._variable[i]).getCurvesLabels().length; ++n8) {
                        int n9 = 10 - ((MCInputRatingCurveVariable)this._variable[i]).getCurvesLabels()[n8].toString().length();
                        String string10 = String.format("%0" + (int)Math.ceil((double)n9 / 2.0) + "d", 0).replace("0", " ");
                        String string11 = String.format("%0" + (int)Math.floor((double)n9 / 2.0) + "d", 0).replace("0", " ") + " ";
                        string = string.concat(string10 + ((MCInputRatingCurveVariable)this._variable[i]).getCurvesLabels()[n8] + string11);
                    }
                    string = string.concat(System.getProperty("line.separator"));
                    string = string.concat("     probability clipped out = ");
                    for (n8 = 0; n8 < ((MCInputRatingCurveVariable)this._variable[i]).getCurvesLabels().length; ++n8) {
                        string = string.concat(String.format("%.4f", ((ClipDist)abstractContDist).getClipData().getMaxProb()) + "    ");
                    }
                } else {
                    string = string.concat("     probability clipped out = " + String.format("%.4f", 1.0 - ((ClipDist)abstractContDist).getClipData().getMaxProb()));
                }
            } else {
                string = string.concat("Clip Max Zero: disabled");
                string = string.concat(System.getProperty("line.separator"));
            }
            string = string.concat(System.getProperty("line.separator"));
            string = string.concat("##########################################");
            string = string.concat(System.getProperty("line.separator"));
        }
        return string;
    }

    private void writeInputVariableCSVReport(BufferedWriter bufferedWriter) {
        ParameterValueReportDialog parameterValueReportDialog = this;
        String string = parameterValueReportDialog.getHeaders(parameterValueReportDialog._variable[0]);
        try {
            bufferedWriter.write("Monte Carlo Relative Input Variable Report\n");
            bufferedWriter.write(string);
            for (int i = 0; i < this._variable.length; ++i) {
                int n;
                Double[] doubleArray;
                Object object;
                Object object2;
                Object object3 = this._variable[i].getDist();
                if (object3 instanceof SeasonalContinuousDistribution) {
                    object2 = (SeasonalContinuousDistribution)((Object)object3);
                    object = ((SeasonalContinuousDistribution)((Object)object2)).getHecTimes();
                    doubleArray = this._parent.getDefaultValues(((SeasonalContinuousDistribution)this._variable[i].getDist()).getHecTimes(), ((MCInputVariableImpl)this._variable[i]).getParameterEqualString());
                    for (n = 0; n < object.size(); ++n) {
                        int n2;
                        object3 = "";
                        Object object4 = object.get(n).date(0);
                        object3 = (String)object3 + ((String)object4).substring(0, ((String)object4).indexOf(",")) + ",";
                        object3 = (String)object3 + ((MCInputVariableImpl)this._variable[i]).getVariableName() + ",";
                        object3 = (String)object3 + this._variable[i].getLocation() + ",";
                        object3 = (String)object3 + this._variable[i].getParameter() + ",";
                        object3 = doubleArray.length == object.size() ? (String)object3 + doubleArray[n] + "," : (String)object3 + doubleArray[0] + ",";
                        object3 = (String)object3 + ((SeasonalContinuousDistribution)((Object)object2)).getDist().getType() + ",";
                        object4 = ((SeasonalContinuousDistribution)((Object)object2)).getDist(n) instanceof MultiParametrizadDist ? (Object)((MultiParametrizadDist)((SeasonalContinuousDistribution)((Object)object2)).getDist(n)).getActiveParams() : (Object)((SeasonalContinuousDistribution)((Object)object2)).getDist(n).getParamVals();
                        for (n2 = 0; n2 < ((Object)object4).length; ++n2) {
                            object3 = (String)object3 + (double)object4[n2] + "%,";
                        }
                        for (n2 = 0; n2 < ((Object)object4).length; ++n2) {
                            object3 = doubleArray.length == object.size() ? (String)object3 + doubleArray[n] * object4[n2] / 100.0 + "," : (String)object3 + doubleArray[0] * object4[n2] / 100.0 + ",";
                        }
                        object3 = ((ClipDist)((SeasonalContinuousDistribution)((Object)object2)).getDist(n)).getClipData().hasMinClip() ? (String)object3 + ((ClipDist)((SeasonalContinuousDistribution)((Object)object2)).getDist(n)).getClipData().getMinProb() + "," : (String)object3 + "Disabled,";
                        object3 = ((ClipDist)((SeasonalContinuousDistribution)((Object)object2)).getDist(n)).getClipData().hasMaxClip() ? (String)object3 + ((ClipDist)((SeasonalContinuousDistribution)((Object)object2)).getDist(n)).getClipData().getMaxProb() + "," : (String)object3 + "Disabled\n";
                        bufferedWriter.write((String)object3);
                    }
                    continue;
                }
                if (this._variable[i] instanceof MCInputRatingCurveVariable && ((MCInputRatingCurveVariable)this._variable[i]).getCurvesLabels().length > 1) continue;
                doubleArray = this._parent.getDefaultValue(((MCInputVariableImpl)this._variable[i]).getType(), this._variable[i].getLocation(), this._variable[i].getParameter());
                object2 = "";
                object2 = "" + ((MCInputVariableImpl)this._variable[i]).getVariableName() + ",";
                object2 = (String)object2 + this._variable[i].getLocation() + ",";
                object2 = (String)object2 + this._variable[i].getParameter() + ",";
                object2 = (String)object2 + doubleArray[0] + ",";
                object2 = (String)object2 + object3.getType() + ",";
                object = object3.getParamVals();
                for (n = 0; n < ((Object)object).length; ++n) {
                    object2 = (String)object2 + (double)object[n] + "%,";
                }
                for (n = 0; n < ((Object)object).length; ++n) {
                    object2 = (String)object2 + doubleArray[0] * object[n] / 100.0 + ",";
                }
                object2 = ((ClipDist)object3).getClipData().hasMinClip() ? (String)object2 + ((ClipDist)object3).getClipData().getMinProb() + "," : (String)object2 + "Disabled,";
                object2 = ((ClipDist)object3).getClipData().hasMaxClip() ? (String)object2 + ((ClipDist)object3).getClipData().getMaxProb() + "\n" : (String)object2 + "Disabled\n";
                bufferedWriter.write((String)object2);
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            return;
        }
        catch (IOException iOException) {
            System.out.println("Failed to write variable CSV report. " + String.valueOf(iOException.getStackTrace()));
            return;
        }
    }

    private int getNumberOfColumns(MCInputStochasticVariableImpl mCInputStochasticVariableImpl) {
        int n = 7;
        if (mCInputStochasticVariableImpl.isSeasonal()) {
            ++n;
        }
        return n += mCInputStochasticVariableImpl.getDist().getParamNames().length;
    }

    private String getHeaders(MCInputStochasticVariableImpl objectArray) {
        Object object = "";
        if (objectArray.isSeasonal()) {
            object = (String)object + "Season Start,";
        }
        object = (String)object + "Variable Name,Variable Location,Variable Parameter,Original Variable Value, Distribution Type,";
        if ((objectArray = objectArray.getDist()) instanceof EmpiricalDist) {
            int n;
            objectArray = ((EmpiricalDist)objectArray).getCumProbs();
            for (n = 0; n < objectArray.length; ++n) {
                object = (String)object + "Relative " + (double)objectArray[n] + " %,";
            }
            for (n = 0; n < objectArray.length; ++n) {
                object = (String)object + "Absolute " + (double)objectArray[n] + " %,";
            }
        } else {
            int n;
            objectArray = objectArray.getParamNames();
            for (n = 0; n < objectArray.length; ++n) {
                object = (String)object + "Relative " + objectArray[n] + ",";
            }
            for (n = 0; n < objectArray.length; ++n) {
                object = (String)object + "Absolute " + objectArray[n] + ",";
            }
        }
        object = (String)object + "Clip Min Zero,Clip Max Zero\n";
        return object;
    }
}

