/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.data.ParamDouble;
import hec.rss.model.RssAlt;
import hec.rss.plugins.montecarlo.client.ClipAtZeroPanel;
import hec.rss.plugins.montecarlo.client.ClipByValuePanel;
import hec.rss.plugins.montecarlo.client.DistributionPanel;
import hec.rss.plugins.montecarlo.client.MCScalarDistributionWizardPanel;
import hec.rss.plugins.montecarlo.client.MCVariableDependencySelectionDialog;
import hec.rss.plugins.montecarlo.client.MCVariableWizardDialog;
import hec.rss.plugins.montecarlo.client.ParamsCnstPanel$1;
import hec.rss.plugins.montecarlo.client.ParamsPanel;
import hec.rss.plugins.montecarlo.model.MCInputVariableImpl;
import hec.statistics.AbstractContDist;
import hec.statistics.ClipDist;
import hec.statistics.EmpiricalDist;
import hec.statistics.MultiParametrizadDist;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;
import rma.services.ServiceLookup;
import rma.swing.RmaInsets;
import rma.swing.RmaJButton;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJPanel;
import rma.swing.RmaJTable;
import rma.swing.table.RmaTableModel;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class ParamsCnstPanel
extends ParamsPanel {
    private RmaJTable _empirTable;
    private RmaJButton[] _dependencyButtons;
    private RmaJPanel[] _fieldPanel;
    private RmaJLabel[] _paramLabels;
    private RmaJPanel _totalProbPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
    private RmaJDecimalField _totalProb = new RmaJDecimalField();
    private boolean _fillingPanel;

    public ParamsCnstPanel(Class<? extends AbstractContDist> clazz, DistributionPanel distributionPanel) {
        super(clazz, distributionPanel);
        this.buildPanel();
    }

    public void buildPanel() {
        Object object;
        if (this._distClass == null) {
            return;
        }
        try {
            object = this._distClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            object = null;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().insets = RmaInsets.INSETS0555;
        if (object instanceof EmpiricalDist) {
            this._empirTable = new RmaJTable((Component)((Object)this));
            this._empirTable.setNumRows(8);
            String[] stringArray = new String[]{"Exceed Prob.", "Value (%S)"};
            boolean[] blArray = new boolean[]{true, true};
            object = new RmaTableModel(stringArray, 8, blArray, null);
            object.setDisplayUnitsSystem(ServiceLookup.getUnitsDisplayService().getDisplayUnitsSystem());
            this._empirTable.setModel((TableModel)object);
            this._empirTable.setPrecision(2);
            object = this._empirTable.setDoubleCellEditor(0);
            object.setMinValue(0.0);
            object.setMaxValue(1.0);
            object.setPrecision(2);
            object = this._empirTable.setDoubleCellEditor(1);
            object.setPrecision(2);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.fill = 1;
            object = this._empirTable.getScrollPane();
            object.setPreferredSize(new Dimension(80, 120));
            this._paramFieldsPanel.add((Component)object, (Object)gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            this._paramFieldsPanel.add((Component)this._totalProbPanel, (Object)gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.25;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            this._totalProbPanel.add((Component)new RmaJLabel("Total Probability:"), (Object)gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.75;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            this._totalProbPanel.add((Component)this._totalProb, (Object)gridBagConstraints);
            return;
        }
        int n = 0;
        String[] stringArray = null;
        if (object != null) {
            stringArray = object.getParamNames();
            n = stringArray.length;
        }
        this._paramLabels = new RmaJLabel[n];
        this._paramFlds = new RmaJDecimalField[n];
        this._dependencyButtons = new RmaJButton[n];
        this._fieldPanel = new RmaJPanel[n];
        for (int i = 0; i < n; ++i) {
            this._fieldPanel[i] = new RmaJPanel((LayoutManager)new GridBagLayout());
            this._paramLabels[i] = new RmaJLabel("");
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = i;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            this._paramFieldsPanel.add((Component)this._fieldPanel[i], (Object)gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridy = 0;
            this._fieldPanel[i].add((Component)this._paramLabels[i], (Object)gridBagConstraints);
            this._paramFlds[i] = new RmaJDecimalField();
            this._paramFlds[i].setPrecision(2);
            this._paramFlds[i].setUseDecimalFormatForParameters(true);
            if (this._distClass.toString().contains("Log")) {
                this._paramFlds[i].setMinValue(0.001);
            }
            this._paramFlds[i].setDisplayUnitsSystem(ServiceLookup.getUnitsDisplayService().getDisplayUnitsSystem());
            this._paramLabels[i].setLabelFor((Component)this._paramFlds[i]);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            this._fieldPanel[i].add((Component)this._paramFlds[i], (Object)gridBagConstraints);
            this._dependencyButtons[i] = new RmaJButton("...");
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            this._fieldPanel[i].add((Component)this._dependencyButtons[i], (Object)gridBagConstraints);
        }
        this.setParamLabels(stringArray);
        this.addActionListeners();
        this._clipPanel = this._parent.isRelative() ? new ClipAtZeroPanel(this._parent) : new ClipByValuePanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 10.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        ParamsCnstPanel paramsCnstPanel = this;
        paramsCnstPanel.add((Component)((Object)paramsCnstPanel._clipPanel), gridBagConstraints);
    }

    private void addActionListeners() {
        for (int i = 0; i < this._dependencyButtons.length; ++i) {
            int n = i;
            this._dependencyButtons[i].addActionListener((ActionListener)new ParamsCnstPanel$1(this, n));
        }
    }

    private void removeDependency(int n) {
        this._paramFlds[n].setVisible(true);
        this._dependencyButtons[n].setText("...");
        this._fieldPanel[n].remove((Component)this._dependencyButtons[n]);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this._fieldPanel[n].add((Component)this._dependencyButtons[n], (Object)gridBagConstraints);
        this._fieldPanel[n].revalidate();
        this._fieldPanel[n].repaint();
        this._paramFlds[n].requestFocus();
        if (this._parent.isRelative()) {
            ((ClipAtZeroPanel)this._clipPanel).enableReporting();
        }
        for (n = 0; n < this._paramFlds.length; ++n) {
            if (this._paramFlds[n].isVisible()) continue;
            return;
        }
        this._parent.setPlotPanelEnabled(true);
        this._parent.updateDistribution();
    }

    private void addDependency(int n, String object) {
        this._dependencyButtons[n].setText((String)object);
        this._paramFlds[n].setVisible(false);
        this._fieldPanel[n].remove((Component)this._dependencyButtons[n]);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 2;
        this._fieldPanel[n].add((Component)this._dependencyButtons[n], object);
        this._fieldPanel[n].revalidate();
        this._fieldPanel[n].repaint();
        if (n > 0) {
            this._paramFlds[n - 1].requestFocus();
        } else {
            this._paramFlds[n + 1].requestFocus();
        }
        if (this._parent.isRelative()) {
            ((ClipAtZeroPanel)this._clipPanel).disableReporting();
        }
        this._parent.setPlotPanelEnabled(false);
    }

    @Override
    protected RmaJTable getTable() {
        return this._empirTable;
    }

    private void tableModelChanged(TableModelEvent tableModelEvent) {
        if (this._fillingPanel) {
            return;
        }
        this._parent.updateDistribution();
    }

    @Override
    public void fillPanel(AbstractContDist abstractContDist, int n, Map<Integer, String> object) {
        this._fillingPanel = true;
        this._paramId = n;
        if (abstractContDist == null || this._distClass == null || !this._distClass.equals(abstractContDist.getClass())) {
            return;
        }
        try {
            if (abstractContDist instanceof EmpiricalDist) {
                Object object2 = (EmpiricalDist)abstractContDist;
                EmpiricalDist.InterpType interpType = object2.getInterpType();
                boolean bl = false;
                object = new boolean[]{true, true};
                String[] stringArray = new String[]{};
                Object object3 = new int[]{};
                if (interpType == EmpiricalDist.InterpType.LINEAR) {
                    this._linrInterpRadio.setSelected(true);
                    this._stepInterpRadio.setSelected(false);
                    stringArray = new String[]{"Exceed Prob. (decreasing)", "Value (%S)"};
                    object3 = new int[]{-1, n};
                } else if (interpType == EmpiricalDist.InterpType.STEP) {
                    stringArray = new String[]{"Value (%S)", "Probability"};
                    this._linrInterpRadio.setSelected(false);
                    this._stepInterpRadio.setSelected(true);
                    object3 = new int[]{n, -1};
                    bl = true;
                }
                object = new RmaTableModel(stringArray, 8, (boolean[])object, null);
                object.setDisplayUnitsSystem(ServiceLookup.getUnitsDisplayService().getDisplayUnitsSystem());
                this._empirTable.setModel((TableModel)object);
                this._empirTable.setColumnParameters(object3);
                this._totalProbPanel.setVisible(bl);
                this._empirTable.addTableModelListener(this::tableModelChanged);
                this._empirTable.setUnitsHeaderRenderer();
                this._empirTable.clearCells();
                this._empirTable.setPrecision(2);
                object = object2.getExceedProbs();
                double[] dArray = object2.getCumProbs();
                object2 = object2.getValues();
                int n2 = ((Object)object).length;
                this._empirTable.setNumRows(Math.max(n2, 8));
                object3 = new DecimalFormat("#.####");
                if (interpType == EmpiricalDist.InterpType.LINEAR) {
                    for (int i = 0; i < n2; ++i) {
                        this._empirTable.setValueAt((Object)object3.format((double)object[i]), i, 0);
                        this._empirTable.setValueAt((Object)object3.format((double)object2[i]), i, 1);
                    }
                } else if (interpType == EmpiricalDist.InterpType.STEP) {
                    for (int i = 0; i < n2; ++i) {
                        if (i > 0) {
                            this._empirTable.setValueAt((Object)object3.format(dArray[i] - dArray[i - 1]), i, 1);
                        } else {
                            this._empirTable.setValueAt((Object)object3.format(dArray[i]), i, 1);
                        }
                        this._empirTable.setValueAt((Object)object3.format((double)object2[i]), i, 0);
                    }
                }
            } else {
                int n3 = 0;
                double[] dArray = null;
                if (abstractContDist != null) {
                    dArray = abstractContDist.getParamVals();
                    if (abstractContDist instanceof MultiParametrizadDist && ((MultiParametrizadDist)abstractContDist).getParametrizationName().equals("Linear")) {
                        this._parent._linearScaleRadio.setSelected(true);
                        dArray = ((MultiParametrizadDist)abstractContDist).getParams2();
                        ((ParamsPanel)this).convertLogToLinear();
                    }
                    n3 = dArray.length;
                }
                for (int i = 0; i < n3; ++i) {
                    this._paramFlds[i].setValue(new ParamDouble(dArray[i], n, 1, 2));
                    if (!object.keySet().contains(i)) continue;
                    this.addDependency(i, (String)object.get(i));
                }
            }
            if (this._dependencyButtons != null) {
                String string = null;
                if (this._parent._parent._variable != null) {
                    string = this._parent._parent._variable.getShortName();
                }
                List<MCInputVariableImpl> list = MCVariableDependencySelectionDialog.getEffectiveVariables(this._parent._parent.getAvailableInputVariables(), string);
                for (int i = 0; i < this._dependencyButtons.length; ++i) {
                    object = this._dependencyButtons[i];
                    if (list.isEmpty() && this._paramFlds[i].isVisible()) {
                        object.setEnabled(false);
                        object.setToolTipText("No available variables to select as dependency");
                        continue;
                    }
                    object.setEnabled(true);
                    object.setToolTipText(null);
                }
            }
            this.updateMinMaxActions();
            if (abstractContDist instanceof ClipDist) {
                this._clipPanel.fillPanel((ClipDist)abstractContDist, n);
            }
            return;
        }
        finally {
            this._fillingPanel = false;
        }
    }

    @Override
    public Object[] getDistributionParams() {
        Object[] objectArray;
        if (this._distClass.getSimpleName().contains("Empirical")) {
            Object object;
            EmpiricalDist.InterpType interpType = this._linrInterpRadio.isSelected() ? EmpiricalDist.InterpType.LINEAR : EmpiricalDist.InterpType.STEP;
            ArrayList<Double> arrayList = new ArrayList<Double>();
            objectArray = new ArrayList();
            int n = this._empirTable.getNumRows();
            for (int i = 0; i < n; ++i) {
                Object object2;
                object = this._empirTable.getValueAt(i, 0);
                if (object instanceof ParamDouble) {
                    object = object.toString();
                }
                if ((object2 = this._empirTable.getValueAt(i, 1)) instanceof ParamDouble) {
                    object2 = object2.toString();
                }
                if (!(object instanceof String) || object == null || ((String)object).isEmpty() || !(object2 instanceof String) || object2 == null || ((String)object2).isEmpty()) continue;
                double d = RMAIO.parseDouble((Object)object);
                double d2 = RMAIO.parseDouble((Object)object2);
                if (!RMAConst.isValidValue((double)d) || !RMAConst.isValidValue((double)d2)) continue;
                arrayList.add(d);
                objectArray.add(d2);
            }
            n = arrayList.size();
            double[] dArray = new double[n];
            object = new double[n];
            for (int i = 0; i < n; ++i) {
                if (interpType == EmpiricalDist.InterpType.LINEAR) {
                    dArray[i] = 1.0 - (Double)arrayList.get(i);
                    object[i] = (Double)objectArray.get(i);
                    continue;
                }
                object[i] = (Double)arrayList.get(i);
                dArray[i] = i > 0 ? (Double)objectArray.get(i) + dArray[i - 1] : (Double)objectArray.get(i);
            }
            if (interpType == EmpiricalDist.InterpType.STEP && dArray.length > 0) {
                this._totalProb.setValue(dArray[dArray.length - 1]);
            }
            double[][] dArray2 = this.removeDuplicates((double[])object, dArray);
            Object[] objectArray2 = new Object[3];
            objectArray = objectArray2;
            objectArray2[0] = interpType;
            objectArray[1] = dArray2[0];
            objectArray[2] = dArray2[1];
        } else {
            int n = 0;
            if (this._paramFlds != null) {
                n = this._paramFlds.length;
            }
            objectArray = new Double[n];
            for (int i = 0; i < n; ++i) {
                this._paramFlds[i].setModified(false);
                objectArray[i] = this._paramFlds[i].getValue();
            }
        }
        return objectArray;
    }

    private double[][] removeDuplicates(double[] dArray, double[] dArray2) {
        boolean[] blArray = new boolean[dArray2.length];
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < i; ++j) {
                if (dArray[i] != dArray[j] && dArray2[i] != dArray2[j]) continue;
                blArray[i] = true;
            }
            if (blArray[i]) continue;
            ++n;
        }
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        n = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray[i]) continue;
            dArray3[n] = dArray[i];
            dArray4[n] = dArray2[i];
            ++n;
        }
        return new double[][]{dArray4, dArray3};
    }

    @Override
    protected ClipDist getClipDist() {
        return this._clipPanel.getDistribution();
    }

    @Override
    public Map<Integer, String> getDependentVariableNames() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        for (int i = 0; i < this._paramFlds.length; ++i) {
            if (this._paramFlds[i].isVisible()) continue;
            hashMap.put(i, this._dependencyButtons[i].getText());
        }
        return hashMap;
    }

    @Override
    public void convertLogToLinear() {
        double[] dArray = new double[((ParamsPanel)this).getDistributionParams().length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = (Double)((ParamsPanel)this).getDistributionParams()[i];
        }
        try {
            MultiParametrizadDist multiParametrizadDist = (MultiParametrizadDist)this._distClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            String[] stringArray = multiParametrizadDist.getParamNames2();
            this.setParamLabels(stringArray);
            multiParametrizadDist.setParams1(dArray);
            dArray = multiParametrizadDist.getParams2();
            for (int i = 0; i < dArray.length; ++i) {
                this._paramFlds[i].setValue(new ParamDouble(dArray[i], this._paramId, 1));
            }
            return;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    @Override
    public void convertLinearToLog() {
        double[] dArray = new double[((ParamsPanel)this).getDistributionParams().length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = (Double)((ParamsPanel)this).getDistributionParams()[i];
        }
        try {
            Object object = (MultiParametrizadDist)this._distClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            String[] stringArray = object.getParamNames1();
            this.setParamLabels(stringArray);
            object.setParams2(dArray);
            object = object.getParams1();
            for (int i = 0; i < dArray.length; ++i) {
                this._paramFlds[i].setValue(new ParamDouble((double)object[i], this._paramId, 1));
            }
            return;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    private void setParamLabels(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            string = string.replace("Ln", " Ln");
            String string2 = (string = string.replace("Log", " Log")).contains("Shape") || string.contains("Skew") || string.contains("Freedom") ? "" : (string.contains("Log") ? " (Log(%S))" : (string.contains("Ln") ? " (Ln(%S))" : " (%S)"));
            this._paramLabels[i].setText(string.concat(string2));
            this._paramLabels[i].setDisplayUnitsSystem(ServiceLookup.getUnitsDisplayService().getDisplayUnitsSystem());
        }
    }

    @Override
    protected Object[] getLogParams(Object[] objectArray) {
        double[] dArray = new double[objectArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = (Double)objectArray[i];
            double cfr_ignored_0 = dArray[i];
        }
        try {
            MultiParametrizadDist multiParametrizadDist = (MultiParametrizadDist)this._distClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            multiParametrizadDist.setParams2(dArray);
            objectArray = new Double[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                objectArray[i] = multiParametrizadDist.getParams1()[i];
            }
            if (Double.isNaN((Double)objectArray[0]) || (Double)objectArray[0] == Double.NEGATIVE_INFINITY) {
                return null;
            }
            return objectArray;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public void checkWarning(String[] stringArray, RssAlt object) {
        object = this.getMCScalarDistributionWizardPanel();
        AbstractContDist abstractContDist = this.getDistribution();
        if (abstractContDist == null) {
            return;
        }
        if (this._parent.isRelative()) {
            abstractContDist.getCDF(100.0);
        } else {
            double d = abstractContDist.getCDF(this._parent._parent.getDefaultValue()[0].doubleValue());
            if (d > 0.995 || d < 0.005) {
                stringArray[0] = stringArray[0].concat("WARNING: Network variable value is outside 99% bounds of the sampling distribution specified above. The distribution parameters should be revised for consistency.\n");
            }
        }
        if (abstractContDist instanceof EmpiricalDist && this._empirTable != null) {
            for (int i = 0; i <= this._empirTable.getColumnCount() - 1; ++i) {
                if (this._empirTable.getColumnName(i).contains("Prob")) {
                    if (ParamsCnstPanel.isDiscreteDist((MCScalarDistributionWizardPanel)((Object)object))) {
                        ParamsCnstPanel.isTotalProbValid(this._empirTable, i, stringArray);
                    } else if (ParamsCnstPanel.isEmpiricalDist((MCScalarDistributionWizardPanel)((Object)object))) {
                        ParamsCnstPanel.checkMonotonicOrder(this._empirTable, i, stringArray, true, "Empirical");
                    }
                } else {
                    String string = "";
                    if (abstractContDist instanceof EmpiricalDist) {
                        if (ParamsCnstPanel.isDiscreteDist((MCScalarDistributionWizardPanel)((Object)object))) {
                            string = "Discrete";
                        } else if (ParamsCnstPanel.isEmpiricalDist((MCScalarDistributionWizardPanel)((Object)object))) {
                            string = "Empirical";
                        }
                        ParamsCnstPanel.checkMonotonicOrder(this._empirTable, i, stringArray, false, string);
                    }
                }
                MCVariableWizardDialog.setFinalWarningMessages(stringArray);
            }
        }
    }
}

