/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.rss.model.RssAlt;
import hec.rss.plugins.montecarlo.client.ClipPanelImpl;
import hec.rss.plugins.montecarlo.client.DistributionPanel;
import hec.rss.plugins.montecarlo.client.MCScalarDistributionWizardPanel;
import hec.statistics.AbstractContDist;
import hec.statistics.ClipData;
import hec.statistics.ClipDist;
import hec.statistics.EmpiricalDist;
import hec.statistics.MultiParametrizadDist;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJPanel;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTable;
import rma.util.RMAIO;

public abstract class ParamsPanel
extends RmaJPanel {
    protected static final int a = 8;
    protected static final String b = "WARNING: %s Distribution Data is not valid. Distribution Values must be strictly monotonically increasing.  Your input data may not save correctly.\n";
    protected static final String c = "WARNING: %s Distribution Data is not valid. Exceedance Probability Values must be strictly monotonically decreasing. Your input data may not save correctly.\n";
    protected static final String d = "WARNING: Network variable value is outside 99% bounds of the sampling distribution specified above. The distribution parameters should be revised for consistency.\n";
    protected static final String e = "ERROR: Discrete Distribution Data is not valid. Probabilities must add up to 1.\n";
    protected static final String f = "Prob";
    protected static final String g = "Discrete";
    protected static final String h = "Empirical";
    Class<? extends AbstractContDist> _distClass;
    protected RmaJRadioButton _linrInterpRadio;
    protected RmaJRadioButton _stepInterpRadio;
    protected RmaJPanel _interpolationPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
    protected DistributionPanel _parent;
    protected ClipPanelImpl _clipPanel;
    protected RmaJDecimalField[] _paramFlds;
    protected RmaJPanel _paramFieldsPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
    protected int _paramId;

    public ParamsPanel(Class<? extends AbstractContDist> clazz, DistributionPanel distributionPanel) {
        super((LayoutManager)new GridBagLayout());
        this._distClass = clazz;
        this._parent = distributionPanel;
        this.buildControls();
        this.setToolTipText("");
    }

    private void buildControls() {
        AbstractContDist abstractContDist;
        try {
            abstractContDist = this._distClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            abstractContDist = null;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        if (abstractContDist instanceof EmpiricalDist) {
            this._linrInterpRadio = new RmaJRadioButton("Linear");
            this._stepInterpRadio = new RmaJRadioButton("Step");
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weighty = 1.0;
        }
        this._paramFieldsPanel.setBorder((Border)BorderFactory.createTitledBorder("Distribution Parameters"));
        ParamsPanel paramsPanel = this;
        paramsPanel.add((Component)paramsPanel._paramFieldsPanel, gridBagConstraints);
    }

    protected abstract RmaJTable getTable();

    public void stopEditingTable() {
        RmaJTable rmaJTable = this.getTable();
        if (rmaJTable != null && rmaJTable.getCellEditor() != null) {
            rmaJTable.getCellEditor().stopCellEditing();
            this._parent.updateDistribution();
        }
    }

    public AbstractContDist getDistribution() {
        AbstractContDist abstractContDist = this.getDistributionParams();
        abstractContDist = this.buildDistribution((Object[])abstractContDist);
        if (this._clipPanel != null && abstractContDist != null) {
            ClipData clipData = ((ClipDist)abstractContDist).getClipData();
            clipData.setMaxVal(this.getClipDist().getClipData().getMaxVal());
            clipData.setMaxClip(this.getClipDist().getClipData().hasMaxClip());
            clipData.setMinVal(this.getClipDist().getClipData().getMinVal());
            clipData.setMinClip(this.getClipDist().getClipData().hasMinClip());
        }
        return abstractContDist;
    }

    protected abstract Object[] getLogParams(Object[] var1);

    protected abstract ClipDist getClipDist();

    public void updateDistParams(ClipDist clipDist) {
        this._clipPanel.updateDistParams(clipDist);
    }

    public abstract Object[] getDistributionParams();

    public abstract void fillPanel(AbstractContDist var1, int var2, Map<Integer, String> var3);

    public AbstractContDist buildDistribution(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        try {
            AbstractContDist abstractContDist;
            Class[] classArray = new Class[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                abstractContDist = objectArray[i].getClass();
                classArray[i] = abstractContDist.equals(Double.class) ? Double.TYPE : abstractContDist;
            }
            Constructor<? extends AbstractContDist> constructor = this._distClass.getDeclaredConstructor(classArray);
            abstractContDist = constructor.newInstance(objectArray);
            if (abstractContDist instanceof MultiParametrizadDist && this._parent._linearScaleRadio.isSelected()) {
                ((MultiParametrizadDist)abstractContDist).setParametrizationName("Linear");
                ((MultiParametrizadDist)abstractContDist).setParams2(new double[]{(Double)objectArray[0], (Double)objectArray[1]});
            }
            return abstractContDist;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException exception) {
            return null;
        }
    }

    void setMinValueAction() {
        if (this._distClass == null) {
            return;
        }
        if (this._distClass.getSimpleName().contains("Unif") || this._distClass.getSimpleName().contains("Triang")) {
            double d;
            int n = this._paramFlds.length;
            double d2 = this._paramFlds[0].getValue();
            if (d > this._paramFlds[0].getMaxValue()) {
                return;
            }
            for (int i = 1; i < n; ++i) {
                this._paramFlds[i].setValue(Math.max(d2, this._paramFlds[i].getValue()));
                this._paramFlds[i].setMinValue(d2);
            }
        }
    }

    void setMaxValueAction() {
        if (this._distClass == null) {
            return;
        }
        if (this._distClass.getSimpleName().contains("Unif") || this._distClass.getSimpleName().contains("Triang")) {
            double d;
            int n = this._paramFlds.length;
            double d2 = this._paramFlds[n - 1].getValue();
            if (d < this._paramFlds[n - 1].getMinValue()) {
                return;
            }
            for (int i = 0; i < n - 1; ++i) {
                this._paramFlds[i].setValue(Math.min(d2, this._paramFlds[i].getValue()));
                this._paramFlds[i].setMaxValue(d2);
            }
        }
    }

    public void updateMinMaxActions() {
        try {
            this._parent.setIgnoreTableModelEvents(true);
            this.setMinValueAction();
            this.setMaxValueAction();
            return;
        }
        finally {
            this._parent.setIgnoreTableModelEvents(false);
        }
    }

    public Map<Integer, String> getDependentVariableNames() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        return hashMap;
    }

    public abstract void convertLogToLinear();

    public abstract void convertLinearToLog();

    public abstract void checkWarning(String[] var1, RssAlt var2);

    public String getToolTipText(MouseEvent mouseEvent) {
        if (mouseEvent.isControlDown() && mouseEvent.isAltDown() && mouseEvent.isShiftDown()) {
            return "Class is:" + ((Object)((Object)this)).getClass().getName();
        }
        return null;
    }

    public static boolean isEmpiricalDist(MCScalarDistributionWizardPanel mCScalarDistributionWizardPanel) {
        return h.equals(mCScalarDistributionWizardPanel._distributionType.getSelectedItem());
    }

    public static boolean isDiscreteDist(MCScalarDistributionWizardPanel mCScalarDistributionWizardPanel) {
        return g.equals(mCScalarDistributionWizardPanel._distributionType.getSelectedItem());
    }

    public MCScalarDistributionWizardPanel getMCScalarDistributionWizardPanel() {
        return (MCScalarDistributionWizardPanel)((Object)this._parent.getParent().getParent());
    }

    public static void isTotalProbValid(RmaJTable rmaJTable, int n, String[] stringArray) {
        int n2 = rmaJTable.getRowCount();
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            Object object = rmaJTable.getValueAt(i, n);
            if (object == null || object.toString().trim().isEmpty()) continue;
            double d2 = ParamsPanel.a(object);
            d += d2;
        }
        if (Math.abs(d - 1.0) > 0.005) {
            stringArray[0] = stringArray[0].concat(e);
        }
    }

    public static void checkMonotonicOrder(RmaJTable rmaJTable, int n, String[] stringArray, boolean bl, String string) {
        int n2;
        if (string == null) {
            string = "";
        }
        if ((n2 = rmaJTable.getRowCount()) < 2) {
            return;
        }
        Object object = rmaJTable.getValueAt(0, n);
        if (object == null || object.toString().trim().isEmpty()) {
            return;
        }
        if ((object = ParamsPanel.a(object)) == null) {
            return;
        }
        for (int i = 1; i < n2; ++i) {
            Object object2 = rmaJTable.getValueAt(i, n);
            if (object2 == null || object2.toString().trim().isEmpty()) {
                return;
            }
            if ((object2 = ParamsPanel.a(object2)) == null) {
                return;
            }
            if (bl) {
                if ((Double)object2 >= (Double)object) {
                    stringArray[0] = stringArray[0].concat(String.format(c, string));
                    return;
                }
            } else if ((Double)object2 <= (Double)object) {
                stringArray[0] = stringArray[0].concat(String.format(b, string));
                return;
            }
            object = object2;
        }
    }

    private static Double a(Object object) {
        double d = object instanceof Number ? ((Number)object).doubleValue() : RMAIO.parseDouble((String)object.toString());
        return d;
    }
}

