/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.data.ParamDouble;
import hec.heclib.util.HecTime;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.rss.client.SeasonalVariationJDialog;
import hec.rss.model.RssAlt;
import hec.rss.plugins.montecarlo.client.ClipAtZeroSeasonalPanel;
import hec.rss.plugins.montecarlo.client.ClipBySeasonalValuePanel;
import hec.rss.plugins.montecarlo.client.DistributionPanel;
import hec.rss.plugins.montecarlo.client.MCScalarDistributionWizardPanel;
import hec.rss.plugins.montecarlo.client.MCVariableWizardDialog;
import hec.rss.plugins.montecarlo.client.ParamsPanel;
import hec.rss.plugins.montecarlo.client.ParamsSeasonalPanel$1;
import hec.rss.plugins.montecarlo.client.ParamsSeasonalPanel$ExtendedRmaTable;
import hec.rss.plugins.montecarlo.model.SeasonalClipData;
import hec.rss.plugins.montecarlo.model.SeasonalContinuousDistribution;
import hec.statistics.AbstractContDist;
import hec.statistics.ClipDist;
import hec.statistics.EmpiricalDist;
import hec.statistics.MultiParametrizadDist;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import rma.services.ServiceLookup;
import rma.swing.RmaInsets;
import rma.swing.RmaJButton;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJPanel;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.table.RmaCellEditor;
import rma.swing.table.RmaTableModel;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class ParamsSeasonalPanel
extends ParamsPanel {
    private ParamsSeasonalPanel$ExtendedRmaTable _paramTable;
    private RmaJButton _editSeasonsButton;
    private RmaJLabel[] _label;
    HecTime[] _dates;
    private AbstractContDist[] _defaultDist;
    private RmaJPanel _totalProbPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
    private RmaJDecimalField _totalProb = new RmaJDecimalField();
    private int _paramId;
    private DecimalFormat _format = new DecimalFormat("#.####");
    private boolean _updatingTable;

    public ParamsSeasonalPanel(AbstractContDist abstractContDist, DistributionPanel distributionPanel) {
        super(abstractContDist.getClass(), distributionPanel);
        this._dates = this._parent._parent.getDates();
        this._defaultDist = this._parent._parent.getDists(this._distClass, this._dates);
        if (this._defaultDist[0] instanceof EmpiricalDist) {
            for (int i = 0; i < this._defaultDist.length; ++i) {
                ((EmpiricalDist)this._defaultDist[i]).setInterpType(((EmpiricalDist)abstractContDist).getInterpType());
            }
        }
        this.buildPanel();
    }

    public void buildPanel() {
        Object object;
        if (this._distClass == null) {
            return;
        }
        try {
            object = this._distClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            object = null;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().insets = RmaInsets.INSETS0555;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        this._editSeasonsButton = new RmaJButton("Edit Seasons");
        this._editSeasonsButton.addActionListener((ActionListener)new ParamsSeasonalPanel$1(this));
        this._paramFieldsPanel.add((Component)this._editSeasonsButton);
        if (object instanceof EmpiricalDist) {
            ParamsSeasonalPanel paramsSeasonalPanel = this;
            this._paramTable = new ParamsSeasonalPanel$ExtendedRmaTable(paramsSeasonalPanel, (Component)((Object)paramsSeasonalPanel));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.fill = 1;
            object = this._paramTable.getScrollPane();
            object.setPreferredSize(new Dimension(80, 120));
            this._paramFieldsPanel.add((Component)object, (Object)gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            this._paramFieldsPanel.add((Component)this._totalProbPanel, (Object)gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.25;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            this._totalProbPanel.add((Component)new RmaJLabel("Total Probability:"), (Object)gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.75;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            this._totalProbPanel.add((Component)this._totalProb, (Object)gridBagConstraints);
            return;
        }
        ParamsSeasonalPanel paramsSeasonalPanel = this;
        this._paramTable = new ParamsSeasonalPanel$ExtendedRmaTable(paramsSeasonalPanel, (Component)((Object)paramsSeasonalPanel));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        object = this._paramTable.getScrollPane();
        object.setPreferredSize(new Dimension(80, 80));
        this._paramFieldsPanel.add((Component)object, (Object)gridBagConstraints);
        this._clipPanel = this._parent.isRelative() ? new ClipAtZeroSeasonalPanel(this._parent) : new ClipBySeasonalValuePanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        ParamsSeasonalPanel paramsSeasonalPanel2 = this;
        paramsSeasonalPanel2.add((Component)((Object)paramsSeasonalPanel2._clipPanel), gridBagConstraints);
    }

    private void buildTable(HecTime[] objectArray, AbstractContDist[] abstractContDistArray) {
        this._updatingTable = true;
        try {
            int n;
            this._dates = objectArray;
            int n2 = 0;
            String[] stringArray = null;
            if (abstractContDistArray != null) {
                stringArray = abstractContDistArray[0].getParamNames();
                n2 = stringArray.length;
            }
            if (abstractContDistArray[0] instanceof MultiParametrizadDist) {
                stringArray = ((MultiParametrizadDist)abstractContDistArray[0]).getActiveParamNames();
            }
            this._label = new RmaJLabel[n2];
            String[] stringArray2 = new String[1 + objectArray.length];
            objectArray = stringArray2;
            stringArray2[0] = "Parameter";
            boolean[] blArray = new boolean[objectArray.length];
            Object object = blArray;
            blArray[0] = false;
            for (int i = 1; i < objectArray.length; ++i) {
                objectArray[i] = this._dates[i - 1].date(14).substring(0, 5);
                object[i] = true;
            }
            RmaTableModel rmaTableModel = new RmaTableModel((String[])objectArray, abstractContDistArray[0].getParamVals().length - 1, (boolean[])object, null);
            rmaTableModel.setDisplayUnitsSystem(ServiceLookup.getUnitsDisplayService().getDisplayUnitsSystem());
            this._paramTable.setModel((TableModel)rmaTableModel);
            this._paramTable.addTableModelListener(this::tableModelChanged);
            this._paramTable.setCellSelectionEnabled(true);
            this._paramTable.getSelectionModel().setSelectionMode(2);
            this._paramTable.setColumnEnabled(false, 0);
            this._paramTable.setUnitsHeaderRenderer();
            this._paramTable.setColumnEditor(0, new RmaCellEditor((JTextField)new RmaJTextField()));
            this._paramTable.setColumnWidth(0, 100);
            for (n = 1; n < this._paramTable.getColumnCount(); ++n) {
                for (int i = 0; i < n2; ++i) {
                    rmaTableModel = new RmaJDecimalField();
                    rmaTableModel = new RmaCellEditor((RmaJDecimalField)rmaTableModel);
                    rmaTableModel.setUnitSystem(1);
                    this._paramTable.setCellEditor(i, n, (TableCellEditor)rmaTableModel);
                }
            }
            for (n = 0; n < n2; ++n) {
                if (n > 0 && n < n2 - 1) {
                    this._paramTable.appendRow();
                }
                String string = stringArray[n];
                object = string;
                String string2 = string.replace("Ln", " Ln");
                object = string2;
                String string3 = string2.replace("Log", " Log");
                object = string3;
                String string4 = string3.contains("Shape") || ((String)object).contains("Skew") || ((String)object).contains("Freedom") ? "" : (((String)object).contains("Log") ? " (Log(%S))" : (((String)object).contains("Ln") ? " (Ln(%S))" : " (%S)"));
                this._label[n] = new RmaJLabel(((String)object).concat(string4));
                for (int i = 1; i < this._paramTable.getColumnCount(); ++i) {
                    if (i == 1) {
                        object = new RmaJDecimalField();
                        this._label[n].setLabelFor((Component)object);
                        if (abstractContDistArray[0] instanceof MultiParametrizadDist) {
                            object.setValue(new ParamDouble(Double.valueOf(this._format.format(((MultiParametrizadDist)abstractContDistArray[0]).getActiveParams()[n])).doubleValue(), this._paramId, 1, 2));
                        } else {
                            object.setValue(new ParamDouble(Double.valueOf(this._format.format(abstractContDistArray[0].getParamVals()[n])).doubleValue(), this._paramId, 1, 2));
                        }
                        this._paramTable.getModel().setValueAt(this._label[n].getText(), n, 0);
                    }
                    if (abstractContDistArray.length != this._paramTable.getColumnCount() - 1) {
                        if (abstractContDistArray[0] instanceof MultiParametrizadDist) {
                            this._paramTable.getModel().setValueAt(Double.valueOf(this._format.format(((MultiParametrizadDist)abstractContDistArray[0]).getActiveParams()[n])), n, i);
                            continue;
                        }
                        this._paramTable.getModel().setValueAt(Double.valueOf(this._format.format(abstractContDistArray[0].getParamVals()[n])), n, i);
                        continue;
                    }
                    if (abstractContDistArray[i - 1] instanceof MultiParametrizadDist) {
                        this._paramTable.getModel().setValueAt(Double.valueOf(this._format.format(((MultiParametrizadDist)abstractContDistArray[i - 1]).getActiveParams()[n])), n, i);
                        continue;
                    }
                    this._paramTable.getModel().setValueAt(Double.valueOf(this._format.format(abstractContDistArray[i - 1].getParamVals()[n])), n, i);
                }
            }
            this._paramTable.setColumnSelectionInterval(1, 1);
            return;
        }
        finally {
            this._updatingTable = false;
        }
    }

    @Override
    void setMinValueAction() {
        if (this._distClass == null) {
            return;
        }
        if (this._distClass.getSimpleName().contains("Unif") || this._distClass.getSimpleName().contains("Triang")) {
            for (int i = 1; i < this._paramTable.getColumnCount(); ++i) {
                int n = this._paramTable.getRowCount();
                Object object = this._paramTable.getValueAt(0, i);
                double d = object instanceof String ? Double.valueOf((String)this._paramTable.getValueAt(0, i)).doubleValue() : ((Double)this._paramTable.getValueAt(0, i)).doubleValue();
                for (int j = 1; j < n; ++j) {
                    object = this._paramTable.getValueAt(j, i);
                    double d2 = object instanceof String ? Double.valueOf((String)object).doubleValue() : ((Double)object).doubleValue();
                    this._paramTable.setValueAt(Math.max(d, d2), j, i);
                    ((RmaJDecimalField)((RmaCellEditor)this._paramTable.getCellEditor(j, i)).getComponent()).setMinValue(d);
                }
            }
        }
    }

    @Override
    void setMaxValueAction() {
        if (this._distClass == null) {
            return;
        }
        if (this._distClass.getSimpleName().contains("Unif") || this._distClass.getSimpleName().contains("Triang")) {
            for (int i = 1; i < this._paramTable.getColumnCount(); ++i) {
                int n = this._paramTable.getRowCount();
                Object object = this._paramTable.getValueAt(n - 1, i);
                double d = object instanceof String ? Double.valueOf((String)object).doubleValue() : ((Double)object).doubleValue();
                for (int j = 0; j < n - 1; ++j) {
                    object = this._paramTable.getValueAt(j, i);
                    double d2 = object instanceof String ? Double.valueOf((String)object).doubleValue() : ((Double)object).doubleValue();
                    this._paramTable.setValueAt(Math.min(d, d2), j, i);
                    ((RmaJDecimalField)((RmaCellEditor)this._paramTable.getCellEditor(j, i)).getComponent()).setMaxValue(d);
                }
            }
        }
    }

    private void buildEmpiricalTable(HecTime[] objectArray, AbstractContDist[] abstractContDistArray) {
        int n;
        this._dates = objectArray;
        this._paramTable.setNumRows(8);
        EmpiricalDist.InterpType interpType = ((EmpiricalDist)abstractContDistArray[0]).getInterpType();
        boolean bl = false;
        objectArray = new String[1 + objectArray.length];
        Object object = new boolean[objectArray.length];
        if (interpType == EmpiricalDist.InterpType.LINEAR) {
            this._linrInterpRadio.setSelected(true);
            this._stepInterpRadio.setSelected(false);
            objectArray[0] = "Exceed Prob. (decreasing)";
        } else if (interpType == EmpiricalDist.InterpType.STEP) {
            this._linrInterpRadio.setSelected(false);
            this._stepInterpRadio.setSelected(true);
            bl = true;
            objectArray[0] = "Probability";
        }
        object[0] = true;
        for (int i = 1; i < objectArray.length; ++i) {
            objectArray[i] = this._dates[i - 1].date(14).substring(0, 5);
            object[i] = true;
        }
        RmaTableModel rmaTableModel = new RmaTableModel((String[])objectArray, 8, object, null);
        rmaTableModel.setDisplayUnitsSystem(ServiceLookup.getUnitsDisplayService().getDisplayUnitsSystem());
        this._paramTable.setModel((TableModel)rmaTableModel);
        this._paramTable.setUnitsHeaderRenderer();
        this._totalProbPanel.setVisible(bl);
        this._paramTable.addTableModelListener(this::tableModelChanged);
        this._paramTable.setPrecision(2);
        RmaJDecimalField rmaJDecimalField = this._paramTable.setDoubleCellEditor(0);
        rmaJDecimalField.setMinValue(0.0);
        rmaJDecimalField.setMaxValue(1.0);
        rmaJDecimalField.setPrecision(2);
        for (n = 1; n < objectArray.length; ++n) {
            RmaJDecimalField rmaJDecimalField2 = this._paramTable.setDoubleCellEditor(n);
            object = rmaJDecimalField2;
            rmaJDecimalField2.setPrecision(2);
        }
        for (n = 0; n < objectArray.length; ++n) {
            for (int i = 0; i < ((EmpiricalDist)abstractContDistArray[0]).getExceedProbs().length; ++i) {
                if (n == 0) {
                    if (interpType == EmpiricalDist.InterpType.LINEAR) {
                        this._paramTable.setValueAt(this._format.format(((EmpiricalDist)abstractContDistArray[0]).getExceedProbs()[i]), i, n);
                        continue;
                    }
                    if (i == 0) {
                        this._paramTable.setValueAt(this._format.format(((EmpiricalDist)abstractContDistArray[0]).getCumProb(i)), i, n);
                        continue;
                    }
                    this._paramTable.setValueAt(this._format.format(((EmpiricalDist)abstractContDistArray[0]).getCumProb(i) - ((EmpiricalDist)abstractContDistArray[0]).getCumProb(i - 1)), i, n);
                    continue;
                }
                this._paramTable.setValueAt(this._format.format(((EmpiricalDist)abstractContDistArray[n - 1]).getValue(i)), i, n);
            }
        }
        this._paramTable.setColumnSelectionInterval(1, 1);
    }

    @Override
    protected RmaJTable getTable() {
        return this._paramTable;
    }

    private void tableModelChanged(TableModelEvent tableModelEvent) {
        if (this._updatingTable) {
            return;
        }
        this._parent.updateDistribution();
    }

    @Override
    public void fillPanel(AbstractContDist abstractContDist, int n, Map<Integer, String> object) {
        this._updatingTable = true;
        try {
            this._paramId = n;
            if (!(abstractContDist instanceof SeasonalContinuousDistribution)) {
                object = new SeasonalContinuousDistribution(this.getHecTimes(), this.getDistList(), this.getRts());
            } else {
                object = (SeasonalContinuousDistribution)abstractContDist;
                if (((SeasonalContinuousDistribution)((Object)object)).getDist() instanceof MultiParametrizadDist && ((MultiParametrizadDist)((SeasonalContinuousDistribution)((Object)object)).getDist()).getParametrizationNumber() == 2) {
                    this._parent._linearScaleRadio.setSelected(true);
                }
                ((SeasonalContinuousDistribution)((Object)object)).setDoesDec31Exist(false);
                int n2 = 0;
                while (true) {
                    Map<Integer, String> map = object;
                    if (n2 >= ((SeasonalContinuousDistribution)((Object)map)).getDist(((SeasonalContinuousDistribution)((Object)map)).getHecTimes().size()).getParamVals().length) break;
                    Map<Integer, String> map2 = object;
                    if (((SeasonalContinuousDistribution)((Object)map2)).getDist(((SeasonalContinuousDistribution)((Object)map2)).getHecTimes().size()).getParamVals()[n2] != ((SeasonalContinuousDistribution)((Object)object)).getDist(0).getParamVals()[n2]) {
                        ((SeasonalContinuousDistribution)((Object)object)).setDoesDec31Exist(true);
                        break;
                    }
                    ++n2;
                }
            }
            this.buildTable((SeasonalContinuousDistribution)((Object)object));
            if (abstractContDist instanceof ClipDist && this._clipPanel != null) {
                this._clipPanel.fillPanel((ClipDist)object, n);
            }
            return;
        }
        finally {
            this._updatingTable = false;
        }
    }

    private void buildTable(SeasonalContinuousDistribution seasonalContinuousDistribution) {
        HecTime[] hecTimeArray = new HecTime[seasonalContinuousDistribution.getHecTimes().size()];
        AbstractContDist[] abstractContDistArray = new AbstractContDist[seasonalContinuousDistribution.getHecTimes().size()];
        for (int i = 0; i < hecTimeArray.length; ++i) {
            hecTimeArray[i] = seasonalContinuousDistribution.getHecTimes().get(i);
            abstractContDistArray[i] = seasonalContinuousDistribution.getDist(i);
        }
        if (abstractContDistArray[0] instanceof EmpiricalDist) {
            this.buildEmpiricalTable(hecTimeArray, abstractContDistArray);
            return;
        }
        this.buildTable(hecTimeArray, abstractContDistArray);
    }

    private RunTimeStep getRts() {
        RunTimeWindow runTimeWindow = new RunTimeWindow(new HecTime("01/01/00", "00:00:01"), new HecTime("12/31/00", "00:00:01"), new HecTime("01/02/00", "00:00:01"));
        runTimeWindow.setTimeStep(1, 3);
        runTimeWindow = new RunTimeStep(runTimeWindow);
        return runTimeWindow;
    }

    private List<AbstractContDist> getDistList() {
        ArrayList<AbstractContDist> arrayList = new ArrayList<AbstractContDist>();
        for (int i = 0; i < this._dates.length; ++i) {
            if (this._defaultDist.length <= i) {
                arrayList.add((AbstractContDist)this._defaultDist[0].clone());
                continue;
            }
            arrayList.add((AbstractContDist)this._defaultDist[i].clone());
        }
        return arrayList;
    }

    private List<HecTime> getHecTimes() {
        ArrayList<HecTime> arrayList = new ArrayList<HecTime>();
        for (int i = 0; i < this._dates.length; ++i) {
            arrayList.add((HecTime)this._dates[i].clone());
        }
        return arrayList;
    }

    public void fillPanel() {
        this._updatingTable = true;
        try {
            if (!(this._defaultDist[0] instanceof EmpiricalDist)) {
                double[] dArray = this._defaultDist[0].getParamVals();
                int n = dArray.length;
                for (int i = 0; i < n; ++i) {
                    RmaJDecimalField rmaJDecimalField = new RmaJDecimalField();
                    this._label[i].setLabelFor((Component)rmaJDecimalField);
                    rmaJDecimalField.setValue(new ParamDouble(Double.valueOf(this._format.format(dArray[i])).doubleValue(), this._paramId, 1, 2));
                    this._paramTable.getModel().setValueAt(this._label[i].getText(), i, 0);
                }
            }
            this._parent.addListeners();
            return;
        }
        finally {
            this._updatingTable = false;
        }
    }

    @Override
    protected ClipDist getClipDist() {
        return this._clipPanel.getDistribution();
    }

    @Override
    public AbstractContDist getDistribution() {
        Object object = ((ParamsPanel)this).getDistributionParams();
        object = (SeasonalContinuousDistribution)((ParamsPanel)this).buildDistribution((Object[])object);
        if (this._clipPanel != null && object != null) {
            SeasonalClipData seasonalClipData = (SeasonalClipData)((SeasonalContinuousDistribution)((Object)object)).getClipData();
            seasonalClipData.setMaxVal(((SeasonalClipData)this.getClipDist().getClipData()).getMaxValRecord());
            seasonalClipData.setMaxClip(this.getClipDist().getClipData().hasMaxClip());
            seasonalClipData.setMinVal(((SeasonalClipData)this.getClipDist().getClipData()).getMinValRecord());
            seasonalClipData.setMinClip(this.getClipDist().getClipData().hasMinClip());
        }
        return object;
    }

    @Override
    public Object[] getDistributionParams() {
        Object[] objectArray = new RunTimeWindow(new HecTime("01/01/00", "00:00:01"), new HecTime("12/31/00", "00:00:01"), new HecTime("01/02/00", "00:00:01"));
        int n = this._paramTable.getSelectedColumn();
        if (n > 0) {
            --n;
        } else if (n < 0) {
            n = 0;
        }
        objectArray.setTimeStep(1, 3);
        RunTimeStep runTimeStep = new RunTimeStep((RunTimeWindow)objectArray);
        runTimeStep.setStep(this.getTimes()[n] / 1440 + 364);
        if (this._distClass.getSimpleName().contains("Empirical")) {
            EmpiricalDist.InterpType interpType = this._linrInterpRadio.isSelected() ? EmpiricalDist.InterpType.LINEAR : EmpiricalDist.InterpType.STEP;
            ArrayList<AbstractContDist> arrayList = new ArrayList<AbstractContDist>();
            for (int i = 0; i < this._paramTable.getColumnCount() - 1; ++i) {
                Object object;
                ArrayList<Double> arrayList2 = new ArrayList<Double>();
                ArrayList<Double> arrayList3 = new ArrayList<Double>();
                int n2 = this._paramTable.getNumRows();
                for (n = 0; n < n2; ++n) {
                    Object object2 = this._paramTable.getValueAt(n, 0);
                    if (object2 instanceof ParamDouble || object2 instanceof Double) {
                        object2 = object2.toString();
                    }
                    Object object3 = this._paramTable.getValueAt(n, i + 1);
                    object = object3;
                    if (object3 instanceof ParamDouble || object instanceof Double) {
                        object = object.toString();
                    }
                    if (object2 == null) {
                        object2 = "";
                    }
                    if (object == null) {
                        object = "";
                    }
                    if (!((String)object2).isEmpty() && ((String)object).isEmpty()) {
                        this._paramTable.setValueAt(Double.toString(0.0), n, i + 1);
                        object = this._paramTable.getValueAt(n, i + 1);
                    }
                    if (!(object2 instanceof String) || object2 == null || ((String)object2).isEmpty() || !(object instanceof String) || object == null || ((String)object).isEmpty()) continue;
                    double d = RMAIO.parseDouble((Object)object2);
                    double d2 = RMAIO.parseDouble((Object)object);
                    if (!RMAConst.isValidValue((double)d) || !RMAConst.isValidValue((double)d2)) continue;
                    arrayList2.add(d);
                    arrayList3.add(d2);
                }
                n2 = arrayList2.size();
                double[] dArray = new double[n2];
                object = new double[n2];
                for (int j = 0; j < n2; ++j) {
                    if (interpType == EmpiricalDist.InterpType.LINEAR) {
                        dArray[j] = 1.0 - (Double)arrayList2.get(j);
                        object[j] = (Double)arrayList3.get(j);
                        continue;
                    }
                    object[j] = (Double)arrayList3.get(j);
                    dArray[j] = j > 0 ? (Double)arrayList2.get(j) + dArray[j - 1] : (Double)arrayList2.get(j);
                }
                if (interpType == EmpiricalDist.InterpType.STEP && dArray.length > 0) {
                    this._totalProb.setValue(dArray[dArray.length - 1]);
                    if (Math.abs(dArray[dArray.length - 1] - 1.0) > 0.01) {
                        dArray = new double[n2];
                        object = new double[n2];
                    }
                }
                Object[] objectArray2 = new Object[3];
                objectArray = objectArray2;
                objectArray2[0] = interpType;
                objectArray[1] = dArray;
                objectArray[2] = object;
                arrayList.add(super.buildDistribution(objectArray));
            }
            objectArray = new Object[3];
            ArrayList<HecTime> arrayList4 = new ArrayList<HecTime>();
            for (int i = 0; i < this._paramTable.getColumnCount() - 1; ++i) {
                arrayList4.add((HecTime)this._dates[i].clone());
            }
            objectArray[0] = arrayList4;
            objectArray[1] = arrayList;
            objectArray[2] = runTimeStep;
            return objectArray;
        }
        objectArray = new Object[3];
        ArrayList<HecTime> arrayList = new ArrayList<HecTime>();
        ArrayList<AbstractContDist> arrayList5 = new ArrayList<AbstractContDist>();
        for (int i = 0; i < this._paramTable.getColumnCount() - 1; ++i) {
            Object[] objectArray3 = new Object[this._paramTable.getRowCount()];
            for (int j = 0; j < objectArray3.length; ++j) {
                objectArray3[j] = this._paramTable.getValueAt(j, i + 1) instanceof Double ? this._paramTable.getValueAt(j, i + 1) : Double.valueOf((String)this._paramTable.getValueAt(j, i + 1));
            }
            arrayList.add((HecTime)this._dates[i].clone());
            arrayList5.add(super.buildDistribution(objectArray3));
        }
        objectArray[0] = arrayList;
        objectArray[1] = arrayList5;
        runTimeStep.setStep(this.getTimes()[n] / 1440 + 364);
        objectArray[2] = runTimeStep;
        return objectArray;
    }

    @Override
    public AbstractContDist buildDistribution(Object[] objectArray) {
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Class<?> clazz = objectArray[i].getClass();
            classArray[i] = clazz.equals(Double.class) ? Double.TYPE : clazz;
        }
        SeasonalContinuousDistribution seasonalContinuousDistribution = new SeasonalContinuousDistribution((List)objectArray[0], (List)objectArray[1], (RunTimeStep)objectArray[2]);
        return seasonalContinuousDistribution;
    }

    void editSeasonAction() {
        int[] nArray = this.getTimes();
        Window window = SwingUtilities.windowForComponent((Component)this._paramFieldsPanel);
        window = new SeasonalVariationJDialog((Window)((Dialog)window), true);
        window.fillForm(nArray, 0);
        window.removeInterpPanel();
        window.setVisible(true);
        if (window.isCanceled()) {
            return;
        }
        this._parent.resetAllSeasons(window.getDateTimes());
    }

    void resetTimes(int[] nArray) {
        int[] nArray2 = this.getTimes();
        AbstractContDist[] abstractContDistArray = new AbstractContDist[nArray.length];
        this._dates = new HecTime[nArray.length];
        block0: for (int i = 0; i < nArray.length; ++i) {
            this._dates[i] = new HecTime(nArray[i], 1);
            this._dates[i].showTimeAsBeginningOfDay(true);
            for (int j = 0; j < nArray2.length; ++j) {
                if (nArray2[j] == HecTime.iymdjl((int)1900, (int)this._dates[i].month(), (int)this._dates[i].day()) * 1440) {
                    this._paramTable.setSelectedIndices(new int[]{j});
                    abstractContDistArray[i] = this.getDistribution(j);
                    continue block0;
                }
                if (j != nArray2.length - 1) continue;
                abstractContDistArray[i] = this._parent._parent.getDists(abstractContDistArray[0].getClass(), new HecTime[]{new HecTime(nArray[i], 1)})[0];
                if (!(abstractContDistArray[i] instanceof MultiParametrizadDist) || !this._parent._linearScaleRadio.isSelected()) continue;
                ((MultiParametrizadDist)abstractContDistArray[i]).setParametrizationNumber(2);
            }
        }
        if (abstractContDistArray[0] instanceof EmpiricalDist) {
            this._paramFieldsPanel.remove(this._paramFieldsPanel.getComponents()[1]);
            ParamsSeasonalPanel paramsSeasonalPanel = this;
            paramsSeasonalPanel.buildEmpiricalTable(paramsSeasonalPanel._dates, abstractContDistArray);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            new GridBagConstraints().gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.fill = 1;
            JScrollPane jScrollPane = this._paramTable.getScrollPane();
            jScrollPane.setPreferredSize(new Dimension(80, 120));
            this._paramFieldsPanel.add((Component)jScrollPane, (Object)gridBagConstraints);
        } else {
            this._paramFieldsPanel.remove(this._paramFieldsPanel.getComponents()[1]);
            ParamsSeasonalPanel paramsSeasonalPanel = this;
            paramsSeasonalPanel.buildTable(paramsSeasonalPanel._dates, abstractContDistArray);
            if (!this._parent.isRelative()) {
                ((ClipBySeasonalValuePanel)this._clipPanel).fillPanel(new SeasonalContinuousDistribution(this.getHecTimes(), this.getDistList(), this.getRts()), this._paramId);
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            new GridBagConstraints().gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = RmaInsets.INSETS5505;
            JScrollPane jScrollPane = this._paramTable.getScrollPane();
            jScrollPane.setPreferredSize(new Dimension(80, 80));
            this._paramFieldsPanel.add((Component)jScrollPane, (Object)gridBagConstraints);
        }
        this._paramFieldsPanel.setModified(true);
        this._paramFieldsPanel.validate();
        this._paramFieldsPanel.repaint();
        this.fillPanel();
    }

    private AbstractContDist getDistribution(int n) {
        if (this._distClass.getSimpleName().contains("Empirical")) {
            Object object;
            EmpiricalDist.InterpType interpType = this._linrInterpRadio.isSelected() ? EmpiricalDist.InterpType.LINEAR : EmpiricalDist.InterpType.STEP;
            ArrayList<Double> arrayList = new ArrayList<Double>();
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            int n2 = this._paramTable.getNumRows();
            for (int i = 0; i < n2; ++i) {
                Object object2 = this._paramTable.getValueAt(i, 0);
                if (object2 instanceof ParamDouble || object2 instanceof Double) {
                    object2 = object2.toString();
                }
                Object object3 = this._paramTable.getValueAt(i, n + 1);
                object = object3;
                if (object3 instanceof ParamDouble || object instanceof Double) {
                    object = object.toString();
                }
                if (object2 == null) {
                    object2 = "";
                }
                if (object == null) {
                    object = "";
                }
                if (!((String)object2).isEmpty() && ((String)object).isEmpty()) {
                    this._paramTable.setValueAt(Double.toString(0.0), i, n + 1);
                    object = this._paramTable.getValueAt(i, n + 1);
                }
                if (!(object2 instanceof String) || object2 == null || ((String)object2).isEmpty() || !(object instanceof String) || object == null || ((String)object).isEmpty()) continue;
                double d = RMAIO.parseDouble((Object)object2);
                if (interpType == EmpiricalDist.InterpType.STEP) {
                    d = i == 0 ? 1.0 - d : (Double)arrayList.get(i - 1) - d;
                }
                double d2 = RMAIO.parseDouble((Object)object);
                if (!RMAConst.isValidValue((double)d) || !RMAConst.isValidValue((double)d2)) continue;
                arrayList.add(d);
                arrayList2.add(d2);
            }
            n2 = arrayList.size();
            double[] dArray = new double[n2];
            object = new double[n2];
            for (int i = 0; i < n2; ++i) {
                dArray[i] = 1.0 - (Double)arrayList.get(i);
                object[i] = (Double)arrayList2.get(i);
            }
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray[0] = interpType;
            objectArray2[1] = dArray;
            objectArray2[2] = object;
            return super.buildDistribution(objectArray2);
        }
        Object[] objectArray = new Object[this._paramTable.getRowCount()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this._paramTable.getValueAt(i, n + 1) instanceof Double ? this._paramTable.getValueAt(i, n + 1) : Double.valueOf((String)this._paramTable.getValueAt(i, n + 1));
        }
        return super.buildDistribution(objectArray);
    }

    private int[] getTimes() {
        int[] nArray = new int[this._dates.length];
        for (int i = 0; i < this._dates.length; ++i) {
            nArray[i] = HecTime.iymdjl((int)1900, (int)this._dates[i].month(), (int)this._dates[i].day()) * 1440;
        }
        return nArray;
    }

    @Override
    public void updateDistParams(ClipDist clipDist) {
        if (this._clipPanel != null) {
            this._clipPanel.updateDistParams(clipDist);
        }
    }

    @Override
    public void convertLogToLinear() {
        for (int i = 0; i < this._paramTable.getColumnCount() - 1; ++i) {
            double[] dArray = this.getParamVals(i);
            try {
                String[] stringArray = (String[])this._defaultDist[0].getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                stringArray.setParams1(dArray);
                dArray = stringArray.getParams2();
                if (i == 0) {
                    stringArray = stringArray.getParamNames2();
                    this.setParamLabels(stringArray);
                }
                for (int j = 0; j < dArray.length; ++j) {
                    this._paramTable.setValueAt(Double.valueOf(this._format.format(dArray[j])), j, i + 1);
                }
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                Exception exception2 = exception;
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void convertLinearToLog() {
        for (int i = 0; i < this._paramTable.getColumnCount() - 1; ++i) {
            Object[] objectArray = this.getParamVals(i);
            try {
                MultiParametrizadDist multiParametrizadDist = (MultiParametrizadDist)this._defaultDist[0].getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                multiParametrizadDist.setParams2(objectArray);
                if (i == 0) {
                    objectArray = multiParametrizadDist.getParamNames1();
                    this.setParamLabels((String[])objectArray);
                }
                objectArray = multiParametrizadDist.getParams1();
                for (int j = 0; j < objectArray.length; ++j) {
                    this._paramTable.setValueAt(Double.valueOf(this._format.format(objectArray[j])), j, i + 1);
                }
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                Exception exception2 = exception;
                exception.printStackTrace();
            }
        }
    }

    private void setParamLabels(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            string = string.replace("Ln", " Ln");
            String string2 = (string = string.replace("Log", " Log")).contains("Shape") || string.contains("Skew") || string.contains("Freedom") ? "" : (string.contains("Log") ? " (Log(%S))" : (string.contains("Ln") ? " (Ln(%S))" : " (%S)"));
            RmaJDecimalField rmaJDecimalField = new RmaJDecimalField();
            this._label[i].setText(string.concat(string2));
            this._label[i].setLabelFor((Component)rmaJDecimalField);
            rmaJDecimalField.setValue(new ParamDouble(0.0, this._paramId, 1, 2));
            this._paramTable.getModel().setValueAt(this._label[i].getText(), i, 0);
        }
    }

    @Override
    protected Object[] getLogParams(Object[] objectArray) {
        double[] dArray = new double[objectArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = (Double)objectArray[i];
        }
        try {
            MultiParametrizadDist multiParametrizadDist = (MultiParametrizadDist)this._distClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            multiParametrizadDist.setParams2(dArray);
            objectArray = new Double[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                objectArray[i] = multiParametrizadDist.getParams1()[i];
            }
            return objectArray;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public void checkWarning(String[] stringArray, RssAlt doubleArray) {
        doubleArray = this._parent._parent.getDefaultValues(this._dates);
        MCScalarDistributionWizardPanel mCScalarDistributionWizardPanel = this.getMCScalarDistributionWizardPanel();
        if (this._paramTable != null) {
            if (this._paramTable.getColumnCount() > 0 && this._paramTable.getColumnName(0).contains("Prob")) {
                AbstractContDist abstractContDist = this.getDistribution(0);
                if (abstractContDist == null) {
                    return;
                }
                if (abstractContDist instanceof EmpiricalDist) {
                    if (ParamsSeasonalPanel.isDiscreteDist(mCScalarDistributionWizardPanel)) {
                        ParamsSeasonalPanel.isTotalProbValid(this._paramTable, 0, stringArray);
                    } else if (ParamsSeasonalPanel.isEmpiricalDist(mCScalarDistributionWizardPanel)) {
                        ParamsSeasonalPanel.checkMonotonicOrder(this._paramTable, 0, stringArray, true, "Empirical");
                    }
                }
            }
            for (int i = 1; i < this._paramTable.getColumnCount(); ++i) {
                Object object = this.getDistribution(i - 1);
                if (object == null) {
                    return;
                }
                double d = this._parent.isRelative() ? object.getCDF(100.0) : (doubleArray.length == this._paramTable.getColumnCount() - 1 ? object.getCDF(doubleArray[i - 1].doubleValue()) : object.getCDF(this._parent._parent.getDefaultValue(this._dates[i - 1])[0].doubleValue()));
                if (!(!(d > 0.995) && !(d < 0.005) || object instanceof EmpiricalDist && ((EmpiricalDist)object).getCumProbs().length == 0)) {
                    stringArray[0] = stringArray[0].concat("WARNING: Network variable value is outside 99% bounds of the sampling distribution specified above. The distribution parameters should be revised for consistency.\n");
                }
                if (!(object instanceof EmpiricalDist)) continue;
                object = "";
                if (ParamsSeasonalPanel.isDiscreteDist(mCScalarDistributionWizardPanel)) {
                    object = "Discrete";
                } else if (ParamsSeasonalPanel.isEmpiricalDist(mCScalarDistributionWizardPanel)) {
                    object = "Empirical";
                }
                ParamsSeasonalPanel.checkMonotonicOrder(this._paramTable, i, stringArray, false, (String)object);
            }
            MCVariableWizardDialog.setFinalWarningMessages(stringArray);
        }
    }

    private double[] getParamVals(int n) {
        double[] dArray = new double[this._paramTable.getRowCount()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this._paramTable.getValueAt(i, n + 1) instanceof Double ? ((Double)this._paramTable.getValueAt(i, n + 1)).doubleValue() : Double.valueOf((String)this._paramTable.getValueAt(i, n + 1)).doubleValue();
        }
        return dArray;
    }
}

