/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client.rating;

import hec.data.ParamDouble;
import hec.io.PairedDataContainer;
import hec.model.PairedValuesExt;
import hec.model.PairedValuesTableModel;
import hec.rss.client.TwoVariableDialog;
import hec.rss.model.Junction;
import hec.rss.plugins.montecarlo.client.MCVectorDistributionWizardPanel;
import hec.rss.plugins.montecarlo.client.rating.ColumnGroupEntry;
import hec.rss.plugins.montecarlo.client.rating.ColumnGroupEntryComparator;
import hec.rss.plugins.montecarlo.client.rating.ColumnGroupEntryEditor;
import hec.rss.plugins.montecarlo.client.rating.ColumnGroupEntryRenderer;
import hec.rss.plugins.montecarlo.client.rating.EditableEntry;
import hec.rss.plugins.montecarlo.client.rating.RatingCurveEditPanel$1;
import hec.rss.plugins.montecarlo.client.rating.RatingCurveEditPanel$2;
import hec.rss.plugins.montecarlo.client.rating.RatingCurveEditPanel$3;
import hec.rss.plugins.montecarlo.client.rating.RatingCurveEditPanel$4;
import hec.rss.plugins.montecarlo.client.rating.RatingCurveEditPanel$MCRatingTable;
import hec.rss.plugins.montecarlo.model.MCInputRatingCurveVariable;
import hec.rss.plugins.montecarlo.model.MCInputStochasticVariableImpl;
import hec.rss.swing.table.TwoVariableTableHeaderRender;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import rma.swing.IParameterScale;
import rma.swing.RmaJButton;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJLabel;
import rma.swing.RmaJPanel;
import rma.swing.RmaJTable;
import rma.swing.table.ColumnGroup;
import rma.swing.table.GroupableTableHeader;
import rma.swing.table.RmaCellEditor;
import rma.swing.table.RmaTableModelInterface;

public class RatingCurveEditPanel
extends RmaJPanel {
    private static final Logger a = Logger.getLogger(RatingCurveEditPanel.class.getName());
    private PairedValuesExt _pve;
    protected RatingCurveEditPanel$MCRatingTable pveTableModel;
    private ArrayList<ColumnGroup> columnGroups = new ArrayList();
    private List<String> _groupLabels;
    private int _tableDistType;
    private ActionListener _distActionListener;
    private MCVectorDistributionWizardPanel _parent;
    private RmaJLabel distLabel;
    private RmaJComboBox<String> distributionType;
    private RmaJButton editColumnValuesButton;
    private RmaJButton _resetToDefaultValueButton;
    private JScrollPane jScrollPane1;
    private RmaJTable pveTable;
    private Junction _junction;

    public RatingCurveEditPanel(MCVectorDistributionWizardPanel mCVectorDistributionWizardPanel) {
        this._parent = mCVectorDistributionWizardPanel;
        this.initComponents();
    }

    private String[] getColNames(PairedValuesExt object, int n) {
        String[] stringArray = this.getDistributionType() == 3 ? new String[]{"Left", "Peak", "Right"} : new String[]{"Mean", "Std Dev"};
        String[] stringArray2 = new String[stringArray.length * n + 1];
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        object = String.format("%s (%s)", object.getParamXString(), object.getParamXUnitsString());
        stringArray2[0] = object;
        for (int i = 0; i < n; ++i) {
            System.arraycopy(stringArray, 0, stringArray2, i * stringArray.length + 1, stringArray.length);
        }
        return stringArray2;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.pveTable = new RmaJTable();
        this.distributionType = new RmaJComboBox((Object[])new String[]{"Normal", "Triangular"});
        this.distLabel = new RmaJLabel();
        this.editColumnValuesButton = new RmaJButton();
        this._resetToDefaultValueButton = new RmaJButton();
        this.jScrollPane1.setName("jScrollPane1");
        this.pveTable.setName("pveTable");
        Object object = new String[]{"Flow (%S)", "Mean Stage (%S)"};
        this.pveTable.setModel((TableModel)new PairedValuesTableModel((String[])object, new boolean[]{false, false}));
        this.jScrollPane1.setViewportView((Component)this.pveTable);
        this.distributionType.setName("distributionType");
        this._distActionListener = new RatingCurveEditPanel$1(this);
        this.distributionType.addActionListener(this._distActionListener);
        this.distLabel.setText("Distribution Type:");
        this.distLabel.setName("distLabel");
        this._resetToDefaultValueButton.setText("Reset To Default Values");
        this._resetToDefaultValueButton.setName("resetToDefaultValueButton");
        this._resetToDefaultValueButton.addActionListener((ActionListener)new RatingCurveEditPanel$2(this));
        this.editColumnValuesButton.setText("Edit Column Values");
        this.editColumnValuesButton.setName("editColumnValuesButton");
        this.editColumnValuesButton.addActionListener((ActionListener)new RatingCurveEditPanel$3(this));
        object = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)object);
        Object object2 = object;
        ((GroupLayout)object2).setHorizontalGroup(((GroupLayout)object2).createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(((GroupLayout)object).createSequentialGroup().addContainerGap().addGroup(((GroupLayout)object).createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 507, Short.MAX_VALUE).addGroup(((GroupLayout)object).createSequentialGroup().addComponent((Component)this.distLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.distributionType, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, ((GroupLayout)object).createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent((Component)this._resetToDefaultValueButton, -2, -1, -2))).addContainerGap()));
        Object object3 = object;
        ((GroupLayout)object3).setVerticalGroup(((GroupLayout)object3).createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(((GroupLayout)object).createSequentialGroup().addContainerGap().addGroup(((GroupLayout)object).createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.distLabel, -2, -1, -2).addComponent((Component)this.distributionType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 234, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this._resetToDefaultValueButton, -2, -1, -2)));
    }

    private void resetToDefaultValueButtonActionPerformed(ActionEvent actionEvent) {
        this._parent.resetTableDefaultValues();
    }

    private void editColumnValuesButtonActionPerformed(ActionEvent object) {
        object = SwingUtilities.windowForComponent((Component)((Object)this));
        if (!(object instanceof RmaJDialog)) {
            return;
        }
        String string = this._pve.getParamYString() + " (%S)";
        ColumnGroupEntryRenderer columnGroupEntryRenderer = new ColumnGroupEntryRenderer();
        ColumnGroupEntryEditor columnGroupEntryEditor = new ColumnGroupEntryEditor();
        ColumnGroupEntryComparator columnGroupEntryComparator = new ColumnGroupEntryComparator();
        object = new TwoVariableDialog((Dialog)object, true, string, (Comparator)columnGroupEntryComparator, (TableCellRenderer)((Object)columnGroupEntryRenderer), (RmaCellEditor)columnGroupEntryEditor);
        object.fillForm(ColumnGroupEntry.wrap(this.columnGroups), 0.0);
        object.pack();
        object.setVisible(true);
        if (object.isOk() && (object = object.getTableValues()) != null && !object.isEmpty()) {
            a.fine("new groups were:" + String.valueOf(object));
            this.applyChanges((Collection<ColumnGroupEntry>)object);
        }
    }

    private void distributionTypeActionPerformed(ActionEvent actionEvent) {
        RatingCurveEditPanel ratingCurveEditPanel = this;
        ratingCurveEditPanel.removeDistributionAttributeColumns(ratingCurveEditPanel._tableDistType);
        this.fillTable(true);
    }

    public int getDistributionType() {
        int n = this.distributionType.getSelectedIndex();
        if (n == 0) {
            return 1;
        }
        if (n == 1) {
            return 3;
        }
        return 0;
    }

    private void applyChanges(Collection<ColumnGroupEntry> collection) {
        Set<ColumnGroup> set = new StringBuffer("newGroups:");
        for (ColumnGroupEntry object2 : collection) {
            ((StringBuffer)((Object)set)).append((String)object2.getValue());
            ((StringBuffer)((Object)set)).append(", ");
        }
        a.finest(((StringBuffer)((Object)set)).substring(0, ((StringBuffer)((Object)set)).length() - 1));
        Set<ColumnGroup> set22 = this.getColumnGroupsToDelete(collection);
        a.finer("toDelete:" + String.valueOf(this.getNames((Collection<ColumnGroup>)set22)));
        SortedSet<Integer> sortedSet = this.getIndexesToDelete(set22);
        for (Set<ColumnGroup> set22 : sortedSet) {
            this.removeCurveGroup((Integer)((Object)set22));
        }
        set = this.renameColumnGroups(collection);
        a.finer("renamed:" + String.valueOf(this.getNames(set)));
        set22 = this.addNewColumnGroups(collection);
        a.finer("added:" + String.valueOf(this.getNames(set22)));
        RatingCurveEditPanel ratingCurveEditPanel = this;
        a.finest("going to update groupLabel: old:" + String.valueOf(this._groupLabels) + " new:" + String.valueOf(ratingCurveEditPanel.getNames(ratingCurveEditPanel.columnGroups)));
        this._groupLabels = this.getNames(this.columnGroups);
        this.fillTable(true);
    }

    private List<String> getNames(Collection<ColumnGroup> object) {
        ArrayList<String> arrayList = null;
        if (object != null) {
            arrayList = new ArrayList<String>(object.size());
            object = object.iterator();
            while (object.hasNext()) {
                ColumnGroup columnGroup = (ColumnGroup)object.next();
                arrayList.add(columnGroup.getHeaderValue().toString());
            }
        }
        return arrayList;
    }

    private Set<ColumnGroup> getColumnGroupsToDelete(Collection<ColumnGroupEntry> object) {
        HashSet<ColumnGroup> hashSet = new HashSet<ColumnGroup>(this.columnGroups);
        object = object.iterator();
        while (object.hasNext()) {
            ColumnGroupEntry columnGroupEntry = (ColumnGroupEntry)object.next();
            if (columnGroupEntry.realEntry == null) continue;
            String string = columnGroupEntry.getEntryValue();
            String cfr_ignored_0 = (String)columnGroupEntry.getNewValue();
            if (string == null) continue;
            hashSet.remove(columnGroupEntry.realEntry);
        }
        return hashSet;
    }

    private void removeCurveGroup(int n) {
        int n2 = this.getDistributionType();
        n2 = MCInputRatingCurveVariable.getNumberOfDistParametersPerCurve(n2);
        this._pve.getNumberCurves();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(this._pve.getCurveLabels()));
        int n3 = n * (n2 + 1);
        while (n2 > 0) {
            this._pve.removeCurve(n3 + n2);
            arrayList.remove(n3 + n2);
            --n2;
        }
        this._pve.removeCurve(n3);
        arrayList.remove(n3);
        this._groupLabels.remove(n);
        this.columnGroups.remove(n);
        ArrayList<String> arrayList2 = arrayList;
        String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
        a.fine("resetting curve labels:" + String.valueOf(Arrays.asList(stringArray)));
        this._pve.setCurveLabels(stringArray);
    }

    private SortedSet<Integer> getIndexesToDelete(Set<ColumnGroup> object) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>(Collections.reverseOrder());
        object = object.iterator();
        while (object.hasNext()) {
            ColumnGroup columnGroup = (ColumnGroup)object.next();
            treeSet.add(this.columnGroups.indexOf(columnGroup));
        }
        return treeSet;
    }

    private Set<ColumnGroup> addNewColumnGroups(Collection<ColumnGroupEntry> object) {
        HashSet<ColumnGroup> hashSet = new HashSet<ColumnGroup>();
        int n = 0;
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (ColumnGroupEntry)object.next();
            if (((EditableEntry)object2).realEntry == null) {
                object2 = (String)((EditableEntry)object2).getValue();
                ColumnGroup columnGroup = new ColumnGroup((String)object2);
                this.columnGroups.add(n, columnGroup);
                this.addCurveGroup((String)object2, n);
                hashSet.add(columnGroup);
            }
            ++n;
        }
        return hashSet;
    }

    private Set<ColumnGroup> renameColumnGroups(Collection<ColumnGroupEntry> object) {
        HashSet<ColumnGroup> hashSet = new HashSet<ColumnGroup>();
        object = object.iterator();
        while (object.hasNext()) {
            ColumnGroupEntry columnGroupEntry = (ColumnGroupEntry)object.next();
            if (columnGroupEntry.realEntry == null) continue;
            String string = columnGroupEntry.getEntryValue();
            String string2 = (String)columnGroupEntry.getValue();
            if (string2.equals(string)) continue;
            hashSet.add((ColumnGroup)columnGroupEntry.realEntry);
            ((ColumnGroup)columnGroupEntry.realEntry).setHeaderValue(columnGroupEntry.getValue());
        }
        return hashSet;
    }

    public void addDistributionTypeActionListener(ActionListener actionListener) {
        this.distributionType.addActionListener(actionListener);
    }

    public void removeDistributionTypeActionListener(ActionListener actionListener) {
        this.distributionType.removeActionListener(actionListener);
    }

    public Object getSelectedDistribution() {
        return this.distributionType.getSelectedItem();
    }

    public void fillForm(MCInputRatingCurveVariable mCInputRatingCurveVariable) {
        this._junction = mCInputRatingCurveVariable.getJunction();
        this._groupLabels = new ArrayList<String>(Arrays.asList(mCInputRatingCurveVariable.getCurveLabels()));
        this._pve = mCInputRatingCurveVariable.getValues();
        this._tableDistType = mCInputRatingCurveVariable.getDistributionType();
        this.setSelectedDistributionType(mCInputRatingCurveVariable);
    }

    protected void setSelectedDistributionType(MCInputRatingCurveVariable object) {
        object = ((MCInputStochasticVariableImpl)object).getDistributionName();
        int n = this.distributionType.getItemCount();
        for (int i = 0; i < n; ++i) {
            Object object2 = this.distributionType.getItemAt(i);
            if (!((String)object2).contains((CharSequence)object)) continue;
            this.distributionType.setSelectedIndex(i);
            return;
        }
    }

    public MCInputRatingCurveVariable buildRCVariable(String object) {
        this.pveTableModel.storeData(this._pve);
        String[] stringArray = this._groupLabels.toArray(new String[this._groupLabels.size()]);
        object = new MCInputRatingCurveVariable((String)object, this.getDistributionType(), this._pve.clone(), stringArray);
        return object;
    }

    public void fillForm(Junction junction, boolean bl) {
        this._junction = junction;
        junction = MCInputRatingCurveVariable.getFlowVsStageCurves(junction);
        junction = junction.clone();
        this._pve = junction;
        this._groupLabels = new ArrayList<String>(Arrays.asList(this._pve.getCurveLabels()));
        this.fillTable(bl);
    }

    public void fillForm(boolean bl) {
        PairedValuesExt pairedValuesExt = MCInputRatingCurveVariable.getFlowVsStageCurves(this._junction);
        this._pve = pairedValuesExt = pairedValuesExt.clone();
        this._groupLabels = new ArrayList<String>(Arrays.asList(this._pve.getCurveLabels()));
        this.fillTable(bl);
    }

    public void fillForm(MCInputRatingCurveVariable mCInputRatingCurveVariable, boolean bl) {
        this._pve = mCInputRatingCurveVariable.clone().getValues();
        this._junction = mCInputRatingCurveVariable.getJunction();
        RatingCurveEditPanel ratingCurveEditPanel = this;
        ratingCurveEditPanel.removeDistributionTypeActionListener(ratingCurveEditPanel._distActionListener);
        this.setSelectedDistributionType(mCInputRatingCurveVariable);
        this.distributionType.addActionListener(this._distActionListener);
        this._groupLabels = new ArrayList<String>(Arrays.asList(mCInputRatingCurveVariable.getCurveLabels()));
        this.fillTable(bl);
    }

    private void fillTable(boolean n) {
        n = n != 0 ? MCInputRatingCurveVariable.getNumberOfDistParametersPerCurve(0) + 1 : MCInputRatingCurveVariable.getNumberOfDistParametersPerCurve(this.getDistributionType()) + 1;
        RatingCurveEditPanel ratingCurveEditPanel = this;
        String[] stringArray = ratingCurveEditPanel.getColNames(ratingCurveEditPanel._pve, this._pve.getNumberCurves() / n);
        PairedValuesExt pairedValuesExt = this._pve;
        int n2 = pairedValuesExt.getNumberCurves();
        Object object = new boolean[n2 + 1];
        Arrays.fill((boolean[])object, true);
        this.pveTableModel = new RatingCurveEditPanel$MCRatingTable(this, stringArray, this._pve, (boolean[])object);
        this.pveTable.setModel((TableModel)((Object)this.pveTableModel));
        int n3 = this._pve.getNumberCurves() / n;
        if (n3 == 1) {
            this._tableDistType = this.getDistributionType();
            this.pveTable.setUnitsHeaderRenderer();
            this.editColumnValuesButton.setVisible(false);
            object = this.pveTable.getColumnModel();
            GroupableTableHeader groupableTableHeader = new GroupableTableHeader((TableColumnModel)object);
            TwoVariableTableHeaderRender twoVariableTableHeaderRender = new TwoVariableTableHeaderRender();
            ColumnGroup columnGroup = new ColumnGroup((TableCellRenderer)twoVariableTableHeaderRender, "Stage(%S)");
            for (int i = 1; i < object.getColumnCount(); ++i) {
                TableColumn tableColumn = object.getColumn(i);
                columnGroup.add((Object)tableColumn);
            }
            groupableTableHeader.addColumnGroup(columnGroup);
            this.columnGroups.add(columnGroup);
            this.pveTable.setTableHeader((JTableHeader)groupableTableHeader);
        } else {
            this._tableDistType = this.getDistributionType();
            n = MCInputRatingCurveVariable.getNumberOfDistParametersPerCurve(this.getDistributionType()) + 1;
            object = this.pveTable.getColumnModel();
            GroupableTableHeader groupableTableHeader = new GroupableTableHeader((TableColumnModel)object);
            TwoVariableTableHeaderRender twoVariableTableHeaderRender = new TwoVariableTableHeaderRender();
            ColumnGroup columnGroup = new ColumnGroup((TableCellRenderer)twoVariableTableHeaderRender, "Stage(%S)");
            GroupableTableHeader groupableTableHeader2 = new GroupableTableHeader((TableColumnModel)object);
            this.columnGroups.clear();
            for (int i = 0; i < n3; ++i) {
                String string = this._groupLabels.get(i);
                string = new ColumnGroup((TableCellRenderer)twoVariableTableHeaderRender, string);
                int n4 = 1 + i * n;
                for (int j = 0; j < n; ++j) {
                    TableColumn tableColumn = object.getColumn(n4 + j);
                    string.add((Object)tableColumn);
                }
                groupableTableHeader2.addColumnGroup((ColumnGroup)string);
                this.columnGroups.add((ColumnGroup)string);
                columnGroup.add((Object)string);
            }
            this.pveTable.setTableHeader((JTableHeader)groupableTableHeader2);
            groupableTableHeader.addColumnGroup(columnGroup);
            this.pveTable.setTableHeader((JTableHeader)groupableTableHeader);
        }
        this.setDistributionEditors();
    }

    private void setDistributionEditors() {
        switch (this.getDistributionType()) {
            case 3: {
                this.addTriangularEditors();
                return;
            }
        }
        this.addNormalEditors();
    }

    private void addNormalEditors() {
        int n = this.pveTable.getColumnCount();
        for (int i = n - 1; i > 1; i -= 2) {
            RmaJDecimalField rmaJDecimalField = this.pveTable.setDoubleCellEditor(i);
            rmaJDecimalField.setMinValue(0.0);
            for (int j = 0; j < this.pveTable.getModel().getRowCount(); ++j) {
                if (!(((ParamDouble)this.pveTable.getModel().getValueAt(j, i)).doubleValue() > 0.0) && ((ParamDouble)this.pveTable.getModel().getValueAt(j, 0)).doubleValue() > 0.0) {
                    this.pveTable.getModel().setValueAt(1.0, j, i);
                }
                if (((ParamDouble)this.pveTable.getModel().getValueAt(j, i - 1)).doubleValue() > 0.0) continue;
                this.pveTable.getModel().setValueAt(this.pveTable.getModel().getValueAt(j, i / 2), j, i - 1);
                this.pveTable.getModel().setValueAt(null, j, i / 2);
            }
        }
        this.setPVE(n);
    }

    private void addTriangularEditors() {
        int n = this.pveTable.getColumnCount();
        for (int i = n - 2; i > 1; i -= 3) {
            RmaJDecimalField rmaJDecimalField = this.pveTable.setDoubleCellEditor(i);
            rmaJDecimalField.setMinValue(0.0);
            for (int j = 0; j < this.pveTable.getModel().getRowCount(); ++j) {
                double d = ((ParamDouble)this.pveTable.getModel().getValueAt(j, (i + 1) / 3)).doubleValue();
                if (!(((ParamDouble)this.pveTable.getModel().getValueAt(j, i)).doubleValue() > 0.0)) {
                    this.pveTable.getModel().setValueAt(d, j, i);
                    this.pveTable.getModel().setValueAt(null, j, (i + 1) / 3);
                }
                if (((ParamDouble)this.pveTable.getModel().getValueAt(j, i + 1)).doubleValue() > 0.0 || !(((ParamDouble)this.pveTable.getModel().getValueAt(j, 0)).doubleValue() > 0.0)) continue;
                double d2 = d;
                this.pveTable.getModel().setValueAt(d2 + d2 / 2.0, j, i + 1);
                double d3 = d;
                this.pveTable.getModel().setValueAt(d3 - d3 / 2.0, j, i - 1);
            }
        }
        this.setPVE(n);
    }

    private void setPVE(int n) {
        this._pve.clearValues();
        double[] dArray = new double[n - 1];
        for (int i = 0; i < this.pveTable.getModel().getRowCount(); ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                dArray[j] = ((ParamDouble)this.pveTable.getValueAt(i, j + 1)).getValue();
            }
            this._pve.addPair(((ParamDouble)this.pveTable.getValueAt(i, 0)).getValue(), dArray);
        }
    }

    private void addTriangularParamEditor(int n, int n2, boolean bl) {
        Object object = this.pveTable.getColumnModel();
        if (n >= object.getColumnCount() || n < 0) {
            return;
        }
        object = this.pveTable.getColumnModel().getColumn(n);
        if (object == null) {
            return;
        }
        Object object2 = new RmaJDecimalField(0, 5);
        object2.setPrecision(this.pveTable.getPrecision());
        object2.setHorizontalAlignment(4);
        object2.addMouseListener((MouseListener)this.pveTable);
        RatingCurveEditPanel$4 ratingCurveEditPanel$4 = new RatingCurveEditPanel$4(this, (RmaJDecimalField)object2, n2, bl, (RmaJDecimalField)object2);
        ratingCurveEditPanel$4.setDisplayUnitSystem(this.pveTable.getDisplayUnitSystem());
        Map map = this.pveTable.getDisplayScaleMap();
        object2 = this.pveTable.convertColumnIndexToModel(n);
        map = (IParameterScale)map.get(object2);
        if (map != null) {
            ratingCurveEditPanel$4.setDisplayScaleFactor(map.getParamId(), map.getScale());
        }
        ratingCurveEditPanel$4.setClickCountToStart(this.pveTable.getClickCountToStart());
        ((TableColumn)object).setCellEditor((TableCellEditor)((Object)ratingCurveEditPanel$4));
        this.pveTable.setHorizontalAlignment(4, n);
        if (this.pveTable.getModel() instanceof RmaTableModelInterface) {
            ((RmaTableModelInterface)this.pveTable.getModel()).setColumnClass(n, Number.class);
        }
    }

    protected void addDistributionAttributeColumns() {
        int n = this._pve.getCurveLabels().length;
        Object object = this._pve.getCurveLabels();
        object = object == null ? new ArrayList() : new ArrayList<String>(Arrays.asList(object));
        int n2 = this.getDistributionType();
        --n;
        while (n >= 0) {
            String string = String.format("%s (%s)", this._pve.getParamYString(), this._pve.getParamYUnitsString());
            object.set(n, string);
            switch (n2) {
                case 3: {
                    this.addTriangularDistColumns(n, this._pve, (List<String>)object);
                    break;
                }
                default: {
                    this.addNormalDistColumns(n, this._pve, (List<String>)object);
                }
            }
            --n;
        }
        Object object2 = object;
        this._pve.setCurveLabels(object2.toArray(new String[object2.size()]));
        this._tableDistType = n2;
    }

    public void addCurveGroup(String string, int n) {
        Object object = this._pve.getCurveLabels();
        object = object == null ? new ArrayList() : new ArrayList<String>(Arrays.asList(object));
        int n2 = this.getDistributionType();
        int n3 = MCInputRatingCurveVariable.getNumberOfDistParametersPerCurve(n2);
        this._pve.getNumberCurves();
        this._groupLabels.add(string);
        object.add(n *= ++n3, String.format("%s (%s)", this._pve.getParamYString(), this._pve.getParamYUnitsString()));
        this._pve.insertCurve(n, 0.0);
        switch (n2) {
            case 3: {
                this.addTriangularDistColumns(n, this._pve, (List<String>)object);
                break;
            }
            default: {
                this.addNormalDistColumns(n, this._pve, (List<String>)object);
            }
        }
        Object object2 = object;
        this._pve.setCurveLabels(object2.toArray(new String[object2.size()]));
    }

    protected void addTriangularDistColumns(int n, PairedValuesExt pairedValuesExt, List<String> object) {
        object.add(n + 1, (String)"min");
        this._pve.insertCurve(n + 1, 0.0);
        object.add(n + 2, (String)"max");
        this._pve.insertCurve(n + 2, 7.0);
        pairedValuesExt = this._pve.getPairedDataContainer();
        object = pairedValuesExt.yOrdinates[n];
        double[] dArray = pairedValuesExt.yOrdinates[n + 1];
        double[] dArray2 = pairedValuesExt.yOrdinates[n + 2];
        for (int i = 0; i < ((Object)object).length; ++i) {
            dArray[i] = object[i] <= 1.0 ? 0.0 : (double)(object[i] - 1.0);
            dArray2[i] = (double)(object[i] + 1.0);
        }
        this._pve.clearValues();
        this._pve.setData((PairedDataContainer)pairedValuesExt);
    }

    protected void addNormalDistColumns(int n, PairedValuesExt pairedValuesExt, List<String> list) {
        this._pve.insertCurve(n + 1, 1.0);
        list.add(n + 1, "Stage Std Dev (%S)");
    }

    protected void removeDistributionAttributeColumns(int n) {
        int n2 = this._pve.getNumberCurves();
        if (n == 1) {
            this.removeNormalDistribution(n2);
            return;
        }
        if (n == 3) {
            this.removTriangularDistribution(n2);
        }
    }

    private void removTriangularDistribution(int n) {
        while (n > 0) {
            this._pve.removeCurve(n * 3 - 1);
            this._pve.removeCurve(n * 3 - 3);
            --n;
        }
    }

    private void removeNormalDistribution(int n) {
        while (n > 0) {
            this._pve.removeCurve((n << 1) - 1);
            --n;
        }
    }

    private String getDistributionLabel(int n) {
        int n2 = this.getDistributionType();
        return (switch (n2) {
            case 1 -> new String[]{"Stage Std Dev (%S)"};
            case 3 -> new String[]{"min", "max"};
            default -> new String[]{""};
        })[n];
    }

    public TableModel getPVETableModel() {
        return this.pveTableModel;
    }

    public void highlightResetValuesButtonColor() {
        this._resetToDefaultValueButton.setBackground(Color.red);
    }

    public void unhighlightResetValuesButtonColor() {
        this._resetToDefaultValueButton.setBackground(new RmaJButton().getBackground());
    }
}

