/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.model;

import com.google.common.flogger.FluentLogger;
import hec.client.ScalarOutputDialog;
import hec.clientapp.client.ClientApp;
import hec.clientapp.model.TSDataSet;
import hec.data.Parameter;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.HecTime;
import hec.hecmath.HecMath;
import hec.hecmath.TimeSeriesMath;
import hec.hecmath.functions.TimeSeriesFunctions;
import hec.io.DSSIdentifier;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import hec.model.PairedValuesExt;
import hec.model.ScalarOutputter;
import hec.model.TSRecord;
import hec.rss.io.ParseableDSSIdentifier;
import hec.rss.model.PythonScriptContainer;
import hec.rss.model.RssAlt;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssRun;
import hec.rss.model.reports.AlternativeInputReport;
import hec.rss.plugins.factories.AltPluginDataFactory;
import hec.rss.plugins.model.AbstractAltPluginData;
import hec.rss.plugins.montecarlo.model.DependencyMatrix;
import hec.rss.plugins.montecarlo.model.MCAltPluginData$1;
import hec.rss.plugins.montecarlo.model.MCAltPluginData$2;
import hec.rss.plugins.montecarlo.model.MCAltPluginData$3;
import hec.rss.plugins.montecarlo.model.MCAltPluginData$4;
import hec.rss.plugins.montecarlo.model.MCDisplayVar;
import hec.rss.plugins.montecarlo.model.MCInputClippedDataVariable;
import hec.rss.plugins.montecarlo.model.MCInputLookbackVariable;
import hec.rss.plugins.montecarlo.model.MCInputRatingCurveVariable;
import hec.rss.plugins.montecarlo.model.MCInputResRuleVariable;
import hec.rss.plugins.montecarlo.model.MCInputScriptVariable;
import hec.rss.plugins.montecarlo.model.MCInputStochasticVariableImpl;
import hec.rss.plugins.montecarlo.model.MCInputTSMultiplierVariable;
import hec.rss.plugins.montecarlo.model.MCInputTSVariable;
import hec.rss.plugins.montecarlo.model.MCInputVariable;
import hec.rss.plugins.montecarlo.model.MCInputVariableImpl;
import hec.rss.plugins.montecarlo.model.MCOutputVariable;
import hec.rss.plugins.montecarlo.model.MCSampleScripts;
import hec.rss.plugins.montecarlo.model.MCScalarOutput;
import hec.rss.plugins.montecarlo.model.SeasonalContinuousDistribution;
import hec.rss.plugins.montecarlo.model.SeasonalDiscreteDistribution;
import hec.statistics.ClipDist;
import hec.statistics.CorrelationMatrix;
import hec.statistics.DiscreteDist;
import hec.statistics.EmpiricalDist;
import hec.statistics.MultiParametrizadDist;
import hec.statistics.TableDist;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.resourceservices.ParameterLookup;
import org.jdom.Element;
import rma.stats.model.DoubleRandomTable;
import rma.stats.model.MCInputVarRealizations;
import rma.stats.model.MCOutputVarRealizations;
import rma.stats.model.MCVarRealizations;
import rma.stats.model.MCVarSavePolicy;
import rma.util.IntArray;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class MCAltPluginData
extends AbstractAltPluginData {
    private static final FluentLogger b = FluentLogger.forEnclosingClass();
    private final String c = AltPluginDataFactory.MC;
    private boolean d = false;
    private int e;
    private int f;
    private double g;
    private int h = 0;
    private long i = 0L;
    private int j = 0;
    private String k = "";
    private int[] l;
    public static final int CONTINUE_TO_ADD = 0;
    public static final int CLEAR_PREVIOUS = 1;
    public static final int SIMULATE_AND_SAVE = 2;
    private List<MCInputVariableImpl> m = new ArrayList<MCInputVariableImpl>();
    private List<MCOutputVariable> n = new ArrayList<MCOutputVariable>();
    private int o;
    private int p;
    private boolean q;
    private boolean r;
    public static final String PartD_INPUT = "MC INPUT";
    public static final String PartD_OUTPUT = "MC OUTPUT";
    public static final String PartD_SAVE_SUFFIX = " (SAVE)";
    public static final String PartE_TS = "Time Series:";
    public static final String PartE_RP = "Rule Param:";
    public static final String PartE_LB = "Lookback:";
    public static final String PartE_RC = "Rating Curve:";
    public static final String PartE_SC = "Script:";
    public static final String MCVAR_TYPE_INPUT = "Input Variable";
    public static final String MCVAR_TYPE_OUTPUT = "Output Variable";
    private List<MCInputVarRealizations> s;
    private List<MCInputVarRealizations> t;
    private MCSampleScripts u = new MCSampleScripts(true);
    private MCSampleScripts v = new MCSampleScripts(false);
    private Map<String, CorrelationMatrix> w = new HashMap<String, CorrelationMatrix>();
    private String x = null;
    private List<MCOutputVarRealizations> y;
    private boolean z = false;
    private static double[] A = new double[]{0.01, 0.025, 0.05, 0.1, 0.25, 0.5, 0.75, 0.9, 0.95, 0.975, 0.99};
    private static double[] B = new double[]{1.0E-4, 0.002, 0.005, 0.01, 0.03, 0.05, 0.07, 0.09, 0.11, 0.13, 0.15, 0.17, 0.19, 0.21, 0.23, 0.25, 0.27, 0.29, 0.31, 0.33, 0.35, 0.37, 0.39, 0.41, 0.43, 0.45, 0.47, 0.49, 0.51, 0.53, 0.55, 0.57, 0.59, 0.61, 0.63, 0.65, 0.67, 0.69, 0.71, 0.73, 0.75, 0.77, 0.79, 0.81, 0.83, 0.85, 0.87, 0.89, 0.91, 0.93, 0.95, 0.97, 0.99, 0.995, 0.998, 0.999};

    public void setUseCompute(boolean bl) {
        this.d = bl;
    }

    public boolean useCompute() {
        return this.d;
    }

    public int compute(RssRun rssRun) {
        int n = rssRun.isSeededCompute();
        String[] stringArray = new String[1];
        if (n == 0 && !this.dataOK(stringArray)) {
            rssRun.printErrorMessage("Monte Carlo Compute Data Errors:\n".concat(stringArray[0]));
            return 1;
        }
        rssRun.setRunProgress(0.0);
        rssRun.setTimeBlocking(false);
        rssRun.setIterative(true);
        rssRun.setTimeInit(0L);
        rssRun.setTimePulse(0L);
        rssRun.setTimeCLoc(0L);
        rssRun.setTimeUReg(0L);
        rssRun.setTimeReg2(0L);
        rssRun.setTimeHOut(0L);
        rssRun.setTimeCplt(0L);
        long[] lArray = new long[1];
        long l = 0L;
        long l2 = 0L;
        int n2 = rssRun.initCompute(lArray);
        String[] stringArray2 = new String[1];
        this.checkWarning(stringArray2, rssRun.getAlternative());
        if (n2 != 0) {
            return n2;
        }
        RssRun rssRun2 = rssRun;
        rssRun2.setTimeInit(rssRun2.getTimeInit()[0] + lArray[0]);
        long l3 = System.currentTimeMillis();
        int n3 = this.getSimulationOption();
        n2 = this.initVariables(rssRun);
        if (n2 != 0) {
            return n2;
        }
        int n4 = this.p;
        long l4 = System.currentTimeMillis();
        RssRun rssRun3 = rssRun;
        rssRun3.setTimeInit(rssRun3.getTimeInit()[0] + l4 - l3);
        this.u.initCompute();
        this.v.initCompute();
        this.u.runInitScript();
        this.v.runInitScript();
        for (int i = 0; n != 0 && i == 0 || n == 0 && (n3 == 2 && i < this.o || n3 != 2 && (n4 <= this.getMinIterations() || n4 <= this.getMaxIterations() && !this.q)); ++n4, ++i) {
            int n5;
            try {
                int n6;
                MCInputVarRealizations mCInputVarRealizations;
                MCOutputVarRealizations mCOutputVarRealizations;
                block67: {
                    int n7;
                    block66: {
                        boolean bl;
                        block65: {
                            Object object;
                            l = System.currentTimeMillis();
                            l3 = System.currentTimeMillis();
                            n4 = n == 0 && n3 == 2 ? this.getIterations()[i] : this.p + i;
                            rssRun.initProgress();
                            rssRun.printMessage("\n***Computing Realization " + n4);
                            this.u.runMainScript();
                            n7 = n;
                            n5 = n4;
                            MCAltPluginData mCAltPluginData = this;
                            int n8 = n5;
                            if (n7 != 0) {
                                n8 = 1;
                            }
                            mCOutputVarRealizations = new HashMap();
                            for (int j = 0; j < mCAltPluginData.m.size(); ++j) {
                                MCInputVariable mCInputVariable = mCAltPluginData.m.get(j);
                                object = mCAltPluginData.s.get(j);
                                if (!(mCInputVariable instanceof MCInputVariableImpl)) continue;
                                mCOutputVarRealizations.put(((MCInputVariableImpl)mCInputVariable).getShortName(), object.generateVariate(n5));
                            }
                            for (String string : mCAltPluginData.w.keySet()) {
                                mCAltPluginData.w.get(string).makeVariatesCorrelated(mCOutputVarRealizations);
                            }
                            for (int j = 0; j < mCAltPluginData.m.size(); ++j) {
                                double d;
                                int n9;
                                Double d2;
                                MCInputVariable mCInputVariable = mCAltPluginData.m.get(j);
                                object = mCAltPluginData.s.get(j);
                                mCInputVarRealizations = mCAltPluginData.t.get(j);
                                if (!mCInputVariable.isActive()) continue;
                                if (mCInputVariable.getType() == 0) {
                                    MCInputTSVariable mCInputTSVariable = (MCInputTSVariable)mCInputVariable;
                                    mCAltPluginData.a(n8, (Double)mCOutputVarRealizations.get(mCInputTSVariable.getShortName()), mCInputTSVariable, (MCInputVarRealizations)object, mCInputVarRealizations);
                                    continue;
                                }
                                if (mCInputVariable.getType() == 1) {
                                    MCInputResRuleVariable mCInputResRuleVariable = (MCInputResRuleVariable)mCInputVariable;
                                    mCAltPluginData.a(n8, (Double)mCOutputVarRealizations.get(mCInputResRuleVariable.getShortName()), mCInputResRuleVariable, (MCInputVarRealizations)object, mCInputVarRealizations);
                                    continue;
                                }
                                if (mCInputVariable.getType() == 3) {
                                    MCInputRatingCurveVariable mCInputRatingCurveVariable = (MCInputRatingCurveVariable)mCInputVariable;
                                    MCInputVarRealizations mCInputVarRealizations2 = mCInputVarRealizations;
                                    mCInputVarRealizations = object;
                                    object = mCInputRatingCurveVariable;
                                    d2 = (Double)mCOutputVarRealizations.get(mCInputRatingCurveVariable.getShortName());
                                    n9 = n8;
                                    if (!((MCInputVariableImpl)object).isActive()) continue;
                                    d = d2;
                                    mCInputVarRealizations.setVariate(d2.doubleValue());
                                    mCInputVarRealizations2.setRealization(n9);
                                    mCInputVarRealizations2.setVariate(d);
                                    mCInputVarRealizations.saveVariate();
                                    mCInputVarRealizations2.saveVariate();
                                    ((MCInputVariableImpl)object).applyRealization(d);
                                    continue;
                                }
                                if (mCInputVariable.getType() == 2) {
                                    MCInputLookbackVariable mCInputLookbackVariable = (MCInputLookbackVariable)mCInputVariable;
                                    MCInputVarRealizations mCInputVarRealizations3 = mCInputVarRealizations;
                                    mCInputVarRealizations = object;
                                    object = mCInputLookbackVariable;
                                    d2 = (Double)mCOutputVarRealizations.get(mCInputLookbackVariable.getShortName());
                                    n9 = n8;
                                    if (!((MCInputVariableImpl)object).isActive()) continue;
                                    d = d2;
                                    mCInputVarRealizations.setVariate(d2.doubleValue());
                                    if (((MCInputLookbackVariable)object).getHCData() != null) {
                                        ((MCInputVariableImpl)object).applyRealization(d);
                                    }
                                    mCInputVarRealizations3.setRealization(n9);
                                    mCInputVarRealizations3.setVariate(((MCInputVariableImpl)object).getVariate());
                                    mCInputVarRealizations.saveVariate();
                                    mCInputVarRealizations3.saveVariate();
                                    continue;
                                }
                                if (mCInputVariable.getType() == 4) {
                                    MCInputTSMultiplierVariable mCInputTSMultiplierVariable = (MCInputTSMultiplierVariable)mCInputVariable;
                                    mCAltPluginData.a(n8, (Double)mCOutputVarRealizations.get(mCInputTSMultiplierVariable.getShortName()), mCInputTSMultiplierVariable, (MCInputVarRealizations)object, mCInputVarRealizations);
                                    continue;
                                }
                                if (mCInputVariable.getType() != 5) continue;
                                MCInputScriptVariable mCInputScriptVariable = (MCInputScriptVariable)mCInputVariable;
                                mCAltPluginData.a(n8, (Double)mCOutputVarRealizations.get(mCInputScriptVariable.getShortName()), mCInputScriptVariable, (MCInputVarRealizations)object, mCInputVarRealizations);
                            }
                            this.v.runMainScript();
                            rssRun.setRunProgress(5.0);
                            long l5 = System.currentTimeMillis();
                            RssRun rssRun4 = rssRun;
                            rssRun4.setTimeInit(rssRun4.getTimeInit()[0] + l5 - l3);
                            if (i == 0) break block66;
                            MCAltPluginData mCAltPluginData2 = this;
                            if (mCAltPluginData2.m == null) {
                                System.out.println("Unable to get Monte Carlo Input Variable Data.");
                            } else {
                                for (n5 = 0; n5 < mCAltPluginData2.m.size(); ++n5) {
                                    MCInputVariable mCInputVariable = mCAltPluginData2.m.get(n5);
                                    if (!mCInputVariable.isActive() || mCInputVariable.getType() != 1) continue;
                                    bl = true;
                                    break block65;
                                }
                            }
                            bl = false;
                        }
                        if (!bl) break block67;
                    }
                    if ((n2 = rssRun.pulseRoutingCompute(lArray)) != 0) {
                        n7 = n2;
                        return n7;
                    }
                    RssRun rssRun5 = rssRun;
                    rssRun5.setTimePulse(rssRun5.getTimePulse()[0] + lArray[0]);
                    rssRun.setRunProgress(10.0);
                }
                if ((n2 = rssRun.cumLocCompute(lArray)) != 0) {
                    int n10 = n2;
                    return n10;
                }
                RssRun rssRun6 = rssRun;
                rssRun6.setTimePulse(rssRun6.getTimeCLoc()[0] + lArray[0]);
                rssRun.setRunProgress(15.0);
                n2 = rssRun.unRegCompute(lArray);
                if (n2 != 0) {
                    int n11 = n2;
                    return n11;
                }
                RssRun rssRun7 = rssRun;
                rssRun7.setTimeUReg(rssRun7.getTimeUReg()[0] + lArray[0]);
                rssRun.setRunProgress(25.0);
                n2 = rssRun.regCompute(lArray);
                if (n2 != 0) {
                    int n12 = n2;
                    return n12;
                }
                RssRun rssRun8 = rssRun;
                rssRun8.setTimeReg2(rssRun8.getTimeReg2()[0] + lArray[0]);
                rssRun.setRunProgress(90.0);
                n2 = rssRun.holdOutCompute(lArray);
                if (n2 != 0) {
                    int n13 = n2;
                    return n13;
                }
                RssRun rssRun9 = rssRun;
                rssRun9.setTimeHOut(rssRun9.getTimeHOut()[0] + lArray[0]);
                rssRun.setRunProgress(95.0);
                l3 = System.currentTimeMillis();
                int n14 = n4;
                RssRun rssRun10 = rssRun;
                MCAltPluginData mCAltPluginData = this;
                try {
                    for (n6 = 0; n6 < mCAltPluginData.n.size(); ++n6) {
                        int n10;
                        MCOutputVariable mCOutputVariable = mCAltPluginData.n.get(n6);
                        mCOutputVarRealizations = mCAltPluginData.y.get(n6);
                        String string = rssRun10.getAlternative().getSystem().getNameForKeyString(mCOutputVariable.getProxyName());
                        String string2 = RssModelVariableSet.getParamName((int)mCOutputVariable.getModelVariableId());
                        TSRecord tSRecord = rssRun10.getTSRecordByPathParts(string, string2);
                        mCInputVarRealizations = tSRecord.getTimeSeriesContainer();
                        TimeSeriesMath timeSeriesMath = new TimeSeriesMath((TimeSeriesContainer)mCInputVarRealizations);
                        double d = 0.0;
                        if ("Maximum".equals(mCOutputVariable.getStatistic())) {
                            d = timeSeriesMath.max();
                        } else if ("Minimum".equals(mCOutputVariable.getStatistic())) {
                            d = timeSeriesMath.min();
                        } else if ("Mean".equals(mCOutputVariable.getStatistic())) {
                            d = timeSeriesMath.mean();
                        } else if ("Volume".equals(mCOutputVariable.getStatistic()) && ((n10 = mCOutputVariable.getParamId()) == Parameter.PARAMID_FLOW || n10 == Parameter.PARAMID_POWER)) {
                            mCInputVarRealizations = (TimeSeriesMath)TimeSeriesMath.createInstance((DataContainer)timeSeriesMath.getData());
                            TimeSeriesMath timeSeriesMath2 = (TimeSeriesMath)timeSeriesMath.transformTimeSeries((HecMath)mCInputVarRealizations, "ITG");
                            d = TimeSeriesFunctions.lastValidValue((TimeSeriesContainer)timeSeriesMath2.getContainer());
                            double d3 = 0.0;
                            int n11 = rssRun10.getUnitSystem();
                            if (n10 == Parameter.PARAMID_FLOW) {
                                if (n11 == 0) {
                                    d3 = 0.0013774104683195593;
                                } else if (n11 == 1) {
                                    d3 = 60.0;
                                }
                            } else if (n10 == Parameter.PARAMID_POWER) {
                                d3 = 0.016666666666666666;
                            }
                            d *= d3;
                        }
                        mCOutputVarRealizations.setRealization(n14);
                        mCOutputVarRealizations.setVariate(d);
                        mCOutputVarRealizations.saveVariate();
                    }
                }
                catch (Exception exception) {
                    System.out.println("Failed to compute MC Output Var. " + exception.getMessage());
                    exception.printStackTrace();
                }
                if (n == 0) {
                    int n17;
                    mCAltPluginData = this;
                    n6 = mCAltPluginData.getSimulationOption();
                    boolean bl = false;
                    for (n17 = 0; n17 < mCAltPluginData.n.size(); ++n17) {
                        MCOutputVariable mCOutputVariable = mCAltPluginData.n.get(n17);
                        MCOutputVarRealizations mCOutputVarRealizations2 = mCAltPluginData.y.get(n17);
                        if (!mCOutputVariable.isActive() || n6 == 2) continue;
                        bl |= mCOutputVarRealizations2.getTestPass();
                    }
                    mCAltPluginData.r = bl;
                    this.r |= n3 == 2;
                    if (this.r) {
                        int n18 = n4;
                        mCAltPluginData = rssRun;
                        TSDataSet tSDataSet = mCAltPluginData.getOutputTSData();
                        Vector vector = tSDataSet.getTSRecords();
                        for (n17 = 0; n17 < vector.size(); ++n17) {
                            TSRecord tSRecord = (TSRecord)vector.get(n17);
                            DSSPathname dSSPathname = new DSSPathname(tSRecord.getDSSPathname());
                            if (dSSPathname.bPart() == "") continue;
                            dSSPathname.setCollectionSequence(n18);
                            tSRecord.setDSSPathname(dSSPathname.getPathname());
                        }
                    }
                    this.a(n4);
                }
                long l6 = System.currentTimeMillis();
                RssRun rssRun11 = rssRun;
                rssRun11.setTimeCplt(rssRun11.getTimeCplt()[0] + l6 - l3);
                n2 = rssRun.finalizeCompute(lArray, this.r);
                if (n2 != 0) {
                    n14 = n2;
                    return n14;
                }
                RssRun rssRun12 = rssRun;
                rssRun12.setTimeCplt(rssRun12.getTimeCplt()[0] + lArray[0]);
                rssRun.setRunProgress(100.0);
                l2 = System.currentTimeMillis();
                continue;
            }
            finally {
                l3 = System.currentTimeMillis();
                this.a();
                if (n3 != 2) {
                    if (n2 == 0) {
                        n5 = n4;
                        MCAltPluginData mCAltPluginData = this;
                        this.h = n5;
                    }
                    this.a(l2 - l);
                    RssAlt rssAlt = rssRun.getAlternative();
                    rssAlt.writeFile(rssAlt.getIdentifier());
                }
                long l7 = System.currentTimeMillis();
                RssRun rssRun13 = rssRun;
                rssRun13.setTimeCplt(rssRun13.getTimeCplt()[0] + l7 - l3);
            }
        }
        MCAltPluginData mCAltPluginData = this;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (MCInputVariableImpl mCInputVariableImpl : mCAltPluginData.m) {
            if (!(mCInputVariableImpl instanceof MCInputTSMultiplierVariable)) continue;
            arrayList2.add(mCInputVariableImpl.getShortName());
        }
        Collections.sort(arrayList2);
        arrayList.addAll(arrayList2);
        arrayList2.clear();
        for (MCInputVariableImpl mCInputVariableImpl : mCAltPluginData.m) {
            if (!(mCInputVariableImpl instanceof MCInputTSVariable)) continue;
            arrayList2.add(mCInputVariableImpl.getShortName());
        }
        Collections.sort(arrayList2);
        arrayList.addAll(arrayList2);
        arrayList2.clear();
        for (MCInputVariableImpl mCInputVariableImpl : mCAltPluginData.m) {
            if (!(mCInputVariableImpl instanceof MCInputResRuleVariable)) continue;
            arrayList2.add(mCInputVariableImpl.getShortName());
        }
        Collections.sort(arrayList2);
        arrayList.addAll(arrayList2);
        arrayList2.clear();
        for (MCInputVariableImpl mCInputVariableImpl : mCAltPluginData.m) {
            if (!(mCInputVariableImpl instanceof MCInputLookbackVariable)) continue;
            arrayList2.add(mCInputVariableImpl.getShortName());
        }
        Collections.sort(arrayList2);
        arrayList.addAll(arrayList2);
        arrayList2.clear();
        for (MCInputVariableImpl mCInputVariableImpl : mCAltPluginData.m) {
            if (!(mCInputVariableImpl instanceof MCInputRatingCurveVariable)) continue;
            arrayList2.add(mCInputVariableImpl.getShortName());
        }
        Collections.sort(arrayList2);
        arrayList.addAll(arrayList2);
        arrayList2.clear();
        for (MCInputVariableImpl mCInputVariableImpl : mCAltPluginData.m) {
            if (!(mCInputVariableImpl instanceof MCInputScriptVariable)) continue;
            arrayList2.add(mCInputVariableImpl.getShortName());
        }
        Collections.sort(arrayList2);
        arrayList.addAll(arrayList2);
        arrayList2.clear();
        mCAltPluginData.a(arrayList);
        this.u.runCleanupScript();
        this.v.runCleanupScript();
        return n2;
    }

    private int a(MCInputVarRealizations mCInputVarRealizations, RssRun rssRun) {
        if (!rssRun.isSeededCompute()) {
            int n = this.getSimulationOption();
            switch (n) {
                case 1: {
                    break;
                }
                case 0: {
                    n = this.getLastIterationComputed() + 1;
                    int n2 = mCInputVarRealizations.getRealization();
                    if (n2 >= n - 1) break;
                    Logger.getLogger(MCAltPluginData.class.getName()).log(Level.FINE, "Last saved iteration {0} is less than reported variable realization {1}.", new Object[]{n2, n});
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private int a(MCOutputVarRealizations mCOutputVarRealizations, boolean bl, RssRun rssRun) {
        void var3_6;
        if (!var3_6.isSeededCompute() && bl) {
            int n = this.getSimulationOption();
            switch (n) {
                case 1: {
                    break;
                }
                case 0: {
                    int n2 = this.getLastIterationComputed() + 1;
                    int n3 = mCOutputVarRealizations.getRealization();
                    if (n3 >= n2 - 1) break;
                    Logger.getLogger(MCAltPluginData.class.getName()).log(Level.FINE, "Last saved iteration {0} is less than reported variable realization {1}.", new Object[]{n3, n2});
                }
            }
        }
        return 0;
    }

    private MCInputVarRealizations a(MCInputVariableImpl mCInputVariableImpl, RssRun rssRun) {
        double d;
        int n = this.getSimulationOption();
        int n2 = 2;
        boolean bl = false;
        DSSPathname dSSPathname = new DSSPathname();
        dSSPathname.setAPart("");
        dSSPathname.setBPart(mCInputVariableImpl.getLocation());
        dSSPathname.setFPart(rssRun.getName());
        String string = "";
        dSSPathname.setCPart("REALIZATION-PROBABILITY");
        switch (mCInputVariableImpl.getType()) {
            case 0: {
                dSSPathname.setEPart(PartE_TS + mCInputVariableImpl.getParameter());
                break;
            }
            case 1: {
                dSSPathname.setEPart(PartE_RP + mCInputVariableImpl.getParameter());
                break;
            }
            case 2: {
                dSSPathname.setEPart(PartE_LB + mCInputVariableImpl.getParameter());
                break;
            }
            case 3: {
                dSSPathname.setEPart(PartE_RC + mCInputVariableImpl.getParameter());
                break;
            }
            case 5: {
                dSSPathname.setEPart(PartE_SC + ((MCInputScriptVariable)mCInputVariableImpl).getDescription() + ":" + mCInputVariableImpl.getParameter());
                break;
            }
            default: {
                dSSPathname.setEPart(mCInputVariableImpl.getParameter());
            }
        }
        if (rssRun.isSeededCompute()) {
            dSSPathname.setDPart(PartD_INPUT);
            n2 = 2;
            bl = false;
            switch (mCInputVariableImpl.getUncertaintyType()) {
                case 0: {
                    d = rssRun.simulationRealizationRandomSeed();
                    break;
                }
                default: {
                    d = rssRun.simulationEventRandomSeed();
                    break;
                }
            }
        } else {
            switch (n) {
                case 1: {
                    dSSPathname.setDPart(PartD_INPUT);
                    n2 = 1;
                    bl = false;
                    break;
                }
                case 0: {
                    dSSPathname.setDPart(PartD_INPUT);
                    n2 = 1;
                    bl = true;
                    break;
                }
                case 2: {
                    dSSPathname.setDPart("MC INPUT (SAVE)");
                    n2 = 2;
                    bl = false;
                }
            }
            d = this.getStandaloneSeed();
        }
        DSSIdentifier dSSIdentifier = new DSSIdentifier(rssRun.getDSSOutputFile(), dSSPathname.getPathname());
        dSSIdentifier.setType("");
        dSSIdentifier.setUnits(string);
        MCInputVarRealizations mCInputVarRealizations = new MCInputVarRealizations(mCInputVariableImpl.getLocation() + ":" + mCInputVariableImpl.getParameter(), dSSIdentifier, n2, bl, d);
        if (!mCInputVariableImpl.isActive()) {
            try {
                rssRun.getDSSFileManager().delete(dSSIdentifier.getFileName(), new Vector<String>(Arrays.asList(dSSIdentifier.getDSSPath())));
            }
            catch (NullPointerException | RemoteException exception) {}
            mCInputVarRealizations.setSavePolicy((MCVarSavePolicy)new MCAltPluginData$1());
        }
        return mCInputVarRealizations;
    }

    private MCInputVarRealizations b(MCInputVariableImpl mCInputVariableImpl, RssRun rssRun) {
        double d;
        MCInputRatingCurveVariable mCInputRatingCurveVariable;
        String string;
        int n = this.getSimulationOption();
        int n2 = 2;
        boolean bl = false;
        DSSPathname dSSPathname = new DSSPathname();
        dSSPathname.setAPart("");
        dSSPathname.setBPart(mCInputVariableImpl.getLocation());
        dSSPathname.setFPart(rssRun.getName());
        int n3 = rssRun.getUnitSystem();
        switch (mCInputVariableImpl.getType()) {
            case 0: {
                string = "";
                dSSPathname.setCPart("REALIZATION-CHOICE");
                dSSPathname.setEPart(PartE_TS + mCInputVariableImpl.getParameter());
                break;
            }
            case 1: {
                int n4 = ((MCInputClippedDataVariable)mCInputVariableImpl).getParamId();
                string = Parameter.getUnitsStringForSystem((int)n4, (int)n3);
                dSSPathname.setCPart("REALIZATION-" + ParameterLookup.getFullParamString((int)n4));
                dSSPathname.setEPart(PartE_RP + mCInputVariableImpl.getParameter());
                break;
            }
            case 2: {
                int n4 = ((MCInputClippedDataVariable)mCInputVariableImpl).getParamId();
                string = Parameter.getUnitsStringForSystem((int)n4, (int)n3);
                dSSPathname.setCPart("REALIZATION-" + Parameter.getParamString((int)n4));
                dSSPathname.setEPart(PartE_LB + mCInputVariableImpl.getParameter());
                break;
            }
            case 3: {
                mCInputRatingCurveVariable = (MCInputRatingCurveVariable)mCInputVariableImpl;
                int n4 = mCInputRatingCurveVariable.getParamId();
                string = Parameter.getUnitsStringForSystem((int)n4, (int)n3);
                dSSPathname.setCPart("REALIZATION-" + Parameter.getParamString((int)n4));
                dSSPathname.setEPart(PartE_RC + mCInputVariableImpl.getParameter());
                break;
            }
            default: {
                string = "";
                dSSPathname.setCPart("REALIZATION-" + Parameter.getParamString((int)-1));
                dSSPathname.setEPart(mCInputVariableImpl.getParameter());
            }
        }
        if (rssRun.isSeededCompute()) {
            dSSPathname.setDPart(PartD_INPUT);
            n2 = 2;
            bl = false;
            switch (mCInputVariableImpl.getUncertaintyType()) {
                case 0: {
                    d = rssRun.simulationRealizationRandomSeed();
                    break;
                }
                default: {
                    d = rssRun.simulationEventRandomSeed();
                    break;
                }
            }
        } else {
            switch (n) {
                case 1: {
                    dSSPathname.setDPart(PartD_INPUT);
                    n2 = 1;
                    bl = false;
                    break;
                }
                case 0: {
                    dSSPathname.setDPart(PartD_INPUT);
                    n2 = 1;
                    bl = true;
                    break;
                }
                case 2: {
                    dSSPathname.setDPart("MC INPUT (SAVE)");
                    n2 = 2;
                    bl = false;
                }
            }
            d = this.getStandaloneSeed();
        }
        mCInputRatingCurveVariable = new DSSIdentifier(rssRun.getDSSOutputFile(), dSSPathname.getPathname());
        mCInputRatingCurveVariable.setType("");
        mCInputRatingCurveVariable.setUnits(string);
        MCInputVarRealizations mCInputVarRealizations = new MCInputVarRealizations(mCInputVariableImpl.getLocation() + ":" + mCInputVariableImpl.getParameter(), (DSSIdentifier)mCInputRatingCurveVariable, n2, bl, d);
        if (!mCInputVariableImpl.isActive()) {
            try {
                rssRun.getDSSFileManager().delete(mCInputRatingCurveVariable.getFileName(), new Vector<String>(Arrays.asList(mCInputRatingCurveVariable.getDSSPath())));
            }
            catch (NullPointerException | RemoteException exception) {}
            mCInputVarRealizations.setSavePolicy((MCVarSavePolicy)new MCAltPluginData$2());
        }
        return mCInputVarRealizations;
    }

    private MCOutputVarRealizations a(MCOutputVariable mCOutputVariable, RssRun rssRun) {
        int n = this.getSimulationOption();
        int n2 = 2;
        boolean bl = false;
        DSSPathname dSSPathname = new DSSPathname();
        dSSPathname.setAPart("");
        String string = rssRun.getAlternative().getSystem().getNameForKeyString(mCOutputVariable.getProxyName());
        dSSPathname.setBPart(string);
        dSSPathname.setFPart(rssRun.getName());
        int n3 = rssRun.getUnitSystem();
        int n4 = mCOutputVariable.getParamId();
        String string2 = Parameter.getUnitsStringForSystem((int)n4, (int)n3);
        dSSPathname.setCPart("REALIZATION-" + ParameterLookup.getFullParamString((int)n4));
        String string3 = RssModelVariableSet.getParamName((int)mCOutputVariable.getModelVariableId());
        dSSPathname.setEPart(string3);
        if (rssRun.isSeededCompute()) {
            dSSPathname.setDPart(PartD_OUTPUT);
            n2 = 2;
            bl = false;
        } else {
            switch (n) {
                case 1: {
                    dSSPathname.setDPart(PartD_OUTPUT);
                    n2 = 1;
                    bl = false;
                    break;
                }
                case 0: {
                    dSSPathname.setDPart(PartD_OUTPUT);
                    n2 = 1;
                    bl = true;
                    break;
                }
                case 2: {
                    dSSPathname.setDPart("MC OUTPUT (SAVE)");
                    n2 = 2;
                    bl = false;
                }
            }
        }
        DSSIdentifier dSSIdentifier = new DSSIdentifier(rssRun.getDSSOutputFile(), dSSPathname.getPathname());
        dSSIdentifier.setType("");
        dSSIdentifier.setUnits(string2);
        MCOutputVarRealizations mCOutputVarRealizations = new MCOutputVarRealizations(string + ":" + string3, dSSIdentifier, n2, bl, mCOutputVariable.hasTest(), mCOutputVariable.getTestOp(), mCOutputVariable.getTestVal(), mCOutputVariable.hasConv(), mCOutputVariable.getConfidence() / 100.0, mCOutputVariable.getRelTol() / 100.0);
        if (!mCOutputVariable.isActive()) {
            try {
                rssRun.getDSSFileManager().delete(dSSIdentifier.getFileName(), new Vector<String>(Arrays.asList(dSSIdentifier.getDSSPath())));
            }
            catch (NullPointerException | RemoteException exception) {}
            mCOutputVarRealizations.setSavePolicy((MCVarSavePolicy)new MCAltPluginData$3());
        }
        return mCOutputVarRealizations;
    }

    public Vector getTSInputData(RssAlt rssAlt, HecTime object) {
        object = null;
        TSDataSet tSDataSet = new TSDataSet();
        for (int i = 0; i < this.m.size(); ++i) {
            MCInputVariable mCInputVariable = this.m.get(i);
            if (!(mCInputVariable instanceof MCInputTSVariable) || ((MCInputTSVariable)(mCInputVariable = (MCInputTSVariable)mCInputVariable)).getDiscreteDist().size() <= 0) continue;
            for (int j = 0; j < ((MCInputTSVariable)mCInputVariable).getDiscreteDist().size(); ++j) {
                if (object == null) {
                    object = new Vector();
                }
                ParseableDSSIdentifier parseableDSSIdentifier = (ParseableDSSIdentifier)((MCInputTSVariable)mCInputVariable).getDiscreteDist().getValue(j);
                TSRecord tSRecord = tSDataSet.createTSRecord();
                tSRecord.setDSSPathname(parseableDSSIdentifier.getDSSPath());
                tSRecord.setDSSFilename(parseableDSSIdentifier.getFileName());
                ((Vector)object).add(tSRecord);
                ((ParseableDSSIdentifier)((MCInputTSVariable)mCInputVariable).getDiscreteDist().getValue(j)).setFileName(rssAlt.getWorkspacePath() + "/simulation.dss");
                this.m.set(i, (MCInputVariableImpl)mCInputVariable);
            }
        }
        return object;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public boolean dataOK(String[] var1_1) {
        if (var1_1 == null || var1_1.length <= 0) {
            return false;
        }
        var1_1[0] = "";
        var2_2 = true;
        if (this.m == null) {
            var1_1[0] = var1_1[0].concat("Unable to get Monte Carlo Input Variable Data." + System.getProperty("line.separator"));
            var2_2 = false;
        } else {
            var3_3 = this.m.size();
            var4_4 = false;
            for (var5_5 = 0; var5_5 < var3_3; ++var5_5) {
                var6_6 = this.m.get(var5_5);
                if (var6_6 == null) continue;
                var6_6.initInputVariable(this.getAlt());
                var2_2 = var2_2 != false && var6_6.checkErrors(var1_1) != false;
                var4_4 = var4_4 != false || var6_6.isActive() != false;
            }
            if (!var4_4) {
                var1_1[0] = var1_1[0].concat("Simulation does not have active Monte Carlo input variables." + System.getProperty("line.separator"));
                var2_2 = false;
            }
        }
        var3_3 = 1;
        var4_4 = true;
        if (this.n == null) {
            var1_1[0] = var1_1[0].concat("Unable to get Monte Carlo Output Variable Data." + System.getProperty("line.separator"));
            var3_3 = 0;
        } else {
            var5_5 = this.n.size();
            var6_7 = false;
            var7_12 = false;
            for (var8_14 = 0; var8_14 < var5_5; ++var8_14) {
                var9_16 = this.n.get(var8_14);
                if (var9_16 == null || !var9_16.isActive()) continue;
                var6_7 = true;
                if (!var9_16.hasConv()) continue;
                var7_12 = true;
                break;
            }
            if (!var6_7) {
                var1_1[0] = var1_1[0].concat("Simulation does not have active Monte Carlo output variables." + System.getProperty("line.separator"));
                var3_3 = 0;
            }
            if (!var7_12) {
                var1_1[0] = var1_1[0].concat("Simulation does not have active Monte Carlo convergence variables." + System.getProperty("line.separator"));
                var4_4 = false;
            }
        }
        var5_5 = 1;
        for (String var7_13 : this.w.keySet()) {
            if (this.w.get(var7_13).isValid()) continue;
            var1_1[0] = var1_1[0].concat("Correlation matrix for \"" + var7_13 + "\" is not positive semi-definite. Matrix must be positive semi-definite to generate correlated random variables." + System.getProperty("line.separator"));
            var5_5 = 0;
        }
        var6_9 = true;
        if (this.getDepencyMatrix().containsCircularDependency()) {
            var6_9 = false;
            var1_1[0] = var1_1[0].concat("Defined variables contain at least one circular dependency. Check the dependency diagram to diagnose the problem." + System.getProperty("line.separator"));
        }
        if (!var6_9) ** GOTO lbl-1000
        var6_10 = var1_1;
        var1_1 = this;
        var7_12 = true;
        for (Cloneable var9_16 : var1_1.m) {
            var10_17 = var9_16.getInputVariableNames();
            for (Integer var12_19 : var10_17.keySet()) {
                var13_20 = false;
                for (MCInputVariableImpl var15_22 : var1_1.m) {
                    if (!var10_17.get(var12_19).equals(var15_22.getShortName()) || !var15_22.isActive()) continue;
                    var13_20 = true;
                }
                if (var13_20) continue;
                var6_10[0] = var6_10[0].concat("ERROR: " + var9_16.getShortName() + " depends on " + var10_17.get(var12_19) + " but the variable is inactive or does not exist." + System.getProperty("line.separator"));
                var7_12 = false;
            }
        }
        if (var7_12) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = var6_11 = false;
        }
        return var2_2 != false && var3_3 != 0 && var4_4 != false && var5_5 != 0 && var6_11 != false;
    }

    public DependencyMatrix getDepencyMatrix() {
        DependencyMatrix dependencyMatrix = new DependencyMatrix();
        for (MCInputVariableImpl mCInputVariableImpl : this.m) {
            Map<Integer, String> map = mCInputVariableImpl.getInputVariableNames();
            for (Integer n : map.keySet()) {
                dependencyMatrix.addEntry(mCInputVariableImpl.getShortName(), map.get(n));
            }
        }
        dependencyMatrix.orderComponents();
        return dependencyMatrix;
    }

    public boolean checkWarning(String[] object, RssAlt stringArray) {
        Object object2;
        int n;
        int n2;
        object[0] = "";
        boolean bl = true;
        for (n2 = 0; n2 < this.m.size(); ++n2) {
            MCInputVariable mCInputVariable = this.m.get(n2);
            if (mCInputVariable == null) continue;
            boolean bl2 = bl = mCInputVariable.checkWarnings((String[])object, (RssAlt)stringArray) && bl;
            if (!this.isDuplicated(mCInputVariable.getType(), mCInputVariable.getLocation(), mCInputVariable.getParameter())) continue;
            object[0] = ((String)object[0]).concat("WARNING: Input variable " + mCInputVariable.getClassName() + " at " + mCInputVariable.getLocation() + " is duplicated in the input table ... this may lead to errors in Monte Carlo sampling." + System.getProperty("line.separator"));
        }
        n2 = 1;
        for (n = 0; n < this.n.size(); ++n) {
            object2 = this.n.get(n);
            if (object2 == null) continue;
            n2 = ((MCOutputVariable)object2).checkWarnings((String[])object, (RssAlt)stringArray) && n2 != 0 ? 1 : 0;
        }
        stringArray = object;
        object = this;
        n = 1;
        object2 = ((MCAltPluginData)((Object)object)).getCorrelationMap();
        block2: for (String string : object2.keySet()) {
            for (String string2 : ((CorrelationMatrix)object2.get(string)).getKeys()) {
                boolean bl3 = false;
                for (MCInputVariableImpl mCInputVariableImpl : ((MCAltPluginData)((Object)object)).m) {
                    if (!string2.equals(mCInputVariableImpl.getShortName()) || !mCInputVariableImpl.isActive()) continue;
                    bl3 = true;
                }
                if (bl3) continue;
                stringArray[0] = stringArray[0].concat("WARNING: Correlation group " + string + " contains variables that are do not exist or are inactive" + System.getProperty("line.separator"));
                n = 0;
                continue block2;
            }
        }
        return bl && n2 != 0 && n != 0;
    }

    public boolean isDuplicated(int n, String string, String string2) {
        int n2 = 0;
        for (int i = 0; i < this.m.size(); ++i) {
            Object object = this.m.get(i);
            int n3 = object.getType();
            String string3 = object.getLocation();
            object = object.getParameter();
            if (n3 != n || !string3.equals(string) || !((String)object).equals(string2) || ++n2 != 2) continue;
            return true;
        }
        return false;
    }

    public boolean isTSConflict(int n, String string, String string2) {
        for (int i = 0; i < this.m.size(); ++i) {
            Object object = this.m.get(i);
            int n2 = object.getType();
            String string3 = object.getLocation();
            object = object.getParameter();
            if ((n2 != 0 || n != 4) && (n2 != 4 || n != 0) || !string3.equals(string) || !((String)object).equals(string2)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public int initVariables(RssRun var1_1) {
        block11: {
            block10: {
                v0 = this;
                v0.a(v0.getDepencyMatrix().getSequence());
                var3_2 /* !! */  = var1_1;
                var2_5 = this;
                this.o = 0;
                var2_5.p = 1;
                if (!var3_2 /* !! */ .isSeededCompute()) break block10;
                var2_5.p = var3_2 /* !! */ .seededIterationNumber();
                var7_9 = 0;
                var3_2 /* !! */  = var2_5;
                var2_5.h = var7_9;
                var7_10 = 0L;
                var3_2 /* !! */  = var2_5;
                var2_5.i = var7_10;
                break block11;
            }
            var3_3 = var2_5.getSimulationOption();
            switch (var3_3) {
                case 1: {
                    var7_11 = 0;
                    var3_4 = var2_5;
                    var2_5.h = var7_11;
                    var7_12 = 0L;
                    var3_4 = var2_5;
                    var2_5.i = var7_12;
                    break;
                }
                case 0: {
                    v1 = var2_5;
                    v2 = v1;
                    v3 = v1.getLastIterationComputed() + 1;
                    ** GOTO lbl37
                }
                case 2: {
                    var2_5.o = var2_5.getIterations().length;
                    v4 = var2_5;
                    v2 = v4;
                    v3 = v4.getIterations().length == 0 ? 0 : var2_5.getIterations()[0];
lbl37:
                    // 2 sources

                    v2.p = v3;
                }
            }
        }
        var2_6 = this.a(var1_1);
        if (var2_6 != 0) {
            return var2_6;
        }
        var2_7 = this;
        if (var2_7.n == null) {
            System.out.println("Unable to get Monte Carlo Output Variable Data.");
            v5 = 1;
        } else {
            v5 = var2_8 = 0;
        }
        if (v5 != 0) {
            return var2_8;
        }
        var2_8 = this.b(var1_1);
        if (var2_8 != 0) {
            return var2_8;
        }
        this.z = true;
        v6 = this;
        v6.a(v6.getLastIterationComputed());
        return var2_8;
    }

    private int a(RssRun rssRun) {
        if (this.m == null) {
            System.out.println("Unable to get Monte Carlo Input Variable Data.");
            return 1;
        }
        this.s = new ArrayList<MCInputVarRealizations>();
        this.t = new ArrayList<MCInputVarRealizations>();
        for (int i = 0; i < this.m.size(); ++i) {
            MCInputVariableImpl mCInputVariableImpl = this.m.get(i);
            MCInputVarRealizations mCInputVarRealizations = this.a(mCInputVariableImpl, rssRun);
            this.s.add(i, mCInputVarRealizations);
            if (mCInputVariableImpl.isActive()) {
                this.a(mCInputVarRealizations, rssRun);
            }
            mCInputVarRealizations = this.b(mCInputVariableImpl, rssRun);
            this.t.add(i, mCInputVarRealizations);
            if (!mCInputVariableImpl.isActive()) continue;
            this.a(mCInputVarRealizations, rssRun);
        }
        return 0;
    }

    private int b(RssRun rssRun) {
        if (this.n == null) {
            System.out.println("Unable to get Monte Carlo Output Variable Data.");
            return 1;
        }
        this.y = new ArrayList<MCOutputVarRealizations>();
        for (int i = 0; i < this.n.size(); ++i) {
            MCOutputVariable mCOutputVariable = this.n.get(i);
            MCOutputVarRealizations mCOutputVarRealizations = this.a(mCOutputVariable, rssRun);
            this.y.add(i, mCOutputVarRealizations);
            this.a(mCOutputVarRealizations, mCOutputVariable.isActive() && mCOutputVariable.hasConv(), rssRun);
        }
        return 0;
    }

    private void a(List<Object> object) {
        ArrayList<MCInputVariableImpl> arrayList = new ArrayList<MCInputVariableImpl>();
        object = object.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            for (int i = 0; i < this.m.size(); ++i) {
                if (!this.m.get(i).getShortName().equals(e)) continue;
                arrayList.add(this.m.get(i));
            }
        }
        for (int i = 0; i < this.m.size(); ++i) {
            if (arrayList.contains(this.m.get(i))) continue;
            arrayList.add(this.m.get(i));
        }
        this.m = arrayList;
    }

    protected void a(int n, Double d, MCInputResRuleVariable mCInputResRuleVariable, MCInputVarRealizations mCInputVarRealizations, MCInputVarRealizations mCInputVarRealizations2) {
        if (mCInputResRuleVariable.isActive()) {
            double d2 = d;
            mCInputVarRealizations.setVariate(d.doubleValue());
            ((MCInputVariableImpl)mCInputResRuleVariable).applyRealization(d2);
            mCInputVarRealizations2.setRealization(n);
            mCInputVarRealizations2.setVariate(((MCInputVariableImpl)mCInputResRuleVariable).getVariate());
            mCInputVarRealizations.saveVariate();
            mCInputVarRealizations2.saveVariate();
        }
    }

    protected void a(int n, Double d, MCInputTSVariable mCInputTSVariable, MCInputVarRealizations mCInputVarRealizations, MCInputVarRealizations mCInputVarRealizations2) {
        if (mCInputTSVariable.isActive()) {
            double d2 = d;
            mCInputVarRealizations.setVariate(d.doubleValue());
            ((MCInputVariableImpl)mCInputTSVariable).applyRealization(d2);
            mCInputVarRealizations2.setRealization(n);
            mCInputVarRealizations2.setVariate(((MCInputVariableImpl)mCInputTSVariable).getVariate());
            mCInputVarRealizations.saveVariate();
            mCInputVarRealizations2.saveVariate();
        }
    }

    protected void a(int n, Double d, MCInputTSMultiplierVariable mCInputTSMultiplierVariable, MCInputVarRealizations mCInputVarRealizations, MCInputVarRealizations mCInputVarRealizations2) {
        if (mCInputTSMultiplierVariable.isActive()) {
            double d2 = d;
            mCInputVarRealizations.setVariate(d.doubleValue());
            ((MCInputVariableImpl)mCInputTSMultiplierVariable).applyRealization(d2);
            mCInputVarRealizations2.setRealization(n);
            mCInputVarRealizations2.setVariate(((MCInputVariableImpl)mCInputTSMultiplierVariable).getVariate());
            mCInputVarRealizations.saveVariate();
            mCInputVarRealizations2.saveVariate();
        }
    }

    protected void a(int n, Double d, MCInputScriptVariable mCInputScriptVariable, MCInputVarRealizations mCInputVarRealizations, MCInputVarRealizations mCInputVarRealizations2) {
        if (mCInputScriptVariable.isActive()) {
            double d2 = d;
            mCInputVarRealizations.setVariate(d.doubleValue());
            ((MCInputVariableImpl)mCInputScriptVariable).applyRealization(d2);
            mCInputVarRealizations2.setRealization(n);
            mCInputVarRealizations2.setVariate(mCInputScriptVariable.getVariate());
            mCInputVarRealizations.saveVariate();
            mCInputVarRealizations2.saveVariate();
        }
    }

    private void a() {
        for (int i = 0; i < this.m.size(); ++i) {
            MCInputVariable mCInputVariable = this.m.get(i);
            if (!mCInputVariable.isActive()) continue;
            if (mCInputVariable.getType() == 0) {
                ((MCInputVariableImpl)((MCInputTSVariable)mCInputVariable)).restoreInputVariable(new Object[0]);
                if (((MCInputTSVariable)mCInputVariable).getTSData() != null) continue;
                continue;
            }
            if (mCInputVariable.getType() == 1) {
                ((MCInputVariableImpl)((MCInputResRuleVariable)mCInputVariable)).restoreInputVariable(new Object[0]);
                continue;
            }
            if (mCInputVariable.getType() == 2) {
                if (((MCInputLookbackVariable)mCInputVariable).getHCData() == null) continue;
                ((MCInputVariableImpl)((MCInputLookbackVariable)mCInputVariable)).restoreInputVariable(new Object[0]);
                continue;
            }
            if (mCInputVariable.getType() == 3) {
                ((MCInputVariableImpl)((MCInputRatingCurveVariable)mCInputVariable)).restoreInputVariable(new Object[0]);
                continue;
            }
            if (mCInputVariable.getType() == 4) {
                ((MCInputVariableImpl)((MCInputTSMultiplierVariable)mCInputVariable)).restoreInputVariable(new Object[0]);
                continue;
            }
            ((MCInputVariableImpl)((MCInputScriptVariable)mCInputVariable)).restoreInputVariable(new Object[0]);
        }
    }

    private void a(int n) {
        int n2 = this.getSimulationOption();
        boolean bl = n2 != 2;
        for (int i = 0; i < this.n.size(); ++i) {
            MCOutputVariable mCOutputVariable = this.n.get(i);
            MCOutputVarRealizations mCOutputVarRealizations = this.y.get(i);
            if (!mCOutputVariable.isActive() || n2 == 2) continue;
            bl &= mCOutputVarRealizations.hasConverged(n);
        }
        this.q = bl;
    }

    public void setType(String string) {
    }

    public String getType() {
        return this.c;
    }

    public int getLastIterationComputed() {
        return this.h;
    }

    public long getCumulativeTime() {
        return this.i;
    }

    public int[] getCumulativeTimeArray() {
        int[] nArray = new int[4];
        long l = Math.round((double)this.getCumulativeTime() / 1000.0);
        long l2 = l / 60L;
        long l3 = l2 / 60L;
        long l4 = l3 / 24L;
        nArray[3] = (int)l % 60;
        nArray[2] = (int)l2 % 60;
        nArray[1] = (int)l3 % 24;
        nArray[0] = (int)l4;
        return nArray;
    }

    public String getCumulativeTimeString() {
        int[] nArray = this.getCumulativeTimeArray();
        DecimalFormat decimalFormat = new DecimalFormat("00");
        return nArray[0] + "," + decimalFormat.format(nArray[1]) + ":" + decimalFormat.format(nArray[2]) + ":" + decimalFormat.format(nArray[3]) + " (dd,hh:mm:ss)";
    }

    private void a(long l) {
        this.i += l;
    }

    public long getRealizTime() {
        if (this.getLastIterationComputed() == 0) {
            return 0L;
        }
        return this.i / (long)this.getLastIterationComputed();
    }

    public int[] getRealizTimeArray() {
        int[] nArray = new int[3];
        long l = Math.round((double)this.getRealizTime() / 1000.0);
        long l2 = l / 60L;
        long l3 = l2 / 60L;
        nArray[2] = (int)l % 60;
        nArray[1] = (int)l2 % 60;
        nArray[0] = (int)l3;
        return nArray;
    }

    public String getRealizTimeString() {
        int[] nArray = this.getRealizTimeArray();
        DecimalFormat decimalFormat = new DecimalFormat("00");
        return nArray[0] + ":" + decimalFormat.format(nArray[1]) + ":" + decimalFormat.format(nArray[2]) + " (hh:mm:ss)";
    }

    public int getMinIterations() {
        return this.e;
    }

    public void setMinIterations(int n) {
        this.e = n;
    }

    public double getStandaloneSeed() {
        return this.g;
    }

    public void setStandaloneSeed(double d) {
        this.g = d;
    }

    public int getMaxIterations() {
        return this.f;
    }

    public void setMaxIterations(int n) {
        this.f = n;
    }

    public void setSimulationOption(int n) {
        this.j = n;
    }

    public int getSimulationOption() {
        return this.j;
    }

    public String getIterationString() {
        return this.k;
    }

    public void setIterationString(String string) {
        this.k = string;
    }

    public int[] getIterations() {
        return this.l;
    }

    public void setIterations(int[] nArray) {
        this.l = nArray;
    }

    public void setInputVaribales(List<MCInputVariableImpl> list) {
        this.m = list;
    }

    public List<MCInputVariableImpl> getInputVariables() {
        return this.m;
    }

    public void setOutputVariables(List<MCOutputVariable> list) {
        this.n = list;
    }

    public List<MCOutputVariable> getOutputVariables() {
        return this.n;
    }

    public List<MCInputVarRealizations> getInputPrbRealizations() {
        return this.s;
    }

    public List<MCInputVarRealizations> getInputVarRealizations() {
        return this.t;
    }

    public List<MCOutputVarRealizations> getOutputVarRealizations() {
        return this.y;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void read(BufferedReader object) {
        try {
            Object object2 = new IntArray();
            Object object3 = ((BufferedReader)object).readLine();
            while (object3 != null) {
                if (((String)object3).length() == 0) {
                    object3 = ((BufferedReader)object).readLine();
                    continue;
                }
                String string = RMAIO.getType((String)object3, (String)":");
                object3 = RMAIO.getParam((String)object3, (String)":");
                if (string.equals("PlugInEnd")) {
                    this.l = object2.toArray();
                    if (this.x == null) return;
                    object = this;
                    object3 = null;
                    String string2 = object.getAlt().getRelativePath(((MCAltPluginData)((Object)object)).x);
                    object2 = object.getAlt().makeAbsolutePath(((MCAltPluginData)((Object)object)).x);
                    if (!string2.equals(((MCAltPluginData)((Object)object)).x)) {
                        ((MCAltPluginData)((Object)object)).x = string2;
                    } else if (string2.equals(object2)) {
                        System.out.println("Warning: unable to locate the mcscript file \"" + ((MCAltPluginData)((Object)object)).x + "\" for the " + object.getAlt().getName() + " alternative\nA new mcscript file will be created when this alternative is saved.");
                        ((MCAltPluginData)((Object)object)).x = null;
                        return;
                    }
                    try {
                        object3 = new BufferedReader(new FileReader(object.getAlt().makeAbsolutePath(((MCAltPluginData)((Object)object)).x)));
                    }
                    catch (Exception exception) {
                        System.out.println("Warning: unable to locate the mcscript file \"" + ((MCAltPluginData)((Object)object)).x + "\" for the " + object.getAlt().getName() + " alternative\nA new mcscript file will be created when this alternative is saved.");
                        ((MCAltPluginData)((Object)object)).x = null;
                        return;
                    }
                    String string3 = ((BufferedReader)object3).readLine();
                    while (string3 != null) {
                        if (string3.length() < 6 || !string3.substring(0, 6).equals(PythonScriptContainer.a)) continue;
                        if (string3.contains(MCSampleScripts.PRESAMPLE_HEADER)) {
                            ((MCAltPluginData)((Object)object)).u = new MCSampleScripts(true);
                            ((MCAltPluginData)((Object)object)).u.read((BufferedReader)object3);
                        } else if (string3.contains(MCSampleScripts.POSTSAMPLE_HEADER)) {
                            ((MCAltPluginData)((Object)object)).v = new MCSampleScripts(false);
                            ((MCAltPluginData)((Object)object)).v.read((BufferedReader)object3);
                        } else if (string3.contains(MCInputScriptVariable.SCRIPT_START)) {
                            for (int i = 0; i < ((MCAltPluginData)((Object)object)).m.size(); ++i) {
                                MCInputVariable mCInputVariable = ((MCAltPluginData)((Object)object)).m.get(i);
                                if (!(mCInputVariable instanceof MCInputScriptVariable) || !string3.contains(((MCInputScriptVariable)mCInputVariable).getVariableName())) continue;
                                ((MCInputScriptVariable)mCInputVariable).readScript((BufferedReader)object3);
                            }
                        }
                        string3 = ((BufferedReader)object3).readLine();
                    }
                    try {
                        ((BufferedReader)object3).close();
                        return;
                    }
                    catch (IOException iOException) {
                        System.out.println("Failed to close scripts file. " + iOException.getMessage());
                        iOException.printStackTrace();
                        return;
                    }
                    catch (IOException iOException) {
                        try {
                            IOException iOException2 = iOException;
                            iOException.printStackTrace();
                            if (object3 == null) return;
                        }
                        catch (Throwable throwable) {
                            if (object3 == null) throw throwable;
                            try {
                                ((BufferedReader)object3).close();
                                throw throwable;
                            }
                            catch (IOException iOException3) {
                                System.out.println("Failed to close scripts file. " + iOException3.getMessage());
                                iOException3.printStackTrace();
                            }
                            throw throwable;
                        }
                        try {
                            ((BufferedReader)object3).close();
                            return;
                        }
                        catch (IOException iOException4) {
                            System.out.println("Failed to close scripts file. " + iOException4.getMessage());
                            iOException4.printStackTrace();
                            return;
                        }
                    }
                }
                if (string.equals("MinIterations")) {
                    this.setMinIterations(Integer.parseInt((String)object3));
                } else if (string.equals("MaxIterations")) {
                    this.setMaxIterations(Integer.parseInt((String)object3));
                } else if (string.equals("LastIteration")) {
                    int n = Integer.parseInt((String)object3);
                    object3 = this;
                    this.h = n;
                } else if (string.equals("CumulativeTime")) {
                    long l = Long.parseLong((String)object3);
                    object3 = this;
                    this.i = l;
                } else if (string.equals("SimulationOption")) {
                    this.setSimulationOption(Integer.parseInt((String)object3));
                } else if (string.equals("Iteration")) {
                    object2.add(Integer.parseInt((String)object3));
                } else if (string.equals("IterationString")) {
                    this.setIterationString((String)object3);
                } else if (string.equals("Compute")) {
                    this.setUseCompute(Boolean.parseBoolean((String)object3));
                } else if (string.equals("StandAloneRandomSeed")) {
                    this.setStandaloneSeed(Double.parseDouble((String)object3));
                } else if (string.equals("InputVariable")) {
                    if (((String)object3).equals("MCInputTSVariable")) {
                        object3 = new MCInputTSVariable("", "", 0, false);
                        object3.read((BufferedReader)object);
                        this.m.add((MCInputStochasticVariableImpl)object3);
                    } else if (((String)object3).equals("MCInputLookbackVariable")) {
                        object3 = new MCInputLookbackVariable("", "", 2);
                        object3.read((BufferedReader)object);
                        this.m.add((MCInputStochasticVariableImpl)object3);
                    } else if (((String)object3).equals("MCInputResRuleVariable")) {
                        object3 = new MCInputResRuleVariable("", "", 1);
                        object3.read((BufferedReader)object);
                        this.m.add((MCInputStochasticVariableImpl)object3);
                    } else if (((String)object3).equals("MCInputRatingCurveVariable")) {
                        object3 = new MCInputRatingCurveVariable("", 1, new PairedValuesExt(), new String[0]);
                        object3.read((BufferedReader)object);
                        this.m.add((MCInputStochasticVariableImpl)object3);
                    } else if (((String)object3).equals("MCInputTSMultiplierVariable")) {
                        object3 = new MCInputTSMultiplierVariable("", "", 4);
                        object3.read((BufferedReader)object);
                        this.m.add((MCInputStochasticVariableImpl)object3);
                    } else if (((String)object3).equals("MCInputScript")) {
                        object3 = new MCInputScriptVariable("", "", 5, null);
                        object3.read((BufferedReader)object);
                        this.m.add((MCInputVariableImpl)object3);
                    }
                } else if (string.equals("OutputVariable")) {
                    object3 = new MCOutputVariable("", 0, 0);
                    ((MCOutputVariable)object3).read((BufferedReader)object);
                    this.n.add((MCOutputVariable)object3);
                } else if (string.equals("PreSampleScript")) {
                    this.u = new MCSampleScripts(true);
                    this.u.read((BufferedReader)object);
                } else if (string.equals("PostSampleScript")) {
                    this.v = new MCSampleScripts(false);
                    this.v.read((BufferedReader)object);
                } else if (string.equals("CorrelationMatrixBegin")) {
                    object3 = new CorrelationMatrix();
                    object3.read((BufferedReader)object);
                    this.w.put(object3.getCorrelationSetName(), (CorrelationMatrix)object3);
                } else if (string.equals("ScriptFilePath") && object3 != null && !((String)object3).equals("null")) {
                    this.x = object3;
                }
                object3 = ((BufferedReader)object).readLine();
            }
            object = this;
            for (MCInputVariableImpl mCInputVariableImpl : ((MCAltPluginData)((Object)object)).m) {
                if (!(mCInputVariableImpl instanceof MCInputStochasticVariableImpl)) continue;
                object2 = ((MCInputStochasticVariableImpl)mCInputVariableImpl).getInputVariableNames();
                for (Integer n : object2.keySet()) {
                    for (MCInputVariableImpl mCInputVariableImpl2 : ((MCAltPluginData)((Object)object)).m) {
                        if (!(mCInputVariableImpl2.getVariableName() + mCInputVariableImpl2.getLocation() + mCInputVariableImpl2.getParameter()).equals(object2.get(n))) continue;
                        ((MCInputStochasticVariableImpl)mCInputVariableImpl).addDependentVariable(n, mCInputVariableImpl2);
                    }
                }
            }
            return;
        }
        catch (IOException iOException) {
            System.out.println("Failed to read Monte Carlo Plugin Data. " + iOException.getMessage());
            iOException.printStackTrace();
            return;
        }
    }

    public void write(BufferedWriter bufferedWriter) {
        int n;
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"PlugIn:Monte Carlo");
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("MinIterations:" + Integer.toString(this.getMinIterations())));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("MaxIterations:" + Integer.toString(this.getMaxIterations())));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("LastIteration:" + Integer.toString(this.getLastIterationComputed())));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("CumulativeTime:" + Long.toString(this.getCumulativeTime())));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("SimulationOption:" + Integer.toString(this.getSimulationOption())));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("ScriptFilePath:" + this.x));
        if (this.l != null) {
            for (n = 0; n < this.l.length; ++n) {
                RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Iteration:" + this.l[n]));
            }
        }
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("IterationString:" + this.getIterationString()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Compute:" + this.useCompute()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("StandAloneRandomSeed:" + this.getStandaloneSeed()));
        for (int i = 0; i < this.m.size(); ++i) {
            MCInputVariable mCInputVariable = this.m.get(i);
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("InputVariable:" + mCInputVariable.getClassName()));
            mCInputVariable.write(bufferedWriter);
        }
        for (n = 0; n < this.n.size(); ++n) {
            MCOutputVariable mCOutputVariable = this.n.get(n);
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)"OutputVariable:");
            mCOutputVariable.write(bufferedWriter);
        }
        MCAltPluginData mCAltPluginData = this;
        if (mCAltPluginData.x != null) {
            try {
                Object object = mCAltPluginData.a.makeAbsolutePath(mCAltPluginData.x);
                object = new BufferedWriter(new FileWriter((String)object));
                if (mCAltPluginData.u != null) {
                    mCAltPluginData.u.write((BufferedWriter)object);
                }
                RMAIO.fout((BufferedWriter)object, (String)(PythonScriptContainer.a + "####################################################################"));
                RMAIO.fout((BufferedWriter)object, (String)(PythonScriptContainer.a + "                            Script Divider                          "));
                RMAIO.fout((BufferedWriter)object, (String)(PythonScriptContainer.a + "####################################################################"));
                if (mCAltPluginData.v != null) {
                    mCAltPluginData.v.write((BufferedWriter)object);
                }
                RMAIO.fout((BufferedWriter)object, (String)(PythonScriptContainer.a + "####################################################################"));
                RMAIO.fout((BufferedWriter)object, (String)(PythonScriptContainer.a + "                            Script Divider                          "));
                RMAIO.fout((BufferedWriter)object, (String)(PythonScriptContainer.a + "####################################################################"));
                for (int i = 0; i < mCAltPluginData.m.size(); ++i) {
                    MCInputVariable mCInputVariable = mCAltPluginData.m.get(i);
                    if (!(mCInputVariable instanceof MCInputScriptVariable)) continue;
                    ((MCInputScriptVariable)mCInputVariable).a((BufferedWriter)object);
                    RMAIO.fout((BufferedWriter)object, (String)(PythonScriptContainer.a + "####################################################################"));
                    RMAIO.fout((BufferedWriter)object, (String)(PythonScriptContainer.a + "                            Script Divider                          "));
                    RMAIO.fout((BufferedWriter)object, (String)(PythonScriptContainer.a + "####################################################################"));
                }
                ((BufferedWriter)object).close();
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                iOException.printStackTrace();
            }
        }
        if (this.w != null) {
            for (String string : this.w.keySet()) {
                this.w.get(string).write(bufferedWriter);
            }
        }
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"PlugInEnd");
    }

    public MCAltPluginData clone() {
        try {
            int n;
            MCAltPluginData mCAltPluginData = (MCAltPluginData)super.clone();
            ((MCAltPluginData)super.clone()).d = this.d;
            if (this.l != null) {
                System.arraycopy(this.l, 0, mCAltPluginData.l, 0, this.l.length);
            }
            mCAltPluginData.k = this.k;
            mCAltPluginData.f = this.f;
            mCAltPluginData.e = this.e;
            mCAltPluginData.h = this.h;
            mCAltPluginData.i = this.i;
            mCAltPluginData.j = this.j;
            mCAltPluginData.setStandaloneSeed(this.getStandaloneSeed());
            mCAltPluginData.m = new ArrayList<MCInputVariableImpl>();
            for (n = 0; n < this.m.size(); ++n) {
                mCAltPluginData.m.add(this.m.get(n).clone());
            }
            mCAltPluginData.n = new ArrayList<MCOutputVariable>();
            for (n = 0; n < this.n.size(); ++n) {
                mCAltPluginData.n.add(this.n.get(n).clone());
            }
            mCAltPluginData.w = new HashMap<String, CorrelationMatrix>();
            for (String string : this.w.keySet()) {
                mCAltPluginData.w.put(string, this.w.get(string).clone());
            }
            return mCAltPluginData;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("MCAltPluginDataclone: Error in clone " + String.valueOf(cloneNotSupportedException));
            return null;
        }
    }

    private boolean c(RssRun rssRun) {
        int n = 0;
        try {
            n = this.getSimulationOption();
            this.setSimulationOption(0);
            if (this.a(rssRun) != 0) {
                System.out.println("Monte Carlo Input Variable Data not found.");
                return false;
            }
            if (this.b(rssRun) != 0) {
                System.out.println("Monte Carlo Output Variable Data not found.");
                return false;
            }
            this.z = true;
        }
        finally {
            this.setSimulationOption(n);
        }
        MCAltPluginData mCAltPluginData = this;
        mCAltPluginData.a(mCAltPluginData.getLastIterationComputed());
        return true;
    }

    public boolean writeReport(BufferedWriter bufferedWriter, RssRun rssRun) throws IOException {
        int n;
        String string;
        Object object;
        String string22;
        Object object2;
        Object object3;
        Object object4;
        String string3;
        String string4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        int n2;
        BufferedWriter bufferedWriter2;
        Object object11;
        if (!this.c(rssRun)) {
            return false;
        }
        String string5 = "                    ";
        bufferedWriter.write(string5 + "##############################");
        bufferedWriter.newLine();
        bufferedWriter.write(string5 + "#                            #");
        bufferedWriter.newLine();
        bufferedWriter.write(string5 + "#     MONTE CARLO REPORT     #");
        bufferedWriter.newLine();
        bufferedWriter.write(string5 + "#                            #");
        bufferedWriter.newLine();
        bufferedWriter.write(string5 + "##############################");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("Simulation Converged: " + (this.q ? "YES" : "NO"));
        bufferedWriter.newLine();
        Object object12 = this.q ? "Rel. Error less than Tolerance for active Conv. Vars." : (this.getLastIterationComputed() < this.getMaxIterations() ? "Simulation incomplete, stopped or interrupted" : "Maximum number of iteration reached");
        bufferedWriter.write("REASON: " + object12);
        bufferedWriter.newLine();
        bufferedWriter.write("Number  Realizations: " + this.getLastIterationComputed());
        bufferedWriter.newLine();
        bufferedWriter.write("Minimum Realizations: " + this.getMinIterations());
        bufferedWriter.newLine();
        bufferedWriter.write("Maximum Realizations: " + this.getMaxIterations());
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("Compute Time so far : " + this.getCumulativeTimeString());
        bufferedWriter.newLine();
        bufferedWriter.write("Time per Realization: " + this.getRealizTimeString());
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        if (this.m.size() > 0) {
            bufferedWriter.write(string5 + "### INPUT VARIABLES ###");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            object11 = rssRun;
            bufferedWriter2 = bufferedWriter;
            object12 = this;
            n2 = object11.getUnitSystem();
            object10 = "%.2f";
            object9 = "==========";
            object8 = "----------";
            String string6 = object9;
            String string7 = object9;
            String string8 = object9;
            String string9 = object9;
            String cfr_ignored_0 = string6 + string6 + string7 + string7 + string8 + string8 + string9 + string9;
            String string10 = object8;
            String string11 = object8;
            String string12 = object8;
            Object object13 = object8;
            String cfr_ignored_1 = string10 + string10 + string11 + string11 + string12 + string12 + (String)object13 + (String)object13;
            String string13 = object9;
            String string14 = object9;
            String string15 = object9;
            String string16 = string13 + string13 + string14 + string14 + string15 + string15 + (String)object9 + "===";
            Object object14 = object8;
            Object object15 = object8;
            Object object16 = object8;
            String string17 = (String)object14 + (String)object14 + (String)object15 + (String)object15 + (String)object16 + (String)object16 + (String)object8 + "---";
            bufferedWriter2.write(string16);
            bufferedWriter2.newLine();
            bufferedWriter2.write("Active?     Variable Type  Seasonality   Distribution           Unc. Type");
            bufferedWriter2.newLine();
            bufferedWriter2.write("Reference   Location                     Distribution Parameters");
            bufferedWriter2.newLine();
            bufferedWriter2.write("GroupNumber Location Parameters (units)  Clipping");
            bufferedWriter2.newLine();
            bufferedWriter2.write(string16);
            bufferedWriter2.newLine();
            for (int i = 0; i < ((MCAltPluginData)((Object)object12)).m.size(); ++i) {
                object7 = ((MCAltPluginData)((Object)object12)).m.get(i);
                object6 = ((MCAltPluginData)((Object)object12)).t.get(i);
                if (object7 == null || object6 == null || (object5 = object6.getRandomTable()) == null) continue;
                string4 = ((MCInputVariableImpl)object7).isActive() ? "Yes" : "No";
                string3 = ((MCInputVariableImpl)object7).getLocation();
                object4 = object7 instanceof MCInputStochasticVariableImpl && ((MCInputStochasticVariableImpl)object7).isRelative() ? "Relative" : "Absolute";
                String string18 = object7 instanceof MCInputStochasticVariableImpl && ((MCInputStochasticVariableImpl)object7).isSeasonal() ? "Seasonal" : "Constant";
                object3 = ((MCInputVariableImpl)object7).getParameter();
                object2 = ((MCInputVariableImpl)object7).getUncertaintyTypeNameForReport();
                int n3 = ((MCInputVariableImpl)object7).getParamId();
                String string19 = ParameterLookup.getFullParamString((int)n3);
                String string20 = "(" + Parameter.getUnitsStringForSystem((int)n3, (int)n2) + ")";
                String string21 = (String)object3 + (String)(Parameter.isValid((String)string19) ? string20 : "");
                String string22 = "";
                String string23 = "";
                Object object17 = "";
                String string24 = "";
                switch (((MCInputVariableImpl)object7).getType()) {
                    case 0: {
                        string22 = "InputTS";
                        string23 = "Discrete";
                        string24 = "N/A";
                        object11 = ((MCInputTSVariable)object7).getDiscreteDist();
                        if (object11 != null && !object11.isEmpty()) {
                            object17 = object11.size() + " Time Series";
                            break;
                        }
                        object17 = "0 Time Series";
                        break;
                    }
                    case 1: {
                        string22 = "Rule";
                        object11 = ((MCInputClippedDataVariable)object7).getClipDist();
                        string23 = object11.getType();
                        if (string23.equals("Empirical") && ((EmpiricalDist)object11).getInterpType() == EmpiricalDist.InterpType.STEP) {
                            string23 = "Discrete";
                        }
                        String.format("%-10.2f", object5.getAvg());
                        string24 = object11.getSummaryClip((String)object10);
                        object17 = object11.getSummaryDef((String)object10);
                        break;
                    }
                    case 2: {
                        string22 = "Lookback";
                        object11 = ((MCInputClippedDataVariable)object7).getClipDist();
                        string23 = object11.getType();
                        if (string23.equals("Empirical")) {
                            if (object11 instanceof SeasonalContinuousDistribution && ((EmpiricalDist)((SeasonalContinuousDistribution)((Object)object11)).getDist()).getInterpType() == EmpiricalDist.InterpType.STEP) {
                                string23 = "Discrete";
                            } else if (object11 instanceof EmpiricalDist && ((EmpiricalDist)object11).getInterpType() == EmpiricalDist.InterpType.STEP) {
                                string23 = "Discrete";
                            }
                        }
                        String.format("%-10.2f", object5.getAvg());
                        string24 = object11.getSummaryClip((String)object10);
                        object17 = object11.getSummaryDef((String)object10);
                        break;
                    }
                    case 4: {
                        string22 = "TS Multiplier";
                        object11 = ((MCInputClippedDataVariable)object7).getClipDist();
                        string23 = object11.getType();
                        if (string23.equals("Empirical") && ((EmpiricalDist)object11).getInterpType() == EmpiricalDist.InterpType.STEP) {
                            string23 = "Discrete";
                        }
                        String.format("%-10.2f", object5.getAvg());
                        string24 = object11.getSummaryClip((String)object10);
                        object17 = object11.getSummaryDef((String)object10);
                        break;
                    }
                    case 3: {
                        if (!(object7 instanceof MCInputRatingCurveVariable)) break;
                        object11 = (MCInputRatingCurveVariable)object7;
                        string22 = "Rating Curve";
                        string23 = ((MCInputStochasticVariableImpl)object11).getDistributionName();
                        string24 = "N/A";
                        object17 = ((MCInputRatingCurveVariable)object11).getSummaryDef((String)object10);
                        break;
                    }
                    case 5: {
                        if (!(object7 instanceof MCInputScriptVariable)) break;
                        string22 = "Script";
                        string23 = "N/A";
                        string24 = "N/A";
                        object17 = "N/A";
                    }
                }
                object11 = String.valueOf(((MCInputVariableImpl)object7).getGroupNumber());
                if (((String)object11).equals("0")) {
                    object11 = "N/A";
                }
                if (((String)object17).contains("Right") && ((String)object17).contains("Peak") && ((String)object17).contains("Left")) {
                    object17 = ((String)object17).replace("ight", "");
                    object17 = ((String)object17).replace("eak", "");
                    object17 = ((String)object17).replace("eft", "");
                }
                bufferedWriter2.write(String.format("%-12.12s%-15.15s%-14.14s%-21.21s%-12.12s", string4, string22, string18, string23, object2));
                bufferedWriter2.newLine();
                bufferedWriter2.write(String.format("%-12.12s%-29.29s%-33.33s", object4, string3, object17));
                bufferedWriter2.newLine();
                bufferedWriter2.write(String.format("%-12.12s%-29.29s%-33.33s", object11, string21, string24));
                bufferedWriter2.newLine();
                bufferedWriter2.write(i == ((MCAltPluginData)((Object)object12)).m.size() - 1 ? string16 : string17);
                bufferedWriter2.newLine();
            }
            bufferedWriter2.newLine();
            object11 = rssRun;
            bufferedWriter2 = bufferedWriter;
            object12 = this;
            n2 = object11.getUnitSystem();
            object10 = "%8d";
            string22 = "%10.2f";
            object9 = "%15.2f";
            Object object18 = object8 = "=====";
            Object object19 = object8;
            object = "=====" + (String)object8 + (String)object18 + (String)object18 + (String)object19 + (String)object19;
            Object object20 = object8;
            string = (String)object + (String)object20 + (String)object20;
            string16 = (String)string + (String)object;
            for (n = 0; n < ((MCAltPluginData)((Object)object12)).m.size(); ++n) {
                double d;
                double d2;
                MCInputVariable mCInputVariable = ((MCAltPluginData)((Object)object12)).m.get(n);
                object7 = ((MCAltPluginData)((Object)object12)).t.get(n);
                if (mCInputVariable == null || object7 == null || (object6 = object7.getRandomTable()) == null) continue;
                double[] dArray = object6.getAll();
                object5 = dArray;
                if (dArray == null || ((Object)object5).length < 2) continue;
                string4 = new TableDist((double[])object5);
                string3 = mCInputVariable.getLocation();
                object4 = mCInputVariable.getParameter();
                int n4 = mCInputVariable.getParamId();
                object3 = ParameterLookup.getFullParamString((int)n4);
                object2 = "(" + Parameter.getUnitsStringForSystem((int)n4, (int)n2) + ")";
                String string25 = (String)object4 + (String)(Parameter.isValid((String)object3) ? object2 : "");
                if (string4.size() < 2 || A == null || A.length <= 0) continue;
                if (mCInputVariable.getType() == 0) {
                    DiscreteDist<ParseableDSSIdentifier> discreteDist = ((MCInputTSVariable)mCInputVariable).getDiscreteDist();
                    if (discreteDist == null) continue;
                    bufferedWriter2.write(string3 + " - " + string25);
                    bufferedWriter2.newLine();
                    bufferedWriter2.write("Generated Discrete Probability Table");
                    bufferedWriter2.newLine();
                    bufferedWriter2.write(string16);
                    bufferedWriter2.newLine();
                    bufferedWriter2.write("TS Index  Defined  Generated DSS Path");
                    bufferedWriter2.newLine();
                    bufferedWriter2.write("TS Index  Value     Value    DSS Path");
                    bufferedWriter2.newLine();
                    bufferedWriter2.write(string16);
                    bufferedWriter2.newLine();
                    double d3 = 0.0;
                    for (int i = 0; i < discreteDist.size(); ++i) {
                        d2 = string4.getCDF((double)i + 0.5) - d3;
                        d3 += d2;
                        d = discreteDist instanceof SeasonalDiscreteDistribution ? ((SeasonalDiscreteDistribution)discreteDist).getProb(i, object11.getRunTimeWindow().getStartTime()) : discreteDist.getProb(i);
                        bufferedWriter2.write(String.format((String)object10, i) + String.format(string22, d) + String.format(string22, d2) + "  " + ((ParseableDSSIdentifier)discreteDist.getValue(i)).getDSSPath());
                        bufferedWriter2.newLine();
                    }
                    bufferedWriter2.write(string16);
                    bufferedWriter2.newLine();
                    bufferedWriter2.newLine();
                    continue;
                }
                if (mCInputVariable.getType() == 1 || mCInputVariable.getType() == 2 || mCInputVariable.getType() == 4) {
                    double d4;
                    ClipDist clipDist = ((MCInputClippedDataVariable)mCInputVariable).getClipDist();
                    if (clipDist == null) continue;
                    if (clipDist instanceof SeasonalContinuousDistribution) {
                        ((SeasonalContinuousDistribution)clipDist).setStartTime(object11.getRunTimeWindow().getStartTime());
                    }
                    bufferedWriter2.write(string3 + " - " + string25);
                    bufferedWriter2.newLine();
                    bufferedWriter2.write("Generated CDF Table");
                    bufferedWriter2.newLine();
                    if (((MCInputStochasticVariableImpl)mCInputVariable).isRelative()) {
                        if (((MCInputVariableImpl)mCInputVariable).getAlt() == null) {
                            ((MCInputVariableImpl)mCInputVariable).setAlt(object11.getAlternative());
                        }
                        Object object21 = object8;
                        bufferedWriter2.write((String)string + (String)object21 + (String)object21 + (String)object8);
                        bufferedWriter2.newLine();
                        bufferedWriter2.write("  Quantile        Def. Rel      Def. Abs.     Generated");
                        bufferedWriter2.newLine();
                        bufferedWriter2.write("  Quantile          Value         Value         Value");
                        bufferedWriter2.newLine();
                        Object object22 = object8;
                        bufferedWriter2.write((String)string + (String)object22 + (String)object22 + (String)object8);
                        bufferedWriter2.newLine();
                        for (int i = 0; i < A.length; ++i) {
                            d4 = string4.invCDF(A[i]);
                            d2 = clipDist.invCDF(A[i]);
                            d = ((MCInputStochasticVariableImpl)((MCInputClippedDataVariable)mCInputVariable)).getAbsoluteDist().invCDF(A[i]);
                            bufferedWriter2.write(String.format(string22, 100.0 * A[i]) + String.format((String)object9, d2) + String.format((String)object9, d) + String.format((String)object9, d4));
                            bufferedWriter2.newLine();
                        }
                        Object object23 = object8;
                        bufferedWriter2.write((String)string + (String)object23 + (String)object23 + (String)object8);
                        bufferedWriter2.newLine();
                        bufferedWriter2.newLine();
                        continue;
                    }
                    bufferedWriter2.write(string);
                    bufferedWriter2.newLine();
                    bufferedWriter2.write("  Quantile        Defined       Generated");
                    bufferedWriter2.newLine();
                    bufferedWriter2.write("  Quantile         Value          Value");
                    bufferedWriter2.newLine();
                    bufferedWriter2.write(string);
                    bufferedWriter2.newLine();
                    for (int i = 0; i < A.length; ++i) {
                        d4 = string4.invCDF(A[i]);
                        d2 = clipDist.invCDF(A[i]);
                        bufferedWriter2.write(String.format(string22, 100.0 * A[i]) + String.format((String)object9, d2) + String.format((String)object9, d4));
                        bufferedWriter2.newLine();
                    }
                    bufferedWriter2.write(string);
                    bufferedWriter2.newLine();
                    bufferedWriter2.newLine();
                    continue;
                }
                if (mCInputVariable.getType() != 5) continue;
                bufferedWriter2.write(((MCInputScriptVariable)mCInputVariable).getDescription() + " - " + string3 + " - " + string25);
                bufferedWriter2.newLine();
                bufferedWriter2.write("Generated CDF Table");
                bufferedWriter2.newLine();
                bufferedWriter2.write(string);
                bufferedWriter2.newLine();
                bufferedWriter2.write("  Quantile        Defined       Generated");
                bufferedWriter2.newLine();
                bufferedWriter2.write("  Quantile         Value          Value");
                bufferedWriter2.newLine();
                bufferedWriter2.write(string);
                bufferedWriter2.newLine();
                for (int i = 0; i < A.length; ++i) {
                    double d5 = string4.invCDF(A[i]);
                    bufferedWriter2.write(String.format(string22, 100.0 * A[i]) + "          N/A" + String.format((String)object9, d5));
                    bufferedWriter2.newLine();
                }
                bufferedWriter2.write(string);
                bufferedWriter2.newLine();
                bufferedWriter2.newLine();
            }
        }
        if (this.b() > 0) {
            bufferedWriter.write(string5 + "### CONVERGENCE VARIABLES ###");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            object11 = rssRun;
            bufferedWriter2 = bufferedWriter;
            object12 = this;
            n2 = object11.getUnitSystem();
            object10 = "%10.2f";
            string22 = "%15.2f";
            object9 = "==========";
            object8 = "----------";
            String string26 = object9;
            String string27 = object9;
            String string28 = object9;
            object = string26 + string26 + string27 + string27 + string28 + string28 + (String)object9;
            String string29 = object8;
            Object object24 = object8;
            Object object25 = object8;
            string = string29 + string29 + (String)object24 + (String)object24 + (String)object25 + (String)object25 + (String)object8;
            bufferedWriter2.write((String)object);
            bufferedWriter2.newLine();
            bufferedWriter2.write("Actv?     Location                 ");
            bufferedWriter2.write("                Confid(%)    Tol(%)");
            bufferedWriter2.newLine();
            bufferedWriter2.write("Conv?     Parameter(units)         ");
            bufferedWriter2.write("Statistic        Run.Mean  Rel.E(%)");
            bufferedWriter2.newLine();
            bufferedWriter2.write((String)object);
            bufferedWriter2.newLine();
            int n5 = ((MCAltPluginData)((Object)object12)).b();
            for (n = 0; n < ((MCAltPluginData)((Object)object12)).n.size(); ++n) {
                MCOutputVariable mCOutputVariable = ((MCAltPluginData)((Object)object12)).n.get(n);
                object7 = ((MCAltPluginData)((Object)object12)).y.get(n);
                if (mCOutputVariable == null || object7 == null || !mCOutputVariable.hasConv() || (object6 = object7.getRandomTable()) == null) continue;
                object5 = mCOutputVariable.isActive() ? "Yes" : "No";
                string4 = object7.hasConverged() ? "Yes" : "No";
                string3 = object11.getAlternative().getSystem().getNameForKeyString(mCOutputVariable.getProxyName());
                object4 = RssModelVariableSet.getParamName((int)mCOutputVariable.getModelVariableId());
                int n6 = mCOutputVariable.getParamId();
                object3 = "(" + Parameter.getUnitsStringForSystem((int)n6, (int)n2) + ")";
                object2 = (String)object4 + (String)object3;
                String string30 = mCOutputVariable.getStatistic();
                String string31 = String.format(string22, mCOutputVariable.getConfidence());
                String string32 = String.format(string22, object6.getAvg());
                String string33 = String.format((String)object10, mCOutputVariable.getRelTol());
                String string34 = String.format((String)object10, 100.0 * object6.getBoundRelErrorOfMean(mCOutputVariable.getConfidence() / 100.0));
                bufferedWriter2.write(String.format("%-10.10s%-25.25s%-10.10s%15.15s%10.10s", object5, string3, "", string31, string33));
                bufferedWriter2.newLine();
                bufferedWriter2.write(String.format("%-10.10s%-25.25s%-10.10s%15.15s%10.10s", string4, object2, string30, string32, string34));
                bufferedWriter2.newLine();
                bufferedWriter2.write((String)(n == n5 - 1 ? object : string));
                bufferedWriter2.newLine();
            }
            bufferedWriter2.newLine();
        }
        if (this.n.size() > 0) {
            int n7;
            bufferedWriter.write(string5 + "### OUTPUT VARIABLES ###");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            object11 = rssRun;
            bufferedWriter2 = bufferedWriter;
            object12 = this;
            n2 = object11.getUnitSystem();
            object10 = "%15.2f";
            string22 = "==========";
            object9 = "----------";
            String string35 = string22;
            String string36 = string22;
            String string37 = string22;
            object8 = string35 + string35 + string36 + string36 + string37 + string37;
            String string38 = object9;
            String string39 = object9;
            String string40 = object9;
            object = string38 + string38 + string39 + string39 + string40 + string40;
            bufferedWriter2.write((String)object8);
            bufferedWriter2.newLine();
            bufferedWriter2.write("Actv?     Location                 ");
            bufferedWriter2.write("                 FlagCond");
            bufferedWriter2.newLine();
            bufferedWriter2.write("Flag?     Parameter(units)         ");
            bufferedWriter2.write("Statistic        Run.Mean");
            bufferedWriter2.newLine();
            bufferedWriter2.write((String)object8);
            bufferedWriter2.newLine();
            for (n7 = 0; n7 < ((MCAltPluginData)((Object)object12)).n.size(); ++n7) {
                DoubleRandomTable doubleRandomTable;
                MCOutputVariable mCOutputVariable = ((MCAltPluginData)((Object)object12)).n.get(n7);
                MCOutputVarRealizations mCOutputVarRealizations = ((MCAltPluginData)((Object)object12)).y.get(n7);
                if (mCOutputVariable == null || mCOutputVarRealizations == null || (doubleRandomTable = mCOutputVarRealizations.getRandomTable()) == null) continue;
                object7 = mCOutputVariable.isActive() ? "Yes" : "No";
                object6 = mCOutputVariable.hasTest() ? "Yes" : "No";
                object5 = object11.getAlternative().getSystem().getNameForKeyString(mCOutputVariable.getProxyName());
                string4 = RssModelVariableSet.getParamName((int)mCOutputVariable.getModelVariableId());
                int n8 = mCOutputVariable.getParamId();
                object4 = "(" + Parameter.getUnitsStringForSystem((int)n8, (int)n2) + ")";
                String string41 = string4 + (String)object4;
                object3 = mCOutputVariable.getStatistic();
                object2 = mCOutputVariable.hasTest() ? mCOutputVariable.getTestOp() + String.format((String)object10, mCOutputVariable.getTestVal()).trim() : "";
                String string42 = String.format((String)object10, doubleRandomTable.getAvg());
                bufferedWriter2.write(String.format("%-10.10s%-25.25s%-10.10s%15.15s", object7, object5, "", object2));
                bufferedWriter2.newLine();
                bufferedWriter2.write(String.format("%-10.10s%-25.25s%-10.10s%15.15s", object6, string41, object3, string42));
                bufferedWriter2.newLine();
                bufferedWriter2.write((String)(n7 == ((MCAltPluginData)((Object)object12)).n.size() - 1 ? object8 : object));
                bufferedWriter2.newLine();
            }
            bufferedWriter2.newLine();
            object11 = rssRun;
            bufferedWriter2 = bufferedWriter;
            object12 = this;
            n2 = object11.getUnitSystem();
            object10 = "%10.2f";
            string22 = "%15.2f";
            Object object26 = object9 = "=====";
            object8 = "=====" + (String)object9 + (String)object26 + (String)object26 + (String)object9;
            object = (String)object8 + (String)object9;
            for (n7 = 0; n7 < ((MCAltPluginData)((Object)object12)).n.size(); ++n7) {
                DoubleRandomTable doubleRandomTable;
                MCOutputVariable mCOutputVariable = ((MCAltPluginData)((Object)object12)).n.get(n7);
                MCOutputVarRealizations mCOutputVarRealizations = ((MCAltPluginData)((Object)object12)).y.get(n7);
                if (mCOutputVariable == null || mCOutputVarRealizations == null || (doubleRandomTable = mCOutputVarRealizations.getRandomTable()) == null) continue;
                double[] dArray = doubleRandomTable.getAll();
                object7 = dArray;
                if (dArray == null || ((MCOutputVarRealizations)object7).length < 2) continue;
                object6 = new EmpiricalDist((double[])object7);
                object6.setInterpType(EmpiricalDist.InterpType.STEP);
                object5 = object11.getAlternative().getSystem().getNameForKeyString(mCOutputVariable.getProxyName());
                string4 = RssModelVariableSet.getParamName((int)mCOutputVariable.getModelVariableId());
                int n9 = mCOutputVariable.getParamId();
                object4 = "(" + Parameter.getUnitsStringForSystem((int)n9, (int)n2) + ")";
                String string43 = string4 + (String)object4;
                if (object6.size() >= 2 && A != null && A.length > 0) {
                    bufferedWriter2.write((String)object5 + " - " + string43);
                    bufferedWriter2.newLine();
                    bufferedWriter2.write("Generated CDF Table");
                    bufferedWriter2.newLine();
                    bufferedWriter2.write((String)object8);
                    bufferedWriter2.newLine();
                    bufferedWriter2.write("  Quantile          Value");
                    bufferedWriter2.newLine();
                    bufferedWriter2.write((String)object8);
                    bufferedWriter2.newLine();
                    for (int i = 0; i < A.length; ++i) {
                        double d = object6.invCDF(A[i]);
                        bufferedWriter2.write(String.format((String)object10, 100.0 * A[i]) + String.format(string22, d));
                        bufferedWriter2.newLine();
                    }
                    bufferedWriter2.write((String)object8);
                    bufferedWriter2.newLine();
                    bufferedWriter2.newLine();
                }
                if (mCOutputVariable.hasTest()) {
                    String string44 = mCOutputVariable.getTestOp();
                    double d = mCOutputVariable.getTestVal();
                    if (object6.size() >= 2 && string44 != null && RMAConst.isValidValue((double)d)) {
                        bufferedWriter2.write((String)object5 + " - " + string43);
                        bufferedWriter2.newLine();
                        bufferedWriter2.write("Flag condition: sample " + string44 + " " + d);
                        bufferedWriter2.newLine();
                        double d6 = 0.0;
                        if ("<".equals(string44)) {
                            d6 = object6.getCDF(d);
                        } else if (">".equals(string44)) {
                            d6 = 1.0 - object6.getCDF(d);
                        } else if ("=".equals(string44)) {
                            d6 = object6.getCDF(d + 0.001) - object6.getCDF(d - 0.001);
                        }
                        bufferedWriter2.write("Frequency of flag condition: " + String.format("%.2f", d6 * 100.0) + "%");
                        bufferedWriter2.newLine();
                        bufferedWriter2.newLine();
                    }
                }
                object3 = mCOutputVariable.getUsrCdfVals();
                if (object6.size() < 2 || object3 == null || ((Object)object3).length <= 0) continue;
                bufferedWriter2.write((String)object5 + " - " + string43);
                bufferedWriter2.newLine();
                bufferedWriter2.write("Values of Interest Table");
                bufferedWriter2.newLine();
                bufferedWriter2.write((String)object);
                bufferedWriter2.newLine();
                bufferedWriter2.write("          Value   Non-Exc Prob");
                bufferedWriter2.newLine();
                bufferedWriter2.write((String)object);
                bufferedWriter2.newLine();
                for (int i = 0; i < ((Object)object3).length; ++i) {
                    double d = object6.getCDF((double)object3[i]);
                    bufferedWriter2.write(String.format(string22, (double)object3[i]) + String.format(string22, d * 100.0));
                    bufferedWriter2.newLine();
                }
                bufferedWriter2.write((String)object);
                bufferedWriter2.newLine();
                bufferedWriter2.newLine();
            }
        }
        if (this.w != null) {
            bufferedWriter.write(string5 + "### CORRELATION SETS ###");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter2 = bufferedWriter;
            object12 = this;
            String string45 = "================================================================================";
            for (String string22 : ((MCAltPluginData)((Object)object12)).w.keySet()) {
                bufferedWriter2.write("Correlation Set: " + string22 + "\n");
                bufferedWriter2.write(string45 + "\n");
                bufferedWriter2.write("          Variable 1                    Variable 2               Correlation\n");
                bufferedWriter2.write(string45 + "\n");
                object9 = ((MCAltPluginData)((Object)object12)).w.get(string22).getKeys();
                for (int i = 0; i < object9.size(); ++i) {
                    for (Object object27 : object9.subList(i + 1, object9.size())) {
                        Object object28 = (String)object9.get(i);
                        String string46 = object28;
                        String string47 = object27;
                        if (((String)object28).length() > 30) {
                            object28 = ((String)object28).substring(0, 29);
                        }
                        object7 = " ";
                        if (((String)object28).length() < 29) {
                            object7 = String.format("%0" + (int)Math.ceil(30.0 - (double)((String)object28).length()) + "d", 0).replace("0", " ");
                        }
                        object28 = (String)object28 + (String)object7;
                        if (((String)object27).length() > 30) {
                            object27 = ((String)object27).substring(0, 29);
                        }
                        object7 = " ";
                        if (((String)object27).length() < 29) {
                            object7 = String.format("%0" + (int)Math.ceil(30.0 - (double)((String)object27).length()) + "d", 0).replace("0", " ");
                        }
                        object27 = (String)object27 + (String)object7;
                        object6 = (String)object28 + (String)object27 + "        " + String.format("%1.2f", ((MCAltPluginData)((Object)object12)).w.get(string22).getCorEntry(string46, string47));
                        bufferedWriter2.write((String)object6 + "\n");
                    }
                }
                bufferedWriter2.write(string45);
                bufferedWriter2.write("\n");
            }
        }
        return true;
    }

    private int b() {
        if (this.n == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.n.size(); ++i) {
            MCOutputVariable mCOutputVariable = this.n.get(i);
            if (!mCOutputVariable.hasConv()) continue;
            ++n;
        }
        return n;
    }

    private static List<ScalarOutputter> a(MCOutputVariable mCOutputVariable, MCOutputVarRealizations object, boolean bl, boolean bl2) {
        ArrayList<ScalarOutputter> arrayList = new ArrayList<ScalarOutputter>();
        DoubleRandomTable doubleRandomTable = object.getRandomTable();
        if (doubleRandomTable != null) {
            object = new MCScalarOutput("Number of Realizations", Double.valueOf(doubleRandomTable.size()));
            arrayList.add((ScalarOutputter)object);
            object = new MCScalarOutput("Running Average (of " + mCOutputVariable.getStatistic() + ")", doubleRandomTable.getAvg());
            arrayList.add((ScalarOutputter)object);
        }
        if (mCOutputVariable.hasConv()) {
            object = new MCScalarOutput("Convergence: Confidence (%)", mCOutputVariable.getConfidence());
            arrayList.add((ScalarOutputter)object);
            object = new MCScalarOutput("Convergence: Rel Tolerance (%)", mCOutputVariable.getRelTol());
            arrayList.add((ScalarOutputter)object);
            if (doubleRandomTable != null) {
                object = new MCScalarOutput("Convergence: Rel Error (%)", 100.0 * doubleRandomTable.getBoundRelErrorOfMean(mCOutputVariable.getConfidence() / 100.0));
                arrayList.add((ScalarOutputter)object);
            }
        }
        if (bl2 && mCOutputVariable.hasTest()) {
            object = new MCScalarOutput("Flag Test: " + mCOutputVariable.getStatistic() + " " + mCOutputVariable.getTestOp(), mCOutputVariable.getTestVal());
            arrayList.add((ScalarOutputter)object);
        }
        return arrayList;
    }

    private static List<PairedDataContainer> a(double[] object, MCVarRealizations mCVarRealizations, int n) {
        int n2 = ClientApp.Workspace().getUnitSystem();
        ArrayList<PairedDataContainer> arrayList = new ArrayList<PairedDataContainer>();
        PairedDataContainer pairedDataContainer = new PairedDataContainer();
        new PairedDataContainer().numberCurves = 1;
        pairedDataContainer.numberOrdinates = ((double[])object).length;
        pairedDataContainer.xOrdinates = new double[((double[])object).length];
        int n3 = 0;
        while (n3 < ((double[])object).length) {
            int n4 = n3++;
            pairedDataContainer.xOrdinates[n4] = (double)n4 + 1.0;
        }
        pairedDataContainer.yOrdinates = new double[1][];
        pairedDataContainer.yOrdinates[0] = object;
        pairedDataContainer.labels = new String[]{mCVarRealizations.getName()};
        pairedDataContainer.labelsUsed = true;
        DSSIdentifier dSSIdentifier = mCVarRealizations.getDSSId();
        pairedDataContainer.fileName = dSSIdentifier.getFileName();
        pairedDataContainer.fullName = dSSIdentifier.getDSSPath();
        pairedDataContainer.xtype = "";
        pairedDataContainer.ytype = "";
        pairedDataContainer.xunits = "";
        object = Parameter.getUnitsStringForSystem((int)n, (int)n2);
        pairedDataContainer.yunits = (double[])(Parameter.isValid((String)object) ? object : (double[])"");
        pairedDataContainer.xparameter = "Realization";
        pairedDataContainer.yparameter = Parameter.isValid((String)object) ? ParameterLookup.getFullParamString((int)n) : "";
        arrayList.add(pairedDataContainer);
        return arrayList;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public boolean displayHistogram(RssRun var1_1) {
        if (!this.c(var1_1 /* !! */ )) {
            return false;
        }
        var2_2 = var1_1 /* !! */ ;
        var1_1 /* !! */  = this;
        var3_3 = var2_2.getAlternative();
        var4_4 = new ArrayList<Object>();
        for (var5_5 = 0; var5_5 < var1_1 /* !! */ .m.size(); ++var5_5) {
            var6_6 = var1_1 /* !! */ .m.get(var5_5);
            if (!var6_6.isActive()) continue;
            var7_7 /* !! */  = var1_1 /* !! */ .t.get(var5_5);
            if (var6_6 == null || var7_7 /* !! */  == null || (var8_8 /* !! */  = var7_7 /* !! */ .getRandomTable()) == null) continue;
            v0 = var8_8 /* !! */ .getAll();
            var8_8 /* !! */  = (DoubleRandomTable)v0;
            if (v0 == null || ((DoubleRandomTable)var8_8 /* !! */ ).length == 0) continue;
            var9_14 = MCAltPluginData.a((double[])var8_8 /* !! */ , (MCVarRealizations)var7_7 /* !! */ , var6_6.getParamId());
            var9_14 = var6_6 instanceof MCInputScriptVariable != false ? new MCDisplayVar("Input Variable", "Script:" + ((MCInputScriptVariable)var6_6).getDescription() + ":" + var7_7 /* !! */ .getName(), var6_6.getParamId(), (List<PairedDataContainer>)var9_14) : new MCDisplayVar("Input Variable", ((MCInputStochasticVariableImpl)var6_6).getShortName(), var6_6.getParamId(), (List<PairedDataContainer>)var9_14);
            if (var6_6.getType() == 0) {
                var9_14.setBinType(1);
                var9_14.setBinSize(0.999999999999);
            }
            var9_14.setDescription("");
            if (((MCInputVariableImpl)var6_6).getAlt() == null) {
                ((MCInputVariableImpl)var6_6).setAlt(var3_3);
            }
            var11_16 = var2_2;
            var10_15 = var6_6;
            var13_22 = new double[2][];
            switch (var10_15.getType()) {
                case 0: {
                    var14_23 = ((MCInputTSVariable)var10_15).getDiscreteDist();
                    if (var14_23 == null || var14_23.isEmpty() || var14_23.size() == 0) {
                        v1 = null;
                        break;
                    }
                    var13_22[0] = new double[2 * var14_23.size()];
                    var13_22[1] = new double[2 * var14_23.size()];
                    for (var15_24 = 0; var15_24 < var14_23.size(); ++var15_24) {
                        var13_22[0][2 * var15_24] = (double)var15_24 - 0.5;
                        var13_22[0][2 * var15_24 + 1] = (double)var15_24 + 0.5;
                        if (var14_23 instanceof SeasonalDiscreteDistribution) {
                            var13_22[1][2 * var15_24] = ((SeasonalDiscreteDistribution)var14_23).getProb(var15_24, var11_16.getRunTimeWindow().getStartTime());
                            var13_22[1][2 * var15_24 + 1] = ((SeasonalDiscreteDistribution)var14_23).getProb(var15_24, var11_16.getRunTimeWindow().getStartTime());
                            continue;
                        }
                        var13_22[1][2 * var15_24] = var14_23.getProb(var15_24);
                        var13_22[1][2 * var15_24 + 1] = var14_23.getProb(var15_24);
                    }
                    ** GOTO lbl92
                }
                case 1: {
                    var12_21 = ((MCInputClippedDataVariable)var10_15).getClipDist();
                    if (((MCInputClippedDataVariable)var10_15).isRelative()) {
                        var12_21 = ((MCInputClippedDataVariable)var10_15).getAbsoluteDist();
                    }
                    if (var12_21 == null) {
                        v1 = null;
                        break;
                    }
                    if (var12_21 instanceof SeasonalContinuousDistribution) {
                        ((SeasonalContinuousDistribution)var12_21).setStartTime(var11_16.getRunTimeWindow().getStartTime());
                    }
                    var13_22[0] = new double[MCAltPluginData.B.length];
                    var13_22[1] = new double[MCAltPluginData.B.length];
                    for (var15_25 = 0; var15_25 < MCAltPluginData.B.length; ++var15_25) {
                        var13_22[0][var15_25] = var12_21.invCDF(MCAltPluginData.B[var15_25]);
                        var13_22[1][var15_25] = var12_21.getPDF(var13_22[0][var15_25]);
                    }
                    ** GOTO lbl92
                }
                case 2: {
                    var12_21 = ((MCInputClippedDataVariable)var10_15).getClipDist();
                    if (((MCInputClippedDataVariable)var10_15).isRelative()) {
                        var12_21 = ((MCInputClippedDataVariable)var10_15).getAbsoluteDist();
                    }
                    if (var12_21 == null) {
                        v1 = null;
                        break;
                    }
                    if (var12_21 instanceof SeasonalContinuousDistribution) {
                        ((SeasonalContinuousDistribution)var12_21).setStartTime(var11_16.getRunTimeWindow().getStartTime());
                    }
                    var13_22[0] = new double[MCAltPluginData.B.length];
                    var13_22[1] = new double[MCAltPluginData.B.length];
                    for (var15_26 = 0; var15_26 < MCAltPluginData.B.length; ++var15_26) {
                        var13_22[0][var15_26] = var12_21.invCDF(MCAltPluginData.B[var15_26]);
                        var13_22[1][var15_26] = var12_21.getPDF(var13_22[0][var15_26]);
                    }
                    ** GOTO lbl92
                }
                case 4: {
                    var12_21 = ((MCInputClippedDataVariable)var10_15).getClipDist();
                    if (((MCInputClippedDataVariable)var10_15).isRelative()) {
                        var12_21 = ((MCInputClippedDataVariable)var10_15).getAbsoluteDist();
                    }
                    if (var12_21 == null) {
                        v1 = null;
                        break;
                    }
                    if (var12_21 instanceof SeasonalContinuousDistribution) {
                        ((SeasonalContinuousDistribution)var12_21).setStartTime(var11_16.getRunTimeWindow().getStartTime());
                    }
                    var13_22[0] = new double[MCAltPluginData.B.length];
                    var13_22[1] = new double[MCAltPluginData.B.length];
                    for (var15_27 = 0; var15_27 < MCAltPluginData.B.length; ++var15_27) {
                        var13_22[0][var15_27] = var12_21.invCDF(MCAltPluginData.B[var15_27]);
                        var13_22[1][var15_27] = var12_21.getPDF(var13_22[0][var15_27]);
                    }
                }
lbl92:
                // 5 sources

                default: {
                    v1 = var13_22;
                }
            }
            var10_15 = v1;
            var9_14.setAnalyticX((double[])var10_15[0]);
            var9_14.setAnalyticY((double[])var10_15[1]);
            v2 = var6_6;
            var12_21 = var2_2;
            var6_6 = var8_8 /* !! */ ;
            var11_16 = var7_7 /* !! */ ;
            var10_15 = v2;
            var14_23 = new ArrayList<E>();
            var7_7 /* !! */  = var11_16.getRandomTable();
            var25_36 = 0.0;
            if (var10_15 instanceof MCInputStochasticVariableImpl && ((MCInputStochasticVariableImpl)var10_15).isRelative()) {
                for (var8_9 = 0; var8_9 < ((Cloneable)var6_6).length; ++var8_9) {
                    var25_36 += var6_6[var8_9] / (double)(((Cloneable)var6_6).length + 1);
                }
            } else {
                var25_36 = var7_7 /* !! */ .getAvg();
            }
            if (var7_7 /* !! */  != null) {
                var15_28 = new MCScalarOutput("Number of Realizations", Double.valueOf(var7_7 /* !! */ .size()));
                var14_23.add((MCScalarOutput)var15_28);
                var15_28 = new MCScalarOutput("Running Average", var25_36);
                var14_23.add(var15_28);
            }
            switch (var10_15.getType()) {
                case 0: {
                    var6_6 = ((MCInputTSVariable)var10_15).getDiscreteDist();
                    if (var6_6 == null) break;
                    for (var11_17 = 0; var11_17 < var6_6.size(); ++var11_17) {
                        if (var6_6 instanceof SeasonalDiscreteDistribution) {
                            var15_29 = new MCScalarOutput("Time Series #" + var11_17 + " = " + ((ParseableDSSIdentifier)var6_6.getValue(var11_17)).getDSSPath() + "  Defined Prob.", ((SeasonalDiscreteDistribution)var6_6).getProb(var11_17, var12_21.getRunTimeWindow().getStartTime()));
                            var14_23.add(var15_29);
                            continue;
                        }
                        var15_29 = new MCScalarOutput("Time Series #" + var11_17 + " = " + ((ParseableDSSIdentifier)var6_6.getValue(var11_17)).getDSSPath() + "  Defined Prob.", var6_6.getProb(var11_17));
                        var14_23.add(var15_29);
                    }
                    break;
                }
                case 1: {
                    var8_10 = ((MCInputClippedDataVariable)var10_15).getAbsoluteDist();
                    if (var8_10 == null) break;
                    var6_6 = var8_10.getParamNames();
                    if (var8_10 instanceof MultiParametrizadDist) {
                        var7_7 /* !! */  = (MCInputVarRealizations)((MultiParametrizadDist)var8_10).getActiveParams();
                    } else if (var8_10 instanceof SeasonalContinuousDistribution && ((SeasonalContinuousDistribution)var8_10).getDist() instanceof MultiParametrizadDist) {
                        ((SeasonalContinuousDistribution)var8_10).setStartTime(var12_21.getRunTimeWindow().getStartTime());
                        var7_7 /* !! */  = (MCInputVarRealizations)((MultiParametrizadDist)((SeasonalContinuousDistribution)var8_10).getDist()).getActiveParams();
                    } else if (var8_10 instanceof SeasonalContinuousDistribution) {
                        ((SeasonalContinuousDistribution)var8_10).setStartTime(var12_21.getRunTimeWindow().getStartTime());
                        var7_7 /* !! */  = (MCInputVarRealizations)((SeasonalContinuousDistribution)var8_10).getDist().getParamVals();
                    } else {
                        var7_7 /* !! */  = (MCInputVarRealizations)var8_10.getParamVals();
                    }
                    for (var11_18 = 0; var11_18 < ((Cloneable)var6_6).length; ++var11_18) {
                        var15_30 = new MCScalarOutput("Rule Parameter - " + var8_10.getType() + " - " + (String)var6_6[var11_18], (double)var7_7 /* !! */ [var11_18]);
                        var14_23.add(var15_30);
                    }
                    var8_10 = ((MCInputClippedDataVariable)var10_15).getClipDist();
                    var6_6 = var8_10.getClipParamNames();
                    var7_7 /* !! */  = (MCInputVarRealizations)var8_10.getClipParamVals();
                    for (var11_18 = 0; var11_18 < ((Cloneable)var6_6).length; ++var11_18) {
                        var15_31 = new MCScalarOutput("Rule Parameter - Clip " + (String)var6_6[var11_18], (double)var7_7 /* !! */ [var11_18]);
                        var14_23.add(var15_31);
                    }
                    break;
                }
                case 2: {
                    var8_11 = ((MCInputClippedDataVariable)var10_15).getAbsoluteDist();
                    if (var8_11 == null) break;
                    var6_6 = var8_11.getParamNames();
                    if (var8_11 instanceof MultiParametrizadDist) {
                        var7_7 /* !! */  = (MCInputVarRealizations)((MultiParametrizadDist)var8_11).getActiveParams();
                    } else if (var8_11 instanceof SeasonalContinuousDistribution && ((SeasonalContinuousDistribution)var8_11).getDist() instanceof MultiParametrizadDist) {
                        ((SeasonalContinuousDistribution)var8_11).setStartTime(var12_21.getRunTimeWindow().getStartTime());
                        var7_7 /* !! */  = (MCInputVarRealizations)((MultiParametrizadDist)((SeasonalContinuousDistribution)var8_11).getDist()).getActiveParams();
                    } else if (var8_11 instanceof SeasonalContinuousDistribution) {
                        ((SeasonalContinuousDistribution)var8_11).setStartTime(var12_21.getRunTimeWindow().getStartTime());
                        var7_7 /* !! */  = (MCInputVarRealizations)((SeasonalContinuousDistribution)var8_11).getDist().getParamVals();
                    } else {
                        var7_7 /* !! */  = (MCInputVarRealizations)var8_11.getParamVals();
                    }
                    for (var11_19 = 0; var11_19 < ((Cloneable)var6_6).length; ++var11_19) {
                        var15_32 = new MCScalarOutput("Lookback Value - " + var8_11.getType() + " - " + (String)var6_6[var11_19], (double)var7_7 /* !! */ [var11_19]);
                        var14_23.add(var15_32);
                    }
                    var8_11 = ((MCInputClippedDataVariable)var10_15).getClipDist();
                    var6_6 = var8_11.getClipParamNames();
                    var7_7 /* !! */  = (MCInputVarRealizations)var8_11.getClipParamVals();
                    for (var11_19 = 0; var11_19 < ((Cloneable)var6_6).length; ++var11_19) {
                        var15_33 = new MCScalarOutput("Lookback Value - Clip " + (String)var6_6[var11_19], (double)var7_7 /* !! */ [var11_19]);
                        var14_23.add(var15_33);
                    }
                    break;
                }
                case 4: {
                    var8_12 = ((MCInputClippedDataVariable)var10_15).getAbsoluteDist();
                    if (var8_12 == null) break;
                    var6_6 = var8_12.getParamNames();
                    if (var8_12 instanceof MultiParametrizadDist) {
                        var7_7 /* !! */  = (MCInputVarRealizations)((MultiParametrizadDist)var8_12).getActiveParams();
                    } else if (var8_12 instanceof SeasonalContinuousDistribution && ((SeasonalContinuousDistribution)var8_12).getDist() instanceof MultiParametrizadDist) {
                        ((SeasonalContinuousDistribution)var8_12).setStartTime(var12_21.getRunTimeWindow().getStartTime());
                        var7_7 /* !! */  = (MCInputVarRealizations)((MultiParametrizadDist)((SeasonalContinuousDistribution)var8_12).getDist()).getActiveParams();
                    } else if (var8_12 instanceof SeasonalContinuousDistribution) {
                        ((SeasonalContinuousDistribution)var8_12).setStartTime(var12_21.getRunTimeWindow().getStartTime());
                        var7_7 /* !! */  = (MCInputVarRealizations)((SeasonalContinuousDistribution)var8_12).getDist().getParamVals();
                    } else {
                        var7_7 /* !! */  = (MCInputVarRealizations)var8_12.getParamVals();
                    }
                    for (var11_20 = 0; var11_20 < ((Cloneable)var6_6).length; ++var11_20) {
                        var15_34 = new MCScalarOutput("Time Series Multiplier - " + var8_12.getType() + " - " + (String)var6_6[var11_20], (double)var7_7 /* !! */ [var11_20]);
                        var14_23.add(var15_34);
                    }
                    var8_12 = ((MCInputClippedDataVariable)var10_15).getClipDist();
                    var6_6 = var8_12.getClipParamNames();
                    var7_7 /* !! */  = (MCInputVarRealizations)var8_12.getClipParamVals();
                    for (var11_20 = 0; var11_20 < ((Cloneable)var6_6).length; ++var11_20) {
                        var15_35 = new MCScalarOutput("Time Series Multiplier - Clip " + (String)var6_6[var11_20], (double)var7_7 /* !! */ [var11_20]);
                        var14_23.add(var15_35);
                    }
                    break;
                }
            }
            var6_6 = var14_23;
            var9_14.setScalarOutputters((List<ScalarOutputter>)var6_6);
            var4_4.add(var9_14);
        }
        for (var5_5 = 0; var5_5 < var1_1 /* !! */ .n.size(); ++var5_5) {
            var6_6 = var1_1 /* !! */ .n.get(var5_5);
            if (!var6_6.isActive()) continue;
            var7_7 /* !! */  = var1_1 /* !! */ .y.get(var5_5);
            if (var6_6 == null || var7_7 /* !! */  == null || (var8_13 /* !! */  = var7_7 /* !! */ .getRandomTable()) == null) continue;
            v3 = var8_13 /* !! */ .getAll();
            var8_13 /* !! */  = (DoubleRandomTable)v3;
            if (v3 == null) continue;
            var9_14 = MCAltPluginData.a((double[])var8_13 /* !! */ , (MCVarRealizations)var7_7 /* !! */ , var6_6.getParamId());
            var9_14 = new MCDisplayVar("Output Variable", var7_7 /* !! */ .getName(), var6_6.getParamId(), (List<PairedDataContainer>)var9_14);
            var9_14.setDescription("");
            var10_15 = MCAltPluginData.a((MCOutputVariable)var6_6, (MCOutputVarRealizations)var7_7 /* !! */ , true, true);
            var9_14.setScalarOutputters((List<ScalarOutputter>)var10_15);
            var4_4.add(var9_14);
        }
        var1_1 /* !! */  = var4_4;
        if (var1_1 /* !! */ .size() <= 0) {
            return false;
        }
        var1_1 /* !! */  = new MCAltPluginData$4(this, (List)var1_1 /* !! */ );
        var1_1 /* !! */ .setVisible(true);
        return true;
    }

    public boolean displayConvPlot(RssRun object) {
        if (!this.z) {
            int n = 0;
            try {
                n = this.getSimulationOption();
                this.setSimulationOption(0);
                if (this.b((RssRun)object) != 0) {
                    System.out.println("Monte Carlo Conv Variable Data not found.");
                    return false;
                }
            }
            finally {
                this.setSimulationOption(n);
            }
            MCAltPluginData mCAltPluginData = this;
            mCAltPluginData.a(mCAltPluginData.getLastIterationComputed());
        }
        object = this;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < object.n.size(); ++i) {
            double[][] dArray;
            double[] dArray2;
            double[] dArray3;
            Object object2;
            Object object3 = object.n.get(i);
            MCOutputVarRealizations mCOutputVarRealizations = object.y.get(i);
            if (object3 == null || mCOutputVarRealizations == null || !((MCOutputVariable)object3).hasConv() || (object2 = mCOutputVarRealizations.getRandomTable()) == null) continue;
            double[] dArray4 = object2.getAll();
            object2 = dArray4;
            if (dArray4 == null) continue;
            MCOutputVarRealizations mCOutputVarRealizations2 = mCOutputVarRealizations;
            object2 = object3;
            int n = ClientApp.Workspace().getUnitSystem();
            ArrayList<PairedDataContainer> arrayList2 = new ArrayList<PairedDataContainer>();
            Object object4 = mCOutputVarRealizations2.getRandomTable();
            if (object4 == null) {
                dArray3 = new double[]{};
                dArray2 = new double[]{};
                dArray = new double[2][0];
                object4 = new double[0];
            } else {
                dArray3 = object4.getAll();
                dArray2 = object4.getAllAvg();
                dArray = object4.getAllConfidenceInterval(((MCOutputVariable)object2).getConfidence() / 100.0);
                object4 = object4.getAllBoundRelErrorOfMean(((MCOutputVariable)object2).getConfidence() / 100.0);
            }
            int n2 = dArray3.length;
            double[] dArray5 = new double[n2];
            double[] dArray6 = new double[n2];
            double[] dArray7 = new double[n2];
            double[] dArray8 = new double[n2];
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n3;
                dArray5[n4] = (double)n4 + 1.0;
                dArray6[n3] = ((MCOutputVariable)object2).getRelTol();
                dArray7[n3] = dArray2[n3] * (1.0 - ((MCOutputVariable)object2).getRelTol() / 100.0);
                dArray8[n3] = dArray2[n3] * (1.0 + ((MCOutputVariable)object2).getRelTol() / 100.0);
                Object object5 = object4;
                int n5 = n3++;
                object5[n5] = object5[n5] * 100.0;
            }
            DSSIdentifier dSSIdentifier = mCOutputVarRealizations2.getDSSId();
            PairedDataContainer pairedDataContainer = new PairedDataContainer();
            new PairedDataContainer().numberCurves = 1;
            pairedDataContainer.numberOrdinates = n2;
            pairedDataContainer.xOrdinates = dArray5;
            pairedDataContainer.yOrdinates = new double[][]{dArray3};
            pairedDataContainer.labels = new String[]{mCOutputVarRealizations2.getName()};
            pairedDataContainer.labelsUsed = true;
            pairedDataContainer.fileName = dSSIdentifier.getFileName();
            pairedDataContainer.fullName = dSSIdentifier.getDSSPath();
            int n6 = ((MCOutputVariable)object2).getParamId();
            pairedDataContainer.xtype = "";
            pairedDataContainer.ytype = "";
            pairedDataContainer.xunits = "";
            pairedDataContainer.yunits = " " + Parameter.getUnitsStringForSystem((int)n6, (int)n);
            pairedDataContainer.xparameter = "Realization";
            pairedDataContainer.yparameter = ParameterLookup.getFullParamString((int)n6);
            arrayList2.add(pairedDataContainer);
            pairedDataContainer = new PairedDataContainer();
            new PairedDataContainer().numberCurves = 5;
            pairedDataContainer.numberOrdinates = n2;
            pairedDataContainer.xOrdinates = dArray5;
            pairedDataContainer.yOrdinates = new double[][]{dArray2, dArray7, dArray8, dArray[0], dArray[1]};
            pairedDataContainer.labels = new String[]{"Running Average", "Lower Tolerance", "Upper Tolerance", "Lower Est. Error", "Upper Est Error"};
            pairedDataContainer.labelsUsed = true;
            pairedDataContainer.fileName = dSSIdentifier.getFileName();
            pairedDataContainer.fullName = dSSIdentifier.getDSSPath();
            int n7 = ((MCOutputVariable)object2).getParamId();
            pairedDataContainer.xtype = "";
            pairedDataContainer.ytype = "";
            pairedDataContainer.xunits = "";
            pairedDataContainer.yunits = Parameter.getUnitsStringForSystem((int)n7, (int)n);
            pairedDataContainer.xparameter = "Realization";
            pairedDataContainer.yparameter = ParameterLookup.getFullParamString((int)n7);
            arrayList2.add(pairedDataContainer);
            pairedDataContainer = new PairedDataContainer();
            new PairedDataContainer().numberCurves = 2;
            pairedDataContainer.numberOrdinates = n2;
            pairedDataContainer.xOrdinates = dArray5;
            pairedDataContainer.yOrdinates = new double[][]{dArray6, (double[])object4};
            pairedDataContainer.labels = new String[]{"Tolerance", "Rel. Error"};
            pairedDataContainer.labelsUsed = true;
            pairedDataContainer.fileName = dSSIdentifier.getFileName();
            pairedDataContainer.fullName = dSSIdentifier.getDSSPath();
            n7 = Parameter.PARAMID_PERCENT;
            pairedDataContainer.xtype = "";
            pairedDataContainer.ytype = "";
            pairedDataContainer.xunits = "";
            pairedDataContainer.yunits = "Percent";
            pairedDataContainer.xparameter = "Realization";
            pairedDataContainer.yparameter = ParameterLookup.getFullParamString((int)n7);
            arrayList2.add(pairedDataContainer);
            object2 = arrayList2;
            object2 = new MCDisplayVar(MCVAR_TYPE_OUTPUT, mCOutputVarRealizations.getName(), ((MCOutputVariable)object3).getParamId(), (List<PairedDataContainer>)object2);
            ((MCDisplayVar)object2).setDescription("");
            object3 = MCAltPluginData.a((MCOutputVariable)object3, mCOutputVarRealizations, true, false);
            ((MCDisplayVar)object2).setScalarOutputters((List<ScalarOutputter>)object3);
            arrayList.add(object2);
        }
        if (arrayList.size() <= 0) {
            return false;
        }
        object = new ScalarOutputDialog(arrayList, null);
        object.setSize(object.getWidth() + 100, object.getHeight() + 200);
        object.setVisible(true);
        return true;
    }

    public List<String> getCollectionNumbers(RssAlt rssAlt, HecTime hecTime) {
        return null;
    }

    public void outputReport(AlternativeInputReport alternativeInputReport, Element element) {
    }

    public void setMCScripts(String string, String string2, String string3, boolean bl) {
        if (bl) {
            this.u = new MCSampleScripts(bl);
            this.u.setInitScript(string);
            this.u.setMainScript(string2);
            this.u.setCleanupScript(string3);
            return;
        }
        this.v = new MCSampleScripts(bl);
        this.v.setInitScript(string);
        this.v.setMainScript(string2);
        this.v.setCleanupScript(string3);
    }

    public void setMCScripts(MCSampleScripts mCSampleScripts, boolean bl) {
        if (bl) {
            this.u = mCSampleScripts;
            return;
        }
        this.v = mCSampleScripts;
    }

    public MCSampleScripts getMCScripts(boolean bl) {
        if (bl) {
            return this.u;
        }
        return this.v;
    }

    public Map<String, CorrelationMatrix> getCorrelationMap() {
        return this.w;
    }

    public Map<String, CorrelationMatrix> copyCorrelationMap() {
        HashMap<String, CorrelationMatrix> hashMap = new HashMap<String, CorrelationMatrix>();
        for (String string : this.w.keySet()) {
            hashMap.put(string, new CorrelationMatrix());
            hashMap.get(string).setCorrelationSetName(string);
            hashMap.get(string).setVariables(this.w.get(string).getVariables());
            for (String string2 : this.w.get(string).getCorMatrix().keySet()) {
                hashMap.get(string).getCorMatrix().put(string2, (Map)this.w.get(string).getCorMatrix().get(string2));
            }
        }
        return hashMap;
    }

    public void setCorrelationMap(Map<String, CorrelationMatrix> map) {
        this.w.clear();
        for (String string : map.keySet()) {
            this.w.put(string, new CorrelationMatrix());
            this.w.get(string).setCorrelationSetName(string);
            this.w.get(string).setVariables(map.get(string).getVariables());
            for (String string2 : map.get(string).getCorMatrix().keySet()) {
                this.w.get(string).getCorMatrix().put(string2, (Map)map.get(string).getCorMatrix().get(string2));
            }
        }
    }

    public void setScriptFileName(String string) {
        this.x = string;
    }

    public Double getInputVariableVariate(String string) {
        for (MCInputVariableImpl mCInputVariableImpl : this.m) {
            if (!mCInputVariableImpl.getShortName().equals(string)) continue;
            return mCInputVariableImpl.getVariate();
        }
        return null;
    }

    public Double getInputVariableVariate(String string, String string2, String string3) {
        for (MCInputVariableImpl mCInputVariableImpl : this.m) {
            if (!mCInputVariableImpl.getVariableName().equals(string) || !mCInputVariableImpl.getLocation().equals(string2) || !mCInputVariableImpl.getParameter().equals(string3)) continue;
            return mCInputVariableImpl.getVariate();
        }
        return null;
    }

    public MCInputVariableImpl getInputVariable(String string, String string2, String string3) {
        for (MCInputVariableImpl mCInputVariableImpl : this.m) {
            if (mCInputVariableImpl instanceof MCInputScriptVariable && ((MCInputScriptVariable)mCInputVariableImpl).getDescription().equals(string) && mCInputVariableImpl.getLocation().equals(string2) && mCInputVariableImpl.getParameter().equals(string3)) {
                return mCInputVariableImpl;
            }
            if (!mCInputVariableImpl.getVariableName().equals(string) || !mCInputVariableImpl.getLocation().equals(string2) || !mCInputVariableImpl.getParameter().equals(string3)) continue;
            return mCInputVariableImpl;
        }
        return null;
    }

    public List<MCInputVariableImpl> getVariableListForClassName(Class clazz) {
        ArrayList<MCInputVariableImpl> arrayList = new ArrayList<MCInputVariableImpl>();
        for (MCInputVariableImpl mCInputVariableImpl : this.m) {
            if (!mCInputVariableImpl.getClass().toString().contains(clazz.toString())) continue;
            arrayList.add(mCInputVariableImpl);
        }
        return arrayList;
    }

    public boolean hasAlt() {
        return this.a != null;
    }

    public void setAlt(RssAlt rssAlt) {
        File file;
        if (this.a != null && rssAlt != null && this.x != null && !this.x.equals("null") && (file = new File(this.a.makeAbsolutePath(this.x))).exists()) {
            Object object = rssAlt.getName();
            int n = rssAlt.getName().indexOf(":");
            if (n > 0) {
                object = ((String)object).substring(0, n);
            } else if (n == 0) {
                object = ((String)object).substring(1, rssAlt.getName().length());
            }
            object = (String)object + ".mcscripts";
            Object object2 = rssAlt.makeAbsolutePath(this.x);
            object2 = ((String)object2).substring(0, ((String)object2).lastIndexOf("/") + 1) + (String)object;
            object = new File((String)object2);
            this.x = rssAlt.getRelativePath((String)object2);
            try {
                Files.copy(file.toPath(), ((File)object).toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException iOException) {
                ((FluentLogger.Api)b.atInfo()).log("Unable to copy script file for alt %s from %s to %s. Error: %s", (Object)rssAlt.getName(), (Object)file.getAbsolutePath(), (Object)((File)object).getAbsolutePath(), (Object)iOException.toString());
            }
        }
        super.setAlt(rssAlt);
    }
}

