/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.model;

import com.google.common.flogger.FluentLogger;
import hec.model.SeasonalRecord;
import hec.rss.model.RssAlt;
import hec.rss.plugins.factories.AltPluginDataFactory;
import hec.rss.plugins.montecarlo.model.MCAltPluginData;
import hec.rss.plugins.montecarlo.model.MCInputStochasticVariableImpl;
import hec.rss.plugins.montecarlo.model.SeasonalContinuousDistribution;
import hec.statistics.AbstractContDist;
import hec.statistics.ClipData;
import hec.statistics.ClipDist;
import hec.statistics.EmpiricalClipDist;
import hec.statistics.EmpiricalDist;
import hec.statistics.GammaClipDist;
import hec.statistics.Log10NormalB17BClipDist;
import hec.statistics.LogNormalClipDist;
import hec.statistics.LogNormalDist;
import hec.statistics.MultiParametrizadDist;
import hec.statistics.NormalClipDist;
import hec.statistics.TriangClipDist;
import hec.statistics.UnifClipDist;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import rma.util.RMAIO;

public class MCInputClippedDataVariable
extends MCInputStochasticVariableImpl {
    private static final FluentLogger c = FluentLogger.forEnclosingClass();
    protected static final String a = "ClipDistStart";
    protected int b = -1;
    private ClipDist d;

    public MCInputClippedDataVariable(String string, String string2, int n) {
        super(string, string2, -1, n);
    }

    @Override
    public int getType() {
        return this.b;
    }

    @Override
    protected boolean a(String string, String string2, BufferedReader bufferedReader) {
        if (super.a(string, string2, bufferedReader)) {
            return true;
        }
        if (string.equals(a) && string2 != null) {
            if (string2.contains(NormalClipDist.class.getSimpleName())) {
                this.d = new NormalClipDist();
            } else if (string2.contains(UnifClipDist.class.getSimpleName())) {
                this.d = new UnifClipDist();
            } else if (string2.contains(TriangClipDist.class.getSimpleName())) {
                this.d = new TriangClipDist();
            } else if (string2.contains(LogNormalClipDist.class.getSimpleName())) {
                this.d = new LogNormalClipDist();
            } else if (string2.contains(Log10NormalB17BClipDist.class.getSimpleName())) {
                this.d = new Log10NormalB17BClipDist();
            } else if (string2.contains(GammaClipDist.class.getSimpleName())) {
                this.d = new GammaClipDist();
            } else if (string2.contains(EmpiricalClipDist.class.getSimpleName())) {
                this.d = new EmpiricalClipDist();
            } else if (string2.contains(SeasonalContinuousDistribution.class.getSimpleName())) {
                this.d = new SeasonalContinuousDistribution();
            }
            if (this.d != null) {
                this.d.read(bufferedReader);
            } else {
                ((FluentLogger.Api)c.atSevere()).log("Failed to find Distribution Type for : " + string2);
            }
            return true;
        }
        return false;
    }

    @Override
    public void writeParameters(BufferedWriter bufferedWriter) {
        super.writeParameters(bufferedWriter);
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("ClipDistStart:" + this.d.getClass().getName()));
        this.d.write(bufferedWriter);
    }

    @Override
    public MCInputClippedDataVariable clone() {
        MCInputClippedDataVariable mCInputClippedDataVariable = (MCInputClippedDataVariable)super.clone();
        ((MCInputClippedDataVariable)super.clone()).d = (ClipDist)this.d.clone();
        return mCInputClippedDataVariable;
    }

    public ClipDist getClipDist() {
        return this.d;
    }

    @Override
    public AbstractContDist getDist() {
        return (AbstractContDist)this.d;
    }

    public void setClipDist(ClipDist clipDist) {
        this.d = clipDist;
        this.i = (AbstractContDist)clipDist;
    }

    @Override
    public String getClassName() {
        return "MCInputLookbackVariable";
    }

    @Override
    public boolean applyRealization(double d) {
        return true;
    }

    @Override
    public boolean initInputVariable(RssAlt rssAlt) {
        return false;
    }

    @Override
    public boolean checkWarnings(String[] stringArray, RssAlt rssAlt) {
        return true;
    }

    @Override
    public void convertToRelative(Double object) {
        double[] dArray;
        if (this.isSeasonal()) {
            ((SeasonalContinuousDistribution)this.d).a((Double)object);
            return;
        }
        String[] stringArray = this.getClipDist().getParamNames();
        if (((MCInputStochasticVariableImpl)this).getDist() instanceof EmpiricalDist) {
            dArray = ((EmpiricalDist)((MCInputStochasticVariableImpl)this).getDist()).getValues();
            stringArray = new String[dArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = "";
            }
        } else {
            dArray = ((MCInputStochasticVariableImpl)this).getDist().getParamVals();
        }
        Class[] classArray = new Class[dArray.length];
        Object[] objectArray = new Object[dArray.length];
        ClipData clipData = this.d.getClipData();
        double d = clipData.getMaxVal();
        double d2 = clipData.getMinVal();
        clipData.setMaxVal(Double.POSITIVE_INFINITY);
        clipData.setMinVal(Double.NEGATIVE_INFINITY);
        double d3 = 100.0;
        if (((MCInputStochasticVariableImpl)this).getDist() instanceof LogNormalDist) {
            d3 = Math.log(100.0);
        }
        d = d / (Double)object * d3;
        d2 = d2 / (Double)object * d3;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(stringArray[i].contains("Shape") || stringArray[i].contains("Skew") || stringArray[i].contains("Freedom"))) {
                dArray[i] = dArray[i] / (Double)object * d3;
            }
            classArray[i] = Double.TYPE;
            objectArray[i] = dArray[i];
        }
        if (((MCInputStochasticVariableImpl)this).getDist() instanceof EmpiricalDist) {
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray2[0] = ((EmpiricalDist)((MCInputStochasticVariableImpl)this).getDist()).getCumProbs();
            objectArray[1] = dArray;
            Class[] classArray2 = new Class[2];
            classArray = classArray2;
            classArray2[0] = double[].class;
            classArray[1] = double[].class;
        }
        ClipData clipData2 = ((MCInputStochasticVariableImpl)this).getDist().getClass();
        try {
            object = clipData2.getConstructor(classArray);
            this.i = (AbstractContDist)((Constructor)object).newInstance(objectArray);
            this.d = (ClipDist)((Constructor)object).newInstance(objectArray);
            clipData2 = this.d.getClipData();
            clipData2.setMaxVal(d);
            clipData2.setMinVal(d2);
            return;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            object = exception;
            exception.printStackTrace();
            return;
        }
    }

    @Override
    public void convertToAbsolute(Double[] object) {
        double[] dArray;
        if (this.isSeasonal()) {
            ((SeasonalContinuousDistribution)this.d).a((Double[])object);
            return;
        }
        String[] stringArray = ((MCInputStochasticVariableImpl)this).getDist().getParamNames();
        if (((MCInputStochasticVariableImpl)this).getDist() instanceof EmpiricalDist) {
            dArray = ((EmpiricalDist)((MCInputStochasticVariableImpl)this).getDist()).getValues();
            stringArray = new String[dArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = "";
            }
        } else {
            dArray = ((MCInputStochasticVariableImpl)this).getDist().getParamVals();
        }
        double d = 100.0;
        if (((MCInputStochasticVariableImpl)this).getDist() instanceof LogNormalDist) {
            object[0] = Math.log(object[0]);
            d = Math.log(100.0);
        }
        Class[] classArray = new Class[dArray.length];
        Object[] objectArray = new Object[dArray.length];
        ClipData clipData = this.d.getClipData();
        double d2 = clipData.getMaxVal();
        double d3 = clipData.getMinVal();
        clipData.setMaxVal(Double.POSITIVE_INFINITY);
        clipData.setMinVal(Double.NEGATIVE_INFINITY);
        d2 = d2 / d * object[0];
        d3 = d3 / d * object[0];
        for (int i = 0; i < dArray.length; ++i) {
            if (!(stringArray[i].contains("Shape") || stringArray[i].contains("Skew") || stringArray[i].contains("Freedom"))) {
                dArray[i] = dArray[i] / d * (Double)object[0];
            }
            classArray[i] = Double.TYPE;
            objectArray[i] = dArray[i];
        }
        if (((MCInputStochasticVariableImpl)this).getDist() instanceof EmpiricalDist) {
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray2[0] = ((EmpiricalDist)((MCInputStochasticVariableImpl)this).getDist()).getCumProbs();
            objectArray[1] = dArray;
            Class[] classArray2 = new Class[2];
            classArray = classArray2;
            classArray2[0] = double[].class;
            classArray[1] = double[].class;
        }
        ClipData clipData2 = ((MCInputStochasticVariableImpl)this).getDist().getClass();
        try {
            object = clipData2.getConstructor(classArray);
            this.i = (AbstractContDist)((Constructor)object).newInstance(objectArray);
            this.d = (ClipDist)((Constructor)object).newInstance(objectArray);
            clipData2 = this.d.getClipData();
            clipData2.setMaxVal(d2);
            clipData2.setMinVal(d3);
            return;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            object = exception;
            exception.printStackTrace();
            return;
        }
    }

    public ClipDist getAbsoluteDist(Double[] clipDist) {
        double[] dArray;
        if (!this.isRelative()) {
            return (ClipDist)this.d.clone();
        }
        if (this.isSeasonal()) {
            SeasonalContinuousDistribution seasonalContinuousDistribution = (SeasonalContinuousDistribution)((Object)this.d.clone());
            seasonalContinuousDistribution.a((Double[])clipDist);
            return seasonalContinuousDistribution;
        }
        String[] stringArray = ((MCInputStochasticVariableImpl)this).getDist().getParamNames();
        if (((MCInputStochasticVariableImpl)this).getDist() instanceof EmpiricalDist) {
            dArray = ((EmpiricalDist)((MCInputStochasticVariableImpl)this).getDist()).getValues();
            stringArray = new String[dArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = "";
            }
        } else {
            dArray = ((MCInputStochasticVariableImpl)this).getDist() instanceof MultiParametrizadDist ? ((MultiParametrizadDist)((MCInputStochasticVariableImpl)this).getDist()).getParams2() : ((MCInputStochasticVariableImpl)this).getDist().getParamVals();
        }
        Class[] classArray = new Class[dArray.length];
        Object[] objectArray = new Object[dArray.length];
        ClipData clipData = (ClipData)this.d.getClipData().clone();
        double d = clipData.getMaxVal();
        double d2 = clipData.getMinVal();
        clipData.setMaxVal(Double.POSITIVE_INFINITY);
        clipData.setMinVal(Double.NEGATIVE_INFINITY);
        d = d / 100.0 * clipDist[0];
        d2 = d2 / 100.0 * clipDist[0];
        for (int i = 0; i < dArray.length; ++i) {
            if (!(stringArray[i].contains("Shape") || stringArray[i].contains("Skew") || stringArray[i].contains("Freedom"))) {
                dArray[i] = dArray[i] / 100.0 * clipDist[0].doubleValue();
            }
            classArray[i] = Double.TYPE;
            objectArray[i] = dArray[i];
        }
        if (((MCInputStochasticVariableImpl)this).getDist() instanceof EmpiricalDist) {
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray2[0] = ((EmpiricalDist)((MCInputStochasticVariableImpl)this).getDist()).getCumProbs();
            objectArray[1] = dArray;
            Class[] classArray2 = new Class[2];
            classArray = classArray2;
            classArray2[0] = double[].class;
            classArray[1] = double[].class;
        }
        ClipData clipData2 = ((MCInputStochasticVariableImpl)this).getDist().getClass();
        try {
            clipDist = clipData2.getConstructor(classArray);
            clipDist = (ClipDist)clipDist.newInstance(objectArray);
            if (((MCInputStochasticVariableImpl)this).getDist() instanceof MultiParametrizadDist) {
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = (Double)objectArray[i];
                }
                ((MultiParametrizadDist)clipDist).setParams2(dArray);
                ((MultiParametrizadDist)clipDist).setParametrizationNumber(((MultiParametrizadDist)((MCInputStochasticVariableImpl)this).getDist()).getParametrizationNumber());
            }
            clipData2 = clipDist.getClipData();
            clipData2.setMaxClip(this.d.getClipData().hasMaxClip());
            clipData2.setMaxVal(d);
            clipData2.setMinClip(this.d.getClipData().hasMinClip());
            clipData2.setMinVal(d2);
            if (((MCInputStochasticVariableImpl)this).getDist() instanceof EmpiricalDist && ((EmpiricalDist)((MCInputStochasticVariableImpl)this).getDist()).getInterpType() == EmpiricalDist.InterpType.STEP) {
                ((EmpiricalClipDist)clipDist).setInterpType(EmpiricalDist.InterpType.STEP);
            }
            return clipDist;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            clipDist = exception;
            exception.printStackTrace();
            return null;
        }
    }

    protected void a(SeasonalRecord seasonalRecord) {
        ((SeasonalContinuousDistribution)this.d).a(seasonalRecord);
    }

    protected ClipDist b(SeasonalRecord seasonalRecord) {
        if (!this.isRelative()) {
            return (ClipDist)this.d.clone();
        }
        ClipDist clipDist = (ClipDist)this.d.clone();
        ((SeasonalContinuousDistribution)clipDist).a(seasonalRecord);
        return clipDist;
    }

    protected void c(SeasonalRecord seasonalRecord) {
        ((SeasonalContinuousDistribution)this.d).b(seasonalRecord);
    }

    @Override
    public ClipDist getAbsoluteDist() {
        return null;
    }

    public Double getRelativeValue(Double d, RssAlt rssAlt) {
        return null;
    }

    @Override
    public void setDependentDistParams(RssAlt object) {
        object = (MCAltPluginData)object.getAltPluginData(AltPluginDataFactory.MC);
        if (this.isSeasonal()) {
            return;
        }
        double[] dArray = ((MCInputStochasticVariableImpl)this).getDist() instanceof MultiParametrizadDist ? ((MultiParametrizadDist)((MCInputStochasticVariableImpl)this).getDist()).getParams2() : ((MCInputStochasticVariableImpl)this).getDist().getParamVals();
        Class[] classArray = new Class[dArray.length];
        Object[] objectArray = new Object[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            classArray[i] = Double.TYPE;
            if (this.p.keySet().contains(i)) {
                objectArray[i] = this.a(((MCAltPluginData)((Object)object)).getInputVariables(), this.p.get(i));
                if (objectArray[i] != null) continue;
            }
            objectArray[i] = dArray[i];
        }
        Class<?> clazz = ((MCInputStochasticVariableImpl)this).getDist().getClass();
        try {
            object = clazz.getConstructor(classArray);
            object = (ClipDist)((Constructor)object).newInstance(objectArray);
            if (((MCInputStochasticVariableImpl)this).getDist() instanceof MultiParametrizadDist) {
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = (Double)objectArray[i];
                }
                ((MultiParametrizadDist)object).setParams2(dArray);
            }
            object.getClipData().setMaxVal(this.d.getClipData().getMaxVal());
            object.getClipData().setMinVal(this.d.getClipData().getMinVal());
            this.d = object;
            return;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            object = exception;
            exception.printStackTrace();
            return;
        }
    }
}

