/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.model;

import hec.rss.model.HindcastData;
import hec.rss.model.RssAlt;
import hec.rss.model.RssModelVariableSet;
import hec.rss.plugins.montecarlo.model.MCInputClippedDataVariable;
import hec.rss.plugins.montecarlo.model.MCInputStochasticVariableImpl;
import hec.rss.plugins.montecarlo.model.MCInputVariableImpl;
import hec.rss.plugins.montecarlo.model.SeasonalContinuousDistribution;
import hec.statistics.ClipDist;
import java.util.Vector;

public class MCInputLookbackVariable
extends MCInputClippedDataVariable {
    private HindcastData c;
    private double d;

    public MCInputLookbackVariable(String string, String string2, int n) {
        super(string, string2, n);
        this.assignValue(new HindcastData());
        this.b = 2;
    }

    @Override
    public MCInputLookbackVariable clone() {
        MCInputLookbackVariable mCInputLookbackVariable = (MCInputLookbackVariable)super.clone();
        return mCInputLookbackVariable;
    }

    @Override
    public String getClassName() {
        return "MCInputLookbackVariable";
    }

    @Override
    public boolean initInputVariable(RssAlt rssAlt) {
        Vector vector = rssAlt.getHindcastData();
        rssAlt = rssAlt.getSystem();
        this.d = 0.0;
        try {
            for (int i = 0; i < vector.size(); ++i) {
                HindcastData hindcastData = (HindcastData)vector.elementAt(i);
                if (hindcastData == null || !rssAlt.getNameForKeyString(hindcastData.getObjectKey()).equals(this.getLocation()) || !RssModelVariableSet.getVariableName((int)hindcastData.getVariableId()).equals(this.getParameter())) continue;
                this.assignValue(hindcastData);
                this.d = this.getHCData().getValue();
                break;
            }
        }
        catch (Exception exception) {
            System.out.println("Could not initialize the hindcast data for the lookback variable. " + exception.getMessage());
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public HindcastData getHCData() {
        return this.c;
    }

    @Override
    public boolean applyRealization(double d) {
        ClipDist clipDist;
        if (!this.p.isEmpty()) {
            MCInputLookbackVariable mCInputLookbackVariable = this;
            mCInputLookbackVariable.setDependentDistParams(mCInputLookbackVariable.q);
        }
        if ((clipDist = this.isRelative() ? ((MCInputStochasticVariableImpl)this).getAbsoluteDist() : (ClipDist)this.getClipDist().clone()) instanceof SeasonalContinuousDistribution) {
            ((SeasonalContinuousDistribution)clipDist).setStartTime(this.q.getSystem().getRssRun().getRunTimeWindow().getStartTime());
        }
        double d2 = clipDist.invCDF(d);
        ((MCInputVariableImpl)this).setVariate(d2);
        this.c.setValue(d2);
        return true;
    }

    @Override
    public ClipDist getAbsoluteDist() {
        if (this.q != null) {
            MCInputLookbackVariable mCInputLookbackVariable = this;
            ((MCInputVariableImpl)mCInputLookbackVariable).initInputVariable(mCInputLookbackVariable.q);
        }
        return this.getAbsoluteDist(new Double[]{this.d});
    }

    public boolean assignValue(HindcastData hindcastData) {
        this.c = hindcastData;
        return true;
    }

    @Override
    public boolean restoreInputVariable(Object ... objectArray) {
        this.c.setValue(this.d);
        return true;
    }

    @Override
    public boolean checkErrors(String[] stringArray) {
        return super.checkErrors(stringArray);
    }

    @Override
    public boolean checkWarnings(String[] stringArray, RssAlt rssAlt) {
        this.q = rssAlt;
        super.checkWarnings(stringArray, rssAlt);
        ((MCInputVariableImpl)this).initInputVariable(rssAlt);
        rssAlt = this.isRelative() ? ((MCInputStochasticVariableImpl)this).getAbsoluteDist() : (ClipDist)this.getClipDist().clone();
        String string = RssModelVariableSet.getVariableName((int)this.getHCData().getVariableId());
        String string2 = this.getLocation();
        double d = this.getHCData().getValue();
        double d2 = 0.5;
        if (this.isSeasonal()) {
            int n = ((SeasonalContinuousDistribution)rssAlt).getHecTimes().size();
            for (int i = 0; i < n; ++i) {
                double d3 = ((SeasonalContinuousDistribution)rssAlt).getDist(i).getCDF(d);
                if (!(Math.abs(0.5 - d3) > Math.abs(0.5 - d2))) continue;
                d2 = d3;
            }
        } else {
            d2 = rssAlt.getCDF(d);
        }
        return this.checkDistribution(d2, stringArray, string, string2);
    }

    @Override
    public Double getRelativeValue(Double d, RssAlt rssAlt) {
        ((MCInputVariableImpl)this).initInputVariable(rssAlt);
        return d / this.d * 100.0;
    }
}

