/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.model;

import hec.data.DataSetIllegalArgumentException;
import hec.data.Parameter;
import hec.data.Units;
import hec.io.PairedDataContainer;
import hec.model.PairedValues;
import hec.model.PairedValuesExt;
import hec.model.ValueSet;
import hec.rss.model.IndependentVariable;
import hec.rss.model.Junction;
import hec.rss.model.JunctionElement;
import hec.rss.model.RssAlt;
import hec.rss.model.RssRatingObject;
import hec.rss.model.RssSystem;
import hec.rss.plugins.montecarlo.model.MCAltPluginData;
import hec.rss.plugins.montecarlo.model.MCInputStochasticVariableImpl;
import hec.rss.plugins.montecarlo.model.MCInputVariableImpl;
import hec.statistics.ClipDist;
import hec.statistics.EmpiricalClipDist;
import hec.statistics.GammaClipDist;
import hec.statistics.LogNormalClipDist;
import hec.statistics.LogNormalDist;
import hec.statistics.NormalClipDist;
import hec.statistics.NormalDist;
import hec.statistics.TriangClipDist;
import hec.statistics.TriangDist;
import hec.statistics.UnifClipDist;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import rma.util.RMAIO;

public class MCInputRatingCurveVariable
extends MCInputStochasticVariableImpl {
    public static final Logger logger = Logger.getLogger(MCInputRatingCurveVariable.class.getName());
    private PairedValuesExt a;
    private String[] b;
    private Junction c;
    private PairedValuesExt d;

    public MCInputRatingCurveVariable(String string, int n, PairedValuesExt pairedValuesExt, String[] stringArray) {
        super(string, pairedValuesExt.getParamYString(), pairedValuesExt.getParamYId(), n);
        this.b = stringArray;
        this.a = pairedValuesExt;
        this.c = new Junction();
        this.d = new PairedValuesExt();
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    protected boolean a(String string, String string2, BufferedReader bufferedReader) {
        if (super.a(string, string2, bufferedReader)) {
            return true;
        }
        if (string.equals("RatingTableValues")) {
            this.a = this.deserializePVE(string2);
            return true;
        }
        if (string.equals("RatingTableLabels")) {
            this.a.setCurveLabels(MCInputRatingCurveVariable.a(string2));
            return true;
        }
        if (string.equals("RatingTableCurveLabels")) {
            this.b = MCInputRatingCurveVariable.a(string2);
            return true;
        }
        if (string.equals("DistributionStart")) {
            if (NormalClipDist.class.getName().contains(string2)) {
                this.i = new NormalClipDist();
            } else if (UnifClipDist.class.toString().contains(string2)) {
                this.i = new UnifClipDist();
            } else if (TriangClipDist.class.toString().contains(string2)) {
                this.i = new TriangClipDist();
            } else if (LogNormalClipDist.class.toString().contains(string2)) {
                this.i = new LogNormalDist();
            } else if (GammaClipDist.class.toString().contains(string2)) {
                this.i = new GammaClipDist();
            } else if (EmpiricalClipDist.class.toString().contains(string2)) {
                this.i = new EmpiricalClipDist();
            }
            return true;
        }
        if (string.equals("RatingTableXParam")) {
            try {
                string = new Parameter(string2);
                this.a.setParamXId(string.getParameterId());
            }
            catch (DataSetIllegalArgumentException dataSetIllegalArgumentException) {
                logger.log(Level.WARNING, "Caught DataSetIllegalArgumentException", dataSetIllegalArgumentException);
            }
            return true;
        }
        if (string.equals("RatingTableYParam")) {
            try {
                string = new Parameter(string2);
                this.a.setParamYId(string.getParameterId());
            }
            catch (DataSetIllegalArgumentException dataSetIllegalArgumentException) {
                logger.log(Level.WARNING, "Caught DataSetIllegalArgumentException", dataSetIllegalArgumentException);
            }
            return true;
        }
        if (string.equals("RatingTableYUnits")) {
            this.a.setUnitSystem(Units.getUnitSystemForUnits((String)string2));
            return true;
        }
        return false;
    }

    @Override
    public void setDistributionType(int n) {
        this.h = n;
        if (n == 1) {
            this.i = new NormalDist();
            return;
        }
        if (n == 3) {
            this.i = new TriangDist();
        }
    }

    @Override
    protected void writeParameters(BufferedWriter bufferedWriter) {
        super.writeParameters(bufferedWriter);
        MCInputRatingCurveVariable mCInputRatingCurveVariable = this;
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("RatingTableValues:" + mCInputRatingCurveVariable.serializePVE(mCInputRatingCurveVariable.a)));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("RatingTableLabels:" + Arrays.toString(this.a.getCurveLabels())));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("RatingTableCurveLabels:" + Arrays.toString(this.b)));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("RatingTableXParam:" + this.a.getParamXString()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("RatingTableYParam:" + this.a.getParamYString()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("RatingTableYUnits:" + this.a.getParamYUnitsString()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("DistributionStart:" + this.i.getClass().getName()));
    }

    @Override
    public String getClassName() {
        return "MCInputRatingCurveVariable";
    }

    @Override
    public MCInputRatingCurveVariable clone() {
        MCInputRatingCurveVariable mCInputRatingCurveVariable = (MCInputRatingCurveVariable)super.clone();
        mCInputRatingCurveVariable.a = this.a != null ? this.a.clone() : null;
        return mCInputRatingCurveVariable;
    }

    public String serializePVE(PairedValuesExt object) {
        StringBuffer stringBuffer = new StringBuffer();
        object = object.getDataVector();
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            ValueSet valueSet = (ValueSet)((Vector)object).elementAt(i);
            stringBuffer.append(valueSet.xval).append(", ");
            stringBuffer.append(Arrays.toString(valueSet.yval));
            stringBuffer.append("; ");
        }
        return stringBuffer.toString();
    }

    public PairedValuesExt deserializePVE(String object) {
        PairedValuesExt pairedValuesExt = null;
        if (object != null && !((String)object).isEmpty()) {
            pairedValuesExt = new PairedValuesExt();
            object = new StringTokenizer((String)object, ";");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String[] stringArray = ((StringTokenizer)object).nextToken();
                int n = stringArray.indexOf(44);
                if (n <= 0) continue;
                String string = stringArray.substring(0, n);
                stringArray = stringArray.substring(n + 1);
                double[] dArray = null;
                if (!"null".equals(stringArray)) {
                    stringArray = stringArray.replace("[", "").replace("]", "").split(", ");
                    dArray = new double[stringArray.length];
                    for (int i = 0; i < dArray.length; ++i) {
                        dArray[i] = Double.parseDouble(stringArray[i]);
                    }
                }
                stringArray = dArray;
                try {
                    pairedValuesExt.addPair(Double.parseDouble(string.trim()), (double[])stringArray);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.log(Level.WARNING, "Caught NumberFormatException deserializing RatingCurve.", numberFormatException);
                }
            }
        }
        return pairedValuesExt;
    }

    private static String[] a(String string) {
        String[] stringArray = null;
        if (!"null".equals(string)) {
            stringArray = string.replace("[", "").replace("]", "").split(", ");
        }
        return stringArray;
    }

    public PairedValuesExt getValues() {
        return this.a;
    }

    public static List<Junction> getJunctionsWithRatingCurves(RssSystem object) {
        ArrayList<Junction> arrayList = new ArrayList<Junction>();
        object = object.getElementVectorByClass(JunctionElement.class);
        object = ((Vector)object).iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            if (!(object2 instanceof JunctionElement)) continue;
            object2 = (JunctionElement)object2;
            if ((object2 = (Junction)object2.getFunction()) == null || !object2.hasRatingCurve()) continue;
            arrayList.add((Junction)object2);
        }
        return arrayList;
    }

    public static Junction getJunctionByName(String string, RssAlt object) {
        if ((object = object.getSystem()) == null) {
            return null;
        }
        object = MCInputRatingCurveVariable.getJunctionsWithRatingCurves((RssSystem)object);
        object = object.iterator();
        while (object.hasNext()) {
            Junction junction = (Junction)object.next();
            if (junction == null || !junction.getName().equals(string)) continue;
            return junction;
        }
        return null;
    }

    public static Junction getJunctionById(int n, RssAlt rssAlt) {
        JunctionElement junctionElement;
        Junction junction = null;
        if ((rssAlt = rssAlt.getSystem()) != null && (junctionElement = (JunctionElement)rssAlt.getElement(n)) != null) {
            junction = (Junction)junctionElement.getFunction();
        }
        return junction;
    }

    public Junction getJunction(RssAlt rssAlt) {
        Junction junction = null;
        int n = this.getLocationIndex();
        if (n != -1) {
            junction = MCInputRatingCurveVariable.getJunctionById(n, rssAlt);
        }
        if (junction == null && (junction = MCInputRatingCurveVariable.getJunctionByName(this.getLocation(), rssAlt)) != null) {
            this.setLocationIndex(junction.getIndex());
        }
        return junction;
    }

    public Junction getJunction() {
        Junction junction = null;
        int n = this.getLocationIndex();
        if (n != -1) {
            junction = MCInputRatingCurveVariable.getJunctionById(n, this.q);
        }
        if (junction == null && (junction = MCInputRatingCurveVariable.getJunctionByName(this.getLocation(), this.q)) != null) {
            this.setLocationIndex(junction.getIndex());
        }
        return junction;
    }

    public PairedValuesExt sampleCurves(double d) {
        int n;
        int n2;
        int n3 = this.a.getNumberCurves() / this.i.getParamNames().length;
        PairedValuesExt pairedValuesExt = this.a.clone();
        int n4 = this.a();
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            int n5 = n2 * (n4 + 1);
            for (int i = n4 - 1; i >= 0; --i) {
                n = n5 + i + 1;
                pairedValuesExt.removeCurve(n);
            }
        }
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            int n6 = n2 * (n4 + 1);
            double[] dArray = (double[])this.a.getYArray(n2).clone();
            n = this.getDistributionType();
            switch (n) {
                case 1: {
                    logger.log(Level.FINEST, "Std Dev:" + Arrays.toString(this.a.getYArray(n6 + 1)));
                    this.a(d, dArray, this.a.getYArray(n6), this.a.getYArray(n6 + 1));
                    break;
                }
                case 3: {
                    this.a(d, dArray, this.a.getYArray(n6 + 1), this.a.getYArray(n6), this.a.getYArray(n6 + 2));
                }
            }
            n = n2;
            PairedValuesExt pairedValuesExt2 = pairedValuesExt;
            MCInputRatingCurveVariable mCInputRatingCurveVariable = this;
            PairedDataContainer pairedDataContainer = pairedValuesExt2.getPairedDataContainer();
            System.arraycopy(dArray, 0, pairedDataContainer.yOrdinates[n], 0, dArray.length);
            pairedValuesExt2.clearValues();
            if (!mCInputRatingCurveVariable.b[0].equals("null")) {
                if (pairedDataContainer.labels == null) {
                    pairedDataContainer.labels = new String[n];
                }
                if (pairedDataContainer.labels.length == mCInputRatingCurveVariable.b.length && mCInputRatingCurveVariable.b.length >= n) {
                    pairedDataContainer.labels[n] = mCInputRatingCurveVariable.b[n];
                }
            }
            pairedValuesExt2.setData(pairedDataContainer);
        }
        return pairedValuesExt;
    }

    protected String[] a(int n, String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        int n2 = stringArray.length - 1 - n;
        if (n2 > 0) {
            System.arraycopy(stringArray, n + 1, stringArray2, n, n2);
        }
        return stringArray2;
    }

    protected void a(double d, double[] dArray, double[] dArray2, double[] dArray3) {
        NormalDist normalDist = new NormalDist();
        double d2 = normalDist.invCDF(d);
        logger.log(Level.FINER, "invCDF:" + d2);
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = dArray2[i] + dArray3[i] * d2;
        }
    }

    protected void a(double d, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        for (int i = 0; i < dArray.length; ++i) {
            TriangDist triangDist = new TriangDist(dArray3[i], dArray2[i], dArray4[i]);
            dArray[i] = triangDist.invCDF(d);
        }
    }

    public static int getNumberOfDistParametersPerCurve(int n) {
        switch (n) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            default: {
                n = 2;
            }
        }
        return n;
    }

    protected int a() {
        return MCInputRatingCurveVariable.getNumberOfDistParametersPerCurve(this.getDistributionType());
    }

    public static PairedValuesExt getFlowVsStageCurves(Junction junction) {
        RssRatingObject rssRatingObject = null;
        if (junction != null) {
            rssRatingObject = junction.getRatingObject();
            if (rssRatingObject != null && rssRatingObject.usesIndependentVariable()) {
                junction = rssRatingObject.getIndependentVariable();
                if (junction.getType() == 5) {
                    rssRatingObject = rssRatingObject.getIndependentVariableRatingCurveExt();
                } else {
                    junction = rssRatingObject.getIndependentVariableRatingCurve();
                    rssRatingObject = MCInputRatingCurveVariable.a((PairedValues)junction);
                }
            } else {
                if (!"Stage".equals((junction = junction.getRatingCurve()).getParamYString()) || !"Flow".equals(junction.getParamXString())) {
                    junction = MCInputRatingCurveVariable.swapColumns((PairedValues)junction);
                }
                rssRatingObject = MCInputRatingCurveVariable.a((PairedValues)junction);
            }
        }
        return rssRatingObject;
    }

    public static PairedValues swapColumns(PairedValues pairedValues) {
        PairedValues pairedValues2 = (PairedValues)pairedValues.clone();
        pairedValues2.setParamXId(pairedValues.getParamYId());
        pairedValues2.setParamYId(pairedValues.getParamXId());
        pairedValues2.clearValues();
        int n = pairedValues.size();
        for (int i = 0; i < n; ++i) {
            pairedValues2.addPair(pairedValues.getYValue(i), pairedValues.getXValue(i));
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Swapped columns, was {0} vs {1}, now its {2} vs {3}", new Object[]{pairedValues.getParamXString(), pairedValues.getParamYString(), pairedValues2.getParamXString(), pairedValues2.getParamYString()});
        }
        return pairedValues2;
    }

    protected static PairedValuesExt a(PairedValues pairedValues) {
        PairedValuesExt pairedValuesExt = new PairedValuesExt();
        pairedValues = pairedValues.getPairedDataContainer();
        pairedValuesExt.setData((PairedDataContainer)pairedValues);
        return pairedValuesExt;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setFlowVsStageCurves(Junction junction, PairedValuesExt pairedValuesExt) {
        if (junction == null) return;
        RssRatingObject rssRatingObject = junction.getRatingObject();
        if (rssRatingObject != null && rssRatingObject.usesIndependentVariable()) {
            IndependentVariable independentVariable = rssRatingObject.getIndependentVariable();
            if (independentVariable.getType() == 5) {
                rssRatingObject.setIndependentVariableRatingCurveExt(pairedValuesExt);
                return;
            }
            junction = MCInputRatingCurveVariable.a(pairedValuesExt);
            rssRatingObject.setIndependentVariableRatingCurve((PairedValues)junction);
            return;
        }
        PairedValues pairedValues = MCInputRatingCurveVariable.a(pairedValuesExt);
        if ("Stage".equals(pairedValues.getParamYString()) && "Flow".equals(pairedValues.getParamXString())) {
            pairedValues = MCInputRatingCurveVariable.swapColumns(pairedValues);
        }
        junction.setRatingCurve(pairedValues);
    }

    private static PairedValues a(PairedValuesExt pairedValuesExt) {
        PairedValues pairedValues = null;
        if (pairedValuesExt != null) {
            int n = pairedValuesExt.getNumberCurves();
            if (n == 1) {
                pairedValuesExt = pairedValuesExt.getPairedDataContainer();
                pairedValues = new PairedValues();
                pairedValues.setData((PairedDataContainer)pairedValuesExt);
            } else {
                logger.log(Level.WARNING, "Wrong number of curves.  Existing junction had one rating curve.  This object has: {0}", n);
            }
        }
        return pairedValues;
    }

    public String[] getCurveLabels() {
        return this.b;
    }

    public boolean matches(PairedValuesExt pairedValuesExt) {
        int n = 0;
        if (pairedValuesExt != null) {
            int n2;
            int n3;
            n = this.a.getNumberCurves();
            n = n == (n3 = pairedValuesExt.getNumberCurves()) * ((n2 = this.a()) + 1) ? 1 : 0;
            for (int i = 0; n != 0 && i < n3; ++i) {
                double[] dArray = pairedValuesExt.getYArray(i);
                double d = this.curveInverseCDF(dArray, i);
                if (!(d < 0.005) && !(d > 0.995)) continue;
                n = 0;
            }
        } else {
            System.out.println("junctionVal was null");
        }
        return n != 0;
    }

    public double curveInverseCDF(double[] dArray, int n) {
        double d = 0.5;
        for (int i = 0; i < dArray.length; ++i) {
            double d2;
            int n2 = i;
            int n3 = n;
            Object object = this;
            int n4 = ((MCInputRatingCurveVariable)object).a() + 1;
            object = ((MCInputRatingCurveVariable)object).a.getYData();
            object = n4 == 2 ? new NormalDist((double)object[n3 * n4][n2], (double)object[n3 * n4 + 1][n2]) : new TriangDist((double)object[n3 * n4][n2], (double)object[n3 * n4 + 1][n2], (double)object[n3 * n4 + 2][n2]);
            double d3 = object.getCDF(dArray[i]);
            if (!(Math.abs(d2 - 0.5) > Math.abs(d - 0.5))) continue;
            d = d3;
        }
        return d;
    }

    public String getSummaryDef(String string) {
        string = this.a.toString();
        if (string.length() > 35) {
            return "Too large to display";
        }
        return string;
    }

    @Override
    public boolean initInputVariable(RssAlt rssAlt) {
        this.q = rssAlt;
        try {
            if (rssAlt == null) {
                System.out.println("Could not initialize the rating curve.");
                return false;
            }
            rssAlt = this.getJunction(rssAlt);
            this.c = rssAlt;
            rssAlt = MCInputRatingCurveVariable.getFlowVsStageCurves((Junction)rssAlt);
            this.d = rssAlt;
        }
        catch (Exception exception) {
            System.out.println("Could not initialize the rating curve. " + exception.getMessage());
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public void convertToAbsolute() {
        int n;
        Object object = this.a.clone();
        object = object.getYData();
        double[][] dArray = this.d.clone().getYData();
        for (int i = 0; i < ((PairedValuesExt)object).length; ++i) {
            for (n = 0; n < ((PairedValuesExt)object[i]).length; ++n) {
                object[i][n] = this.getDistributionName().equals("Normal") ? object[i][n] / 100.0 * dArray[(int)Math.floor((double)i / 2.0)][n] : object[i][n] / 100.0 * dArray[(int)Math.floor((double)i / 3.0)][n];
            }
        }
        double[][] dArray2 = new double[((PairedValuesExt)object[0]).length][((PairedValuesExt)object).length];
        for (n = 0; n < ((PairedValuesExt)object).length; ++n) {
            for (int i = 0; i < ((PairedValuesExt)object[n]).length; ++i) {
                dArray2[i][n] = (double)object[n][i];
            }
        }
        this.a.setArrays(this.d.clone().getXArray(), dArray2);
    }

    @Override
    public boolean applyRealization(double d) {
        if (this.isRelative()) {
            this.convertToAbsolute();
        }
        if (this.d != null) {
            Logger.getLogger(MCAltPluginData.class.getName()).log(Level.FINE, "Original Table:" + this.d.getData());
        }
        Logger.getLogger(MCAltPluginData.class.getName()).log(Level.FINE, "Random:" + d);
        PairedValuesExt pairedValuesExt = this.sampleCurves(d);
        Logger.getLogger(MCAltPluginData.class.getName()).log(Level.FINE, this.getDistributionName() + "Sampled:" + pairedValuesExt.getData());
        MCInputRatingCurveVariable mCInputRatingCurveVariable = this;
        mCInputRatingCurveVariable.setFlowVsStageCurves(mCInputRatingCurveVariable.c, pairedValuesExt);
        return true;
    }

    @Override
    public boolean restoreInputVariable(Object ... objectArray) {
        if (this.c == null || this.d == null) {
            System.out.println("Could not restore the rating curves to original values");
            return false;
        }
        MCInputRatingCurveVariable mCInputRatingCurveVariable = this;
        mCInputRatingCurveVariable.setFlowVsStageCurves(mCInputRatingCurveVariable.c, this.d);
        if (this.isRelative()) {
            this.convertToRelative();
        }
        return true;
    }

    public void convertToRelative() {
        int n;
        PairedValuesExt pairedValuesExt = this.a.clone();
        double[][] dArray = pairedValuesExt.getYData();
        double[][] dArray2 = this.d.clone().getYData();
        for (int i = 0; i < dArray.length; ++i) {
            for (n = 0; n < dArray[i].length; ++n) {
                dArray[i][n] = this.getDistributionName().equals("Normal") ? dArray[i][n] / dArray2[(int)Math.floor((double)i / 2.0)][n] * 100.0 : dArray[i][n] / dArray2[(int)Math.floor((double)i / 3.0)][n] * 100.0;
            }
        }
        double[][] dArray3 = new double[dArray[0].length][dArray.length];
        for (n = 0; n < dArray.length; ++n) {
            for (int i = 0; i < dArray[n].length; ++i) {
                dArray3[i][n] = dArray[n][i];
            }
        }
        this.a.setArrays(pairedValuesExt.getXArray(), dArray3);
    }

    @Override
    public boolean checkErrors(String[] stringArray) {
        return super.checkErrors(stringArray);
    }

    @Override
    public boolean checkWarnings(String[] stringArray, RssAlt object) {
        super.checkWarnings(stringArray, (RssAlt)object);
        if (((MCInputVariableImpl)this).initInputVariable((RssAlt)object)) {
            if (this.d == null) {
                object = this.getLocation();
                stringArray[0] = stringArray[0].concat("WARNING: Network rating curve at " + (String)object + " has been removed, but a Monte Carlo Random Rating curve still exists. The Monte Carlo Random Rating Curve will be ignored." + System.getProperty("line.separator"));
                return false;
            }
            if (this.a.getXArray().length != this.d.getXArray().length || this.h == 1 && this.a.getNumberCurves() / 2 != this.d.getNumberCurves() || this.h == 3 && this.a.getNumberCurves() / 3 != this.d.getNumberCurves()) {
                if (this.isRelative()) {
                    object = this;
                    if (object.h == 1 && object.a.getNumberCurves() / 2 != object.d.getNumberCurves()) {
                        int n;
                        double[][] dArray = new double[object.d.getNumberCurves() << 1][object.d.getYArray().length];
                        for (int i = 0; i < dArray.length; ++i) {
                            for (n = 0; n < dArray[0].length; ++n) {
                                dArray[i][n] = object.a.getYData()[i % 2][0];
                            }
                        }
                        double[][] dArray2 = new double[dArray[0].length][dArray.length];
                        for (n = 0; n < dArray.length; ++n) {
                            for (int i = 0; i < dArray[n].length; ++i) {
                                dArray2[i][n] = dArray[n][i];
                            }
                        }
                        object.a.setArrays(object.d.getXArray(), dArray2);
                    } else if (object.h == 3 && object.a.getNumberCurves() / 3 != object.d.getNumberCurves()) {
                        int n;
                        double[][] dArray = new double[object.d.getNumberCurves() * 3][object.d.getYArray().length];
                        for (int i = 0; i < dArray.length; ++i) {
                            for (n = 0; n < dArray[0].length; ++n) {
                                dArray[i][n] = object.a.getYData()[i % 3][0];
                            }
                        }
                        double[][] dArray3 = new double[dArray[0].length][dArray.length];
                        for (n = 0; n < dArray.length; ++n) {
                            for (int i = 0; i < dArray[n].length; ++i) {
                                dArray3[i][n] = dArray[n][i];
                            }
                        }
                        object.a.setArrays(object.d.getXArray(), dArray3);
                    } else {
                        int n;
                        double[][] dArray = new double[object.a.getYData().length][object.d.getYArray().length];
                        for (int i = 0; i < dArray.length; ++i) {
                            for (n = 0; n < dArray[0].length; ++n) {
                                dArray[i][n] = object.a.getYData()[i][0];
                            }
                        }
                        double[][] dArray4 = new double[dArray[0].length][dArray.length];
                        for (n = 0; n < dArray.length; ++n) {
                            for (int i = 0; i < dArray[n].length; ++i) {
                                dArray4[i][n] = dArray[n][i];
                            }
                        }
                        object.a.setArrays(object.d.getXArray(), dArray4);
                    }
                } else {
                    stringArray[0] = stringArray[0].concat("WARNING: Monte Carlo Random Variable Rating Curve at " + this.getLocation() + " has a different number of ordinates than the network Rating Curve. The curve should be edited, or reset to the default curve in the Random Variable Wizard." + System.getProperty("line.separator"));
                    return false;
                }
            }
            if (this.isRelative()) {
                this.convertToAbsolute();
            }
            MCInputRatingCurveVariable mCInputRatingCurveVariable = this;
            if (!mCInputRatingCurveVariable.matches(mCInputRatingCurveVariable.d)) {
                object = this.getLocation();
                stringArray[0] = stringArray[0].concat("WARNING: Network rating curve at " + (String)object + " is outside the 99% bounds of the Monte Carlo Rating Curve variable distribution. The curve should be updated in the Random Variable Wizard for consistency." + System.getProperty("line.separator"));
                if (this.isRelative()) {
                    this.convertToRelative();
                }
                return false;
            }
            if (this.isRelative()) {
                this.convertToRelative();
            }
            return true;
        }
        if (this.isRelative()) {
            this.convertToRelative();
        }
        return false;
    }

    public String[] getCurvesLabels() {
        String[] stringArray = this.a.getCurveLabels();
        return stringArray;
    }

    @Override
    public ClipDist getAbsoluteDist() {
        return null;
    }
}

