/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.model;

import hec.heclib.util.HecTime;
import hec.model.SeasonalPairedValues;
import hec.model.SeasonalRecord;
import hec.rss.model.IndependentVariable;
import hec.rss.model.OpRule;
import hec.rss.model.ReleaseFuncOpRule;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssAlt;
import hec.rss.model.TandemOpRule;
import hec.rss.plugins.montecarlo.model.MCInputClippedDataVariable;
import hec.rss.plugins.montecarlo.model.MCInputStochasticVariableImpl;
import hec.rss.plugins.montecarlo.model.MCInputVariableImpl;
import hec.rss.plugins.montecarlo.model.SeasonalContinuousDistribution;
import hec.statistics.ClipDist;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.util.Vector;
import rma.util.RMAIO;

public class MCInputResRuleVariable
extends MCInputClippedDataVariable {
    protected static final String c = "ReserviorID";
    protected static final String d = "RuleID";
    protected static final String e = "ParamType";
    protected static final String f = "ControllerOpID";
    private int r;
    private int s;
    private int t;
    private int u;
    private SeasonalRecord v = new SeasonalRecord();
    private SeasonalPairedValues w = new SeasonalPairedValues();
    private OpRule x = new OpRule();
    private double y;

    public MCInputResRuleVariable(String string, String string2, int n) {
        super(string, string2, n);
        this.b = 1;
    }

    @Override
    public MCInputResRuleVariable clone() {
        MCInputResRuleVariable mCInputResRuleVariable = (MCInputResRuleVariable)super.clone();
        mCInputResRuleVariable.setReserviorID(this.r);
        mCInputResRuleVariable.setRuleID(this.s);
        mCInputResRuleVariable.setParamType(this.u);
        mCInputResRuleVariable.setControllerOpID(this.t);
        return mCInputResRuleVariable;
    }

    @Override
    public String getClassName() {
        return "MCInputResRuleVariable";
    }

    public void setReserviorID(int n) {
        this.r = n;
    }

    public int getParamType() {
        return this.u;
    }

    public void setParamType(int n) {
        this.u = n;
    }

    public void setControllerOpID(int n) {
        this.t = n;
    }

    public int getControllerOpID() {
        return this.t;
    }

    public void setRuleID(int n) {
        this.s = n;
    }

    public int getReserviorID() {
        return this.r;
    }

    public int getRuleID() {
        return this.s;
    }

    @Override
    public void writeParameters(BufferedWriter bufferedWriter) {
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("ReserviorID:" + this.getReserviorID()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("RuleID:" + this.getRuleID()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("ParamType:" + this.getParamType()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("ControllerOpID:" + this.getControllerOpID()));
        super.writeParameters(bufferedWriter);
    }

    @Override
    protected boolean a(String string, String string2, BufferedReader bufferedReader) {
        if (super.a(string, string2, bufferedReader)) {
            return true;
        }
        if (string.equals(c)) {
            this.setReserviorID(Integer.parseInt(string2));
        } else if (string.equals(d)) {
            this.setRuleID(Integer.parseInt(string2));
        } else if (string.equals(e)) {
            this.setParamType(Integer.parseInt(string2));
        } else if (string.equals(f)) {
            this.setControllerOpID(Integer.parseInt(string2));
        } else {
            return false;
        }
        return true;
    }

    @Override
    public boolean initInputVariable(RssAlt object) {
        block12: {
            this.q = object;
            if ((object = object.getSystem().getElementVectorByClass(ReservoirElement.class)) == null) {
                return false;
            }
            try {
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    ReservoirElement reservoirElement = (ReservoirElement)((Vector)object).get(i);
                    if (reservoirElement == null || reservoirElement.getIndex() != this.getReserviorID() || (reservoirElement = reservoirElement.getReservoirOp()) == null || (reservoirElement = reservoirElement.getController(this.getControllerOpID())) == null || (reservoirElement = reservoirElement.getRule(this.getRuleID())) == null || !reservoirElement.isDnstrmRule() && !(reservoirElement instanceof ReleaseFuncOpRule) || reservoirElement instanceof TandemOpRule) continue;
                    this.x = reservoirElement;
                    IndependentVariable independentVariable = ((ReleaseFuncOpRule)reservoirElement).getIndependentVariable();
                    if (independentVariable == null) continue;
                    if (this.getParamType() == 2) {
                        this.y = independentVariable.getTimeSeriesLag();
                        break;
                    }
                    if (this.getParamType() == 3) {
                        this.y = independentVariable.getTimeSeriesPeriod();
                        break;
                    }
                    switch (independentVariable.getType()) {
                        case 0: 
                        case 1: {
                            object = ((ReleaseFuncOpRule)reservoirElement).getSeasonalRecord();
                            if (object != null) {
                                this.v = (SeasonalRecord)object.clone();
                                this.y = object.getLargestValue();
                                break block12;
                            }
                            break block12;
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            object = ((ReleaseFuncOpRule)reservoirElement).getFunctionRelease();
                            if (object != null) {
                                this.w = object.clone();
                                this.y = object.getLargestValue();
                            } else {
                                break;
                            }
                        }
                    }
                    break;
                }
            }
            catch (Exception exception) {
                System.out.println("Could not initialize the rule parameter. " + exception.getMessage());
                exception.printStackTrace();
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean applyRealization(double d) {
        block14: {
            IndependentVariable independentVariable;
            double d2;
            ClipDist clipDist;
            HecTime hecTime;
            block16: {
                block15: {
                    hecTime = this.q.getSystem().getRssRun().getRunTimeWindow().getStartTime();
                    if (!this.p.isEmpty()) {
                        MCInputResRuleVariable mCInputResRuleVariable = this;
                        mCInputResRuleVariable.setDependentDistParams(mCInputResRuleVariable.q);
                    }
                    if ((clipDist = this.isRelative() ? ((MCInputStochasticVariableImpl)this).getAbsoluteDist() : (ClipDist)this.getClipDist().clone()) instanceof SeasonalContinuousDistribution) {
                        ((SeasonalContinuousDistribution)clipDist).setStartTime(hecTime);
                    }
                    d2 = clipDist.invCDF(d);
                    ((MCInputVariableImpl)this).setVariate(d2);
                    if (this.x == null || (independentVariable = ((ReleaseFuncOpRule)this.x).getIndependentVariable()) == null) break block14;
                    if (this.getParamType() != 2) break block15;
                    independentVariable.setTimeSeriesLag(d2);
                    break block14;
                }
                if (this.getParamType() != 3) break block16;
                independentVariable.setTimeSeriesPeriod(d2);
                break block14;
            }
            try {
                switch (independentVariable.getType()) {
                    case 0: 
                    case 1: {
                        independentVariable = ((ReleaseFuncOpRule)this.x).getSeasonalRecord();
                        if (independentVariable != null) {
                            if (clipDist instanceof SeasonalContinuousDistribution) {
                                independentVariable.scaleValues(d2 / ((ReleaseFuncOpRule)this.x).getSeasonalRecord().interpolate(hecTime));
                                break;
                            }
                            if ((independentVariable = (SeasonalRecord)independentVariable.clone()) != null && this.y != 0.0) {
                                ((ReleaseFuncOpRule)this.x).setSeasonalRecord((SeasonalRecord)independentVariable);
                                independentVariable.scaleValues(d2 / this.y);
                            }
                        }
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        independentVariable = ((ReleaseFuncOpRule)this.x).getFunctionRelease();
                        if (independentVariable != null) {
                            if (clipDist instanceof SeasonalContinuousDistribution && ((ReleaseFuncOpRule)this.x).getSeasonalRecord() != null) {
                                ((ReleaseFuncOpRule)this.x).setFunctionRelease((SeasonalPairedValues)independentVariable);
                                independentVariable.scaleValues(d2 / ((ReleaseFuncOpRule)this.x).getSeasonalRecord().interpolate(hecTime));
                                break;
                            }
                            if ((independentVariable = independentVariable.clone()) != null && this.y != 0.0) {
                                ((ReleaseFuncOpRule)this.x).setFunctionRelease((SeasonalPairedValues)independentVariable);
                                independentVariable.scaleValues(d2 / this.y);
                            } else {
                                break;
                            }
                        } else {
                            break;
                        }
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Failed to assign randomized Reservoir Rule seasonal Data. " + exception.getMessage());
                exception.printStackTrace();
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean restoreInputVariable(Object ... independentVariable) {
        if (this.x == null) {
            return false;
        }
        try {
            independentVariable = ((ReleaseFuncOpRule)this.x).getIndependentVariable();
            if (independentVariable != null) {
                if (this.getParamType() == 2) {
                    independentVariable.setTimeSeriesLag(this.y);
                } else if (this.getParamType() == 3) {
                    independentVariable.setTimeSeriesPeriod(this.y);
                } else {
                    switch (independentVariable.getType()) {
                        case 0: 
                        case 1: {
                            ((ReleaseFuncOpRule)this.x).setSeasonalRecord(this.v);
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            ((ReleaseFuncOpRule)this.x).setFunctionRelease(this.w);
                        }
                        default: {
                            break;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Failed to restore Reservoir Rule seasonal Data. " + exception.getMessage());
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean checkErrors(String[] stringArray) {
        return super.checkErrors(stringArray);
    }

    @Override
    public boolean checkWarnings(String[] stringArray, RssAlt rssAlt) {
        String string;
        ((MCInputVariableImpl)this).initInputVariable(rssAlt);
        super.checkWarnings(stringArray, rssAlt);
        rssAlt = this.isRelative() ? ((MCInputStochasticVariableImpl)this).getAbsoluteDist() : (ClipDist)this.getClipDist().clone();
        Object object = ((ReleaseFuncOpRule)this.x).getIndependentVariable();
        double d = 0.0;
        if (this.getParamType() == 2) {
            double d2 = object.getTimeSeriesLag();
            if (this.getClipDist() instanceof SeasonalContinuousDistribution) {
                object = new SeasonalRecord();
                object.setArrays(new int[]{1440, 525600}, new double[]{d2, d2});
                d = ((SeasonalContinuousDistribution)rssAlt).getCDF((SeasonalRecord)object);
            } else {
                d = rssAlt.getCDF(d2);
            }
        } else if (this.getParamType() == 3) {
            double d3 = object.getTimeSeriesPeriod();
            if (this.getClipDist() instanceof SeasonalContinuousDistribution) {
                object = new SeasonalRecord();
                object.setArrays(new int[]{1440, 525600}, new double[]{d3, d3});
                d = ((SeasonalContinuousDistribution)rssAlt).getCDF((SeasonalRecord)object);
            } else {
                d = rssAlt.getCDF(d3);
            }
        } else {
            switch (object.getType()) {
                case 0: 
                case 1: {
                    object = ((ReleaseFuncOpRule)this.x).getSeasonalRecord();
                    if (object == null || this.y == 0.0) break;
                    if (this.getClipDist() instanceof SeasonalContinuousDistribution) {
                        d = ((SeasonalContinuousDistribution)rssAlt).getCDF((SeasonalRecord)object);
                        break;
                    }
                    double d4 = object.getLargestValue();
                    d = rssAlt.getCDF(d4);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    object = ((ReleaseFuncOpRule)this.x).getFunctionRelease();
                    if (object == null || this.y == 0.0) break;
                    ((ReleaseFuncOpRule)this.x).setFunctionRelease((SeasonalPairedValues)object);
                    if (this.getClipDist() instanceof SeasonalContinuousDistribution) {
                        string = MCInputResRuleVariable.a((SeasonalPairedValues)object);
                        d = ((SeasonalContinuousDistribution)rssAlt).getCDF((SeasonalRecord)string);
                        break;
                    }
                    double d5 = object.getLargestValue();
                    d = rssAlt.getCDF(d5);
                }
            }
        }
        object = this.getParameter();
        string = this.getLocation();
        return this.checkDistribution(d, stringArray, (String)object, string);
    }

    private static SeasonalRecord a(SeasonalPairedValues seasonalPairedValues) {
        SeasonalRecord seasonalRecord = new SeasonalRecord();
        seasonalPairedValues = seasonalPairedValues.clone();
        int[] nArray = seasonalPairedValues.getTimeArray();
        double[] dArray = new double[nArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < seasonalPairedValues.getYData()[0].length; ++j) {
                if (!(dArray[i] < seasonalPairedValues.getYData()[i][j])) continue;
                dArray[i] = seasonalPairedValues.getYData()[i][j];
            }
        }
        if (nArray.length == 1) {
            int[] nArray2 = new int[nArray.length + 1];
            double[] dArray2 = new double[nArray.length + 1];
            for (int i = 0; i < dArray.length; ++i) {
                nArray2[i] = nArray[i];
                dArray2[i] = dArray[i];
            }
            nArray2[nArray.length] = 525600;
            dArray2[nArray.length] = dArray[0];
            nArray = nArray2;
            dArray = dArray2;
        }
        seasonalRecord.setArrays(nArray, dArray);
        return seasonalRecord;
    }

    @Override
    public ClipDist getAbsoluteDist() {
        if (this.q != null) {
            MCInputResRuleVariable mCInputResRuleVariable = this;
            ((MCInputVariableImpl)mCInputResRuleVariable).initInputVariable(mCInputResRuleVariable.q);
        }
        if (this.isSeasonal()) {
            if (this.w.getTimeArray() != null) {
                MCInputResRuleVariable mCInputResRuleVariable = this;
                return mCInputResRuleVariable.b(MCInputResRuleVariable.a(mCInputResRuleVariable.w));
            }
            if (this.v.getTimeArray() != null) {
                MCInputResRuleVariable mCInputResRuleVariable = this;
                return mCInputResRuleVariable.b(mCInputResRuleVariable.v);
            }
            SeasonalRecord seasonalRecord = new SeasonalRecord();
            seasonalRecord.setArrays(new int[]{1440, 525600}, new double[]{this.y, this.y});
            return this.b(seasonalRecord);
        }
        return this.getAbsoluteDist(new Double[]{this.y});
    }

    @Override
    public Double getRelativeValue(Double d, RssAlt rssAlt) {
        ((MCInputVariableImpl)this).initInputVariable(rssAlt);
        return d / this.y * 100.0;
    }
}

