/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.model;

import hec.rss.model.RssAlt;
import hec.rss.plugins.factories.AltPluginDataFactory;
import hec.rss.plugins.montecarlo.model.MCAltPluginData;
import hec.rss.plugins.montecarlo.model.MCInputVariableImpl;
import hec.statistics.AbstractContDist;
import hec.statistics.ClipDist;
import hec.statistics.EmpiricalDist;
import hec.statistics.LogNormalDist;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import rma.util.RMAIO;

public abstract class MCInputStochasticVariableImpl
extends MCInputVariableImpl {
    public static final String DISTRIBUTION_TYPE = "DistributionType";
    protected static final String g = "IsRelative";
    public static final int DISCRETE = 0;
    public static final int NORMAL = 1;
    public static final int UNIFORM = 2;
    public static final int TRIANGULAR = 3;
    public static final int LOG_NORMAL = 4;
    public static final int LOG_NORMAL10 = 7;
    public static final int GAMMA = 5;
    public static final int EMPIRICAL = 6;
    protected int h = 1;
    private boolean a = false;
    private double b;
    private boolean c = false;
    protected AbstractContDist i;

    public MCInputStochasticVariableImpl(String string, String string2, int n, int n2) {
        super(string, string2, n);
        this.h = n2;
    }

    public MCInputStochasticVariableImpl(int n, String string, int n2, int n3) {
        super(n, string, n2);
        this.h = n3;
    }

    @Override
    public String getParameterEqualString() {
        return this.m;
    }

    @Override
    public void setParameterEqualString(String string) {
        this.m = string;
    }

    @Override
    public abstract int getType();

    public int getDistributionType() {
        return this.h;
    }

    public void setDistributionType(int n) {
        this.h = n;
    }

    @Override
    public void read(BufferedReader bufferedReader) {
        try {
            Object object = bufferedReader.readLine();
            while (object != null) {
                boolean bl;
                if (((String)object).length() == 0) {
                    object = bufferedReader.readLine();
                    continue;
                }
                BufferedReader bufferedReader2 = bufferedReader;
                String string = object;
                object = this;
                String string2 = RMAIO.getType((String)string, (String)":");
                string = RMAIO.getParam((String)string, (String)":");
                if (string2.equals("MCInputVariableEnd")) {
                    bl = false;
                } else {
                    boolean bl2;
                    ((MCInputStochasticVariableImpl)object).a(string2, string, bufferedReader2);
                    bl = bl2 = true;
                }
                if (bl) {
                    object = bufferedReader.readLine();
                    continue;
                }
                return;
            }
            return;
        }
        catch (IOException iOException) {
            System.out.println("Failed to read Monte Carlo Plugin Data MCInputLookbackVariable.");
            iOException.printStackTrace();
            return;
        }
    }

    @Override
    protected boolean a(String string, String string2, BufferedReader bufferedReader) {
        super.a(string, string2, bufferedReader);
        if (string.equals(DISTRIBUTION_TYPE)) {
            this.setDistributionType(Integer.parseInt(string2));
        } else if (string.equals(g)) {
            this.setReference(Boolean.parseBoolean(string2));
        } else if (string.equals("IsSeasonal")) {
            this.setSeasonality(Boolean.parseBoolean(string2));
        } else if (string.equals(k)) {
            this.setGroupNumber(Integer.parseInt(string2));
        } else if (string.equals("Correlation Set")) {
            this.setCorrelationSetName(string2);
        } else {
            return false;
        }
        return true;
    }

    public void setSeasonality(boolean bl) {
        this.c = bl;
    }

    @Override
    public void write(BufferedWriter bufferedWriter) {
        this.writeParameters(bufferedWriter);
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"MCInputVariableEnd");
    }

    @Override
    protected void writeParameters(BufferedWriter bufferedWriter) {
        super.writeParameters(bufferedWriter);
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("DistributionType:" + Integer.toString(this.getDistributionType())));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("IsRelative:" + this.isRelative()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("IsSeasonal:" + this.isSeasonal()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)(String.valueOf(k) + ":" + this.getGroupNumber()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Correlation Set:" + this.getCorrelationSetName()));
    }

    @Override
    public MCInputStochasticVariableImpl clone() {
        MCInputStochasticVariableImpl mCInputStochasticVariableImpl = (MCInputStochasticVariableImpl)super.clone();
        ((MCInputStochasticVariableImpl)super.clone()).h = this.h;
        mCInputStochasticVariableImpl.m = this.m;
        mCInputStochasticVariableImpl.o = new HashMap<Integer, MCInputVariableImpl>();
        for (Integer n : this.o.keySet()) {
            mCInputStochasticVariableImpl.addDependentVariable(n, this.o.get(n).clone());
        }
        return mCInputStochasticVariableImpl;
    }

    public static String getDistributionName(int n) {
        String string = "Unknown";
        switch (n) {
            case 0: {
                string = "Discrete";
                break;
            }
            case 1: {
                string = "Normal";
                break;
            }
            case 2: {
                string = "Uniform";
                break;
            }
            case 3: {
                string = "Triangular";
                break;
            }
            case 4: {
                string = "Log Normal";
                break;
            }
            case 5: {
                string = "Gamma";
                break;
            }
            case 6: {
                string = "Empirical";
                break;
            }
            case 7: {
                string = "Log Normal 10";
            }
        }
        return string;
    }

    public String getDistributionName() {
        return MCInputStochasticVariableImpl.getDistributionName(this.getDistributionType());
    }

    @Override
    public abstract String getClassName();

    @Override
    public String getVariableName() {
        if (((MCInputVariableImpl)this).getType() == 0) {
            return "Time Series";
        }
        if (((MCInputVariableImpl)this).getType() == 4) {
            return "Time Series Multiplier";
        }
        if (((MCInputVariableImpl)this).getType() == 1) {
            return "Rule Parameter";
        }
        if (((MCInputVariableImpl)this).getType() == 3) {
            return "Rating Curve";
        }
        if (((MCInputVariableImpl)this).getType() == 4) {
            return "Time Series Multiplier";
        }
        return "Lookback";
    }

    public boolean checkDistribution(double d, String[] stringArray, String string, String string2) {
        if (d < 0.005 || d > 0.995) {
            stringArray[0] = stringArray[0].concat("WARNING: Network variable " + string + " at " + string2 + " is outside the 99% bound of the specified Monte Carlo Random Variable distribution. The corresponding Random Variable sampling distribution parameters should be revised." + System.getProperty("line.separator"));
            return false;
        }
        return true;
    }

    public boolean emptyEmpiricalWarning(String[] stringArray, String string, String string2) {
        stringArray[0] = stringArray[0].concat("WARNING: Monte Carlo Random Variable " + string + " at " + string2 + " is defined with an invalid Empirical or Discrete distribution. This variable will be ignored in the compute unless the sampling distribution is updated." + System.getProperty("line.separator"));
        return false;
    }

    @Override
    public boolean initInputVariable(RssAlt rssAlt) {
        return false;
    }

    @Override
    public abstract boolean applyRealization(double var1);

    @Override
    public boolean restoreInputVariable(Object ... objectArray) {
        return false;
    }

    @Override
    public boolean checkErrors(String[] stringArray) {
        block2: {
            block3: {
                AbstractContDist abstractContDist = this.getDist();
                if (!(abstractContDist instanceof EmpiricalDist) || ((EmpiricalDist)abstractContDist).getInterpType() != EmpiricalDist.InterpType.STEP) break block2;
                if ((abstractContDist = (EmpiricalDist)abstractContDist).getNumRows() <= 0) break block3;
                AbstractContDist abstractContDist2 = abstractContDist;
                if (!(Math.abs(1.0 - abstractContDist2.getCumProb(abstractContDist2.getNumRows() - 1)) > 0.005)) break block2;
            }
            stringArray[0] = stringArray[0].concat("ERROR: Distribution probabilities do not add up to 1" + System.getProperty("line.separator"));
            return false;
        }
        return true;
    }

    @Override
    public boolean checkWarnings(String[] stringArray, RssAlt rssAlt) {
        return true;
    }

    public boolean isRelative() {
        return this.a;
    }

    public void setReference(boolean bl) {
        this.a = bl;
    }

    public AbstractContDist getDist() {
        for (Integer n : this.o.keySet()) {
            this.i.getParamVals()[n.intValue()] = this.o.get(n).getVariate();
        }
        return this.i;
    }

    public void setDist(AbstractContDist abstractContDist) {
        this.i = abstractContDist;
    }

    public void convertToRelative(Double object) {
        String[] stringArray = this.getDist().getParamNames();
        double[] dArray = this.getDist() instanceof EmpiricalDist ? ((EmpiricalDist)this.getDist()).getValues() : this.getDist().getParamVals();
        Class[] classArray = new Class[dArray.length];
        Object[] objectArray = new Object[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            if (!(stringArray[i].contains("Shape") || stringArray[i].contains("Skew") || stringArray[i].contains("Freedom"))) {
                dArray[i] = dArray[i] / (Double)object * 100.0;
            }
            classArray[i] = Double.TYPE;
            objectArray[i] = dArray[i];
        }
        if (this.getDist() instanceof EmpiricalDist) {
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray2[0] = ((EmpiricalDist)this.getDist()).getCumProbs();
            objectArray[1] = dArray;
            Class[] classArray2 = new Class[2];
            classArray = classArray2;
            classArray2[0] = double[].class;
            classArray[1] = double[].class;
        }
        Class<?> clazz = this.getDist().getClass();
        try {
            object = clazz.getConstructor(classArray);
            this.i = (AbstractContDist)((Constructor)object).newInstance(objectArray);
            return;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            object = exception;
            exception.printStackTrace();
            return;
        }
    }

    public double[] getRelativeParams() {
        String[] stringArray = this.getDist().getParamNames();
        double d = 100.0;
        if (this.getDist() instanceof LogNormalDist) {
            d = Math.log(100.0);
        }
        double[] dArray = this.getDist() instanceof EmpiricalDist ? ((EmpiricalDist)this.getDist()).getValues() : this.getDist().getParamVals();
        for (int i = 0; i < dArray.length; ++i) {
            if (stringArray[i].contains("Shape") || stringArray[i].contains("Skew") || stringArray[i].contains("Freedom")) continue;
            dArray[i] = dArray[i] / this.getDist().getExpectedValue() * d;
        }
        return dArray;
    }

    public void convertToAbsolute(Double[] object) {
        String[] stringArray = this.getDist().getParamNames();
        double[] dArray = this.getDist() instanceof EmpiricalDist ? ((EmpiricalDist)this.getDist()).getValues() : this.getDist().getParamVals();
        double d = 100.0;
        if (this.getDist() instanceof LogNormalDist) {
            object[0] = Math.log(object[0]);
            d = Math.log(100.0);
        }
        Class[] classArray = new Class[dArray.length];
        Object[] objectArray = new Object[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            if (!(stringArray[i].contains("Shape") || stringArray[i].contains("Skew") || stringArray[i].contains("Freedom"))) {
                dArray[i] = dArray[i] / d * (Double)object[0];
            }
            classArray[i] = Double.TYPE;
            objectArray[i] = dArray[i];
        }
        if (this.getDist() instanceof EmpiricalDist) {
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray2[0] = ((EmpiricalDist)this.getDist()).getCumProbs();
            objectArray[1] = dArray;
            Class[] classArray2 = new Class[2];
            classArray = classArray2;
            classArray2[0] = double[].class;
            classArray[1] = double[].class;
        }
        Class<?> clazz = this.getDist().getClass();
        try {
            object = clazz.getConstructor(classArray);
            this.i = (AbstractContDist)((Constructor)object).newInstance(objectArray);
            return;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            object = exception;
            exception.printStackTrace();
            return;
        }
    }

    public double getOriginalValue() {
        return this.b;
    }

    public void setOriginalValue(double d) {
        this.b = d;
    }

    public boolean isSeasonal() {
        return this.c;
    }

    @Override
    public double getVariate() {
        return this.n;
    }

    @Override
    public void setVariate(double d) {
        this.n = d;
    }

    public String getGroupLabel() {
        String string = this.m.substring(0, this.m.indexOf("-") + 1);
        String string2 = "Group:" + this.getGroupNumber();
        return string + string2;
    }

    public abstract ClipDist getAbsoluteDist();

    protected void setDependentDistParams(RssAlt object) {
        object = (MCAltPluginData)object.getAltPluginData(AltPluginDataFactory.MC);
        double[] dArray = this.getDist().getParamVals();
        Class[] classArray = new Class[dArray.length];
        Object[] objectArray = new Object[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            classArray[i] = Double.TYPE;
            if (this.p.keySet().contains(i)) {
                objectArray[i] = this.a(((MCAltPluginData)((Object)object)).getInputVariables(), this.p.get(i));
                if (objectArray[i] != null) continue;
            }
            objectArray[i] = dArray[i];
        }
        Class<?> clazz = this.getDist().getClass();
        try {
            object = clazz.getConstructor(classArray);
            this.i = (AbstractContDist)((Constructor)object).newInstance(objectArray);
            return;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            object = exception;
            exception.printStackTrace();
            return;
        }
    }

    protected Object a(List<MCInputVariableImpl> object, String string) {
        object = object.iterator();
        while (object.hasNext()) {
            MCInputVariableImpl mCInputVariableImpl = (MCInputVariableImpl)object.next();
            if (!mCInputVariableImpl.getShortName().equals(string)) continue;
            return mCInputVariableImpl.getVariate();
        }
        return null;
    }
}

