/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.model;

import hec.heclib.util.HecTime;
import hec.model.SeasonalRecord;
import hec.rss.model.InflowLocationFactor;
import hec.rss.model.JunctionElement;
import hec.rss.model.RssAlt;
import hec.rss.plugins.montecarlo.model.MCInputClippedDataVariable;
import hec.rss.plugins.montecarlo.model.MCInputStochasticVariableImpl;
import hec.rss.plugins.montecarlo.model.MCInputVariableImpl;
import hec.rss.plugins.montecarlo.model.SeasonalContinuousDistribution;
import hec.statistics.ClipDist;
import java.util.ArrayList;

public class MCInputTSMultiplierVariable
extends MCInputClippedDataVariable {
    public static final String GLOBAL_INFLOW_MULTIPLIER = "GlobalInflowMultiplier";
    private SeasonalRecord c = new SeasonalRecord();
    private String d;
    private Double[] e;

    public MCInputTSMultiplierVariable(String string, String string2, int n) {
        super(string, string2, n);
        this.b = 4;
    }

    @Override
    public boolean initInputVariable(RssAlt rssAlt) {
        this.q = rssAlt;
        this.e = this.getDefaultValue();
        return true;
    }

    @Override
    public boolean applyRealization(double d) {
        double d2;
        if (!this.p.isEmpty()) {
            MCInputTSMultiplierVariable mCInputTSMultiplierVariable = this;
            mCInputTSMultiplierVariable.setDependentDistParams(mCInputTSMultiplierVariable.q);
        }
        ClipDist clipDist = this.isRelative() ? ((MCInputStochasticVariableImpl)this).getAbsoluteDist() : (ClipDist)this.getClipDist().clone();
        if (this.isSeasonal()) {
            ((SeasonalContinuousDistribution)clipDist).setStartTime(this.q.getSystem().getRssRun().getRunTimeWindow().getStartTime());
            d2 = ((SeasonalContinuousDistribution)clipDist).getDist().invCDF(d);
        } else {
            d2 = clipDist.invCDF(d);
        }
        ((MCInputVariableImpl)this).setVariate(d2);
        this.a(d2);
        return true;
    }

    @Override
    public boolean restoreInputVariable(Object ... objectArray) {
        MCInputTSMultiplierVariable mCInputTSMultiplierVariable = this;
        mCInputTSMultiplierVariable.a(mCInputTSMultiplierVariable.e[0]);
        return true;
    }

    @Override
    public boolean checkErrors(String[] stringArray) {
        boolean bl;
        block2: {
            block4: {
                boolean bl2;
                block3: {
                    bl = super.checkErrors(stringArray);
                    if (this.q == null) break block2;
                    if (this.q.isUsingInflowFactors()) break block3;
                    stringArray[0] = stringArray[0].concat("ERROR: Time Series Multiplier specified at " + this.getLocation() + " but Time Series Multipliers are disabled. Please enable Time Series Multipliers." + System.getProperty("line.separator"));
                    break block4;
                }
                boolean bl3 = this.getLocation().equals(GLOBAL_INFLOW_MULTIPLIER);
                boolean bl4 = bl2 = this.q.getInflowFactorType() == 0;
                if (bl3 == bl2) break block2;
                stringArray[0] = !bl3 ? stringArray[0].concat("ERROR: Global time series multiplier is set to be used in this alternative, but local multipliers are setup to be sampled as Monte Carlo variables. Only the global time series multiplier will be used." + System.getProperty("line.separator")) : stringArray[0].concat("ERROR: Local time series multipliers are set to be used in this alternative, but the global multiplier is setup to be sampled as a Monte Carlo variable. Only the local time series multipliers will be used." + System.getProperty("line.separator"));
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean checkWarnings(String[] stringArray, RssAlt rssAlt) {
        this.q = rssAlt;
        super.checkWarnings(stringArray, rssAlt);
        if (rssAlt.getSystem().getRssRun() != null) {
            ((MCInputVariableImpl)this).initInputVariable(rssAlt);
        } else {
            this.e = this.getDefaultValue();
        }
        rssAlt = this.isRelative() ? ((MCInputStochasticVariableImpl)this).getAbsoluteDist() : (ClipDist)this.getClipDist().clone();
        String string = this.getLocation();
        double d = 0.5;
        if (this.isSeasonal()) {
            int n = ((SeasonalContinuousDistribution)rssAlt).getHecTimes().size();
            for (int i = 0; i < n; ++i) {
                double d2 = ((SeasonalContinuousDistribution)rssAlt).getDist(i).getCDF(this.e[0].doubleValue());
                if (!(Math.abs(0.5 - d2) > Math.abs(0.5 - d))) continue;
                d = d2;
            }
        } else {
            d = rssAlt.getCDF(this.e[0].doubleValue());
        }
        return this.checkDistribution(d, stringArray, "Time Series Multiplier", string);
    }

    @Override
    public String getClassName() {
        return "MCInputTSMultiplierVariable";
    }

    public Double getTSMultiplier(HecTime hecTime) {
        return this.c.interpolate(hecTime) / 100.0;
    }

    public void setTSMultiplier(Double d) {
        this.c.setArrays(new int[]{1440, 525600}, new double[]{d, d});
    }

    public String getJunctionID() {
        return this.d;
    }

    public void setJunctionID(String string) {
        this.d = string;
    }

    public Double[] getDefaultValue() {
        Double[] doubleArray = new Double[1];
        if (this.getLocation().equals(GLOBAL_INFLOW_MULTIPLIER)) {
            return new Double[]{this.q.getGlobalInflowFactor()};
        }
        Object object = this.q.getLocationInflowFactors();
        object = object.iterator();
        while (object.hasNext()) {
            InflowLocationFactor inflowLocationFactor = (InflowLocationFactor)object.next();
            Object object2 = this.q.getSystem().getObjectForKeyString(inflowLocationFactor.getJunctionId());
            if (object2 == null) continue;
            object2 = ((JunctionElement)object2).getName();
            if (!inflowLocationFactor.getLocalFlowName().equals(this.getParameter()) || !((String)object2).equals(this.getLocation())) continue;
            doubleArray[0] = inflowLocationFactor.getFactor();
        }
        return doubleArray;
    }

    private void a(Double d) {
        Object object = this.q.getLocationInflowFactors();
        ArrayList<InflowLocationFactor> arrayList = new ArrayList<InflowLocationFactor>();
        object = object.iterator();
        while (object.hasNext()) {
            String string;
            InflowLocationFactor inflowLocationFactor = (InflowLocationFactor)object.next();
            String string2 = ((JunctionElement)this.q.getSystem().getObjectForKeyString(inflowLocationFactor.getJunctionId())).getName();
            if (inflowLocationFactor.getLocalFlowName().equals(this.getParameter()) && string2.equals(this.getLocation())) {
                string2 = inflowLocationFactor.getJunctionId();
                string = inflowLocationFactor.getLocalFlowName();
                arrayList.add(new InflowLocationFactor(string2, string, d.doubleValue()));
                continue;
            }
            string2 = inflowLocationFactor.getJunctionId();
            string = inflowLocationFactor.getLocalFlowName();
            double d2 = inflowLocationFactor.getFactor();
            arrayList.add(new InflowLocationFactor(string2, string, d2));
        }
        if (this.getLocation().equals(GLOBAL_INFLOW_MULTIPLIER)) {
            this.q.setGlobalInflowFactor(d.doubleValue());
        }
        this.q.setLocationInflowFactors(arrayList);
    }

    @Override
    public ClipDist getAbsoluteDist() {
        MCInputTSMultiplierVariable mCInputTSMultiplierVariable = this;
        return mCInputTSMultiplierVariable.getAbsoluteDist(mCInputTSMultiplierVariable.getDefaultValue());
    }

    @Override
    public Double getRelativeValue(Double d, RssAlt rssAlt) {
        this.q = rssAlt;
        return d / this.getDefaultValue()[0] * 100.0;
    }
}

