/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.model;

import hec.clientapp.client.ClientApp;
import hec.model.RunTimeWindow;
import hec.model.SeasonalRecord;
import hec.model.TSRecord;
import hec.rss.io.ParseableDSSIdentifier;
import hec.rss.model.RssAlt;
import hec.rss.model.RssModelVariableSet;
import hec.rss.plugins.montecarlo.model.MCInputStochasticVariableImpl;
import hec.rss.plugins.montecarlo.model.MCInputVariableImpl;
import hec.rss.plugins.montecarlo.model.SeasonalDiscreteDistribution;
import hec.statistics.ClipDist;
import hec.statistics.DiscreteDist;
import hec.statistics.Parseable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Vector;
import rma.util.RMAIO;

public class MCInputTSVariable
extends MCInputStochasticVariableImpl {
    private int a = 0;
    private DiscreteDist<ParseableDSSIdentifier> b;
    private TSRecord c = null;
    private String d = null;

    public MCInputTSVariable(String string, String string2, int n, boolean bl) {
        super(string, string2, -1, n);
        this.setSeasonality(bl);
        if (bl) {
            this.b = new SeasonalDiscreteDistribution<ParseableDSSIdentifier>();
            return;
        }
        this.b = new DiscreteDist();
    }

    @Override
    public int getType() {
        return this.a;
    }

    @Override
    public String getParameterEqualString() {
        return this.m;
    }

    @Override
    public void setParameterEqualString(String string) {
        this.m = string;
    }

    public void setDiscreteDssID(SeasonalRecord seasonalRecord, ParseableDSSIdentifier parseableDSSIdentifier) {
        ((SeasonalDiscreteDistribution)this.b).add(seasonalRecord, parseableDSSIdentifier);
    }

    public void setDiscreteDssID(double d, ParseableDSSIdentifier parseableDSSIdentifier) {
        this.b.add(d, (Parseable)parseableDSSIdentifier);
    }

    public DiscreteDist<ParseableDSSIdentifier> getDiscreteDist() {
        if (this.isSeasonal()) {
            return this.b;
        }
        return this.b;
    }

    @Override
    public int getParamId() {
        return -1;
    }

    @Override
    public void setParamId(int n) {
    }

    @Override
    protected boolean a(String string, String string2, BufferedReader bufferedReader) {
        if (super.a(string, string2, bufferedReader)) {
            return true;
        }
        try {
            if (!this.isSeasonal()) {
                if (string.equals("DiscreteDistribution")) {
                    double d = Double.parseDouble(string2);
                    try {
                        bufferedReader.readLine();
                    }
                    catch (IOException iOException) {
                        System.out.println("Distribution information for the TS variable unexpectedly truncated " + String.valueOf(iOException));
                        iOException.printStackTrace();
                    }
                    string = new ParseableDSSIdentifier();
                    string.read(bufferedReader);
                    this.b.add(d, (Parseable)string);
                    return true;
                }
                return false;
            }
            this.b = new SeasonalDiscreteDistribution<ParseableDSSIdentifier>();
            ((SeasonalDiscreteDistribution)this.b).read(bufferedReader);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    protected void writeParameters(BufferedWriter bufferedWriter) {
        super.writeParameters(bufferedWriter);
        if (this.isSeasonal()) {
            ((SeasonalDiscreteDistribution)this.b).write(bufferedWriter);
            return;
        }
        for (int i = 0; i < this.b.size(); ++i) {
            double d = this.b.getWeight(i);
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("DiscreteDistribution:" + d));
            ParseableDSSIdentifier parseableDSSIdentifier = (ParseableDSSIdentifier)this.b.getValue(i);
            parseableDSSIdentifier.write(bufferedWriter);
        }
    }

    @Override
    public MCInputTSVariable clone() {
        MCInputTSVariable mCInputTSVariable = (MCInputTSVariable)super.clone();
        mCInputTSVariable.b = this.isSeasonal() ? (SeasonalDiscreteDistribution)((Object)this.b.clone()) : (DiscreteDist)this.b.clone();
        return mCInputTSVariable;
    }

    @Override
    public String getClassName() {
        return "MCInputTSVariable";
    }

    @Override
    public boolean initInputVariable(RssAlt rssAlt) {
        this.q = rssAlt;
        try {
            Vector vector = rssAlt.getSystem().getRssRun().getInputTSData().getTSRecords();
            if (vector == null) {
                System.out.println("Could not initialize the time series data.");
                return false;
            }
            for (int i = 0; i < vector.size(); ++i) {
                TSRecord tSRecord = (TSRecord)vector.get(i);
                if (tSRecord == null || !tSRecord.getName().equals(this.getLocation()) || !RssModelVariableSet.getVariableName((int)tSRecord.getVariableId()).equals(this.getParameter())) continue;
                rssAlt = rssAlt.getSystem().getRssRun().getRunTimeWindow();
                tSRecord.initialize((RunTimeWindow)rssAlt);
                this.c = tSRecord;
                if (tSRecord != null) {
                    this.d = tSRecord.getDSSPathname();
                }
                break;
            }
        }
        catch (Exception exception) {
            System.out.println("Could not initialize the time series data. " + exception.getMessage());
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean applyRealization(double d) {
        String string;
        String string2;
        if (this.isSeasonal()) {
            Object object = (SeasonalDiscreteDistribution)this.getDiscreteDist();
            int n = object.invCDFidx(d, this.q.getSystem().getRssRun().getRunTimeWindow().getStartTime());
            ((MCInputVariableImpl)this).setVariate(n);
            string2 = ((ParseableDSSIdentifier)this.getDiscreteDist().getValue(n)).getDSSPath();
            object = ClientApp.Workspace().getWorkspacePath();
            string = (String)object + "/" + ((ParseableDSSIdentifier)this.getDiscreteDist().getValue(n)).getFileName();
        } else {
            Object object = this.getDiscreteDist();
            int n = object.invCDFidx(d);
            ((MCInputVariableImpl)this).setVariate(n);
            string2 = ((ParseableDSSIdentifier)this.getDiscreteDist().getValue(n)).getDSSPath();
            object = ClientApp.Workspace().getWorkspacePath();
            string = (String)object + "/" + ((ParseableDSSIdentifier)this.getDiscreteDist().getValue(n)).getFileName();
        }
        if (this.c != null) {
            this.c.setDSSPathname(string2);
            this.c.setDSSFilename(string);
        }
        return true;
    }

    @Override
    public boolean restoreInputVariable(Object ... objectArray) {
        if (this.c == null) {
            System.out.println("Could not restore the time series to network values");
            return false;
        }
        this.c.setDSSPathname(this.d);
        return true;
    }

    public TSRecord getTSData() {
        return this.c;
    }

    @Override
    public boolean checkErrors(String[] stringArray) {
        return super.checkErrors(stringArray);
    }

    @Override
    public boolean checkWarnings(String[] stringArray, RssAlt rssAlt) {
        if (rssAlt.getSystem().getRssRun() != null) {
            ((MCInputVariableImpl)this).initInputVariable(rssAlt);
        }
        return super.checkWarnings(stringArray, rssAlt);
    }

    @Override
    public ClipDist getAbsoluteDist() {
        return null;
    }
}

