/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.model;

import hec.rss.model.RssAlt;
import hec.rss.plugins.montecarlo.model.MCInputScriptVariable;
import hec.rss.plugins.montecarlo.model.MCInputVariable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import rma.util.RMAIO;

public abstract class MCInputVariableImpl
implements MCInputVariable {
    public static final String PARAM_ID = "ParamID";
    public static final String PARAMETER_EQUAL_STRING = "ParameterEqualString";
    public static final String PARAMETER = "Parameter";
    public static final String LOCATION = "Location";
    public static final String IS_ACTIVE = "IsActive";
    public static final String VARIABLE_END = "MCInputVariableEnd";
    protected static final String j = "LocationIndex";
    protected static final Object k = "GroupNumber";
    protected static final String l = "Uncertainty Type";
    private String a;
    private int b = -1;
    private String c;
    private boolean d = false;
    private int e;
    protected String m;
    public int _uncertaintyType = 1;
    protected double n;
    private int f = 0;
    private String g = null;
    protected Map<Integer, MCInputVariableImpl> o = new HashMap<Integer, MCInputVariableImpl>();
    protected Map<Integer, String> p = new HashMap<Integer, String>();
    protected RssAlt q = null;

    public MCInputVariableImpl(String string, String string2, int n) {
        this.a = string;
        this.c = string2;
        this.e = n;
    }

    public MCInputVariableImpl(int n, String string, int n2) {
        this.b = n;
        this.c = string;
        this.e = n2;
    }

    @Override
    public void setLocation(String string) {
        this.a = string;
    }

    public void setLocationIndex(int n) {
        this.b = n;
    }

    public int getLocationIndex() {
        return this.b;
    }

    @Override
    public void setParameter(String string) {
        this.c = string;
    }

    @Override
    public String getParameterEqualString() {
        return this.m;
    }

    @Override
    public void setParameterEqualString(String string) {
        this.m = string;
    }

    public int getUncertaintyType() {
        return this._uncertaintyType;
    }

    public String getUncertaintyTypeName() {
        if (this._uncertaintyType == 0) {
            return "Epistemic";
        }
        return "Aleatoric";
    }

    public String getUncertaintyTypeNameForReport() {
        if (this._uncertaintyType == 0) {
            return "knowl.uncert";
        }
        return "natural.var";
    }

    public void setUncertaintyType(int n) {
        this._uncertaintyType = n;
    }

    public void setUncertaintyTypeByName(String string) {
        if (string.toLowerCase().startsWith("epi") || string.toLowerCase().contains("knowledge uncertainty")) {
            this._uncertaintyType = 0;
            return;
        }
        if (string.toLowerCase().startsWith("ale") || string.toLowerCase().contains("natural variability")) {
            this._uncertaintyType = 1;
            return;
        }
        System.out.println("WARNING: uncertainty type " + string + " is not a recognized type of uncertainty (epistemic or aleatoric). Defaulting to natural variability (aleatoric)");
    }

    @Override
    public abstract int getType();

    @Override
    public String getLocation() {
        return this.a;
    }

    @Override
    public String getParameter() {
        return this.c;
    }

    @Override
    public void setActive(boolean bl) {
        this.d = bl;
    }

    @Override
    public boolean isActive() {
        return this.d;
    }

    @Override
    public int getParamId() {
        return this.e;
    }

    @Override
    public void setParamId(int n) {
        this.e = n;
    }

    @Override
    public void read(BufferedReader bufferedReader) {
        try {
            Object object = bufferedReader.readLine();
            while (object != null) {
                boolean bl;
                if (((String)object).length() == 0) {
                    object = bufferedReader.readLine();
                    continue;
                }
                BufferedReader bufferedReader2 = bufferedReader;
                String string = object;
                object = this;
                String string2 = RMAIO.getType((String)string, (String)":");
                string = RMAIO.getParam((String)string, (String)":");
                if (string2.equals(VARIABLE_END)) {
                    bl = false;
                } else {
                    boolean bl2;
                    ((MCInputVariableImpl)object).a(string2, string, bufferedReader2);
                    bl = bl2 = true;
                }
                if (bl) {
                    object = bufferedReader.readLine();
                    continue;
                }
                return;
            }
            return;
        }
        catch (IOException iOException) {
            System.out.println("Failed to read Monte Carlo Plugin Data MCInputLookbackVariable.");
            iOException.printStackTrace();
            return;
        }
    }

    protected boolean a(String string, String string2, BufferedReader bufferedReader) {
        if (string.equals(IS_ACTIVE)) {
            this.setActive(Boolean.parseBoolean(string2));
        } else if (string.equals(LOCATION)) {
            this.setLocation(string2);
        } else if (string.equals(j)) {
            this.setLocationIndex(Integer.parseInt(string2));
        } else if (string.equals(PARAMETER)) {
            this.setParameter(string2);
        } else if (string.equals(PARAMETER_EQUAL_STRING)) {
            this.setParameterEqualString(string2);
        } else if (string.equals(PARAM_ID)) {
            this.setParamId(Integer.parseInt(string2));
        } else if (string.equals("DependentVariable")) {
            int n = Integer.valueOf(string2.substring(0, string2.indexOf("-")));
            String string3 = string2;
            string2 = string3.substring(string3.indexOf("-") + 1, string2.length());
            this.addVariableName(n, string2);
        } else if (string.equals(l)) {
            this.setUncertaintyTypeByName(string2);
        } else if (string.equals(k)) {
            this.setGroupNumber(Integer.parseInt(string2));
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void write(BufferedWriter bufferedWriter) {
        this.writeParameters(bufferedWriter);
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)VARIABLE_END);
    }

    protected void writeParameters(BufferedWriter bufferedWriter) {
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Location:" + this.getLocation()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("LocationIndex:" + this.getLocationIndex()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Parameter:" + this.getParameter()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("IsActive:" + this.isActive()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("ParamID:" + this.getParamId()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("ParameterEqualString:" + this.getParameterEqualString()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Uncertainty Type:" + this.getUncertaintyTypeName()));
        for (Integer n : this.p.keySet()) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("DependentVariable:" + n + "-" + this.p.get(n)));
        }
    }

    @Override
    public MCInputVariableImpl clone() {
        try {
            MCInputVariableImpl mCInputVariableImpl = (MCInputVariableImpl)super.clone();
            ((MCInputVariableImpl)super.clone()).m = this.m;
            mCInputVariableImpl._uncertaintyType = this._uncertaintyType;
            mCInputVariableImpl.f = this.f;
            return mCInputVariableImpl;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("MCInputVariableImpl.clone(): Error in clone " + String.valueOf(cloneNotSupportedException));
            return null;
        }
    }

    @Override
    public abstract String getClassName();

    public String getVariableName() {
        if (this.getType() == 0) {
            return "Time Series";
        }
        if (this.getType() == 4) {
            return "Time Series Multiplier";
        }
        if (this.getType() == 1) {
            return "Rule Parameter";
        }
        if (this.getType() == 3) {
            return "Rating Curve";
        }
        if (this.getType() == 4) {
            return "Time Series Multiplier";
        }
        if (this.getType() == 2) {
            return "Lookback";
        }
        return "Script";
    }

    @Override
    public boolean initInputVariable(RssAlt rssAlt) {
        return false;
    }

    @Override
    public abstract boolean applyRealization(double var1);

    @Override
    public boolean restoreInputVariable(Object ... objectArray) {
        return false;
    }

    @Override
    public boolean checkErrors(String[] stringArray) {
        return true;
    }

    @Override
    public boolean checkWarnings(String[] stringArray, RssAlt rssAlt) {
        return true;
    }

    public double getVariate() {
        return this.n;
    }

    public void setVariate(double d) {
        this.n = d;
    }

    public int getGroupNumber() {
        return this.f;
    }

    public void setGroupNumber(int n) {
        this.f = n;
    }

    public String getShortName() {
        Object object = this.getType() == 0 ? "TS:" : (this.getType() == 4 ? "TS Mult:" : (this.getType() == 1 ? "Res Par:" : (this.getType() == 3 ? "Rating Cur:" : (this.getType() == 2 ? "Lookback:" : ((MCInputScriptVariable)this).getDescription() + ":"))));
        object = ((String)object).concat(this.getShortLocation() + ":" + this.getShortParameter());
        return object;
    }

    public String getShortParameter() {
        String string = this.getParameter();
        string = string.trim();
        string = string.replace(" ", "");
        string = string.replace("Lookback", "");
        string = string.replace("Elevation", "Elev.");
        return string;
    }

    public String getShortLocation() {
        String string = this.getLocation();
        string = string.trim();
        string = string.replace(" ", "");
        string = string.replace("Junction", "Junc.");
        return string;
    }

    public void addDependentVariable(Integer n, MCInputVariableImpl mCInputVariableImpl) {
        this.p.put(n, mCInputVariableImpl.getShortName());
        this.o.put(n, mCInputVariableImpl);
    }

    public void setDependentVariableNames(Map<Integer, String> map) {
        for (Integer n : map.keySet()) {
            this.addVariableName(n, map.get(n));
        }
    }

    public Map<Integer, String> getInputVariableNames() {
        return this.p;
    }

    public void addVariableName(Integer n, String string) {
        this.p.put(n, string);
    }

    public String getCorrelationSetName() {
        return this.g;
    }

    public void setCorrelationSetName(String string) {
        this.g = string;
    }

    public void setAlt(RssAlt rssAlt) {
        this.q = rssAlt;
    }

    public RssAlt getAlt() {
        return this.q;
    }
}

