/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.model;

import hec.rss.model.PythonScriptContainer;
import hec.rss.model.PythonScriptMap;
import java.io.BufferedWriter;
import java.util.ArrayList;
import org.python.util.PythonInterpreter;

public class MCSampleScripts
extends PythonScriptMap {
    private static String a = "InitScript";
    private static String b = "MainScript";
    private static String c = "CleanupScript";
    public static String PRESAMPLE_HEADER = "Pre-Sample Script";
    public static String POSTSAMPLE_HEADER = "Post-Sample Script";
    private boolean d;

    public MCSampleScripts(boolean bl) {
        this.d = bl;
        this.put(a, new PythonScriptContainer());
        this.put(b, new PythonScriptContainer());
        this.put(c, new PythonScriptContainer());
    }

    public String getInitScript() {
        return this.get(a).getScript();
    }

    public String getMainScript() {
        return this.get(b).getScript();
    }

    public String getCleanupScript() {
        return this.get(c).getScript();
    }

    public void setInitScript(String string) {
        this.get(a).setScript(string);
    }

    public void setMainScript(String string) {
        this.get(b).setScript(string);
    }

    public void setCleanupScript(String string) {
        this.get(c).setScript(string);
    }

    public void runInitScript() {
        if (this.getInitScript() != null && !this.getInitScript().isEmpty()) {
            try {
                this.get(a).b();
                return;
            }
            catch (Exception exception) {
                System.out.println("Python Compilation Error of Monte Carlo initialization script failed " + String.valueOf(exception));
            }
        }
    }

    public void runMainScript() {
        String string = this.d ? "pre-sample" : "post-sample";
        if (this.getMainScript() != null && !this.getMainScript().isEmpty()) {
            try {
                this.get(b).b();
                return;
            }
            catch (Exception exception) {
                System.out.println("Python Compilation Error of Monte Carlo " + string + " script failed " + String.valueOf(exception));
            }
        }
    }

    public void runCleanupScript() {
        if (this.getCleanupScript() != null && !this.getCleanupScript().isEmpty()) {
            try {
                this.get(c).b();
                return;
            }
            catch (Exception exception) {
                System.out.println("Python Compilation Error of Monte Carlo cleanup script failed " + String.valueOf(exception));
            }
        }
    }

    public void write(BufferedWriter bufferedWriter) {
        String string = this.d ? PRESAMPLE_HEADER : POSTSAMPLE_HEADER;
        PythonScriptContainer.a((BufferedWriter)bufferedWriter, (String)(string + ":"));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(a);
        arrayList.add(b);
        arrayList.add(c);
        this.setWritingOrder(arrayList);
        super.write(bufferedWriter);
        PythonScriptContainer.a((BufferedWriter)bufferedWriter, (String)(string + " End"));
    }

    public void initCompute() {
        this.setInterpreter(new PythonInterpreter());
    }
}

