/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.model;

import hec.heclib.util.HecTime;
import hec.model.RunTimeStep;
import hec.model.SeasonalRecord;
import hec.rss.plugins.montecarlo.model.SeasonalContinuousDistribution;
import hec.statistics.AbstractContDist;
import hec.statistics.ClipData;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class SeasonalClipData
extends ClipData {
    private SeasonalRecord a = new SeasonalRecord();
    private SeasonalRecord b = new SeasonalRecord();
    private SeasonalRecord c = new SeasonalRecord();
    private SeasonalRecord d = new SeasonalRecord();
    private List<HecTime> e;
    private SeasonalContinuousDistribution f;

    public SeasonalClipData(SeasonalContinuousDistribution seasonalContinuousDistribution) {
        this.e = seasonalContinuousDistribution.getFullHecTimes();
        this.f = seasonalContinuousDistribution;
        this.a.setInterpolationType(2);
        this.c.setInterpolationType(2);
        this.b.setInterpolationType(2);
        this.d.setInterpolationType(2);
    }

    public void setMinVal(double d) {
        int[] nArray;
        if (this.a.getTimeArray() == null || this.a.getTimeArray().length != this.e.size()) {
            nArray = new int[this.e.size()];
            for (int i = 0; i < this.e.size(); ++i) {
                nArray[i] = HecTime.iymdjl((int)1900, (int)this.e.get(i).month(), (int)this.e.get(i).day()) * 1440;
            }
        } else {
            nArray = this.a.getTimeArray();
        }
        double[] dArray = new double[this.e.size()];
        for (int i = 0; i < this.e.size(); ++i) {
            dArray[i] = d;
        }
        SeasonalRecord seasonalRecord = new SeasonalRecord();
        seasonalRecord.setArrays(nArray, dArray);
        this.setMinVal(seasonalRecord);
        super.setMinVal(d);
    }

    public SeasonalRecord getMaxValRecord() {
        return this.b;
    }

    public SeasonalRecord getMinValRecord() {
        return this.a;
    }

    public SeasonalRecord getMaxProbRecord() {
        return this.d;
    }

    public SeasonalRecord getMinProbRecord() {
        return this.c;
    }

    public void setMaxVal(double d) {
        int[] nArray;
        if (this.b.getTimeArray() == null || this.b.getTimeArray().length != this.e.size()) {
            nArray = new int[this.e.size()];
            for (int i = 0; i < this.e.size(); ++i) {
                nArray[i] = HecTime.iymdjl((int)1900, (int)this.e.get(i).month(), (int)this.e.get(i).day()) * 1440;
            }
        } else {
            nArray = this.b.getTimeArray();
        }
        double[] dArray = new double[this.e.size()];
        for (int i = 0; i < this.e.size(); ++i) {
            dArray[i] = d;
        }
        SeasonalRecord seasonalRecord = new SeasonalRecord();
        seasonalRecord.setArrays(nArray, dArray);
        this.setMaxVal(seasonalRecord);
        super.setMaxVal(d);
    }

    public void setMinVal(SeasonalRecord seasonalRecord) {
        this.a = seasonalRecord;
        this.a.setInterpolationType(2);
        if (this.a.size() < this.e.size()) {
            SeasonalClipData.a(this.a);
        }
        SeasonalClipData.b(this.c);
        this.a();
    }

    public void setMinClip(boolean bl) {
        super.setMinClip(bl);
        if (!bl) {
            this.setMinProb(0.0);
        }
    }

    public boolean hasMinClip() {
        this.a();
        return super.hasMinClip();
    }

    private void a() {
        int[] nArray = this.a.getTimeArray();
        if (nArray == null) {
            return;
        }
        double[] dArray = new double[nArray.length];
        boolean bl = super.hasMaxClip();
        super.setMaxClip(false);
        boolean bl2 = super.hasMinClip();
        super.setMinClip(false);
        for (int i = 0; i < nArray.length; ++i) {
            dArray[i] = this.f.getDist(i).getCDF(this.a.getDataArray()[i]);
        }
        super.setMaxClip(bl);
        super.setMinClip(bl2);
        this.c.setArrays(nArray, dArray);
    }

    public boolean hasMaxClip() {
        this.b();
        return super.hasMaxClip();
    }

    private void b() {
        int[] nArray = this.b.getTimeArray();
        if (nArray == null) {
            return;
        }
        double[] dArray = new double[nArray.length];
        boolean bl = super.hasMinClip();
        super.setMinClip(false);
        boolean bl2 = super.hasMaxClip();
        super.setMaxClip(false);
        for (int i = 0; i < nArray.length; ++i) {
            dArray[i] = this.f.getDist(i).getCDF(this.b.getDataArray()[i]);
        }
        super.setMinClip(bl);
        super.setMaxClip(bl2);
        this.d.setArrays(nArray, dArray);
    }

    public void setMinProb(double d) {
        int[] nArray;
        if (this.c.getTimeArray() == null || this.c.getTimeArray().length != this.e.size()) {
            nArray = new int[this.e.size()];
            for (int i = 0; i < this.e.size(); ++i) {
                nArray[i] = HecTime.iymdjl((int)1900, (int)this.e.get(i).month(), (int)this.e.get(i).day()) * 1440;
            }
        } else {
            nArray = this.c.getTimeArray();
        }
        double[] dArray = new double[this.e.size()];
        for (int i = 0; i < this.e.size(); ++i) {
            dArray[i] = d;
        }
        SeasonalRecord seasonalRecord = new SeasonalRecord();
        seasonalRecord.setArrays(nArray, dArray);
        this.setMinProb(seasonalRecord);
        super.setMinProb(d);
    }

    public void setMaxClip(boolean bl) {
        super.setMaxClip(bl);
        if (!bl) {
            this.setMaxProb(1.0);
        }
    }

    public void setMaxProb(double d) {
        int[] nArray;
        if (this.d.getTimeArray() == null || this.d.getTimeArray().length != this.e.size()) {
            nArray = new int[this.e.size()];
            for (int i = 0; i < this.e.size(); ++i) {
                nArray[i] = HecTime.iymdjl((int)1900, (int)this.e.get(i).month(), (int)this.e.get(i).day()) * 1440;
            }
        } else {
            nArray = this.d.getTimeArray();
        }
        double[] dArray = new double[this.e.size()];
        for (int i = 0; i < this.e.size(); ++i) {
            dArray[i] = d;
        }
        SeasonalRecord seasonalRecord = new SeasonalRecord();
        seasonalRecord.setArrays(nArray, dArray);
        this.setMaxProb(seasonalRecord);
        super.setMaxProb(d);
    }

    private static void a(SeasonalRecord seasonalRecord) {
        int[] nArray = seasonalRecord.getTimeArray();
        int[] nArray2 = new int[nArray.length + 1];
        double[] dArray = seasonalRecord.getDataArray();
        double[] dArray2 = new double[nArray.length + 1];
        for (int i = 0; i < nArray.length; ++i) {
            dArray2[i] = dArray[i];
        }
        dArray2[nArray.length] = dArray[0];
        seasonalRecord.setArrays(nArray2, dArray2);
    }

    public ClipData getClipData(RunTimeStep runTimeStep) {
        ClipData clipData = (ClipData)this.f.getDefaultDist().getClipData().clone();
        clipData.setMaxClip(this.b(runTimeStep));
        clipData.setMinClip(this.a(runTimeStep));
        clipData.setMaxVal(this.c(runTimeStep));
        clipData.setMinVal(this.d(runTimeStep));
        return clipData;
    }

    private boolean a(RunTimeStep runTimeStep) {
        if (this.getMinProbRecord().getDataArray() == null) {
            return false;
        }
        return this.getMinProbRecord().interpolate(runTimeStep.getHecTime()) > 0.0;
    }

    private boolean b(RunTimeStep runTimeStep) {
        if (this.getMaxProbRecord().getDataArray() == null) {
            return false;
        }
        return this.getMaxProbRecord().interpolate(runTimeStep.getHecTime()) < 1.0;
    }

    public ClipData getClipData(int n) {
        ClipData clipData = (ClipData)this.f.getDefaultDist().getClipData().clone();
        int n2 = n;
        SeasonalClipData seasonalClipData = this;
        clipData.setMaxClip(seasonalClipData.getMaxProbRecord().getDataArray() != null && seasonalClipData.getMaxProbRecord().getDataArray().length > n2 && seasonalClipData.getMaxProbRecord().getDataArray()[n2] < 1.0 && super.hasMaxClip());
        n2 = n;
        seasonalClipData = this;
        clipData.setMinClip(seasonalClipData.getMinProbRecord().getDataArray() != null && seasonalClipData.getMinProbRecord().getDataArray().length > n2 && seasonalClipData.getMinProbRecord().getDataArray()[n2] > 0.0 && super.hasMinClip());
        clipData.setMaxVal(this.a(n));
        clipData.setMinVal(this.b(n));
        return clipData;
    }

    private double a(int n) {
        while (true) {
            if (this.b.getTimeArray() == null) {
                return this.getMaxVal();
            }
            if (this.b.getTimeArray().length > n) break;
            n = 0;
        }
        return this.b.getDataArray()[n];
    }

    private double b(int n) {
        while (true) {
            if (this.a.getTimeArray() == null) {
                return this.getMinVal();
            }
            if (this.a.getTimeArray().length > n) break;
            n = 0;
        }
        return this.a.getDataArray()[n];
    }

    private double c(RunTimeStep runTimeStep) {
        return this.b.interpolate(runTimeStep);
    }

    private double d(RunTimeStep runTimeStep) {
        return this.a.interpolate(runTimeStep);
    }

    public void setMinProb(SeasonalRecord object) {
        this.c = object;
        this.c.setInterpolationType(2);
        SeasonalClipData.b(this.a);
        int[] nArray = this.c.getTimeArray();
        object = nArray;
        double[] dArray = new double[nArray.length];
        for (int i = 0; i < ((SeasonalRecord)object).length; ++i) {
            dArray[i] = this.f.getDist(i).invCDF(this.c.getDataArray()[i]);
        }
        this.a.setArrays((int[])object, dArray);
    }

    private static void b(SeasonalRecord seasonalRecord) {
        seasonalRecord.clear();
        seasonalRecord.setInterpolationType(2);
    }

    public void setMaxVal(SeasonalRecord seasonalRecord) {
        this.b = seasonalRecord;
        this.b.setInterpolationType(2);
        if (this.b.size() < this.e.size()) {
            SeasonalClipData.a(this.b);
        }
        SeasonalClipData.b(this.d);
        this.b();
    }

    public void setMaxProb(SeasonalRecord object) {
        this.d = object;
        this.d.setInterpolationType(2);
        SeasonalClipData.b(this.b);
        int[] nArray = this.d.getTimeArray();
        object = nArray;
        double[] dArray = new double[nArray.length];
        for (int i = 0; i < ((SeasonalRecord)object).length; ++i) {
            dArray[i] = this.f.getDist(i).invCDF(this.d.getDataArray()[i]);
        }
        this.b.setArrays((int[])object, dArray);
    }

    public Object clone() {
        Object object = new ArrayList<HecTime>();
        Object object2 = new ArrayList<AbstractContDist>();
        for (int i = 0; i < this.e.size(); ++i) {
            object.add((HecTime)this.e.get(i).clone());
            object2.add((AbstractContDist)((AbstractContDist)this.f.getDist(i).clone()));
        }
        Object object3 = new SeasonalContinuousDistribution((List<HecTime>)object, (List<AbstractContDist>)object2, new RunTimeStep(this.f.getRunTimeStep()));
        object = new SeasonalClipData((SeasonalContinuousDistribution)((Object)object3));
        ((SeasonalClipData)((Object)object)).setMinClip(this.hasMinClip());
        int[] nArray = this.getMinValRecord().getTimeArray();
        object2 = nArray;
        object3 = new int[nArray.length];
        for (int i = 0; i < ((SeasonalContinuousDistribution)object3).length; ++i) {
            object3[i] = object2[i];
        }
        object2 = object3;
        ((SeasonalClipData)((Object)object)).getMinValRecord().setArrays((int[])object2, SeasonalClipData.a(this.getMinValRecord().getDataArray()));
        ((SeasonalClipData)((Object)object)).getMinProbRecord().setArrays((int[])object2, SeasonalClipData.a(this.getMinProbRecord().getDataArray()));
        ((SeasonalClipData)((Object)object)).setMaxClip(this.hasMaxClip());
        ((SeasonalClipData)((Object)object)).getMaxValRecord().setArrays((int[])object2, SeasonalClipData.a(this.getMaxValRecord().getDataArray()));
        ((SeasonalClipData)((Object)object)).getMaxProbRecord().setArrays((int[])object2, SeasonalClipData.a(this.getMaxProbRecord().getDataArray()));
        return object;
    }

    private static double[] a(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray[i];
        }
        return dArray2;
    }

    public double[] getClipParamVals() {
        SeasonalClipData seasonalClipData = this;
        int n = 0 + (seasonalClipData.a(seasonalClipData.f.getRunTimeStep()) ? 1 : 0);
        SeasonalClipData seasonalClipData2 = this;
        double[] dArray = new double[n += seasonalClipData2.b(seasonalClipData2.f.getRunTimeStep()) ? 1 : 0];
        int n2 = 0;
        SeasonalClipData seasonalClipData3 = this;
        if (seasonalClipData3.a(seasonalClipData3.f.getRunTimeStep())) {
            ++n2;
            SeasonalClipData seasonalClipData4 = this;
            dArray[0] = seasonalClipData4.d(seasonalClipData4.f.getRunTimeStep());
        }
        SeasonalClipData seasonalClipData5 = this;
        if (seasonalClipData5.b(seasonalClipData5.f.getRunTimeStep())) {
            SeasonalClipData seasonalClipData6 = this;
            dArray[n2] = seasonalClipData6.c(seasonalClipData6.f.getRunTimeStep());
        }
        return dArray;
    }

    public String[] getClipParamNames() {
        SeasonalClipData seasonalClipData = this;
        int n = 0 + (seasonalClipData.a(seasonalClipData.f.getRunTimeStep()) ? 1 : 0);
        SeasonalClipData seasonalClipData2 = this;
        String[] stringArray = new String[n += seasonalClipData2.b(seasonalClipData2.f.getRunTimeStep()) ? 1 : 0];
        int n2 = 0;
        SeasonalClipData seasonalClipData3 = this;
        if (seasonalClipData3.a(seasonalClipData3.f.getRunTimeStep())) {
            ++n2;
            stringArray[0] = "Min";
        }
        SeasonalClipData seasonalClipData4 = this;
        if (seasonalClipData4.b(seasonalClipData4.f.getRunTimeStep())) {
            stringArray[n2] = "Max";
        }
        return stringArray;
    }

    public String getSummary(String string) {
        String[] stringArray = this.getClipParamNames();
        double[] dArray = this.getClipParamVals();
        if (stringArray == null || stringArray.length == 0) {
            return "No clipping";
        }
        DecimalFormat decimalFormat = new DecimalFormat("##.##");
        Object object = "";
        for (int i = 0; i < stringArray.length; ++i) {
            RunTimeStep runTimeStep;
            object = (String)object + stringArray[i] + "=" + String.format(string, dArray[i]) + (i < stringArray.length - 1 ? "," : "");
            if (stringArray[i].equals("Min")) {
                Object object2 = object;
                SeasonalClipData seasonalClipData = this;
                runTimeStep = seasonalClipData.f.getRunTimeStep();
                object = seasonalClipData;
                object = (String)object2 + "(" + decimalFormat.format(seasonalClipData.c.interpolate(runTimeStep) * 100.0) + "%)";
            }
            if (!stringArray[i].equals("Max")) continue;
            Object object3 = object;
            SeasonalClipData seasonalClipData = this;
            runTimeStep = seasonalClipData.f.getRunTimeStep();
            object = seasonalClipData;
            object = (String)object3 + "(" + decimalFormat.format(100.0 - seasonalClipData.d.interpolate(runTimeStep) * 100.0) + "%)";
        }
        return object;
    }
}

