/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.model;

import hec.heclib.util.HecTime;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.model.SeasonalRecord;
import hec.rss.plugins.montecarlo.model.SeasonalClipData;
import hec.statistics.AbstractContDist;
import hec.statistics.ClipData;
import hec.statistics.ClipDist;
import hec.statistics.EmpiricalClipDist;
import hec.statistics.EmpiricalDist;
import hec.statistics.GammaClipDist;
import hec.statistics.GammaDist;
import hec.statistics.LinearMoments;
import hec.statistics.Log10NormalB17BClipDist;
import hec.statistics.Log10NormalClipDist;
import hec.statistics.LogNormalClipDist;
import hec.statistics.LogNormalDist;
import hec.statistics.MultiParametrizadDist;
import hec.statistics.NormalClipDist;
import hec.statistics.NormalDist;
import hec.statistics.ProductMoments;
import hec.statistics.TriangClipDist;
import hec.statistics.TriangDist;
import hec.statistics.UnifClipDist;
import hec.statistics.UnifDist;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import rma.util.RMAIO;

public class SeasonalContinuousDistribution
extends AbstractContDist
implements ClipDist {
    private List<SeasonalRecord> b = new ArrayList<SeasonalRecord>();
    private AbstractContDist c;
    private RunTimeStep d = null;
    private String[] e;
    private String f;
    private List<HecTime> g;
    private boolean h = false;
    protected SeasonalClipData a;

    public SeasonalContinuousDistribution() {
    }

    public SeasonalContinuousDistribution(List<HecTime> list, List<AbstractContDist> list2) {
        this.initialize(list, list2);
    }

    public SeasonalContinuousDistribution(List<HecTime> object, List<AbstractContDist> runTimeStep, RunTimeStep runTimeStep2) {
        this.initialize((List<HecTime>)object, (List<AbstractContDist>)runTimeStep);
        runTimeStep = runTimeStep2;
        object = this;
        this.d = runTimeStep;
    }

    public void initialize(List<HecTime> list, List<AbstractContDist> list2) {
        int n;
        boolean bl;
        Object object;
        Object object2;
        List<HecTime> list3;
        List<AbstractContDist> list4;
        block15: {
            this.c = list2.get(0);
            this.g = list;
            list4 = list2;
            list3 = list;
            object2 = this;
            object = new ArrayList();
            ArrayList<AbstractContDist> arrayList = new ArrayList<AbstractContDist>();
            while (!list3.isEmpty()) {
                list3.get(0).showTimeAsBeginningOfDay(true);
                int n2 = list3.get(0).julian();
                int n3 = 0;
                for (int i = 1; i < list3.size(); ++i) {
                    if (n2 <= list3.get(i).julian()) continue;
                    n2 = list3.get(i).julian();
                    n3 = i;
                }
                object.add((Object)list3.get(n3));
                list3.remove(n3);
                arrayList.add(list4.get(n3));
                list4.remove(n3);
            }
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                HecTime hecTime = (HecTime)iterator.next();
                list3.add(hecTime);
            }
            for (AbstractContDist abstractContDist : arrayList) {
                list4.add(abstractContDist);
            }
            object = list3;
            for (int i = 0; i < object.size(); ++i) {
                if (((HecTime)object.get(i)).day() != 31 || ((HecTime)object.get(i)).month() != 12) continue;
                bl = true;
                break block15;
            }
            bl = false;
        }
        if (!bl) {
            object2.h = false;
            list3.add(new HecTime("12/31/1900"));
            List<AbstractContDist> list5 = list4;
            list5.add((AbstractContDist)list5.get(0).clone());
        }
        object2 = new int[list.size()];
        for (n = 0; n < list.size(); ++n) {
            object2[n] = (SeasonalContinuousDistribution)(HecTime.iymdjl((int)1900, (int)list.get(n).month(), (int)list.get(n).day()) * 1440);
        }
        n = list2.get(0) instanceof EmpiricalDist ? ((EmpiricalDist)list2.get(0)).getNumRows() : list2.get(0).getParamVals().length;
        for (int i = 0; i < n; ++i) {
            object = new double[list.size()];
            for (int j = 0; j < list.size(); ++j) {
                object[j] = list2.get(j) instanceof EmpiricalDist ? (Object)((EmpiricalDist)list2.get(j)).getValue(i) : (Object)list2.get(j).getParamVals()[i];
            }
            SeasonalRecord seasonalRecord = new SeasonalRecord();
            seasonalRecord.setArrays((int[])object2, (double[])object);
            seasonalRecord.setInterpolationType(2);
            this.b.add(seasonalRecord);
        }
        this.e = list2.get(0) instanceof MultiParametrizadDist ? ((MultiParametrizadDist)list2.get(0)).getActiveParamNames() : list2.get(0).getParamNames();
        this.f = list2.get(0).getType();
        if (list2.get(0) instanceof EmpiricalDist && ((EmpiricalDist)list2.get(0)).getInterpType() == EmpiricalDist.InterpType.STEP) {
            this.f = "Discrete";
        }
        if (list2.get(0) instanceof ClipDist) {
            double[] dArray = new double[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                dArray[i] = ((ClipDist)list2.get(i)).getClipData().getMinVal();
            }
            object = new SeasonalRecord();
            object.setArrays((int[])object2, dArray);
            object.setInterpolationType(2);
            this.a = new SeasonalClipData(this);
            this.a.setMinVal((SeasonalRecord)object);
            dArray = new double[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                dArray[i] = ((ClipDist)list2.get(i)).getClipData().getMaxVal();
            }
            object = new SeasonalRecord();
            object.setArrays((int[])object2, dArray);
            object.setInterpolationType(2);
            this.a.setMaxVal((SeasonalRecord)object);
        }
        RunTimeWindow runTimeWindow = new RunTimeWindow(new HecTime("01/01/00", "00:00:01"), new HecTime("12/31/00", "00:00:01"), new HecTime("01/02/00", "00:00:01"));
        runTimeWindow.setTimeStep(1, 3);
        this.d = new RunTimeStep(runTimeWindow);
        int n4 = 0;
        while (true) {
            SeasonalContinuousDistribution seasonalContinuousDistribution = this;
            if (n4 >= seasonalContinuousDistribution.getDist(seasonalContinuousDistribution.getHecTimes().size()).getParamVals().length) break;
            SeasonalContinuousDistribution seasonalContinuousDistribution2 = this;
            if (seasonalContinuousDistribution2.getDist(seasonalContinuousDistribution2.getHecTimes().size()).getParamVals()[n4] != this.getDist(0).getParamVals()[n4]) {
                this.setDoesDec31Exist(true);
                return;
            }
            ++n4;
        }
    }

    public SeasonalContinuousDistribution(AbstractContDist abstractContDist, List<SeasonalRecord> list, ClipDist clipDist, String[] stringArray, String string, RunTimeStep runTimeStep) {
        this.c = abstractContDist;
        this.b = list;
        this.e = stringArray;
        this.f = string;
        this.d = runTimeStep;
    }

    public AbstractContDist getDist() {
        SeasonalContinuousDistribution seasonalContinuousDistribution = this;
        return seasonalContinuousDistribution.buildDistribution(seasonalContinuousDistribution.getParams());
    }

    public Object[] getParams() {
        Object[] objectArray;
        if (this.f.contains("Empirical")) {
            objectArray = new Object[3];
            if (((EmpiricalDist)this.c).getInterpType() == null) {
                ((EmpiricalDist)this.c).setInterpType(EmpiricalDist.InterpType.LINEAR);
            }
            objectArray[0] = ((EmpiricalDist)this.c).getInterpType();
            if (((EmpiricalDist)this.c).getValues().length > 0) {
                objectArray[0] = ((EmpiricalDist)this.c).getInterpType();
                objectArray[1] = ((EmpiricalDist)this.c).getCumProbs();
                double[] dArray = new double[this.b.size()];
                for (int i = 0; i < this.b.size(); ++i) {
                    dArray[i] = this.b.get(i).interpolate(this.d);
                }
                objectArray[2] = dArray;
            } else {
                objectArray[1] = new double[0];
                objectArray[2] = new double[0];
            }
        } else if (this.f.contains("Discrete")) {
            objectArray = new Object[3];
            if (((EmpiricalDist)this.c).getInterpType() == null) {
                ((EmpiricalDist)this.c).setInterpType(EmpiricalDist.InterpType.STEP);
            }
            objectArray[0] = ((EmpiricalDist)this.c).getInterpType();
            if (((EmpiricalDist)this.c).getValues().length > 0) {
                objectArray[0] = ((EmpiricalDist)this.c).getInterpType();
                objectArray[1] = ((EmpiricalDist)this.c).getCumProbs();
                double[] dArray = new double[this.b.size()];
                for (int i = 0; i < this.b.size(); ++i) {
                    dArray[i] = this.b.get(i).interpolate(this.d);
                }
                objectArray[2] = dArray;
            } else {
                objectArray[1] = new double[0];
                objectArray[2] = new double[0];
            }
        } else {
            objectArray = new Object[this.b.size()];
            for (int i = 0; i < this.b.size(); ++i) {
                objectArray[i] = this.b.get(i).interpolate(this.d);
            }
        }
        return objectArray;
    }

    public AbstractContDist getDist(int n) {
        SeasonalContinuousDistribution seasonalContinuousDistribution = this;
        return seasonalContinuousDistribution.buildDistribution(seasonalContinuousDistribution.getParams(n), n);
    }

    public Object[] getParams(int n) {
        Object[] objectArray;
        if (this.f.contains("Empirical")) {
            objectArray = new Object[3];
            if (((EmpiricalDist)this.c).getInterpType() == null) {
                ((EmpiricalDist)this.c).setInterpType(EmpiricalDist.InterpType.LINEAR);
            }
            objectArray[0] = ((EmpiricalDist)this.c).getInterpType();
            if (((EmpiricalDist)this.c).getValues().length > 0) {
                objectArray[1] = ((EmpiricalDist)this.c).getCumProbs();
                double[] dArray = new double[this.b.size()];
                for (int i = 0; i < this.b.size(); ++i) {
                    dArray[i] = this.b.get(i).getDataArray()[n];
                }
                objectArray[2] = dArray;
            } else {
                objectArray[1] = new double[0];
                objectArray[2] = new double[0];
            }
        } else if (this.f.contains("Discrete")) {
            objectArray = new Object[3];
            if (((EmpiricalDist)this.c).getInterpType() == null) {
                ((EmpiricalDist)this.c).setInterpType(EmpiricalDist.InterpType.STEP);
            }
            objectArray[0] = ((EmpiricalDist)this.c).getInterpType();
            if (((EmpiricalDist)this.c).getValues().length > 0) {
                objectArray[1] = ((EmpiricalDist)this.c).getCumProbs();
                double[] dArray = new double[this.b.size()];
                for (int i = 0; i < this.b.size(); ++i) {
                    dArray[i] = this.b.get(i).getDataArray()[n];
                }
                objectArray[2] = dArray;
            } else {
                objectArray[1] = new double[0];
                objectArray[2] = new double[0];
            }
        } else {
            objectArray = new Object[this.b.size()];
            for (int i = 0; i < this.b.size(); ++i) {
                objectArray[i] = this.b.get(i).getDataArray()[n];
            }
        }
        return objectArray;
    }

    public AbstractContDist buildDistribution(Object[] clipData) {
        try {
            AbstractContDist abstractContDist;
            Class[] classArray = new Class[((Object[])clipData).length];
            for (int i = 0; i < ((Object[])clipData).length; ++i) {
                abstractContDist = clipData[i].getClass();
                classArray[i] = abstractContDist.equals(Double.class) ? Double.TYPE : abstractContDist;
            }
            Constructor<?> constructor = this.c.getClass().getDeclaredConstructor(classArray);
            abstractContDist = (AbstractContDist)constructor.newInstance((Object[])clipData);
            if (this.c instanceof MultiParametrizadDist) {
                ((MultiParametrizadDist)abstractContDist).setParametrizationNumber(((MultiParametrizadDist)this.c).getParametrizationNumber());
            }
            if (!(abstractContDist instanceof EmpiricalDist)) {
                clipData = ((ClipDist)abstractContDist).getClipData();
                SeasonalContinuousDistribution seasonalContinuousDistribution = this;
                clipData.setMaxVal(seasonalContinuousDistribution.getClipData(seasonalContinuousDistribution.d).getMaxVal());
                SeasonalContinuousDistribution seasonalContinuousDistribution2 = this;
                clipData.setMaxClip(seasonalContinuousDistribution2.getClipData(seasonalContinuousDistribution2.d).hasMaxClip());
                SeasonalContinuousDistribution seasonalContinuousDistribution3 = this;
                clipData.setMinVal(seasonalContinuousDistribution3.getClipData(seasonalContinuousDistribution3.d).getMinVal());
                SeasonalContinuousDistribution seasonalContinuousDistribution4 = this;
                clipData.setMinClip(seasonalContinuousDistribution4.getClipData(seasonalContinuousDistribution4.d).hasMinClip());
            }
            return abstractContDist;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return null;
        }
    }

    public AbstractContDist buildDistribution(Object[] clipData, int n) {
        try {
            AbstractContDist abstractContDist;
            Class[] classArray = new Class[((Object[])clipData).length];
            for (int i = 0; i < ((Object[])clipData).length; ++i) {
                abstractContDist = clipData[i].getClass();
                classArray[i] = abstractContDist.equals(Double.class) ? Double.TYPE : abstractContDist;
            }
            Constructor<?> constructor = this.c.getClass().getDeclaredConstructor(classArray);
            abstractContDist = (AbstractContDist)constructor.newInstance((Object[])clipData);
            if (this.c instanceof MultiParametrizadDist) {
                ((MultiParametrizadDist)abstractContDist).setParametrizationNumber(((MultiParametrizadDist)this.c).getParametrizationNumber());
            }
            if (!(abstractContDist instanceof EmpiricalDist)) {
                clipData = ((ClipDist)abstractContDist).getClipData();
                clipData.setMaxVal(this.getClipData(n).getMaxVal());
                clipData.setMaxClip(this.getClipData(n).hasMaxClip());
                clipData.setMinVal(this.getClipData(n).getMinVal());
                clipData.setMinClip(this.getClipData(n).hasMinClip());
            }
            return abstractContDist;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return null;
        }
    }

    public void read(BufferedReader bufferedReader) {
        ArrayList<HecTime> arrayList = new ArrayList<HecTime>();
        ArrayList<AbstractContDist> arrayList2 = new ArrayList<AbstractContDist>();
        boolean bl = false;
        boolean bl2 = false;
        try {
            String string = bufferedReader.readLine();
            while (string != null) {
                if (string.length() == 0) {
                    string = bufferedReader.readLine();
                    continue;
                }
                String string2 = RMAIO.getType((String)string, (String)":");
                string = RMAIO.getParam((String)string, (String)":");
                if (string2.equals("SeasonalDistEnd")) {
                    this.initialize(arrayList, arrayList2);
                    if (this.a != null) {
                        this.a.setMaxClip(bl);
                        this.a.setMinClip(bl2);
                    }
                    return;
                }
                if (string2.equals("Time")) {
                    arrayList.add(new HecTime(Integer.parseInt(string), 1));
                } else if (string2.equals("SeasonalMaxClip")) {
                    bl = Boolean.parseBoolean(string);
                } else if (string2.equals("SeasonalMinClip")) {
                    bl2 = Boolean.parseBoolean(string);
                } else if (string2.contains("DistBegin") && !string2.contains("Seasonal")) {
                    string = string2.substring(0, string2.indexOf("DistBegin"));
                    if (string2.contains("Clip")) {
                        string2 = null;
                        if (NormalClipDist.class.getName().contains(string)) {
                            string2 = new NormalClipDist();
                        } else if (UnifClipDist.class.toString().contains(string)) {
                            string2 = new UnifClipDist();
                        } else if (TriangClipDist.class.toString().contains(string)) {
                            string2 = new TriangClipDist();
                        } else if (LogNormalClipDist.class.toString().contains(string)) {
                            string2 = new LogNormalClipDist();
                        } else if (Log10NormalClipDist.class.toString().contains(string)) {
                            string2 = new Log10NormalB17BClipDist();
                        } else if (GammaClipDist.class.toString().contains(string)) {
                            string2 = new GammaClipDist();
                        } else if (EmpiricalClipDist.class.toString().contains(string)) {
                            string2 = new EmpiricalClipDist();
                        }
                        string2.read(bufferedReader);
                        arrayList2.add((AbstractContDist)string2);
                    } else {
                        string2 = null;
                        if (NormalDist.class.getName().contains(string)) {
                            string2 = new NormalDist();
                        } else if (UnifDist.class.toString().contains(string)) {
                            string2 = new UnifClipDist();
                        } else if (TriangDist.class.toString().contains(string)) {
                            string2 = new TriangDist();
                        } else if (LogNormalDist.class.toString().contains(string)) {
                            string2 = new LogNormalDist();
                        } else if (Log10NormalClipDist.class.toString().contains(string)) {
                            string2 = new Log10NormalB17BClipDist();
                        } else if (GammaDist.class.toString().contains(string)) {
                            string2 = new GammaDist();
                        } else if (EmpiricalDist.class.toString().contains(string)) {
                            string2 = new EmpiricalDist();
                        }
                        string2.read(bufferedReader);
                        arrayList2.add((AbstractContDist)string2);
                    }
                }
                string = bufferedReader.readLine();
            }
            return;
        }
        catch (IOException iOException) {
            System.out.println("Failed to read NormalClipDist Data.   " + String.valueOf(iOException.getCause()));
            iOException.printStackTrace();
            return;
        }
    }

    public void write(BufferedWriter bufferedWriter) {
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"SeasonalDistBegin");
        if (!this.b.isEmpty()) {
            for (int i = 0; i < this.b.get(0).size(); ++i) {
                RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Time:" + this.b.get(0).getTime(i)));
                SeasonalContinuousDistribution seasonalContinuousDistribution = this;
                seasonalContinuousDistribution.buildDistribution(seasonalContinuousDistribution.getParams(i), i).write(bufferedWriter);
            }
        } else {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)"Time:1440");
            this.c.write(bufferedWriter);
        }
        if (this.a == null) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)"SeasonalMaxClip:false");
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)"SeasonalMinClip:false");
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)"SeasonalDistEnd");
            return;
        }
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("SeasonalMaxClip:" + this.a.hasMaxClip()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("SeasonalMinClip:" + this.a.hasMinClip()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"SeasonalDistEnd");
    }

    public static void main(String[] object) {
        object = new ArrayList<HecTime>();
        object.add(new HecTime("09/01/00"));
        object.add(new HecTime("03/01/00"));
        object.add(new HecTime("12/01/00"));
        object = new ArrayList();
        Object object2 = new NormalClipDist(10.0, 8.0);
        object2.getClipData().setMaxVal(20.0);
        object2.getClipData().setMinVal(0.0);
        object.add((AbstractContDist)object2);
        object2 = new NormalClipDist(15.0, 8.0);
        object2.getClipData().setMaxVal(20.0);
        object2.getClipData().setMinVal(0.0);
        object.add((AbstractContDist)object2);
        object2 = new NormalClipDist(5.0, 8.0);
        object2.getClipData().setMaxVal(20.0);
        object2.getClipData().setMinVal(0.0);
        object.add((AbstractContDist)object2);
        object = new SeasonalContinuousDistribution();
        ((SeasonalContinuousDistribution)((Object)object)).read(new BufferedReader(new StringReader(SeasonalContinuousDistribution.getInputString())));
        object2 = new RunTimeWindow(new HecTime("01/01/00", "00:00:01"), new HecTime("12/31/00", "00:00:01"), new HecTime("01/02/00", "00:00:01"));
        object2.setTimeStep(1, 3);
        object2 = new RunTimeStep((RunTimeWindow)object2);
        object2.getHecTime();
        object2.setStep(424);
        Object object3 = object2;
        object2 = object;
        ((SeasonalContinuousDistribution)((Object)object)).d = object3;
        object2 = ((SeasonalContinuousDistribution)((Object)object)).getDist().getParamNames()[0] + ":" + ((SeasonalContinuousDistribution)((Object)object)).getDist().getParamVals()[0] + "\n" + ((SeasonalContinuousDistribution)((Object)object)).getDist().getParamNames()[1] + ":" + ((SeasonalContinuousDistribution)((Object)object)).getDist().getParamVals()[1];
        if (((SeasonalContinuousDistribution)((Object)object)).getDist() instanceof ClipDist) {
            object2 = ((String)object2).concat(((ClipDist)((SeasonalContinuousDistribution)((Object)object)).getDist()).getClipData().getMaxVal() + " " + ((ClipDist)((SeasonalContinuousDistribution)((Object)object)).getDist()).getClipData().getMinVal());
        }
        System.out.println((String)object2);
        object2 = new BufferedWriter(new OutputStreamWriter(System.out));
        ((SeasonalContinuousDistribution)((Object)object)).write((BufferedWriter)object2);
        try {
            ((BufferedWriter)object2).flush();
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    public static String getInputString() {
        String string = "SeasonalDistBegin" + System.getProperty("line.separator") + "Time:1440" + System.getProperty("line.separator") + "NormalClipDistBegin" + System.getProperty("line.separator") + "Mean:8.333333333333334" + System.getProperty("line.separator") + "Stdv:8.0" + System.getProperty("line.separator") + "ClipDataBegin" + System.getProperty("line.separator") + "MinClip:true" + System.getProperty("line.separator") + "MinVal:10.0" + System.getProperty("line.separator") + "MaxClip:false" + System.getProperty("line.separator") + "MaxVal:20.0" + System.getProperty("line.separator") + "ClipDataEnd" + System.getProperty("line.separator") + "NormalClipDistEnd" + System.getProperty("line.separator") + "Time:86400" + System.getProperty("line.separator") + "NormalClipDistBegin" + System.getProperty("line.separator") + "Mean:15.0" + System.getProperty("line.separator") + "Stdv:8.0" + System.getProperty("line.separator") + "ClipDataBegin" + System.getProperty("line.separator") + "MinClip:false" + System.getProperty("line.separator") + "MinVal:0.0" + System.getProperty("line.separator") + "MaxClip:true" + System.getProperty("line.separator") + "MaxVal:10.0" + System.getProperty("line.separator") + "ClipDataEnd" + System.getProperty("line.separator") + "NormalClipDistEnd" + System.getProperty("line.separator") + "Time:351360" + System.getProperty("line.separator") + "NormalClipDistBegin" + System.getProperty("line.separator") + "Mean:10.0" + System.getProperty("line.separator") + "Stdv:1.0" + System.getProperty("line.separator") + "ClipDataBegin" + System.getProperty("line.separator") + "MinClip:false" + System.getProperty("line.separator") + "MinVal:0.0" + System.getProperty("line.separator") + "MaxClip:false" + System.getProperty("line.separator") + "MaxVal:20.0" + System.getProperty("line.separator") + "ClipDataEnd" + System.getProperty("line.separator") + "NormalClipDistEnd" + System.getProperty("line.separator") + "Time:482400" + System.getProperty("line.separator") + "NormalClipDistBegin" + System.getProperty("line.separator") + "Mean:5.0" + System.getProperty("line.separator") + "Stdv:8.0" + System.getProperty("line.separator") + "ClipDataBegin" + System.getProperty("line.separator") + "MinClip:false" + System.getProperty("line.separator") + "MinVal:0.0" + System.getProperty("line.separator") + "MaxClip:false" + System.getProperty("line.separator") + "MaxVal:20.0" + System.getProperty("line.separator") + "ClipDataEnd" + System.getProperty("line.separator") + "NormalClipDistEnd" + System.getProperty("line.separator") + "Time:525600" + System.getProperty("line.separator") + "NormalClipDistBegin" + System.getProperty("line.separator") + "Mean:8.333333333333334" + System.getProperty("line.separator") + "Stdv:8.0" + System.getProperty("line.separator") + "ClipDataBegin" + System.getProperty("line.separator") + "MinClip:true" + System.getProperty("line.separator") + "MinVal:5.0" + System.getProperty("line.separator") + "MaxClip:false" + System.getProperty("line.separator") + "MaxVal:20.0" + System.getProperty("line.separator") + "ClipDataEnd" + System.getProperty("line.separator") + "NormalClipDistEnd" + System.getProperty("line.separator") + "SeasonalDistEnd";
        return string;
    }

    public double getPDF(double d) {
        return this.getDist().getPDF(d);
    }

    public double getCDF(double d) {
        return this.getDist().getCDF(d);
    }

    public double invCDF(double d) {
        return this.getDist().invCDF(d);
    }

    public boolean fitSampleData(ProductMoments productMoments) {
        return false;
    }

    public boolean fitSampleData(LinearMoments linearMoments) {
        return false;
    }

    public String getType() {
        return this.f;
    }

    public String[] getParamNames() {
        return this.e;
    }

    public void setParamVals(double[] dArray) {
    }

    public double[] getParamVals() {
        double[] dArray = new double[this.getParams().length];
        for (int i = 0; i < dArray.length; ++i) {
            if (!(this.getParams()[i] instanceof Double)) {
                return new double[0];
            }
            dArray[i] = (Double)this.getParams()[i];
        }
        return dArray;
    }

    public Object getClipDist() {
        return null;
    }

    public ClipData getClipData() {
        return this.a;
    }

    public ClipData getClipData(int n) {
        return this.a.getClipData(n);
    }

    public ClipData getClipData(RunTimeStep runTimeStep) {
        return this.a.getClipData(runTimeStep);
    }

    public String[] getClipParamNames() {
        if (this.a == null) {
            return this.getDist().getParamNames();
        }
        return this.getClipData().getClipParamNames();
    }

    public double[] getClipParamVals() {
        if (this.a == null) {
            return this.getDist().getParamVals();
        }
        return this.getClipData().getClipParamVals();
    }

    public double[] getClipParamVals(RunTimeStep runTimeStep) {
        if (this.a == null) {
            return this.getDist().getParamVals();
        }
        return this.getClipData(runTimeStep).getClipParamVals();
    }

    public String getSummaryClip(String string) {
        if (this.a == null) {
            return this.getDist().getSummaryDef(string);
        }
        return this.getClipData().getSummary(string);
    }

    public List<HecTime> getHecTimes() {
        ArrayList<HecTime> arrayList = new ArrayList<HecTime>();
        for (int i = 0; i < this.g.size() && (i != this.g.size() - 1 || this.h); ++i) {
            arrayList.add(new HecTime(this.g.get(i)));
        }
        return arrayList;
    }

    public List<HecTime> getFullHecTimes() {
        ArrayList<HecTime> arrayList = new ArrayList<HecTime>();
        for (int i = 0; i < this.g.size(); ++i) {
            arrayList.add(new HecTime(this.g.get(i)));
        }
        return arrayList;
    }

    public SeasonalContinuousDistribution clone() {
        Object object = new ArrayList<HecTime>();
        Serializable serializable = new ArrayList<AbstractContDist>();
        for (int i = 0; i < this.g.size(); ++i) {
            object.add((HecTime)this.g.get(i).clone());
            if (this.b.size() > 0) {
                serializable.add((AbstractContDist)this.getDist(i).clone());
                continue;
            }
            serializable.add((AbstractContDist)this.c.clone());
        }
        SeasonalContinuousDistribution seasonalContinuousDistribution = new SeasonalContinuousDistribution((List<HecTime>)object, (List<AbstractContDist>)((Object)serializable), new RunTimeStep(this.d));
        if (!(this.c instanceof EmpiricalDist)) {
            object = (SeasonalClipData)seasonalContinuousDistribution.getClipData();
            ((SeasonalClipData)((Object)object)).setMaxVal(this.getClipData().getMaxVal());
            ((SeasonalClipData)((Object)object)).setMaxClip(this.getClipData().hasMaxClip());
            ((SeasonalClipData)((Object)object)).setMinVal(this.getClipData().getMinVal());
            ((SeasonalClipData)((Object)object)).setMinClip(this.getClipData().hasMinClip());
            try {
                ((SeasonalClipData)((Object)object)).setMaxVal((SeasonalRecord)((SeasonalClipData)this.getClipData()).getMaxValRecord().clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                serializable = cloneNotSupportedException;
                cloneNotSupportedException.printStackTrace();
            }
            try {
                ((SeasonalClipData)((Object)object)).setMinVal((SeasonalRecord)((SeasonalClipData)this.getClipData()).getMinValRecord().clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                serializable = cloneNotSupportedException;
                cloneNotSupportedException.printStackTrace();
            }
        }
        return seasonalContinuousDistribution;
    }

    public void setStep(int n) {
        HecTime hecTime = new HecTime(n, 11);
        this.d.getRunTimeWindow().getTimeStep();
        this.d.setStep(HecTime.iymdjl((int)1900, (int)hecTime.month(), (int)hecTime.day()));
    }

    public void setStartTime(HecTime hecTime) {
        this.d.getRunTimeWindow().getTimeStep();
        this.d.setStep(HecTime.iymdjl((int)1900, (int)hecTime.month(), (int)hecTime.day()) - 1);
    }

    public void setTime(HecTime hecTime) {
        this.d.getRunTimeWindow().getTimeStep();
        this.d.setStep(HecTime.iymdjl((int)1900, (int)hecTime.month(), (int)hecTime.day()) - 1);
    }

    public String getCurrentTimeString() {
        Object object = this.d.getRunTimeWindow().getStartTime();
        object.showTimeAsBeginningOfDay(true);
        object = object.date(1);
        return ((String)object).substring(0, ((String)object).length() - 4);
    }

    public SeasonalRecord getSeasonalRecord(double d, int[] nArray) {
        SeasonalRecord seasonalRecord = new SeasonalRecord();
        double[] dArray = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.setStep(nArray[i] - 1440);
            HecTime hecTime = new HecTime(nArray[i], 11);
            nArray[i] = HecTime.iymdjl((int)1900, (int)hecTime.month(), (int)hecTime.day()) * 1440;
            dArray[i] = this.getDist().invCDF(d);
        }
        seasonalRecord.setArrays(nArray, dArray);
        return seasonalRecord;
    }

    public SeasonalRecord getSeasonalRecord(double d) {
        SeasonalRecord seasonalRecord = new SeasonalRecord();
        double[] dArray = new double[this.g.size()];
        int[] nArray = new int[this.g.size()];
        for (int i = 0; i < this.g.size(); ++i) {
            nArray[i] = HecTime.iymdjl((int)1900, (int)this.g.get(i).month(), (int)this.g.get(i).day()) * 1440;
            this.setStep(nArray[i]);
            dArray[i] = this.getDist().invCDF(d);
        }
        seasonalRecord.setArrays(nArray, dArray);
        seasonalRecord.setInterpolationType(2);
        return seasonalRecord;
    }

    public double getCDF(SeasonalRecord seasonalRecord) {
        if (this.b.isEmpty()) {
            return 1.0;
        }
        double d = 0.5;
        int n = !this.h ? this.b.get(0).getTimeArray().length - 1 : this.b.get(0).getTimeArray().length;
        for (int i = 0; i < n; ++i) {
            SeasonalContinuousDistribution seasonalContinuousDistribution = this;
            seasonalContinuousDistribution.setStep(seasonalContinuousDistribution.b.get(0).getTimeArray()[i]);
            double d2 = seasonalRecord.getTimeArray().length == 1 ? this.getDist().getCDF(seasonalRecord.getDataArray()[0]) : this.getDist().getCDF(seasonalRecord.interpolate(new HecTime(this.b.get(0).getTimeArray()[i], 11)));
            if (!(Math.abs(d2 - 0.5) > Math.abs(d - 0.5))) continue;
            d = d2;
        }
        return d;
    }

    public void setDoesDec31Exist(boolean bl) {
        this.h = bl;
    }

    protected void a(SeasonalRecord seasonalRecord) {
        if (this.b.isEmpty()) {
            return;
        }
        if (this.c instanceof MultiParametrizadDist) {
            this.a();
        }
        int[] nArray = this.b.get(0).getTimeArray();
        for (int i = 0; i < nArray.length; ++i) {
            double d = seasonalRecord.interpolateStepValue(nArray[i]);
            for (int j = 0; j < this.b.size(); ++j) {
                if (this.e.length > j && this.e[j].equals("Shape")) continue;
                double d2 = this.b.get(j).getValue(i) / 100.0;
                this.b.get((int)j).getDataArray()[i] = d * d2;
            }
        }
        if (this.c instanceof MultiParametrizadDist) {
            this.b();
        }
    }

    private void a() {
        int n;
        int[] nArray = this.b.get(0).getTimeArray();
        double[][] dArray = new double[this.b.size()][nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            Object[] objectArray = new Object[this.b.size()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = this.b.get(i).getDataArray()[n];
            }
            MultiParametrizadDist multiParametrizadDist = (MultiParametrizadDist)this.buildDistribution(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                dArray[i][n] = multiParametrizadDist.getParams2()[i];
            }
        }
        for (n = 0; n < this.b.size(); ++n) {
            this.b.get(n).setArrays(nArray, dArray[n]);
        }
    }

    private void b() {
        int n;
        int[] nArray = this.b.get(0).getTimeArray();
        double[][] dArray = new double[this.b.size()][nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            int n2;
            Object[] objectArray = new Object[this.b.size()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = this.b.get(i).getDataArray()[n];
            }
            MultiParametrizadDist multiParametrizadDist = (MultiParametrizadDist)this.buildDistribution(objectArray);
            double[] dArray2 = new double[objectArray.length];
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                dArray2[n2] = (Double)objectArray[n2];
            }
            multiParametrizadDist.setParams2(dArray2);
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                dArray[n2][n] = multiParametrizadDist.getParams1()[n2];
            }
        }
        for (n = 0; n < this.b.size(); ++n) {
            this.b.get(n).setArrays(nArray, dArray[n]);
        }
    }

    protected void a(Double[] doubleArray) {
        if (this.c instanceof MultiParametrizadDist) {
            this.a();
        }
        int[] nArray = this.b.get(0).getTimeArray();
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < this.b.size(); ++j) {
                if (this.e.length > j && this.e[j].equals("Shape")) continue;
                double d = this.b.get(j).getValue(i) / 100.0;
                this.b.get((int)j).getDataArray()[i] = doubleArray[0] * d;
            }
        }
        if (this.c instanceof MultiParametrizadDist) {
            this.b();
        }
    }

    protected void a(Double d) {
        if (this.c instanceof MultiParametrizadDist) {
            this.a();
        }
        int[] nArray = this.b.get(0).getTimeArray();
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < this.b.size(); ++j) {
                this.setStep(nArray[i]);
                double d2 = this.b.get(j).getValue(i);
                this.b.get((int)j).getDataArray()[i] = d2 / d * 100.0;
            }
        }
        if (this.c instanceof MultiParametrizadDist) {
            this.b();
        }
    }

    protected void b(SeasonalRecord seasonalRecord) {
        if (this.c instanceof MultiParametrizadDist) {
            this.a();
        }
        int[] nArray = this.b.get(0).getTimeArray();
        for (int i = 0; i < nArray.length; ++i) {
            double d = seasonalRecord.interpolateStepValue(nArray[i]);
            for (int j = 0; j < this.b.size(); ++j) {
                double d2 = this.b.get(j).getValue(i);
                this.b.get((int)j).getDataArray()[i] = d2 / d * 100.0;
            }
        }
        if (this.c instanceof MultiParametrizadDist) {
            this.b();
        }
    }

    public boolean checkConsistency() {
        return false;
    }

    public SeasonalRecord getMaximumValueRecord() {
        return this.a.getMaxValRecord();
    }

    public SeasonalRecord getMinimumValueRecord() {
        return this.a.getMinValRecord();
    }

    public void setMaxVal(SeasonalRecord seasonalRecord) {
        this.a.setMaxVal(seasonalRecord);
    }

    public void setMinVal(SeasonalRecord seasonalRecord) {
        this.a.setMinVal(seasonalRecord);
    }

    public RunTimeStep getRunTimeStep() {
        return this.d;
    }

    public ClipDist getDefaultDist() {
        return (ClipDist)this.c.clone();
    }
}

