/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.UnitUtil;
import mil.army.usace.hec.metadata.UnitsConversionException;
import mil.army.usace.hec.metadata.constants.NumericalConstants;
import mil.army.usace.hec.metadata.resourceservices.ParameterLookup;

public class ParamDouble
extends Number {
    public static final int PRECISION_NOT_SET = -1;
    public static final int EXPONENTIAL_NUMBER = -2;
    private static final String PADDING = "00000000000000000000";
    private static final String DOT = ".";
    private static final long serialVersionUID = -2099619706621239995L;
    private static final Logger LOGGER = Logger.getLogger(ParamDouble.class.getName());
    private double _value;
    private int _paramID;
    private int _unitSystem;
    private int _precision;

    public ParamDouble() {
        this._value = Double.NEGATIVE_INFINITY;
        this._paramID = -1;
        this._unitSystem = Integer.MIN_VALUE;
        this._precision = -1;
    }

    public ParamDouble(double val, int paramID) {
        this._value = val;
        this._paramID = paramID;
        this._unitSystem = Integer.MIN_VALUE;
        this._precision = ParamDouble.findPrecision(val);
    }

    public ParamDouble(double value, int paramID, int unitSys) {
        this._value = value;
        this._paramID = paramID;
        this._unitSystem = unitSys;
        this._precision = ParamDouble.findPrecision(value);
    }

    public ParamDouble(double value, int paramID, int unitSys, int precision) {
        this._value = value;
        this._paramID = paramID;
        this._unitSystem = unitSys;
        this._precision = precision;
    }

    public ParamDouble(ParamDouble other) {
        this._value = other._value;
        this._paramID = other._paramID;
        this._unitSystem = other._unitSystem;
        this._precision = other._precision;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof ParamDouble) {
            ParamDouble otherpd = (ParamDouble)anObject;
            return otherpd.getValue() == this.getValue() && otherpd.getParameterId() == this.getParameterId() && otherpd.getUnitSystem() == this.getUnitSystem();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getValue(), this.getParameterId(), this.getUnitSystem());
    }

    public final void setParameterId(int paramID) {
        this._paramID = paramID;
    }

    public final void setValue(double val) {
        this._value = val;
        this._precision = ParamDouble.findPrecision(val);
    }

    public static int findPrecision(double val) {
        String value = Double.toString(val);
        int decimal = value.indexOf(46);
        if (value.indexOf(101) >= 0 || value.indexOf(69) >= 0) {
            BigDecimal bigDecimal = new BigDecimal(value);
            value = bigDecimal.toPlainString();
        }
        int precision = 0;
        if (decimal >= 0) {
            precision = value.trim().length() - decimal - 1;
        }
        return precision;
    }

    public void setValue(String value) {
        int decimal;
        try {
            this._value = Double.parseDouble(value.trim());
        }
        catch (NumberFormatException e) {
            try {
                this._value = new DecimalFormat().parse(value.trim()).doubleValue();
            }
            catch (ParseException ex) {
                this._value = Double.NEGATIVE_INFINITY;
                this._precision = -1;
                LOGGER.log(Level.FINE, "Error parsing value, setting to undefined", ex);
                return;
            }
        }
        if (value.indexOf(69) > 0 || value.indexOf(101) > 0) {
            BigDecimal bigDecimal = new BigDecimal(value);
            value = bigDecimal.toPlainString();
        }
        this._precision = (decimal = value.indexOf(46)) >= 0 ? value.trim().length() - decimal - 1 : 0;
    }

    public double getValue() {
        return this._value;
    }

    public final int getParameterId() {
        return this._paramID;
    }

    public final void setUnitSystem(int system) {
        this._unitSystem = system;
    }

    public final int getUnitSystem() {
        return this._unitSystem;
    }

    public String toStringDetailed() {
        return "ParamDouble - Value=" + this._value + " Precision=" + this._precision + " ParamId=" + ParameterLookup.getParamString((int)this._paramID) + " UnitSystem=" + this._unitSystem;
    }

    public String toString() {
        if (!NumericalConstants.isValidValue((double)this._value)) {
            return "";
        }
        if (this._precision == -2) {
            return Double.toString(this._value);
        }
        return ParamDouble.valueToString(this._value, this._precision);
    }

    public final void setPrecision(int p) {
        if (p < 0) {
            this._precision = -1;
            return;
        }
        this._precision = p;
    }

    public final boolean isPrecisionSet() {
        return this._precision >= 0;
    }

    public final int getPrecision() {
        return this._precision;
    }

    public final void scaleValue(double scale) {
        this._value *= scale;
    }

    public final double convertToUnitSystem(int system) {
        if (!UnitUtil.isValidUnitsSystem((int)system)) {
            throw new IllegalArgumentException("ERROR <ParamDouble.convertToUnitSystem()> : Invalid unit system id " + system);
        }
        if (system == this._unitSystem) {
            return this._value;
        }
        if (!NumericalConstants.isValidValue((double)this._value)) {
            return this._value;
        }
        String toUnits = ParameterLookup.getUnitsStringForSystem((int)this._paramID, (int)system);
        String fromUnits = ParameterLookup.getUnitsStringForSystem((int)this._paramID, (int)this._unitSystem);
        try {
            return UnitUtil.convertUnits((double)this._value, (String)fromUnits, (String)toUnits);
        }
        catch (UnitsConversionException e) {
            LOGGER.log(Level.WARNING, "ERROR <ParamDouble.convertToUnitSystem()> : Exception occured in convertion, returning current value", e);
            return this._value;
        }
    }

    @Override
    public final long longValue() {
        return (long)this._value;
    }

    @Override
    public final double doubleValue() {
        return this._value;
    }

    @Override
    public final int intValue() {
        return (int)this._value;
    }

    @Override
    public final float floatValue() {
        return (float)this._value;
    }

    private static String valueToString(double dbl, int precision) {
        if (ParamDouble.isUndefinedValue(dbl) || Double.isNaN(dbl) || dbl == Double.POSITIVE_INFINITY) {
            return "";
        }
        double tens = Math.pow(10.0, precision);
        double scaled = Math.rint(dbl * tens);
        if (ParamDouble.isUndefinedValue(dbl = scaled / tens) || Double.isNaN(dbl) || dbl == Double.POSITIVE_INFINITY) {
            return "";
        }
        Object txt = Double.toString(dbl);
        int idx = ((String)txt).indexOf(DOT);
        int length = ((String)txt).length();
        int curprec = length - (idx + 1);
        if (idx == -1) {
            curprec = 0;
        }
        if (((String)txt).indexOf("E") > 0 || ((String)txt).indexOf("e") > 0) {
            return txt;
        }
        if (curprec < precision) {
            int len;
            if (curprec == 0) {
                txt = (String)txt + DOT;
            }
            if ((len = precision - curprec) >= PADDING.length()) {
                len = PADDING.length() - 1;
            }
            txt = (String)txt + PADDING.substring(0, len);
        } else if (curprec > precision) {
            if (precision == 0) {
                txt = ((String)txt).substring(0, idx);
            } else {
                int end = length - (curprec - precision);
                if (end < 0) {
                    end = 0;
                }
                txt = ((String)txt).substring(0, end);
            }
        }
        if (precision == 0 && "-0".equals(txt)) {
            txt = "0";
        }
        return txt;
    }

    private static boolean isUndefinedValue(double v) {
        return v == Double.NEGATIVE_INFINITY || v == -3.4028234663852886E38;
    }

    public static ParamDouble convertUnits(ParamDouble x, String fromUnits, String toUnits) throws UnitsConversionException {
        ParamDouble x1 = new ParamDouble();
        double cVal = UnitUtil.convertUnits((double)x.getValue(), (String)fromUnits, (String)toUnits);
        x1.setValue(cVal);
        x1.setParameterId(x.getParameterId());
        x1.setUnitSystem(UnitUtil.getUnitSystemForUnits((String)toUnits));
        int precision = x.getPrecision();
        double factor = 1.0;
        factor = UnitUtil.getScalarFactor((String)fromUnits, (String)toUnits);
        if (factor == -1.0) {
            factor = 1.0;
        }
        if (precision >= 0 && factor > 0.0) {
            if (factor >= 10.0) {
                --precision;
            }
            if (factor >= 100.0) {
                --precision;
            }
            if (factor <= 0.1) {
                ++precision;
            }
            if (factor <= 0.01) {
                ++precision;
            }
            if (factor <= 0.001) {
                ++precision;
            }
            if (precision < 0) {
                precision = 0;
            }
        }
        x1.setPrecision(precision);
        return x1;
    }
}

