/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import mil.army.usace.hec.data.ParamDouble;
import mil.army.usace.hec.metadata.UnitUtil;
import mil.army.usace.hec.metadata.UnitsConversionException;
import mil.army.usace.hec.metadata.resourceservices.ParameterLookup;

public class ParamDoubleArray {
    public static final int PRECISION_NOT_SET = -1;
    public static final int EXPONENTIAL_NUMBER = -2;
    private static final Logger LOGGER = Logger.getLogger(ParamDoubleArray.class.getName());
    private double[] _values;
    private int _paramID;
    private int _unitSystem;
    private int _precision;

    public ParamDoubleArray() {
        this._values = new double[]{Double.NEGATIVE_INFINITY};
        this._paramID = Integer.MIN_VALUE;
        this._unitSystem = Integer.MIN_VALUE;
        this._precision = -1;
    }

    public ParamDoubleArray(double[] vals, int paramID) {
        this._values = vals;
        this._paramID = paramID;
        this._unitSystem = Integer.MIN_VALUE;
        this._precision = -1;
    }

    public ParamDoubleArray(double[] values, int paramID, int unitSys, int precision) {
        this._values = values;
        this._paramID = paramID;
        this._unitSystem = unitSys;
        this._precision = precision;
    }

    public ParamDoubleArray(ParamDoubleArray other) {
        this._values = new double[other._values.length];
        System.arraycopy(other._values, 0, this._values, 0, other._values.length);
        this._paramID = other._paramID;
        this._unitSystem = other._unitSystem;
        this._precision = other._precision;
    }

    public final void setParameterId(int paramID) {
        this._paramID = paramID;
    }

    public final void setValue(double val, int index) {
        if (index > this._values.length - 1) {
            return;
        }
        this._values[index] = val;
        this._precision = this.findPrecision(val);
    }

    public final void setValues(double[] vals) {
        this._values = vals;
    }

    public final int findPrecision(double val) {
        String value = Double.toString(val);
        int decimal = value.indexOf(46);
        int precision = 0;
        precision = decimal >= 0 ? (value.indexOf(69) > 0 || value.indexOf(101) > 0 ? -2 : value.trim().length() - decimal - 1) : 0;
        return precision;
    }

    public final void setValue(String value, int index) {
        try {
            this.setValue(Double.parseDouble(value.trim()), index);
        }
        catch (NumberFormatException e) {
            try {
                this.setValue(new DecimalFormat().parse(value.trim()).doubleValue(), index);
            }
            catch (ParseException p) {
                this.setValue(Double.NEGATIVE_INFINITY, index);
                return;
            }
        }
        int decimal = value.indexOf(46);
        this._precision = decimal >= 0 ? (value.indexOf(69) > 0 || value.indexOf(101) > 0 ? -2 : value.trim().length() - decimal - 1) : 0;
    }

    public final double getValue(int index) {
        return this._values[index];
    }

    public final double[] getValues() {
        return this._values;
    }

    public final int length() {
        if (this._values == null) {
            return -1;
        }
        return this._values.length;
    }

    public final int getParameterId() {
        return this._paramID;
    }

    public final void setUnitSystem(int system) {
        this._unitSystem = system;
    }

    public final int getUnitSystem() {
        return this._unitSystem;
    }

    public final String toString() {
        if (this._values == null) {
            return "";
        }
        return Arrays.stream(this._values).mapToObj(v -> new ParamDouble(v, this._paramID, this._unitSystem, this._precision)).map(ParamDouble::toString).collect(Collectors.joining(","));
    }

    public final void setPrecision(int p) {
        if (p < 0) {
            this._precision = -1;
            return;
        }
        this._precision = p;
    }

    public final int getPrecision() {
        return this._precision;
    }

    public final double[] convertToUnitSystem(int system) {
        if (!UnitUtil.isValidUnitsSystem((int)system)) {
            throw new IllegalArgumentException("ERROR <ParamDoubleArray.convertToUnitSystem()> : Invalid unit system id " + system);
        }
        if (system == this._unitSystem) {
            return this._values;
        }
        String toUnits = ParameterLookup.getUnitsStringForSystem((int)this._paramID, (int)system);
        String fromUnits = ParameterLookup.getUnitsStringForSystem((int)this._paramID, (int)this._unitSystem);
        try {
            UnitUtil.convertUnits((double[])this._values, (String)fromUnits, (String)toUnits);
            return this._values;
        }
        catch (UnitsConversionException e) {
            LOGGER.log(Level.WARNING, "ERROR <ParamDoubleArray.convertToUnitSystem()> : Exception occured in convertion, returning current value", e);
            return this._values;
        }
    }

    public static ParamDoubleArray convertUnits(ParamDoubleArray x, String fromUnits, String toUnits) throws UnitsConversionException {
        ParamDoubleArray x1 = new ParamDoubleArray();
        if (x.getValues() == null) {
            return x;
        }
        double[] cVals = new double[x.getValues().length];
        System.arraycopy(x.getValues(), 0, cVals, 0, x.getValues().length);
        UnitUtil.convertUnits((double[])cVals, (String)fromUnits, (String)toUnits);
        x1.setValues(cVals);
        x1.setParameterId(x.getParameterId());
        int precision = x.getPrecision();
        double factor = UnitUtil.getScalarFactor((String)fromUnits, (String)toUnits);
        if (factor == -1.0) {
            factor = 1.0;
        }
        if (precision >= 0 && factor > 0.0) {
            if (factor >= 10.0) {
                --precision;
            }
            if (factor >= 100.0) {
                --precision;
            }
            if (factor <= 0.1) {
                ++precision;
            }
            if (factor <= 0.01) {
                ++precision;
            }
            if (factor <= 0.001) {
                ++precision;
            }
            if (precision < 0) {
                precision = 0;
            }
        }
        x1.setPrecision(precision);
        return x1;
    }
}

