/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.forecast;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import mil.army.usace.hec.data.timeseries.TimeSeries;
import mil.army.usace.hec.metadata.forecast.ForecastInstance;

public final class ForecastData {
    private final ForecastInstance _forecastInstance;
    private final Set<TimeSeries> _timeSeriesSet;
    private final byte[] _fileData;

    public ForecastData(ForecastInstance forecastInstance, Set<TimeSeries> timeSeriesData, byte[] fileData) {
        this._forecastInstance = Objects.requireNonNull(forecastInstance, "Cannot create forecast data without a forecast instance");
        this._timeSeriesSet = Objects.requireNonNull(timeSeriesData, "Cannot create forecast data with a null timeseries collection");
        this._fileData = (byte[])Objects.requireNonNull(fileData, "Cannot create forecast data with a null forecast data byte[]. Use an empty array instead.").clone();
    }

    public ForecastInstance getForecastInstance() {
        return this._forecastInstance;
    }

    public Set<TimeSeries> getTimeSeriesSet() {
        return new HashSet<TimeSeries>(this._timeSeriesSet);
    }

    public byte[] getFileData() {
        return (byte[])this._fileData.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForecastData that = (ForecastData)o;
        return Objects.equals(this._forecastInstance, that._forecastInstance) && Objects.equals(this._timeSeriesSet, that._timeSeriesSet) && Arrays.equals(this._fileData, that._fileData);
    }

    public int hashCode() {
        int result = Objects.hash(this._forecastInstance, this._timeSeriesSet);
        result = 31 * result + Arrays.hashCode(this._fileData);
        return result;
    }
}

