/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import mil.army.usace.hec.data.timeseries.AbstractTimeSeries;
import mil.army.usace.hec.data.timeseries.Quality;
import mil.army.usace.hec.data.timeseries.TimeSeriesBuilder;
import mil.army.usace.hec.data.timeseries.math.TimeSeriesTemplate;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.constants.NumericalConstants;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesException;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesIllegalArgumentException;
import mil.army.usace.hec.metadata.timeseries.IntervalOffsetMismatchException;

abstract class AbstractIrregularTimeSeries
extends AbstractTimeSeries {
    private static final long serialVersionUID = 1560793019654222408L;
    private long[] _times = new long[0];

    AbstractIrregularTimeSeries(TimeSeriesBuilder builder) throws DataSetIllegalArgumentException, IntervalOffsetMismatchException, DataSetTimeSeriesException {
        super(builder);
        if (builder.times().length > 0) {
            long startTimeWindow = builder.startTime().toEpochMilli();
            long endTimeWindow = builder.endTime().toEpochMilli();
            if (startTimeWindow == Long.MIN_VALUE || endTimeWindow == Long.MIN_VALUE) {
                startTimeWindow = builder.times()[0];
                endTimeWindow = builder.times()[builder.times().length - 1];
            }
            this.set(builder.times(), builder.values(), builder.quality(), startTimeWindow, endTimeWindow);
            if (this.needToChangeUnits(builder.units())) {
                this.changeUnits(builder.units());
            }
        } else {
            this._times = builder.times();
        }
    }

    @Override
    public final ZonedDateTime getStartTime() {
        ZoneId zoneId = this.getTimeSeriesIdentifier().getIntervalZoneId().orElse(NumericalConstants.UTC_ZONEID);
        if (this._times.length > 0) {
            return ZonedDateTime.ofInstant(Instant.ofEpochMilli(this._times[0]), zoneId);
        }
        return ZonedDateTime.ofInstant(NumericalConstants.UNDEFINED_INSTANT, zoneId);
    }

    @Override
    public final ZonedDateTime getEndTime() {
        ZoneId zoneId = this.getTimeSeriesIdentifier().getIntervalZoneId().orElse(NumericalConstants.UTC_ZONEID);
        if (this._times.length > 0) {
            return ZonedDateTime.ofInstant(Instant.ofEpochMilli(this._times[this._times.length - 1]), zoneId);
        }
        return ZonedDateTime.ofInstant(NumericalConstants.UNDEFINED_INSTANT, zoneId);
    }

    @Override
    void set(long[] times, double[] values, Quality quality, long startTimeWindow, long endTimeWindow) throws DataSetTimeSeriesIllegalArgumentException, IntervalOffsetMismatchException, DataSetIllegalArgumentException {
        SimpleDateFormat sdf = NumericalConstants.sdfFULL();
        if (times.length != values.length) {
            throw new DataSetTimeSeriesIllegalArgumentException("Lengths of times and values not consistent: " + times.length + " != " + values.length);
        }
        if (quality != null && quality.getSize() != times.length) {
            throw new DataSetTimeSeriesIllegalArgumentException("Lengths of times and quality not consistent: " + times.length + " != " + quality.getSize());
        }
        if (startTimeWindow > endTimeWindow) {
            throw new DataSetTimeSeriesIllegalArgumentException("\nStart after end in Time window:\n Time Window: " + sdf.format(new Date(startTimeWindow)) + " " + sdf.format(new Date(endTimeWindow)));
        }
        if (times.length > 2 && (times[1] < startTimeWindow || times[times.length - 2] > endTimeWindow)) {
            throw new DataSetTimeSeriesIllegalArgumentException("\nTimes are outside of time window:\n First/Last Times: " + sdf.format(new Date(times[0])) + " " + sdf.format(new Date(times[times.length - 1])) + "\n      Time Window: " + sdf.format(new Date(startTimeWindow)) + " " + sdf.format(new Date(endTimeWindow)));
        }
        for (int i = 1; i < times.length; ++i) {
            if (times[i - 1] > times[i]) {
                throw new DataSetTimeSeriesIllegalArgumentException("Times not increasing");
            }
            if (times[i - 1] != times[i]) continue;
            throw new DataSetTimeSeriesIllegalArgumentException("Times not unique");
        }
        int countValues = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == -3.4028234663852886E38 && (quality == null || !quality.isScreened(i) || !quality.isMissing(i))) continue;
            ++countValues;
        }
        long[] setTimes = new long[countValues];
        double[] setValues = new double[countValues];
        Quality setQuality = null;
        if (quality != null) {
            setQuality = new Quality(countValues);
        }
        int j = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == -3.4028234663852886E38 && (quality == null || !quality.isScreened(i) || !quality.isMissing(i))) continue;
            setTimes[j] = times[i];
            setValues[j] = values[i];
            if (quality != null) {
                setQuality.setIntegerAt(quality.getIntegerAt(i), j);
            }
            ++j;
        }
        this.setInternal(setTimes, setValues, setQuality);
    }

    @Override
    void setInternal(long[] times, double[] values, Quality quality) throws DataSetTimeSeriesIllegalArgumentException {
        this._times = times;
        this.setValues(values);
        this.setQuality(quality);
        this.getTimeSeriesStatistics().setOutOfDate();
        if (!this.getPreserveRejectedAndMissingValues()) {
            this.setValues(this.getValuesWithQualityFlagsApplied());
            this.setQuality(this.getQualityClearedForValuesWithQualityFlagsApplied());
        }
    }

    @Override
    public long[] getTimes() {
        return this._times;
    }

    @Override
    public NavigableSet<Instant> getInstants() {
        return Arrays.stream(this._times).mapToObj(Instant::ofEpochMilli).collect(Collectors.toCollection(TreeSet::new));
    }

    @Override
    public void fillTails(TimeSeriesTemplate template) throws DataSetTimeSeriesException, DataSetIllegalArgumentException {
    }

    @Override
    public void removeRejectedAndMissingValues(boolean preserveRejectedAndMissingValues) throws DataSetTimeSeriesException, DataSetIllegalArgumentException, IntervalOffsetMismatchException {
        boolean preserve = this.getPreserveRejectedAndMissingValues();
        if (preserve == preserveRejectedAndMissingValues) {
            return;
        }
        if (!preserve && preserveRejectedAndMissingValues) {
            throw new DataSetTimeSeriesException("\nCannot preserve rejected and missing values, because they have been removed previously");
        }
        this.setPreserveRejectedAndMissingValues(false);
        this.set(this.getTimes(), this.getValues(), this.getQuality().orElse(null));
    }
}

