/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.data.timeseries.AbstractTimeSeries;
import mil.army.usace.hec.data.timeseries.DataSetTimeSeriesDeriveException;
import mil.army.usace.hec.data.timeseries.Quality;
import mil.army.usace.hec.data.timeseries.TimeSeriesBuilder;
import mil.army.usace.hec.data.timeseries.math.TimeSeriesTemplate;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.Interval;
import mil.army.usace.hec.metadata.IntervalOffset;
import mil.army.usace.hec.metadata.Units;
import mil.army.usace.hec.metadata.constants.NumericalConstants;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesException;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesIllegalArgumentException;
import mil.army.usace.hec.metadata.timeseries.IntervalOffsetMismatchException;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;

abstract class AbstractRegularTimeSeries
extends AbstractTimeSeries {
    private static final Logger LOGGER = Logger.getLogger(AbstractRegularTimeSeries.class.getName());
    private static final long serialVersionUID = 6922360891519218122L;
    private ZonedDateTime _startTime;

    AbstractRegularTimeSeries(TimeSeriesBuilder builder) throws DataSetIllegalArgumentException, IntervalOffsetMismatchException, DataSetTimeSeriesException {
        super(builder);
        if (builder.times() == null || builder.times().length == 0 && builder.values() != null && builder.values().length > 0) {
            throw new DataSetTimeSeriesIllegalArgumentException("Cannot build a time series with an empty time array. " + builder.timeSeriesIdentifier());
        }
        if (builder.times().length == 1 && builder.values().length > 1) {
            this.initialize(builder.times()[0], builder.values(), builder.timeSeriesIdentifier().getInterval(), builder.startTime().toEpochMilli(), builder.endTime().toEpochMilli(), builder.quality(), builder.units());
        } else if (builder.times().length > 0) {
            this.initialize(builder.startTime().toEpochMilli(), builder.endTime().toEpochMilli(), builder.times(), builder.values(), builder.quality(), builder.units());
        } else {
            ZoneId zoneId = (ZoneId)builder.timeSeriesIdentifier().getIntervalZoneId().orElseThrow(() -> new DataSetIllegalArgumentException("Unable to calculate a predictable interval time series without a time zone. " + builder.timeSeriesIdentifier()));
            this._startTime = ZonedDateTime.ofInstant(NumericalConstants.UNDEFINED_INSTANT, zoneId);
        }
    }

    private void initialize(long startTimeWindow, long endTimeWindow, long[] times, double[] values, Quality quality, Units units) throws DataSetIllegalArgumentException, IntervalOffsetMismatchException, DataSetTimeSeriesIllegalArgumentException, DataSetTimeSeriesDeriveException {
        if (startTimeWindow == Long.MIN_VALUE || endTimeWindow == Long.MIN_VALUE) {
            startTimeWindow = times[0];
            endTimeWindow = times[times.length - 1];
        }
        this.set(times, values, quality, startTimeWindow, endTimeWindow);
        if (this.needToChangeUnits(units)) {
            this.changeUnits(units);
        }
    }

    private void initialize(long startTime, double[] values, Interval interval, Long startTimeWindow, long endTimeWindow, Quality quality, Units units) throws DataSetIllegalArgumentException, DataSetTimeSeriesIllegalArgumentException, IntervalOffsetMismatchException, DataSetTimeSeriesDeriveException {
        long previousInterval;
        TimeSeriesIdentifier timeSeriesIdentifier = this.getTimeSeriesIdentifier();
        IntervalOffset intervalOffset = timeSeriesIdentifier.getIntervalOffset();
        ZoneId intervalZoneId = (ZoneId)timeSeriesIdentifier.getIntervalZoneId().orElseThrow(() -> new DataSetIllegalArgumentException("Unable to calculate a predictable interval time series without a time zone"));
        if (NumericalConstants.isNotValidValue((double)startTime)) {
            throw new DataSetTimeSeriesIllegalArgumentException("Unable to apply values to time series when template time window is undefined");
        }
        if (intervalOffset.isDefined() && (previousInterval = timeSeriesIdentifier.getInterval().getTimeOnPreviousOrCurrentInterval(startTime, intervalOffset, TimeZone.getTimeZone(intervalZoneId))) != startTime) {
            throw new DataSetTimeSeriesIllegalArgumentException("Start time is off of the interval offset, unable to build time series. Start time: " + Instant.ofEpochMilli(startTime).atZone(intervalZoneId) + " Offset: " + intervalOffset);
        }
        this._startTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(startTime), intervalZoneId);
        long[] times = this.getTimes(startTime, values.length, interval);
        if (times == null) {
            throw new DataSetTimeSeriesIllegalArgumentException("Error calculating times array from start time and time window");
        }
        if (startTimeWindow == Long.MIN_VALUE || endTimeWindow == Long.MIN_VALUE) {
            startTimeWindow = times[0];
            endTimeWindow = times[times.length - 1];
        }
        this.set(times, values, quality, startTimeWindow, endTimeWindow);
        if (this.needToChangeUnits(units)) {
            this.changeUnits(units);
        }
    }

    private void updateIntervalOffsetFromBaseSec() throws DataSetIllegalArgumentException {
        Instant startTime;
        TimeSeriesIdentifier timeSeriesIdentifier = this.getTimeSeriesIdentifier();
        IntervalOffset intervalOffset = timeSeriesIdentifier.getIntervalOffset();
        if (intervalOffset.isUndefined() && NumericalConstants.UNDEFINED_INSTANT.equals(startTime = this.getStartTime().toInstant())) {
            timeSeriesIdentifier.updateUndefinedIntervalOffsetWithStartTime(startTime);
        }
    }

    @Override
    public final ZonedDateTime getStartTime() {
        return this._startTime;
    }

    @Override
    final void set(long[] times, double[] values, Quality quality, long startTimeWindow, long endTimeWindow) throws DataSetTimeSeriesIllegalArgumentException, IntervalOffsetMismatchException, DataSetIllegalArgumentException {
        double[] setValues;
        long[] setTimes;
        Instant lendTime;
        Quality setQuality = null;
        SimpleDateFormat sdf = new SimpleDateFormat(" dd MMM yyyy  HH:mm:ss z");
        if (times.length != values.length) {
            throw new DataSetTimeSeriesIllegalArgumentException("Lengths of times and values not consistent: " + times.length + " != " + values.length + " for time series: " + this.getTimeSeriesIdentifier());
        }
        if (quality != null && quality.getSize() != times.length) {
            throw new DataSetTimeSeriesIllegalArgumentException("Lengths of times and quality not consistent: " + times.length + " != " + quality.getSize() + " for time series: " + this.getTimeSeriesIdentifier());
        }
        if (startTimeWindow > endTimeWindow) {
            throw new DataSetTimeSeriesIllegalArgumentException("\nStart after end in Time window:\n Time Window: " + sdf.format(new Date(startTimeWindow)) + " " + sdf.format(new Date(endTimeWindow)) + " for time series: " + this.getTimeSeriesIdentifier());
        }
        if (times.length > 1 && (times[1] < startTimeWindow || times[times.length - 2] > endTimeWindow)) {
            throw new DataSetTimeSeriesIllegalArgumentException("\nTimes are outside of time window:\n First/Last Times: " + sdf.format(new Date(times[0])) + " " + sdf.format(new Date(times[times.length - 1])) + "\n      Time Window: " + sdf.format(new Date(startTimeWindow)) + " " + sdf.format(new Date(endTimeWindow)) + " for time series: " + this.getTimeSeriesIdentifier());
        }
        for (int i2 = 1; i2 < times.length; ++i2) {
            if (times[i2 - 1] > times[i2]) {
                throw new DataSetTimeSeriesIllegalArgumentException("Times not increasing at index: " + i2 + " for time series: " + this.getTimeSeriesIdentifier());
            }
            if (times[i2 - 1] != times[i2]) continue;
            throw new DataSetTimeSeriesIllegalArgumentException("Times not unique at index: " + i2 + " for time series: " + this.getTimeSeriesIdentifier());
        }
        TimeSeriesIdentifier timeSeriesIdentifier = this.getTimeSeriesIdentifier();
        if (times.length > 0) {
            long firstTime = times[0];
            timeSeriesIdentifier.updateUndefinedIntervalOffsetWithStartTime(Instant.ofEpochMilli(firstTime));
        }
        Interval interval = timeSeriesIdentifier.getInterval();
        ZoneId zoneId = (ZoneId)timeSeriesIdentifier.getIntervalZoneId().orElseThrow(() -> new DataSetIllegalArgumentException("Unable to calculate a predictable interval time series without a time zone"));
        IntervalOffset intervalOffset = this.getIntervalOffset();
        Instant lstartTime = interval.getTimeOnNextOrCurrentInterval(Instant.ofEpochMilli(startTimeWindow), intervalOffset, zoneId);
        int num = (int)interval.getNumIntervalPoints(lstartTime, lendTime = interval.getTimeOnPreviousOrCurrentInterval(Instant.ofEpochMilli(endTimeWindow), intervalOffset, zoneId), zoneId);
        if (num != times.length) {
            long[] intervalTimes;
            TreeMap<Long, Double> dataMap = new TreeMap<Long, Double>();
            TreeMap<Long, Integer> qualityMap = new TreeMap<Long, Integer>();
            for (int i3 = 0; i3 < times.length; ++i3) {
                dataMap.put(times[i3], values[i3]);
                if (quality == null) continue;
                qualityMap.put(times[i3], quality.getIntegerAt(i3));
            }
            for (long intervalTime : intervalTimes = this.getTimes(lstartTime.toEpochMilli(), num, interval)) {
                dataMap.putIfAbsent(intervalTime, -3.4028234663852886E38);
                if (quality == null) continue;
                qualityMap.putIfAbsent(intervalTime, Quality.emptyQualityValue());
            }
            setTimes = dataMap.keySet().stream().mapToLong(i -> i).toArray();
            setValues = dataMap.values().stream().mapToDouble(i -> i).toArray();
            if (quality != null) {
                int[] ints = qualityMap.values().stream().mapToInt(i -> i).toArray();
                setQuality = new Quality(ints);
            }
        } else {
            setTimes = times;
            setValues = values;
            setQuality = quality;
        }
        this.testTimesOnInterval(setTimes);
        this.setInternal(setTimes, setValues, setQuality);
        this.updateIntervalOffsetFromBaseSec();
    }

    private void testTimesOnInterval(long[] setTimes) throws DataSetIllegalArgumentException {
        TimeSeriesIdentifier timeSeriesIdentifier = this.getTimeSeriesIdentifier();
        IntervalOffset intervalOffset = timeSeriesIdentifier.getIntervalOffset();
        ZoneId zoneId = (ZoneId)timeSeriesIdentifier.getIntervalZoneId().orElseThrow(() -> new DataSetIllegalArgumentException("Unable to calculate a predictable interval time series without a time zone for time series: " + this.getTimeSeriesIdentifier()));
        Interval interval = timeSeriesIdentifier.getInterval();
        for (long setTime : setTimes) {
            Instant timeOnInterval;
            Instant instant = Instant.ofEpochMilli(setTime);
            if (instant.equals(timeOnInterval = interval.getTimeOnPreviousOrCurrentInterval(instant, intervalOffset, zoneId))) continue;
            ZonedDateTime received = ZonedDateTime.ofInstant(instant, zoneId);
            String receivedDateTime = DateTimeFormatter.ISO_ZONED_DATE_TIME.format(received);
            throw new DataSetIllegalArgumentException("Time: " + receivedDateTime + " does not fall on the interval for the time series: " + timeSeriesIdentifier + " with offset: " + intervalOffset);
        }
    }

    @Override
    final void setInternal(long[] times, double[] values, Quality quality) throws DataSetTimeSeriesIllegalArgumentException {
        ZoneId intervalZoneId = (ZoneId)this.getTimeSeriesIdentifier().getIntervalZoneId().orElseThrow(() -> new DataSetTimeSeriesIllegalArgumentException("Unable to calcualte a predictable interval time series without a time zone"));
        this._startTime = times.length > 0 ? ZonedDateTime.ofInstant(Instant.ofEpochMilli(times[0]), intervalZoneId) : ZonedDateTime.ofInstant(NumericalConstants.UNDEFINED_INSTANT, intervalZoneId);
        this.setValues(values);
        this.setQuality(quality);
        this.getTimeSeriesStatistics().setOutOfDate();
        if (!this.getPreserveRejectedAndMissingValues()) {
            this.setValues(this.getValuesWithQualityFlagsApplied());
            this.setQuality(this.getQualityClearedForValuesWithQualityFlagsApplied());
        }
    }

    private void set(double[] values, Quality quality) throws DataSetIllegalArgumentException {
        TimeSeriesIdentifier descriptionTx = this.getTimeSeriesIdentifier();
        descriptionTx.updateUndefinedIntervalOffsetWithStartTime(this._startTime.toInstant());
        if (!this.getPreserveRejectedAndMissingValues()) {
            values = this.getValuesWithQualityFlagsApplied();
            quality = this.getQualityClearedForValuesWithQualityFlagsApplied();
        }
        this.setValues(values);
        this.setQuality(quality);
        this.getTimeSeriesStatistics().setOutOfDate();
        if (!this.getPreserveRejectedAndMissingValues()) {
            this.setValues(this.getValuesWithQualityFlagsApplied());
            this.setQuality(this.getQualityClearedForValuesWithQualityFlagsApplied());
        }
    }

    @Override
    public final long[] getTimes() {
        return this.getTimes(this._startTime.toInstant().toEpochMilli(), this.getNumberValues(), this.getTimeSeriesIdentifier().getInterval());
    }

    @Override
    public final NavigableSet<Instant> getInstants() {
        return this.getTimes(this._startTime.toInstant(), this.getNumberValues(), this.getTimeSeriesIdentifier().getInterval());
    }

    long[] getTimes(long startValuesTime, int numberOfValues, Interval interval) {
        long[] times = new long[numberOfValues];
        if (numberOfValues == 0) {
            return times;
        }
        times[0] = startValuesTime;
        try {
            TimeZone intervalOffsetTimeZone = TimeZone.getTimeZone(this.getTimeSeriesIdentifier().getIntervalZoneId().orElse(NumericalConstants.UTC_ZONEID));
            for (int i = 1; i < numberOfValues; ++i) {
                times[i] = interval.getNextIntervalTime(times[i - 1], intervalOffsetTimeZone);
            }
        }
        catch (DataSetIllegalArgumentException e) {
            times = null;
            LOGGER.log(Level.FINE, e, () -> "Error in determining next interval time for time series id: " + this.getTimeSeriesIdentifier());
        }
        return times;
    }

    private NavigableSet<Instant> getTimes(Instant startTime, int numberOfValues, Interval interval) {
        TreeSet<Instant> times = new TreeSet<Instant>();
        if (numberOfValues == 0) {
            return times;
        }
        times.add(startTime);
        try {
            ZoneId zoneId = this.getTimeSeriesIdentifier().getIntervalZoneId().orElse(NumericalConstants.UTC_ZONEID);
            for (int i = 1; i < numberOfValues; ++i) {
                startTime = interval.getNextIntervalTime(startTime, zoneId);
                times.add(startTime);
            }
        }
        catch (DataSetIllegalArgumentException e) {
            times = new TreeSet();
            LOGGER.log(Level.FINE, e, () -> "Error in determining next interval time for time series id: " + this.getTimeSeriesIdentifier());
        }
        return times;
    }

    IntervalOffset getIntervalOffset() throws DataSetIllegalArgumentException {
        this.updateIntervalOffsetFromBaseSec();
        return this.getTimeSeriesIdentifier().getIntervalOffset();
    }

    @Override
    public final void fillTails(TimeSeriesTemplate template) throws DataSetTimeSeriesException, DataSetIllegalArgumentException {
        Interval templateInterval = template.getTimeSeriesIdentifier().getInterval();
        Interval interval = this.getTimeSeriesIdentifier().getInterval();
        long lstartTime = this.getStartTime().toInstant().toEpochMilli();
        long lendTime = this.getEndTime().toInstant().toEpochMilli();
        long newStartTime = template.getStartTime();
        long newEndTime = template.getEndTime();
        if (newStartTime >= lstartTime && newEndTime <= lendTime) {
            return;
        }
        if (!interval.equals(templateInterval)) {
            throw new DataSetTimeSeriesException("Cannot fill tails when intervals differ. \nDataSet: " + this.toString() + "\nTemplate: " + template.toString());
        }
        IntervalOffset intervalOffset = this.getIntervalOffset();
        ZoneId zoneId = (ZoneId)this.getTimeSeriesIdentifier().getIntervalZoneId().orElseThrow(() -> new DataSetTimeSeriesIllegalArgumentException("Unable to calculate a predictable interval time series without a time zone"));
        TimeZone intervalOffsetTimeZone = TimeZone.getTimeZone(zoneId);
        newStartTime = interval.getTimeOnNextOrCurrentInterval(newStartTime, intervalOffset, intervalOffsetTimeZone);
        newEndTime = interval.getTimeOnNextOrCurrentInterval(newEndTime, intervalOffset, intervalOffsetTimeZone);
        int newSize = interval.getNumIntervalPoints(newStartTime, newEndTime, intervalOffsetTimeZone) + 1;
        double[] newValues = new double[newSize];
        Quality newQuality = null;
        if (this.hasQuality()) {
            newQuality = new Quality(newSize);
        }
        int beginningTailNum = 0;
        if (newStartTime < lstartTime) {
            beginningTailNum = (int)((lstartTime - newStartTime) / templateInterval.getMillis());
            for (int j = 0; j < beginningTailNum; ++j) {
                newValues[j] = -3.4028234663852886E38;
                if (newQuality == null) continue;
                newQuality.setIntegerAt(0, j);
            }
        }
        Optional<Quality> originalQuality = this.getQuality();
        for (int k = 0; k < this.getValues().length; ++k) {
            newValues[beginningTailNum + k] = this.getValues()[k];
            if (newQuality == null || !originalQuality.isPresent()) continue;
            newQuality.setIntegerAt(originalQuality.get().getIntegerAt(k), beginningTailNum + k);
        }
        if (newEndTime > lendTime) {
            int endingTailNum = (int)((newEndTime - lendTime) / templateInterval.getMillis());
            for (int m = 0; m < endingTailNum; ++m) {
                newValues[beginningTailNum + this.getValues().length + m] = -3.4028234663852886E38;
                if (newQuality == null) continue;
                newQuality.setIntegerAt(0, beginningTailNum + this.getValues().length + m);
            }
        }
        this.setValues(newValues);
        this.setQuality(newQuality);
        this.getTimeSeriesStatistics().setOutOfDate();
    }

    @Override
    public void removeRejectedAndMissingValues(boolean preserveRejectedAndMissingValues) throws DataSetTimeSeriesException, DataSetIllegalArgumentException, IntervalOffsetMismatchException {
        boolean preserve = this.getPreserveRejectedAndMissingValues();
        if (preserve == preserveRejectedAndMissingValues) {
            return;
        }
        if (!preserve && preserveRejectedAndMissingValues) {
            throw new DataSetTimeSeriesException("\nCannot preserve rejected and missing values, because they have been removed previously");
        }
        this.setPreserveRejectedAndMissingValues(false);
        this.set(this.getValues(), this.getQuality().orElse(null));
    }

    @Override
    public ZonedDateTime getEndTime() {
        long[] times = this.getTimes();
        if (times.length == 0) {
            return ZonedDateTime.ofInstant(NumericalConstants.UNDEFINED_INSTANT, this._startTime.getZone());
        }
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(times[times.length - 1]), this._startTime.getZone());
    }
}

