/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import mil.army.usace.hec.data.timeseries.DataSetTimeSeriesDeriveException;
import mil.army.usace.hec.data.timeseries.DataSetTimeSeriesUnitsConversionException;
import mil.army.usace.hec.data.timeseries.Quality;
import mil.army.usace.hec.data.timeseries.TimeSeries;
import mil.army.usace.hec.data.timeseries.TimeSeriesBuilder;
import mil.army.usace.hec.data.timeseries.TimeSeriesFactory;
import mil.army.usace.hec.data.timeseries.TimeSeriesStatistics;
import mil.army.usace.hec.data.timeseries.VersionDate;
import mil.army.usace.hec.data.timeseries.math.TimeSeriesTemplate;
import mil.army.usace.hec.metadata.DataSetException;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.IntervalOffset;
import mil.army.usace.hec.metadata.UnitUtil;
import mil.army.usace.hec.metadata.Units;
import mil.army.usace.hec.metadata.UnitsConversionException;
import mil.army.usace.hec.metadata.constants.NumericalConstants;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesException;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesIllegalArgumentException;
import mil.army.usace.hec.metadata.timeseries.IntervalOffsetMismatchException;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;

abstract class AbstractTimeSeries
implements TimeSeries {
    private static final long serialVersionUID = 3151289340170527603L;
    private final TimeSeriesStatistics _timeSeriesStatistics;
    private final TimeSeriesIdentifier _timeSeriesIdentifier;
    private boolean _preserveRejectedAndMissingValues;
    private Units _units;
    private double[] _values;
    private Quality _quality;
    private final VersionDate _versionDate;
    private long _maxTimeGap;

    AbstractTimeSeries(TimeSeriesBuilder builder) throws DataSetTimeSeriesException {
        this._units = builder.units();
        this._timeSeriesIdentifier = builder.timeSeriesIdentifier();
        this._maxTimeGap = builder.maxTimeGap();
        this._preserveRejectedAndMissingValues = builder.preserveRejectedAndMissingValues();
        this._values = builder.values();
        this._quality = builder.quality();
        this._versionDate = builder.versionDate();
        this.validateIdentifier(this._timeSeriesIdentifier);
        if (this._units == null) {
            throw new DataSetTimeSeriesException("Units are null on instantiation of dataset: \n" + this._timeSeriesIdentifier.toString());
        }
        if (this._units.toString().equals("undef")) {
            throw new DataSetTimeSeriesException("Units are undefined on instantiation of dataset: \n" + this._timeSeriesIdentifier.toString());
        }
        this._timeSeriesStatistics = new TimeSeriesStatistics(this);
    }

    @Override
    public void setMaxTimeGap(long maxTimeGap) {
        this._maxTimeGap = maxTimeGap;
    }

    @Override
    public long getMaxTimeGap() {
        return this._maxTimeGap;
    }

    @Override
    public TimeSeriesIdentifier getTimeSeriesIdentifier() {
        return this._timeSeriesIdentifier;
    }

    @Override
    public Units getUnits() {
        return this._units;
    }

    @Override
    public TimeSeriesStatistics getTimeSeriesStatistics() {
        return this._timeSeriesStatistics;
    }

    abstract void validateIdentifier(TimeSeriesIdentifier var1) throws DataSetTimeSeriesIllegalArgumentException;

    final Quality getQualityClearedForValuesWithQualityFlagsApplied() {
        Quality clearQuality = null;
        Optional<Quality> optQuality = this.getQuality();
        if (optQuality.isPresent()) {
            Quality originalQuality = optQuality.get();
            clearQuality = new Quality(originalQuality);
            for (int i = 0; i < this.getNumberValues(); ++i) {
                if (this.isMissing(i)) {
                    clearQuality.setIntegerAt(0, i);
                }
                if (originalQuality.isReject(i)) {
                    clearQuality.setIntegerAt(0, i);
                }
                clearQuality.clearProtected(i);
            }
        }
        return clearQuality;
    }

    final void setQuality(Quality quality) {
        this._quality = quality;
    }

    @Override
    public final void set(long[] times, double[] values, Quality quality) throws DataSetTimeSeriesIllegalArgumentException, IntervalOffsetMismatchException, DataSetIllegalArgumentException {
        long firstValueTime = times[0];
        long lastValueTime = times[times.length - 1];
        this.set(times, values, quality, firstValueTime, lastValueTime);
    }

    abstract void set(long[] var1, double[] var2, Quality var3, long var4, long var6) throws DataSetTimeSeriesIllegalArgumentException, IntervalOffsetMismatchException, DataSetIllegalArgumentException;

    public final String toString() {
        String startDate = this.getStartTime().toString();
        if (this.getStartTime().toInstant().equals(NumericalConstants.UNDEFINED_INSTANT)) {
            startDate = "--Undefined--";
        }
        String endDate = this.getEndTime().toString();
        if (this.getEndTime().toInstant().equals(NumericalConstants.UNDEFINED_INSTANT)) {
            endDate = "--Undefined--";
        }
        IntervalOffset intervalOffsetFromBaseSec = this._timeSeriesIdentifier.getIntervalOffset();
        return "   -->Description: " + this._timeSeriesIdentifier.toString() + ";\n   -->Start Time: " + startDate + ";\n   -->End Time:   " + endDate + ";\n   -->Interval Offset from " + this.getTimeSeriesIdentifier().getIntervalZoneId().orElse(null) + ": " + intervalOffsetFromBaseSec.toString() + ";\n   -->Units: " + this._units + ";\n   -->Preserve: " + this._preserveRejectedAndMissingValues + ";\n   -->MaxTimeGap: " + this._maxTimeGap / 60000L + " Mins  or  " + this._maxTimeGap / 3600000L + " Hours;\n   -->Number of values: " + this._values.length;
    }

    @Override
    public final NavigableMap<ZonedDateTime, Double> getData(ZoneId zoneId) {
        TreeMap<ZonedDateTime, Double> map = new TreeMap<ZonedDateTime, Double>();
        long[] timesArray = this.getTimes();
        double[] valuesArray = this.getValues();
        for (int ii = 0; ii < timesArray.length; ++ii) {
            ZonedDateTime date = ZonedDateTime.ofInstant(Instant.ofEpochMilli(timesArray[ii]), zoneId);
            Double value = valuesArray[ii];
            map.put(date, value);
        }
        return map;
    }

    @Override
    public final NavigableMap<ZonedDateTime, Double> getData() {
        return this.getData(this.getTimeSeriesIdentifier().getIntervalZoneId().orElse(NumericalConstants.UTC_ZONEID));
    }

    @Override
    public final NavigableMap<Date, Double> getDateValueNavigableMap() {
        TreeMap<Date, Double> map = new TreeMap<Date, Double>();
        long[] timesArray = this.getTimes();
        double[] valuesArray = this.getValues();
        for (int ii = 0; ii < timesArray.length; ++ii) {
            Date date = new Date(timesArray[ii]);
            Double value = valuesArray[ii];
            map.put(date, value);
        }
        return map;
    }

    @Override
    public final double[] getValues() {
        return this._values;
    }

    final void setValues(double[] values) {
        this._values = values;
    }

    @Override
    public final void trim() throws DataSetTimeSeriesIllegalArgumentException {
        int numberOfValues = this.getNumberValues();
        long[] originalTimes = this.getTimes();
        double[] originalValues = this.getValues();
        Optional<Quality> originalQuality = this.getQuality();
        int newStartingIndex = -1;
        for (int ii = 0; ii < numberOfValues; ++ii) {
            if (originalValues[ii] == -3.4028234663852886E38 && (!originalQuality.isPresent() || !this.isMissing(ii) || !originalQuality.get().isProtected(ii))) continue;
            newStartingIndex = ii;
            break;
        }
        int newEndingIndex = -1;
        for (int ii = numberOfValues - 1; ii >= 0; --ii) {
            if (originalValues[ii] == -3.4028234663852886E38 && (!originalQuality.isPresent() || !this.isMissing(ii) || !originalQuality.get().isProtected(ii))) continue;
            newEndingIndex = ii;
            break;
        }
        if (newEndingIndex == -1 && newStartingIndex == -1) {
            this.setInternal(new long[0], new double[0], null);
            return;
        }
        int trimmedValueCount = newEndingIndex - newStartingIndex + 1;
        if (trimmedValueCount == numberOfValues) {
            return;
        }
        long[] trimmedTimes = new long[trimmedValueCount];
        double[] trimmedValues = new double[trimmedValueCount];
        int[] trimmedIntQuality = null;
        Quality trimmedQuality = null;
        if (originalQuality.isPresent()) {
            trimmedIntQuality = new int[trimmedValueCount];
        }
        System.arraycopy(originalTimes, newStartingIndex, trimmedTimes, 0, trimmedValueCount);
        System.arraycopy(originalValues, newStartingIndex, trimmedValues, 0, trimmedValueCount);
        if (originalQuality.isPresent()) {
            int[] originalIntQuality = originalQuality.get().getIntQuality();
            System.arraycopy(originalIntQuality, newStartingIndex, trimmedIntQuality, 0, trimmedValueCount);
            trimmedQuality = new Quality(trimmedIntQuality);
        }
        this.setInternal(trimmedTimes, trimmedValues, trimmedQuality);
    }

    abstract void setInternal(long[] var1, double[] var2, Quality var3) throws DataSetTimeSeriesIllegalArgumentException;

    @Override
    public final double[] getValuesWithQualityFlagsApplied() {
        Optional<Quality> quality = this.getQuality();
        if (quality.isPresent()) {
            double[] values = new double[this._values.length];
            for (int i = 0; i < this._values.length; ++i) {
                values[i] = this.isMissing(i) || quality.get().isReject(i) ? -3.4028234663852886E38 : this._values[i];
            }
            return values;
        }
        return this.getValues();
    }

    @Override
    public final int getIndexOfLatestValidValue() {
        if (this._values.length <= 0) {
            return -1;
        }
        Optional<Quality> quality = this.getQuality();
        if (quality.isPresent()) {
            for (int k = this._values.length - 1; k > -1; --k) {
                if (!quality.get().isNotMissing(k) || !quality.get().isNotReject(k)) continue;
                return k;
            }
        }
        return -1;
    }

    @Override
    public final Optional<VersionDate> getVersionDate() {
        return Optional.ofNullable(this._versionDate);
    }

    @Override
    public final Optional<Quality> getQuality() {
        return Optional.ofNullable(this._quality);
    }

    @Override
    public final boolean hasQuality() {
        return this.getQuality().isPresent();
    }

    @Override
    public final void addEmptyQualityTx() {
        if (!this.hasQuality()) {
            this._quality = new Quality(this._values.length);
        }
    }

    public final boolean equals(Object object) {
        if (object instanceof AbstractTimeSeries) {
            AbstractTimeSeries abstractTimeSeries = (AbstractTimeSeries)object;
            return Objects.equals(this._timeSeriesIdentifier, abstractTimeSeries._timeSeriesIdentifier) && this.getNumberValues() == abstractTimeSeries.getNumberValues() && Objects.equals(this.getStartTime(), abstractTimeSeries.getStartTime()) && Objects.equals(this.getEndTime(), abstractTimeSeries.getEndTime());
        }
        return super.equals(object);
    }

    public int hashCode() {
        return Objects.hash(this.getTimeSeriesIdentifier(), this.getNumberValues());
    }

    @Override
    public final int getNumberValues() {
        return this._values.length;
    }

    @Override
    public final boolean isSameTimeWindow(TimeSeries timeSeries) {
        return this.getStartTime().equals(timeSeries.getStartTime()) && this.getEndTime().equals(timeSeries.getEndTime());
    }

    @Override
    public final boolean needToChangeUnits(Units toUnits) throws DataSetTimeSeriesDeriveException {
        Units fromUnits;
        try {
            fromUnits = new Units(this.getUnits().toString());
        }
        catch (DataSetIllegalArgumentException e) {
            throw new DataSetTimeSeriesDeriveException(e.getMessage(), e);
        }
        if (toUnits == null) {
            throw new DataSetTimeSeriesDeriveException("Convert to units are null for Dataset: \n" + this.getTimeSeriesIdentifier().toString());
        }
        if (fromUnits.toString().equals(toUnits.toString())) {
            return false;
        }
        return !"undef".equals(toUnits.toString());
    }

    @Override
    public final void changeUnits(Units toUnits) throws DataSetTimeSeriesDeriveException {
        try {
            UnitUtil.convertUnits((double[])this.getValues(), (String)this.getUnits().toString(), (String)toUnits.toString());
        }
        catch (UnitsConversionException e) {
            throw new DataSetTimeSeriesUnitsConversionException(e.getMessage(), e);
        }
        this._units = new Units(toUnits);
        this._timeSeriesStatistics.setOutOfDate();
    }

    @Override
    public final void changeUnitSystem(String unitSystem) throws DataSetTimeSeriesException, UnitsConversionException, DataSetIllegalArgumentException {
        int unitSystemId;
        if (unitSystem.equalsIgnoreCase("SI")) {
            unitSystemId = 2;
        } else if (unitSystem.equalsIgnoreCase("English")) {
            unitSystemId = 1;
        } else {
            throw new DataSetTimeSeriesException("Unit System: " + unitSystem + " is not recognized.");
        }
        this.changeUnitSystem(unitSystemId);
    }

    @Override
    public final void changeUnitSystem(int unitSystemId) throws UnitsConversionException, DataSetIllegalArgumentException {
        String toUnits = this.getTimeSeriesIdentifier().getParameter().getUnitsStringForSystem(unitSystemId);
        if (this.getUnits().toString().equals(toUnits)) {
            return;
        }
        UnitUtil.convertUnits((double[])this.getValues(), (String)this.getUnits().toString(), (String)toUnits);
        this._units = new Units(toUnits);
        this._timeSeriesStatistics.setOutOfDate();
    }

    private boolean isQualityEqual(int idxA, Optional<Quality> qualityA, int idxB, Optional<Quality> qualityB) {
        int qb;
        if (!qualityA.isPresent() && !qualityB.isPresent()) {
            return true;
        }
        if (qualityA.isPresent() && !qualityB.isPresent()) {
            return qualityA.get().getIntegerAt(idxA) == 0;
        }
        if (!qualityA.isPresent() && qualityB.isPresent()) {
            return qualityB.get().getIntegerAt(idxB) == 0;
        }
        int qa = qualityA.get().getIntegerAt(idxA);
        return qa == (qb = qualityB.get().getIntegerAt(idxB));
    }

    @Override
    public final TimeSeries generateDifferences(TimeSeries filterData) throws DataSetException {
        int newlength;
        if (!this.getTimeSeriesIdentifier().equals(filterData.getTimeSeriesIdentifier())) {
            throw new DataSetTimeSeriesException("The two data sets must share the same description.");
        }
        long startTimeA = this.getStartTime().toInstant().toEpochMilli();
        long startTimeB = filterData.getStartTime().toInstant().toEpochMilli();
        long endTimeA = this.getEndTime().toInstant().toEpochMilli();
        long endTimeB = filterData.getEndTime().toInstant().toEpochMilli();
        if (startTimeA < startTimeB && endTimeA > endTimeB) {
            return this;
        }
        long[] timesA = this.getTimes();
        double[] valuesA = this.getValues();
        Optional<Quality> qualityA = this.getQuality();
        long[] timesB = filterData.getTimes();
        double[] valuesB = filterData.getValues();
        Optional<Quality> qualityB = filterData.getQuality();
        int startDiff = -1;
        int idxB = 0;
        int idxA = 0;
        while (idxA < timesA.length) {
            if (idxB >= timesB.length) {
                startDiff = idxA;
                break;
            }
            if (timesA[idxA] > timesB[idxB]) {
                ++idxB;
                continue;
            }
            if (timesA[idxA] < timesB[idxB]) {
                startDiff = idxA;
                break;
            }
            if (valuesA[idxA] == valuesB[idxB] && this.isQualityEqual(idxA, qualityA, idxB, qualityB)) {
                ++idxA;
                ++idxB;
                continue;
            }
            startDiff = idxA;
            break;
        }
        if (startDiff == -1) {
            return null;
        }
        idxA = timesA.length - 1;
        idxB = timesB.length - 1;
        int endDiff = idxA;
        while (idxA > startDiff) {
            if (idxB < 0) {
                endDiff = idxA;
                break;
            }
            if (timesA[idxA] < timesB[idxB]) {
                --idxB;
                continue;
            }
            if (timesA[idxA] > timesB[idxB]) {
                endDiff = idxA;
                break;
            }
            if (valuesA[idxA] == valuesB[idxB] && this.isQualityEqual(idxA, qualityA, idxB, qualityB)) {
                --idxA;
                --idxB;
                continue;
            }
            endDiff = idxA;
            break;
        }
        if ((newlength = endDiff + 1 - startDiff) < 1) {
            return null;
        }
        long[] timesR = new long[newlength];
        double[] valsR = new double[newlength];
        int[] qualR = null;
        int[] qualA = null;
        if (qualityA.isPresent()) {
            qualA = qualityA.get().getIntQuality();
            qualR = new int[newlength];
        }
        System.arraycopy(timesA, startDiff, timesR, 0, newlength);
        System.arraycopy(valuesA, startDiff, valsR, 0, newlength);
        if (qualR != null) {
            System.arraycopy(qualA, startDiff, qualR, 0, newlength);
        }
        Quality qualityR = null;
        if (qualR != null) {
            qualityR = new Quality(qualR);
        }
        TimeSeriesTemplate timeSeriesTemplate = new TimeSeriesTemplate(this.getTimeSeriesIdentifier(), this.getUnits());
        return TimeSeriesFactory.buildTimeSeries(timeSeriesTemplate, timesR, valsR, qualityR);
    }

    @Override
    public boolean getPreserveRejectedAndMissingValues() {
        return this._preserveRejectedAndMissingValues;
    }

    @Override
    public void setPreserveRejectedAndMissingValues(boolean preserveRejectedAndMissingValues) {
        this._preserveRejectedAndMissingValues = preserveRejectedAndMissingValues;
    }

    @Override
    public void setUnits(Units units) {
        this._units = units;
    }

    @Override
    public final boolean isOkay(int index) {
        if (this._quality == null || this._quality.isNotScreened(index)) {
            return NumericalConstants.isValidValue((double)this._values[index]);
        }
        return this._quality.isOkay(index);
    }

    @Override
    public final boolean isMissing(int index) {
        if (this._quality == null || this._quality.isNotScreened(index)) {
            return !NumericalConstants.isValidValue((double)this._values[index]);
        }
        return this._quality.isMissing(index);
    }

    @Override
    public final void trimTail() {
        int numberOfValues = this.getNumberValues();
        int i = 0;
        int numberToTrimOnRear = 0;
        Optional<Quality> originalQuality = this.getQuality();
        if (i < numberOfValues) {
            i = numberOfValues - 1;
            while (i > 0) {
                if (this.getValues()[i] == -3.4028234663852886E38) {
                    if (originalQuality.isPresent()) {
                        if (originalQuality.get().getIntegerAt(i) == 0 || originalQuality.get().isNotMissing(i) && originalQuality.get().isNotProtected(i)) {
                            ++numberToTrimOnRear;
                            --i;
                            continue;
                        }
                        i = 0;
                        continue;
                    }
                    ++numberToTrimOnRear;
                    --i;
                    continue;
                }
                i = 0;
            }
        }
        int numberOfValuesAsTrimmed = numberOfValues - numberToTrimOnRear;
        double[] trimmedValues = new double[numberOfValuesAsTrimmed];
        Quality trimmedQuality = null;
        if (originalQuality.isPresent()) {
            trimmedQuality = new Quality(numberOfValuesAsTrimmed);
        }
        if (numberOfValuesAsTrimmed == 0) {
            this.setValues(trimmedValues);
            if (originalQuality.isPresent()) {
                this.setQuality(trimmedQuality);
            }
            this.getTimeSeriesStatistics().setOutOfDate();
        } else {
            for (i = 0; i < numberOfValuesAsTrimmed; ++i) {
                trimmedValues[i] = this.getValues()[i];
                if (!originalQuality.isPresent() || trimmedQuality == null) continue;
                trimmedQuality.setIntegerAt(originalQuality.get().getIntegerAt(i), i);
            }
            this.setValues(trimmedValues);
            if (originalQuality.isPresent()) {
                this.setQuality(trimmedQuality);
            }
            this.getTimeSeriesStatistics().setOutOfDate();
        }
    }

    @Override
    public final void window(TimeSeriesTemplate timeSeriesTemplate) throws DataSetTimeSeriesDeriveException {
        if (this.isEmpty()) {
            return;
        }
        long newStartTime = timeSeriesTemplate.getStartTime();
        long newEndTime = timeSeriesTemplate.getEndTime();
        long currentStartTime = this.getStartTime().toInstant().toEpochMilli();
        long currentEndTime = this.getEndTime().toInstant().toEpochMilli();
        if (newStartTime <= currentStartTime && newEndTime >= currentEndTime) {
            return;
        }
        NavigableMap<Date, Double> fullValueMap = this.getDateValueNavigableMap();
        if (((Date)fullValueMap.firstKey()).getTime() > newEndTime || ((Date)fullValueMap.lastKey()).getTime() < newStartTime) {
            throw new DataSetTimeSeriesDeriveException("In-valid time window\nRequested time window Start: " + new Date(newStartTime) + "  End: " + new Date(newEndTime) + "\nDataSet time window Start: " + fullValueMap.firstKey() + "  End: " + fullValueMap.lastKey());
        }
        NavigableMap<Date, Double> subValueMap = fullValueMap.subMap(new Date(newStartTime), true, new Date(newEndTime), true);
        long[] newTimes = subValueMap.keySet().stream().mapToLong(Date::getTime).toArray();
        double[] newValues = subValueMap.values().stream().mapToDouble(d -> d).toArray();
        Quality newQuality = this.getQuality().map(q -> q.getQualityIntegers(fullValueMap.keySet().stream().mapToLong(Date::getTime).toArray())).map(q -> q.subMap(new Date(newStartTime), true, new Date(newEndTime), true)).map(SortedMap::values).map(q -> q.stream().mapToInt(i -> i).toArray()).map(Quality::new).orElse(null);
        long dataStart = newStartTime;
        long dataEnd = newEndTime;
        if (!subValueMap.isEmpty()) {
            dataStart = ((Date)subValueMap.firstKey()).getTime();
            dataEnd = ((Date)subValueMap.lastKey()).getTime();
        }
        try {
            this.set(newTimes, newValues, newQuality, dataStart, dataEnd);
        }
        catch (DataSetIllegalArgumentException | DataSetTimeSeriesIllegalArgumentException | IntervalOffsetMismatchException e) {
            throw new DataSetTimeSeriesDeriveException((Exception)e);
        }
    }

    @Override
    public final boolean isEmpty() {
        return this._values.length == 0;
    }
}

