/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import mil.army.usace.hec.data.timeseries.BinaryTimeSeries;
import mil.army.usace.hec.data.timeseries.BinaryTimeSeriesRow;
import mil.army.usace.hec.data.timeseries.TextTimeSeries;
import mil.army.usace.hec.data.timeseries.TextTimeSeriesRow;
import mil.army.usace.hec.data.timeseries.TimeValueSeries;

public final class AnnotatedTimeValueSeries<T extends TimeValueSeries> {
    private final TextTimeSeries _textTimeSeries;
    private final BinaryTimeSeries _binaryTimeSeries;
    private final T _timeValueSeries;

    AnnotatedTimeValueSeries(T timeValueSeries, BinaryTimeSeries binaryTimeSeries, TextTimeSeries textTimeSeries) {
        this._timeValueSeries = (TimeValueSeries)Objects.requireNonNull(timeValueSeries, "Cannot annotate a null time series");
        this._binaryTimeSeries = binaryTimeSeries;
        this._textTimeSeries = textTimeSeries;
    }

    public T getTimeSeries() {
        return this._timeValueSeries;
    }

    public Optional<BinaryTimeSeries> getBinaryAnnotations() {
        return Optional.ofNullable(this._binaryTimeSeries);
    }

    public Optional<byte[]> getBinaryAnnotationValue(Instant instant) {
        return this.getBinaryAnnotations().map(BinaryTimeSeries::getData).flatMap(m -> Optional.ofNullable((BinaryTimeSeriesRow)m.get(instant))).map(BinaryTimeSeriesRow::getValue);
    }

    public Optional<BinaryTimeSeriesRow> getBinaryAnnotation(Instant instant) {
        return this.getBinaryAnnotations().map(BinaryTimeSeries::getData).flatMap(m -> Optional.ofNullable((BinaryTimeSeriesRow)m.get(instant)));
    }

    public Optional<TextTimeSeries> getTextAnnotations() {
        return Optional.ofNullable(this._textTimeSeries);
    }

    public Optional<String> getTextAnnotationValue(Instant instant) {
        return this.getTextAnnotations().map(TextTimeSeries::getData).flatMap(m -> Optional.ofNullable((TextTimeSeriesRow)m.get(instant))).map(TextTimeSeriesRow::getValue);
    }

    public Optional<TextTimeSeriesRow> getTextAnnotation(Instant instant) {
        return this.getTextAnnotations().map(TextTimeSeries::getData).flatMap(m -> Optional.ofNullable((TextTimeSeriesRow)m.get(instant)));
    }
}

