/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries;

import java.time.Instant;
import java.util.Collection;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import mil.army.usace.hec.data.timeseries.BinaryTimeSeries;
import mil.army.usace.hec.data.timeseries.BinaryTimeSeriesImpl;
import mil.army.usace.hec.data.timeseries.BinaryTimeSeriesRow;
import mil.army.usace.hec.data.timeseries.VersionDate;
import mil.army.usace.hec.metadata.DataSetException;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesException;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;

public final class BinaryTimeSeriesBuilder {
    private final TimeSeriesIdentifier _timeSeriesIdentifier;
    private final NavigableMap<Instant, BinaryTimeSeriesRow> _rows = new TreeMap<Instant, BinaryTimeSeriesRow>();
    private VersionDate _versionDate;

    public BinaryTimeSeriesBuilder(TimeSeriesIdentifier timeSeriesIdentifier) {
        this._timeSeriesIdentifier = Objects.requireNonNull(timeSeriesIdentifier, "Cannot build a binary time series without an identifier");
    }

    public BinaryTimeSeriesBuilder withRows(Collection<BinaryTimeSeriesRow> rows) {
        rows.forEach(r -> this._rows.put(r.getTime(), (BinaryTimeSeriesRow)r));
        return this;
    }

    public BinaryTimeSeriesBuilder withRow(BinaryTimeSeriesRow row) {
        this._rows.put(row.getTime(), row);
        return this;
    }

    public BinaryTimeSeriesBuilder withVersionDate(VersionDate versionDate) {
        this._versionDate = versionDate;
        return this;
    }

    public BinaryTimeSeries build() throws DataSetException {
        this.validateRowIntervals();
        return new BinaryTimeSeriesImpl(this._timeSeriesIdentifier, this._rows, this._versionDate);
    }

    private void validateRowIntervals() throws DataSetIllegalArgumentException, DataSetTimeSeriesException {
        Optional<BinaryTimeSeriesRow> invalidRow;
        if (this._rows.isEmpty()) {
            return;
        }
        if (!this._timeSeriesIdentifier.getIntervalOffset().isNoOffset() && !this._timeSeriesIdentifier.getIntervalOffset().isDefined()) {
            Instant time = (Instant)this._rows.firstKey();
            this._timeSeriesIdentifier.updateUndefinedIntervalOffsetWithStartTime(time);
        }
        if ((invalidRow = this._rows.values().stream().filter(r -> !this._timeSeriesIdentifier.isOnInterval(r.getTime())).findFirst()).isPresent()) {
            throw new DataSetTimeSeriesException(String.format("Binary time series rows do not correspond to the time series identifier interval and offset: %s %nrow: %s", this._timeSeriesIdentifier, invalidRow.get()));
        }
    }
}

