/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries;

import java.time.Instant;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import mil.army.usace.hec.data.timeseries.BinaryTimeSeries;
import mil.army.usace.hec.data.timeseries.BinaryTimeSeriesRow;
import mil.army.usace.hec.data.timeseries.VersionDate;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;

final class BinaryTimeSeriesImpl
implements BinaryTimeSeries {
    private final TimeSeriesIdentifier _timeSeriesIdentifier;
    private final NavigableMap<Instant, BinaryTimeSeriesRow> _data;
    private VersionDate _versionDate;

    BinaryTimeSeriesImpl(TimeSeriesIdentifier timeSeriesIdentifier, NavigableMap<Instant, BinaryTimeSeriesRow> data, VersionDate versionDate) {
        this._timeSeriesIdentifier = timeSeriesIdentifier;
        this._data = data;
        this._versionDate = versionDate;
    }

    @Override
    public TimeSeriesIdentifier getTimeSeriesIdentifier() {
        return this._timeSeriesIdentifier;
    }

    @Override
    public NavigableMap<Instant, BinaryTimeSeriesRow> getData() {
        return new TreeMap<Instant, BinaryTimeSeriesRow>((SortedMap<Instant, BinaryTimeSeriesRow>)this._data);
    }

    @Override
    public Optional<VersionDate> getVersionDate() {
        return Optional.ofNullable(this._versionDate);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryTimeSeriesImpl that = (BinaryTimeSeriesImpl)o;
        return Objects.equals(this._timeSeriesIdentifier, that._timeSeriesIdentifier) && Objects.equals(this._data, that._data);
    }

    public int hashCode() {
        return Objects.hash(this._timeSeriesIdentifier, this._data);
    }
}

