/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries;

import java.time.Instant;
import mil.army.usace.hec.data.timeseries.BinaryTimeSeriesRow;
import mil.army.usace.hec.data.timeseries.BinaryTimeSeriesRowImpl;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.web.MediaType;

public final class BinaryTimeSeriesRowBuilder {
    private Instant _valueDate;
    private Instant _dataEntryDate;
    private MediaType _mediaType;
    private byte[] _value;
    private String _fileName;
    private int _quality;

    public BinaryTimeSeriesRowBuilder withValueDate(Instant valueDate) {
        this._valueDate = valueDate;
        return this;
    }

    public BinaryTimeSeriesRowBuilder withDataEntryDate(Instant dataEntryDate) {
        this._dataEntryDate = dataEntryDate;
        return this;
    }

    public BinaryTimeSeriesRowBuilder withMediaType(MediaType mediaType) {
        this._mediaType = mediaType;
        return this;
    }

    public BinaryTimeSeriesRowBuilder withValue(byte[] value) {
        this._value = value;
        return this;
    }

    public BinaryTimeSeriesRowBuilder withFileName(String fileName) {
        this._fileName = fileName;
        return this;
    }

    public BinaryTimeSeriesRowBuilder withQuality(int quality) {
        this._quality = quality;
        return this;
    }

    public BinaryTimeSeriesRow build() throws DataSetIllegalArgumentException {
        if (this._value == null) {
            throw new DataSetIllegalArgumentException("Binary time series row value cannot be null. Use an empty array");
        }
        if (this._mediaType == null) {
            throw new DataSetIllegalArgumentException("Binary time series row media type cannot be null.");
        }
        if (this._valueDate == null) {
            throw new DataSetIllegalArgumentException("Binary time series row value date cannot be null.");
        }
        if (this._fileName == null) {
            throw new DataSetIllegalArgumentException("Binary time series row value filename cannot be null.");
        }
        return new BinaryTimeSeriesRowImpl(this._valueDate, this._dataEntryDate, this._mediaType, this._value, this._quality, this._fileName);
    }
}

