/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries;

import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import mil.army.usace.hec.data.timeseries.BinaryTimeSeriesRow;
import mil.army.usace.hec.metadata.web.MediaType;

final class BinaryTimeSeriesRowImpl
implements BinaryTimeSeriesRow {
    private final Instant _valueDate;
    private final Instant _dataEntryDate;
    private final MediaType _mediaType;
    private final byte[] _value;
    private final int _quality;
    private final String _fileName;

    BinaryTimeSeriesRowImpl(Instant valueDate, Instant dataEntryDate, MediaType mediaType, byte[] value, int quality, String fileName) {
        this._valueDate = valueDate;
        this._dataEntryDate = dataEntryDate;
        this._mediaType = mediaType;
        this._value = value;
        this._quality = quality;
        this._fileName = fileName;
    }

    @Override
    public Instant getTime() {
        return this._valueDate;
    }

    @Override
    public Optional<Instant> getDataEntryDate() {
        return Optional.ofNullable(this._dataEntryDate);
    }

    @Override
    public MediaType getMediaType() {
        return this._mediaType;
    }

    @Override
    public byte[] getValue() {
        return Arrays.copyOf(this._value, this._value.length);
    }

    @Override
    public int getQuality() {
        return this._quality;
    }

    @Override
    public String getFileName() {
        return this._fileName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryTimeSeriesRowImpl that = (BinaryTimeSeriesRowImpl)o;
        return Objects.equals(this._valueDate, that._valueDate) && Objects.equals(this._dataEntryDate, that._dataEntryDate) && Objects.equals(this._mediaType, that._mediaType) && Arrays.equals(this._value, that._value) && this._quality == that._quality && Objects.equals(this._fileName, that._fileName);
    }

    public int hashCode() {
        int result = Objects.hash(this._valueDate, this._dataEntryDate, this._mediaType, this._quality, this._fileName);
        result = 31 * result + Arrays.hashCode(this._value);
        return result;
    }

    public String toString() {
        return "BinaryTimeSeriesRowImpl{_valueDate=" + this._valueDate + ", _dataEntryDate=" + this._dataEntryDate + ", _mediaType=" + this._mediaType + ", _value=" + Arrays.toString(this._value) + ", _quality=" + this._quality + ", _fileName='" + this._fileName + "'}";
    }
}

