/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries;

import mil.army.usace.hec.data.timeseries.AbstractIrregularTimeSeries;
import mil.army.usace.hec.data.timeseries.TimeSeries;
import mil.army.usace.hec.data.timeseries.TimeSeriesBuilder;
import mil.army.usace.hec.metadata.DataSetException;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.Units;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesException;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesIllegalArgumentException;
import mil.army.usace.hec.metadata.timeseries.IntervalOffsetMismatchException;
import mil.army.usace.hec.metadata.timeseries.IrregularTimeSeriesIdentifier;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;
import rma.services.annotations.ServiceProvider;

final class IrregularTimeSeries
extends AbstractIrregularTimeSeries {
    private static final long serialVersionUID = 579085330396213325L;

    private IrregularTimeSeries(TimeSeriesBuilder builder) throws DataSetIllegalArgumentException, IntervalOffsetMismatchException, DataSetTimeSeriesException {
        super(builder);
    }

    @Override
    void validateIdentifier(TimeSeriesIdentifier descriptionTx) throws DataSetTimeSeriesIllegalArgumentException {
        if (!(descriptionTx instanceof IrregularTimeSeriesIdentifier)) {
            throw new DataSetTimeSeriesIllegalArgumentException("Regular time series must be defined with a regular identifier");
        }
    }

    private static final class IrregularTimeSeriesBuilder
    extends TimeSeriesBuilder {
        public IrregularTimeSeriesBuilder(TimeSeriesIdentifier timeSeriesIdentifier, Units units) {
            super(timeSeriesIdentifier, units);
        }

        @Override
        public TimeSeries build() throws DataSetException {
            IrregularTimeSeries timeSeries = new IrregularTimeSeries(this);
            return this.wrapVerticalDatum(timeSeries);
        }
    }

    @ServiceProvider(service=TimeSeriesBuilder.TimeSeriesBuilderCreator.class, path="hec/metadata/timeseries/irregular")
    public static final class Creator
    implements TimeSeriesBuilder.TimeSeriesBuilderCreator {
        @Override
        public TimeSeriesBuilder create(TimeSeriesIdentifier timeSeriesIdentifier, Units units) {
            return new IrregularTimeSeriesBuilder(timeSeriesIdentifier, units);
        }
    }
}

