/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.LongStream;
import mil.army.usace.hec.data.timeseries.AbstractRegularTimeSeries;
import mil.army.usace.hec.data.timeseries.TimeSeries;
import mil.army.usace.hec.data.timeseries.TimeSeriesBuilder;
import mil.army.usace.hec.metadata.DataSetException;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.Interval;
import mil.army.usace.hec.metadata.Units;
import mil.army.usace.hec.metadata.constants.NumericalConstants;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesException;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesIllegalArgumentException;
import mil.army.usace.hec.metadata.timeseries.IntervalOffsetMismatchException;
import mil.army.usace.hec.metadata.timeseries.LocalRegularTimeSeriesIdentifier;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;
import rma.services.annotations.ServiceProvider;

final class LocalRegularTimeSeries
extends AbstractRegularTimeSeries {
    private static final long serialVersionUID = -2433409267445035932L;
    private static final ForkJoinPool PARALLEL_STREAM_POOL = new ForkJoinPool(Integer.getInteger("hec.timeseries.interval.threadcount", ForkJoinPool.commonPool().getParallelism()));

    private LocalRegularTimeSeries(TimeSeriesBuilder localRegularTimeSeriesBuilder) throws DataSetTimeSeriesException, DataSetIllegalArgumentException, IntervalOffsetMismatchException {
        super(localRegularTimeSeriesBuilder);
    }

    @Override
    void validateIdentifier(TimeSeriesIdentifier descriptionTx) throws DataSetTimeSeriesIllegalArgumentException {
        if (!(descriptionTx instanceof LocalRegularTimeSeriesIdentifier)) {
            throw new DataSetTimeSeriesIllegalArgumentException("Local regular time series must be defined with a local regular identifier");
        }
    }

    @Override
    long[] getTimes(long startValuesTime, int numberOfValues, Interval interval) {
        try {
            return (long[])((ForkJoinTask)PARALLEL_STREAM_POOL.submit(() -> this.getTimesParallel(startValuesTime, numberOfValues))).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new long[0];
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Error in generation of times array using interval calculations", e);
        }
    }

    private long[] getTimesParallel(long startValuesTime, int numberOfValues) {
        TimeSeriesIdentifier timeSeriesIdentifier = this.getTimeSeriesIdentifier();
        ZoneId zoneId = timeSeriesIdentifier.getIntervalZoneId().orElse(NumericalConstants.UTC_ZONEID);
        ZonedDateTime start = ZonedDateTime.ofInstant(Instant.ofEpochMilli(startValuesTime), zoneId);
        return LongStream.range(0L, numberOfValues).parallel().mapToObj(i -> this.startPlusIntervals(i, start)).map(ChronoZonedDateTime::toInstant).mapToLong(Instant::toEpochMilli).sorted().toArray();
    }

    private ZonedDateTime startPlusIntervals(long i, ZonedDateTime start) {
        Interval interval = this.getTimeSeriesIdentifier().getInterval();
        try {
            return interval.getNextIntervalTime(start.toInstant(), i, start.getZone()).atZone(start.getZone());
        }
        catch (DataSetIllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
    }

    private static final class LocalRegularTimeSeriesBuilder
    extends TimeSeriesBuilder {
        public LocalRegularTimeSeriesBuilder(TimeSeriesIdentifier timeSeriesIdentifier, Units units) {
            super(timeSeriesIdentifier, units);
        }

        @Override
        public TimeSeries build() throws DataSetException {
            LocalRegularTimeSeries timeSeries = new LocalRegularTimeSeries(this);
            return this.wrapVerticalDatum(timeSeries);
        }
    }

    @ServiceProvider(service=TimeSeriesBuilder.TimeSeriesBuilderCreator.class, path="hec/metadata/timeseries/localregular")
    public static final class Creator
    implements TimeSeriesBuilder.TimeSeriesBuilderCreator {
        @Override
        public TimeSeriesBuilder create(TimeSeriesIdentifier timeSeriesIdentifier, Units units) {
            return new LocalRegularTimeSeriesBuilder(timeSeriesIdentifier, units);
        }
    }
}

