/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries;

import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.IntFunction;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import mil.army.usace.hec.data.timeseries.QualityStringRenderer;

public class Quality
implements Serializable {
    static final long serialVersionUID = 5287976742565108510L;
    public static final String QUALITY_FLAGS_EDITABLE = "quality_flags_editable";
    public static final String SHOW_QUALITY_FLAGS = "show_quality_flags";
    private static final int ELEMENT_SIZE_IN_BYTES = 4;
    public static final byte NULL_VALUE = 0;
    private static final int SCREENED_BIT = 1;
    private static final int OKAY_BIT = 2;
    private static final int MISSING_BIT = 3;
    private static final int QUESTION_BIT = 4;
    private static final int REJECT_BIT = 5;
    private static final int RANGE_OF_VALUE_BIT0 = 6;
    private static final int RANGE_OF_VALUE_BIT1 = 7;
    private static final int VALUE_DIFFERS_BIT = 8;
    private static final int HOW_REVISED_BIT0 = 9;
    private static final int HOW_REVISED_BIT1 = 10;
    private static final int HOW_REVISED_BIT2 = 11;
    private static final int REPLACE_METHOD_BIT0 = 12;
    private static final int REPLACE_METHOD_BIT1 = 13;
    private static final int REPLACE_METHOD_BIT2 = 14;
    private static final int REPLACE_METHOD_BIT3 = 15;
    private static final int ABSOLUTEMAGNITUDE_BIT = 16;
    private static final int CONSTANTVALUE_BIT = 17;
    private static final int RATEOFCHANGE_BIT = 18;
    private static final int RELATIVEMAGNITUDE_BIT = 19;
    private static final int DURATIONMAGNITUDE_BIT = 20;
    private static final int NEGATIVEINCREMENTAL_BIT = 21;
    private static final int NOT_DEFINED_BIT0 = 22;
    private static final int GAGELIST_BIT = 23;
    private static final int NOT_DEFINED_BIT1 = 24;
    private static final int USER_DEFINED_TEST_BIT = 25;
    private static final int DISTRIBUTIONTEST_BIT = 26;
    private static final int RESERVED_BIT0 = 27;
    private static final int RESERVED_BIT1 = 28;
    private static final int RESERVED_BIT2 = 29;
    private static final int RESERVED_BIT3 = 30;
    private static final int RESERVED_BIT4 = 31;
    private static final int PROTECTED_BIT = 32;
    private static final int[] MASK = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    static final int MASK_BYTE = 255;
    private static final int USED_BITS_MASK = -2090860545;
    private static final int SCREENED_VALUE = 1;
    private static final int OK_VALUE = 2;
    private static final int OK_MASK = -29;
    private static final int MISSING_VALUE = 4;
    private static final int MISSING_MASK = -27;
    private static final int QUESTIONED_VALUE = 8;
    private static final int QUESTIONED_MASK = -23;
    private static final int REJECTED_VALUE = 16;
    private static final int REJECTED_MASK = -15;
    private static final int DIFFERENT_MASK = 128;
    private static final int NOT_DIFFERENT_MASK = -129;
    private static final int REPL_CAUSE_MASK = 1792;
    private static final int NO_REPL_CAUSE_MASK = -1793;
    private static final int REPL_METHOD_MASK = 30720;
    private static final int NO_REPL_METHOD_MASK = -30721;
    private static final int REPL_CAUSE_SHIFT = 8;
    private static final int REPL_METHOD_SHIFT = 11;
    private byte[] _elementData;
    private byte[] _elementDataCompressed = null;
    private final int _size;
    private final int _sizeInBytes;
    private boolean _isCompressed = false;
    static String[] PADDING = new String[]{"", "0", "00", "000", "0000", "00000", "000000", "0000000", "00000000", "000000000", "0000000000", "00000000000", "000000000000", "0000000000000", "00000000000000", "000000000000000", "0000000000000000", "00000000000000000", "000000000000000000", "0000000000000000000", "00000000000000000000", "000000000000000000000", "0000000000000000000000", "00000000000000000000000", "000000000000000000000000", "0000000000000000000000000", "00000000000000000000000000", "000000000000000000000000000", "0000000000000000000000000000", "00000000000000000000000000000", "000000000000000000000000000000", "0000000000000000000000000000000", "00000000000000000000000000000000"};

    public Quality(int size) {
        this._size = size;
        this._sizeInBytes = size * 4;
        this._elementData = new byte[this._sizeInBytes];
        for (int ii = 0; ii < this._sizeInBytes; ++ii) {
            this._elementData[ii] = 0;
        }
    }

    public Quality(byte[] elementData) {
        this._size = elementData.length / 4;
        this._sizeInBytes = this._size * 4;
        this._elementData = new byte[this._sizeInBytes];
        System.arraycopy(elementData, 0, this._elementData, 0, this._sizeInBytes);
        for (int i = 0; i < this._size; ++i) {
            this.setElementAt(this.getElementAt(i), i);
        }
    }

    public Quality(Quality quality) {
        this._size = quality._size;
        this._sizeInBytes = quality._sizeInBytes;
        this._elementData = new byte[this._sizeInBytes];
        System.arraycopy(quality._elementData, 0, this._elementData, 0, this._sizeInBytes);
        for (int i = 0; i < this._size; ++i) {
            this.setElementAt(this.getElementAt(i), i);
        }
    }

    public Quality(int[] intQuality) {
        this._size = intQuality.length;
        this._sizeInBytes = this._size * 4;
        this._elementData = new byte[this._sizeInBytes];
        for (int ii = 0; ii < this._size; ++ii) {
            this.setIntegerAt(intQuality[ii], ii);
        }
    }

    public static int cleanQualityInteger(int qualityInt) {
        int tmp = qualityInt;
        if ((tmp & 1) == 0) {
            tmp = 0;
        } else {
            boolean different;
            int repl_method;
            if (((tmp &= 0x835FFFFF) & 4) != 0) {
                tmp &= 0xFFFFFFE5;
            } else if ((tmp & 0x10) != 0) {
                tmp &= 0xFFFFFFF1;
            } else if ((tmp & 8) != 0) {
                tmp &= 0xFFFFFFE9;
            } else if ((tmp & 2) != 0) {
                tmp &= 0xFFFFFFE3;
            }
            int repl_cause = (tmp & 0x700) >>> 8;
            if (repl_cause > 4) {
                repl_cause = 4;
                tmp |= repl_cause << 8;
            }
            if ((repl_method = (tmp & 0x7800) >>> 11) > 4) {
                repl_method = 4;
                tmp |= repl_method << 11;
            }
            boolean bl = different = (tmp & 0x80) != 0;
            if (repl_cause == 0) {
                if (repl_method == 0 && different) {
                    tmp &= 0xFFFFFF7F;
                    different = false;
                } else if (repl_method != 0 && !different) {
                    tmp &= 0xFFFF87FF;
                    repl_method = 0;
                }
            } else if (repl_method == 0 && !different) {
                tmp &= 0xFFFFF8FF;
                repl_cause = 0;
            }
            if (repl_cause != 0) {
                if (repl_method != 0 && !different) {
                    tmp |= 0x80;
                    different = true;
                } else if (different && repl_method == 0) {
                    repl_method = 2;
                    tmp |= repl_method << 11;
                }
            } else if (different && repl_method != 0) {
                repl_cause = 3;
                tmp &= repl_cause << 8;
            }
        }
        return tmp;
    }

    public static void compressQuality(Quality tmp) {
        if (tmp._isCompressed) {
            return;
        }
        if (tmp._size < 10) {
            return;
        }
        byte[] tmpComp = new byte[tmp._elementData.length];
        Deflater deflater = new Deflater();
        deflater.setInput(tmp._elementData);
        deflater.finish();
        deflater.deflate(tmpComp);
        int num = deflater.getTotalOut();
        int numIn = deflater.getTotalIn();
        tmp._elementDataCompressed = new byte[num];
        System.arraycopy(tmpComp, 0, tmp._elementDataCompressed, 0, num);
        tmp._elementData = null;
        tmp._isCompressed = true;
    }

    public static void uncompressQuality(Quality tmp) throws DataFormatException {
        if (tmp._isCompressed) {
            tmp._elementData = new byte[tmp._size * 4];
            Inflater inflater = new Inflater();
            inflater.setInput(tmp._elementDataCompressed);
            int numSoFar = inflater.inflate(tmp._elementData);
            int num = inflater.getTotalOut();
            tmp._elementDataCompressed = null;
            tmp._isCompressed = false;
        }
    }

    public static int emptyQualityValue() {
        return 0;
    }

    public static byte[] emptyBytes() {
        return new byte[]{0, 0, 0, 0};
    }

    public byte[] getQuality() {
        return this._elementData;
    }

    public int getSize() {
        return this._size;
    }

    public int getSizeInBytes() {
        return this._sizeInBytes;
    }

    public boolean hasQuality() {
        return this._size > 0;
    }

    public byte[] getElementAt(int elementIndex) {
        if (elementIndex > this._size || elementIndex < 0) {
            throw new ArrayIndexOutOfBoundsException("Index of: " + elementIndex + " Out of range[0 - " + this._size);
        }
        int byteIndex = elementIndex * 4;
        byte[] bytes = new byte[4];
        System.arraycopy(this._elementData, byteIndex, bytes, 0, 4);
        return bytes;
    }

    public int getIntegerAt(int elementIndex) {
        byte[] bytes = this.getElementAt(elementIndex);
        int i0 = bytes[0] & 0xFF;
        int i1 = bytes[1] & 0xFF;
        int i2 = bytes[2] & 0xFF;
        int i3 = bytes[3] & 0xFF;
        int result = i3 | i2 << 8 | i1 << 16 | i0 << 24;
        return result;
    }

    public static int getInteger(byte[] bytes) {
        int i0 = bytes[0] & 0xFF;
        int i1 = bytes[1] & 0xFF;
        int i2 = bytes[2] & 0xFF;
        int i3 = bytes[3] & 0xFF;
        int result = i3 | i2 << 8 | i1 << 16 | i0 << 24;
        return result;
    }

    public void setIntegerAt(int intQuality, int elementIndex) {
        byte[] bytes = new byte[4];
        bytes[3] = (byte)(intQuality & 0xFF);
        bytes[2] = (byte)(intQuality >> 8 & 0xFF);
        bytes[1] = (byte)(intQuality >> 16 & 0xFF);
        bytes[0] = (byte)(intQuality >> 24 & 0xFF);
        this.setElementAt(bytes, elementIndex);
    }

    public static byte[] getBytes(int intQuality) {
        byte[] bytes = new byte[4];
        Quality.getBytes(intQuality, bytes);
        return bytes;
    }

    public static void getBytes(int intQuality, byte[] bytes) {
        if (bytes == null || bytes.length != 4) {
            throw new RuntimeException("<ERROR> QualityTx.getBytes(int,byte[]) : Byte array must be of size 4 before passed to this method");
        }
        bytes[3] = (byte)(intQuality & 0xFF);
        bytes[2] = (byte)(intQuality >> 8 & 0xFF);
        bytes[1] = (byte)(intQuality >> 16 & 0xFF);
        bytes[0] = (byte)(intQuality >> 24 & 0xFF);
    }

    public void setElementAt(byte[] bytes, int elementIndex) {
        if (elementIndex > this._size || elementIndex < 0) {
            throw new ArrayIndexOutOfBoundsException("Index of: " + elementIndex + " Out of range[0 - " + this._size);
        }
        int qualityInt = (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
        int cleanedInt = Quality.cleanQualityInteger(qualityInt);
        byte[] cleanedBytes = new byte[]{(byte)(cleanedInt >>> 24 & 0xFF), (byte)(cleanedInt >>> 16 & 0xFF), (byte)(cleanedInt >>> 8 & 0xFF), (byte)(cleanedInt & 0xFF)};
        int byteIndex = elementIndex * 4;
        for (int i = 0; i < 4; ++i) {
            this._elementData[byteIndex + i] = cleanedBytes[i];
        }
    }

    public static boolean isAccepted(byte[] bytes) {
        return Quality.isBitSet(bytes, 1) && Quality.isBitSet(bytes, 2) && Quality.isBitClear(bytes, 3) && Quality.isBitClear(bytes, 4) && Quality.isBitClear(bytes, 5) && Quality.isBitClear(bytes, 9) && Quality.isBitClear(bytes, 10) && Quality.isBitSet(bytes, 11) && Quality.isBitClear(bytes, 12) && Quality.isBitClear(bytes, 13) && Quality.isBitClear(bytes, 14) && Quality.isBitClear(bytes, 15);
    }

    public static boolean isAccepted_int(int intQuality) {
        return Quality.isBitSet_int(intQuality, 1) && Quality.isBitSet_int(intQuality, 2) && Quality.isBitClear_int(intQuality, 3) && Quality.isBitClear_int(intQuality, 4) && Quality.isBitClear_int(intQuality, 5) && Quality.isBitClear_int(intQuality, 9) && Quality.isBitClear_int(intQuality, 10) && Quality.isBitSet_int(intQuality, 11) && Quality.isBitClear_int(intQuality, 12) && Quality.isBitClear_int(intQuality, 13) && Quality.isBitClear_int(intQuality, 14) && Quality.isBitClear_int(intQuality, 15);
    }

    public static boolean isInterpolated(byte[] bytes) {
        return Quality.isBitSet(bytes, 12) && Quality.isBitClear(bytes, 13) && Quality.isBitClear(bytes, 14) && Quality.isBitClear(bytes, 15);
    }

    public static boolean isInterpolated_int(int intQuality) {
        return Quality.isBitSet_int(intQuality, 12) && Quality.isBitClear_int(intQuality, 13) && Quality.isBitClear_int(intQuality, 14) && Quality.isBitClear_int(intQuality, 15);
    }

    public static boolean isKeyboardInput(byte[] bytes) {
        return Quality.isBitClear(bytes, 12) && Quality.isBitSet(bytes, 13) && Quality.isBitClear(bytes, 14) && Quality.isBitClear(bytes, 15);
    }

    public static boolean isKeyboardInput_int(int intQuality) {
        return Quality.isBitClear_int(intQuality, 12) && Quality.isBitSet_int(intQuality, 13) && Quality.isBitClear_int(intQuality, 14) && Quality.isBitClear_int(intQuality, 15);
    }

    public static boolean isGraphicalEstimate(byte[] bytes) {
        return Quality.isBitClear(bytes, 12) && Quality.isBitClear(bytes, 13) && Quality.isBitSet(bytes, 14) && Quality.isBitClear(bytes, 15);
    }

    public static boolean isGraphicalEstimate_int(int intQuality) {
        return Quality.isBitClear_int(intQuality, 12) && Quality.isBitClear_int(intQuality, 13) && Quality.isBitSet_int(intQuality, 14) && Quality.isBitClear_int(intQuality, 15);
    }

    public boolean isMissing(int elementIndex) {
        return this.isBitSet(elementIndex, 3);
    }

    public boolean isNotMissing(int elementIndex) {
        return this.isBitClear(elementIndex, 3);
    }

    public void clearMissing(int elementIndex) {
        this.clearBit(elementIndex, 3);
        this.setBit(elementIndex, 1);
    }

    public void setMissing(int elementIndex) {
        this.setBit(elementIndex, 3);
        this.clearBit(elementIndex, 2);
        this.clearBit(elementIndex, 4);
        this.clearBit(elementIndex, 5);
        this.setBit(elementIndex, 1);
    }

    public static boolean isMissing(byte[] bytes) {
        return Quality.isBitSet(bytes, 3);
    }

    public static boolean isMissing_int(int intQuality) {
        return Quality.isBitSet_int(intQuality, 1) && Quality.isBitSet_int(intQuality, 3);
    }

    public static boolean isNotMissing(byte[] bytes) {
        return !Quality.isMissing(bytes);
    }

    public static boolean isNotMissing_int(int intQuality) {
        return !Quality.isMissing_int(intQuality);
    }

    public static byte[] clearMissing(byte[] bytes) {
        byte[] tmp = Quality.clearBit(bytes, 3);
        return Quality.setBit(tmp, 1);
    }

    public static int clearMissing_int(int intQuality) {
        return Quality.setBit_int(Quality.clearBit_int(intQuality, 3), 1);
    }

    public static byte[] setMissing(byte[] bytes) {
        byte[] tmp = Quality.setBit(bytes, 3);
        tmp = Quality.clearBit(tmp, 2);
        tmp = Quality.clearBit(tmp, 4);
        tmp = Quality.clearBit(tmp, 5);
        return Quality.setBit(tmp, 1);
    }

    public static int setMissing_int(int intQuality) {
        int tmp = Quality.setBit_int(intQuality, 3);
        tmp = Quality.clearBit_int(tmp, 2);
        tmp = Quality.clearBit_int(tmp, 4);
        tmp = Quality.clearBit_int(tmp, 5);
        return Quality.setBit_int(tmp, 1);
    }

    public boolean isProtected(int elementIndex) {
        return this.isScreened(elementIndex) && this.isBitSet(elementIndex, 32);
    }

    public boolean isNotProtected(int elementIndex) {
        return !this.isProtected(elementIndex);
    }

    public void clearProtected(int elementIndex) {
        this.clearBit(elementIndex, 32);
        this.setBit(elementIndex, 1);
    }

    public void setProtected(int elementIndex) {
        this.setBit(elementIndex, 32);
        this.setBit(elementIndex, 1);
    }

    public static boolean isProtected(byte[] bytes) {
        return Quality.isBitSet(bytes, 32);
    }

    public static boolean isProtected_int(int intQuality) {
        return Quality.isBitSet_int(intQuality, 32);
    }

    public static boolean isNotProtected(byte[] bytes) {
        return !Quality.isProtected(bytes);
    }

    public static boolean isNotProtected_int(int intQuality) {
        return !Quality.isProtected_int(intQuality);
    }

    public static byte[] clearProtected(byte[] bytes) {
        byte[] tmp = Quality.clearBit(bytes, 32);
        return Quality.setBit(tmp, 1);
    }

    public static int clearProtected_int(int intQuality) {
        return Quality.setBit_int(Quality.clearBit_int(intQuality, 32), 1);
    }

    public static byte[] setProtected(byte[] bytes) {
        return Quality.setBit(Quality.setBit(bytes, 32), 1);
    }

    public static int setProtected_int(int intQuality) {
        return Quality.setBit_int(Quality.setBit_int(intQuality, 32), 1);
    }

    public static boolean isBitSet(byte[] bytes, int bitPosition) {
        int targetByte = (32 - bitPosition) / 8;
        byte base = bytes[targetByte];
        int targetBit = (bitPosition - 1) % 8;
        int result = base & MASK[targetBit];
        return result != 0;
    }

    public static boolean isBitClear(byte[] bytes, int bitPosition) {
        return !Quality.isBitSet(bytes, bitPosition);
    }

    public static boolean isQualityClear(byte[] bytes) {
        return Quality.getInteger(bytes) == 0;
    }

    public static boolean isQualityClear_int(int intQuality) {
        return intQuality == 0;
    }

    public static boolean isBitSet_int(int intQuality, int bitPosition) {
        return (intQuality & 1 << bitPosition - 1) != 0;
    }

    public static boolean isBitClear_int(int intQuality, int bitPosition) {
        return (intQuality & 1 << bitPosition - 1) == 0;
    }

    public static int setBit_int(int intQuality, int bitPosition) {
        return intQuality | 1 << bitPosition - 1;
    }

    public static int clearBit_int(int intQuality, int bitPosition) {
        return intQuality & ~(1 << bitPosition - 1);
    }

    public boolean isBitSet(int elementIndex, int bitPosition) {
        if (elementIndex > this._size || elementIndex < 0) {
            throw new ArrayIndexOutOfBoundsException("Index of: " + elementIndex + " Out of range[0 - " + this._size + "]");
        }
        byte[] bytes = this.getElementAt(elementIndex);
        return Quality.isBitSet(bytes, bitPosition);
    }

    public boolean isBitClear(int elementIndex, int bitPosition) {
        return !this.isBitSet(elementIndex, bitPosition);
    }

    public boolean isQualityClear(int elementIndex) {
        return this.getIntegerAt(elementIndex) == 0;
    }

    public void setBit(int elementIndex, int bitPosition) {
        if (elementIndex > this._size || elementIndex < 0) {
            throw new ArrayIndexOutOfBoundsException("Index of: " + elementIndex + " Out of range[0 - " + this._size);
        }
        byte[] bytes = this.getElementAt(elementIndex);
        bytes = Quality.setBit(bytes, bitPosition);
        this.setElementAt(bytes, elementIndex);
    }

    public static byte[] setBit(byte[] bytes, int bitPosition) {
        int targetByte = (32 - bitPosition) / 8;
        byte base = bytes[targetByte];
        int targetBit = (bitPosition - 1) % 8;
        int result = base | MASK[targetBit];
        bytes[targetByte] = (byte)result;
        return bytes;
    }

    public void clearBit(int elementIndex, int bitPosition) {
        if (elementIndex > this._size || elementIndex < 0) {
            throw new ArrayIndexOutOfBoundsException("Index of: " + elementIndex + " Out of range[0 - " + this._size);
        }
        byte[] bytes = this.getElementAt(elementIndex);
        bytes = Quality.clearBit(bytes, bitPosition);
        this.setElementAt(bytes, elementIndex);
    }

    public static byte[] clearBit(byte[] bytes, int bitPosition) {
        int targetByte = (32 - bitPosition) / 8;
        byte base = bytes[targetByte];
        int targetBit = (bitPosition - 1) % 8;
        int result = base & MASK[targetBit];
        if (result != 0) {
            result = base ^ MASK[targetBit];
            bytes[targetByte] = (byte)result;
        }
        return bytes;
    }

    public boolean isScreened(int elementIndex) {
        return this.isBitSet(elementIndex, 1);
    }

    public boolean isNotScreened(int elementIndex) {
        return this.isBitClear(elementIndex, 1);
    }

    public void clearQuality(int elementIndex) {
        byte[] tmpBytes = this.getElementAt(elementIndex);
        int sizeInBytes = tmpBytes.length;
        if (sizeInBytes > 0) {
            byte tmpByte = 0;
            for (int i = 0; i < sizeInBytes; ++i) {
                tmpBytes[i] = tmpByte;
            }
            this.setElementAt(tmpBytes, elementIndex);
        }
    }

    public void clearScreened(int elementIndex) {
        this.clearBit(elementIndex, 1);
    }

    public void setScreened(int elementIndex) {
        this.setBit(elementIndex, 1);
    }

    public static boolean isScreened(byte[] bytes) {
        return Quality.isBitSet(bytes, 1);
    }

    public static boolean isScreened_int(int intQuality) {
        return Quality.isBitSet_int(intQuality, 1);
    }

    public static boolean isNotScreened(byte[] bytes) {
        return Quality.isBitClear(bytes, 1);
    }

    public static boolean isNotScreened_int(int intQuality) {
        return Quality.isBitClear_int(intQuality, 1);
    }

    public static byte[] clearQuality(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        int sizeInBytes = bytes.length;
        byte[] tmpBytes = new byte[sizeInBytes];
        if (sizeInBytes > 0) {
            byte tmpByte = 0;
            for (int i = 0; i < sizeInBytes; ++i) {
                tmpBytes[i] = tmpByte;
            }
        }
        return tmpBytes;
    }

    public static int clearQuality_int(int intQuality) {
        return 0;
    }

    public static int[] clearQuality_int(int[] qualityAsIntegers) {
        if (qualityAsIntegers == null) {
            return null;
        }
        for (int i = 0; i < qualityAsIntegers.length; ++i) {
            qualityAsIntegers[i] = 0;
        }
        return qualityAsIntegers;
    }

    public static byte[] clearScreened(byte[] bytes) {
        return Quality.clearBit(bytes, 1);
    }

    public static int clearScreened_int(int intQuality) {
        return Quality.clearBit_int(intQuality, 1);
    }

    public static byte[] setScreened(byte[] bytes) {
        return Quality.setBit(bytes, 1);
    }

    public static int setScreened_int(int intQuality) {
        return Quality.setBit_int(intQuality, 1);
    }

    public boolean isQuestion(int elementIndex) {
        return this.isScreened(elementIndex) && this.isBitSet(elementIndex, 4);
    }

    public boolean isNotQuestion(int elementIndex) {
        return !this.isQuestion(elementIndex);
    }

    public void clearQuestion(int elementIndex) {
        this.clearBit(elementIndex, 4);
        this.setBit(elementIndex, 1);
    }

    public void setQuestion(int elementIndex) {
        this.setBit(elementIndex, 4);
        this.clearBit(elementIndex, 2);
        this.clearBit(elementIndex, 5);
        this.clearBit(elementIndex, 3);
        this.setBit(elementIndex, 1);
    }

    public static boolean isQuestion(byte[] bytes) {
        return Quality.isScreened(bytes) && Quality.isBitSet(bytes, 4);
    }

    public static boolean isQuestion_int(int intQuality) {
        return Quality.isBitSet_int(intQuality, 1) && Quality.isBitSet_int(intQuality, 4);
    }

    public static boolean isNotQuestion(byte[] bytes) {
        return !Quality.isQuestion(bytes);
    }

    public static boolean isNotQuestion_int(int intQuality) {
        return !Quality.isQuestion_int(intQuality);
    }

    public static byte[] clearQuestion(byte[] bytes) {
        byte[] tmp = Quality.clearBit(bytes, 4);
        return Quality.setBit(tmp, 1);
    }

    public static int clearQuestion_int(int intQuality) {
        return Quality.setBit_int(Quality.clearBit_int(intQuality, 4), 1);
    }

    public static byte[] setQuestion(byte[] bytes) {
        byte[] tmp = Quality.setBit(bytes, 4);
        tmp = Quality.clearBit(tmp, 2);
        tmp = Quality.clearBit(tmp, 3);
        tmp = Quality.clearBit(tmp, 5);
        return Quality.setBit(tmp, 1);
    }

    public static int setQuestion_int(int intQuality) {
        int tmp = Quality.setBit_int(intQuality, 4);
        tmp = Quality.clearBit_int(tmp, 2);
        tmp = Quality.clearBit_int(tmp, 3);
        tmp = Quality.clearBit_int(tmp, 5);
        return Quality.setBit_int(tmp, 1);
    }

    public boolean isReject(int elementIndex) {
        return this.isScreened(elementIndex) && this.isBitSet(elementIndex, 5);
    }

    public boolean isNotReject(int elementIndex) {
        return !this.isReject(elementIndex);
    }

    public void clearReject(int elementIndex) {
        this.clearBit(elementIndex, 5);
        this.setBit(elementIndex, 1);
    }

    public void setReject(int elementIndex) {
        this.setBit(elementIndex, 5);
        this.clearBit(elementIndex, 2);
        this.clearBit(elementIndex, 4);
        this.clearBit(elementIndex, 3);
        this.setBit(elementIndex, 1);
    }

    public void clearRange(int elementIndex) {
        this.clearBit(elementIndex, 6);
        this.clearBit(elementIndex, 7);
    }

    public void setRange0(int elementIndex) {
        this.clearBit(elementIndex, 6);
        this.clearBit(elementIndex, 7);
    }

    public void setRange1(int elementIndex) {
        this.setBit(elementIndex, 6);
        this.clearBit(elementIndex, 7);
    }

    public void setRange2(int elementIndex) {
        this.clearBit(elementIndex, 6);
        this.setBit(elementIndex, 7);
    }

    public void setRange3(int elementIndex) {
        this.setBit(elementIndex, 6);
        this.setBit(elementIndex, 7);
    }

    public boolean isDifferentValue(int elementIndex) {
        return this.isBitSet(elementIndex, 8);
    }

    public boolean isNotDifferentValue(int elementIndex) {
        return !this.isDifferentValue(elementIndex);
    }

    private void clearDifferentValue(int elementIndex) {
        this.clearBit(elementIndex, 8);
    }

    private void setDifferentValue(int elementIndex) {
        this.setBit(elementIndex, 8);
    }

    public boolean isRevised(int elementIndex) {
        return this.isDifferentValue(elementIndex) || this.isBitSet(elementIndex, 9) && this.isBitSet(elementIndex, 10) && !this.isBitSet(elementIndex, 11) || this.isBitSet(elementIndex, 12) || this.isBitSet(elementIndex, 13) || this.isBitSet(elementIndex, 14) || this.isBitSet(elementIndex, 15);
    }

    public boolean isNotRevised(int elementIndex) {
        return !this.isRevised(elementIndex);
    }

    public void clearHowRevised(int elementIndex) {
        this.clearBit(elementIndex, 9);
        this.clearBit(elementIndex, 10);
        this.clearBit(elementIndex, 11);
    }

    public void clearReplaceMethod(int elementIndex) {
        this.clearBit(elementIndex, 12);
        this.clearBit(elementIndex, 13);
        this.clearBit(elementIndex, 14);
        this.clearBit(elementIndex, 15);
    }

    public void setRevisedNoRevision(int elementIndex) {
        this.clearHowRevised(elementIndex);
    }

    public void setReplaceNoRevision(int elementIndex) {
        this.clearReplaceMethod(elementIndex);
    }

    public void setNoRevision(int elementIndex) {
        this.setRevisedNoRevision(elementIndex);
        this.setReplaceNoRevision(elementIndex);
    }

    public void setRevisedAutomatically(int elementIndex) {
        this.setOkay(elementIndex);
        this.setDifferentValue(elementIndex);
        this.setBit(elementIndex, 9);
        this.clearBit(elementIndex, 10);
        this.clearBit(elementIndex, 11);
    }

    public static boolean isRevisedInteractivelyCheckAllBits(byte[] bytes) {
        return Quality.isBitSet(bytes, 1) && Quality.isBitSet(bytes, 2) && Quality.isBitClear(bytes, 3) && Quality.isBitClear(bytes, 4) && Quality.isBitClear(bytes, 5) && Quality.isBitSet(bytes, 8) && Quality.isRevisedInteractively(bytes);
    }

    public static boolean isRevisedInteractivelyCheckAllBits_int(int intQuality) {
        return Quality.isBitSet_int(intQuality, 1) && Quality.isBitSet_int(intQuality, 2) && Quality.isBitClear_int(intQuality, 3) && Quality.isBitClear_int(intQuality, 4) && Quality.isBitClear_int(intQuality, 5) && Quality.isBitSet_int(intQuality, 8) && Quality.isRevisedInteractively_int(intQuality);
    }

    public static boolean isRevisedInteractively(byte[] bytes) {
        return Quality.isBitClear(bytes, 9) && Quality.isBitSet(bytes, 10) && Quality.isBitClear(bytes, 11);
    }

    public static boolean isRevisedInteractively_int(int intQuality) {
        return Quality.isBitClear_int(intQuality, 9) && Quality.isBitSet_int(intQuality, 10) && Quality.isBitClear_int(intQuality, 11);
    }

    public void setRevisedInteractively(int elementIndex) {
        this.setOkay(elementIndex);
        this.setDifferentValue(elementIndex);
        this.clearBit(elementIndex, 9);
        this.setBit(elementIndex, 10);
        this.clearBit(elementIndex, 11);
    }

    public void setRevisedManually(int elementIndex) {
        this.setOkay(elementIndex);
        this.setDifferentValue(elementIndex);
        this.setBit(elementIndex, 9);
        this.setBit(elementIndex, 10);
        this.clearBit(elementIndex, 11);
    }

    public void setRevisedToOriginalAccepted(int elementIndex) {
        this.setOkay(elementIndex);
        this.clearBit(elementIndex, 9);
        this.clearBit(elementIndex, 10);
        this.setBit(elementIndex, 11);
        this.clearReplaceMethod(elementIndex);
    }

    public void setReplaceLinearInterpolation(int elementIndex) {
        this.setOkay(elementIndex);
        this.setDifferentValue(elementIndex);
        this.setBit(elementIndex, 12);
        this.clearBit(elementIndex, 13);
        this.clearBit(elementIndex, 14);
        this.clearBit(elementIndex, 15);
    }

    public void setReplaceManualChange(int elementIndex) {
        this.setOkay(elementIndex);
        this.setDifferentValue(elementIndex);
        this.clearBit(elementIndex, 12);
        this.setBit(elementIndex, 13);
        this.clearBit(elementIndex, 14);
        this.clearBit(elementIndex, 15);
    }

    public void setReplaceGraphicalChange(int elementIndex) {
        this.setOkay(elementIndex);
        this.setDifferentValue(elementIndex);
        this.clearBit(elementIndex, 12);
        this.clearBit(elementIndex, 13);
        this.setBit(elementIndex, 14);
        this.clearBit(elementIndex, 15);
    }

    public void setReplaceWithMissing(int elementIndex) {
        this.setMissing(elementIndex);
        this.setDifferentValue(elementIndex);
        this.setBit(elementIndex, 12);
        this.setBit(elementIndex, 13);
        this.clearBit(elementIndex, 14);
        this.clearBit(elementIndex, 15);
    }

    public static boolean isReject(byte[] bytes) {
        return Quality.isScreened(bytes) && Quality.isBitSet(bytes, 5);
    }

    public static boolean isReject_int(int intQuality) {
        return Quality.isBitSet_int(intQuality, 1) && Quality.isBitSet_int(intQuality, 5);
    }

    public static boolean isNotReject(byte[] bytes) {
        return !Quality.isReject(bytes);
    }

    public static boolean isNotReject_int(int intQuality) {
        return !Quality.isReject_int(intQuality);
    }

    public static byte[] clearReject(byte[] bytes) {
        byte[] tmp = Quality.clearBit(bytes, 5);
        return Quality.setBit(tmp, 1);
    }

    public static int clearReject_int(int intQuality) {
        return Quality.setBit_int(Quality.clearBit_int(intQuality, 5), 1);
    }

    public static byte[] setReject(byte[] bytes) {
        byte[] tmp = Quality.setBit(bytes, 5);
        tmp = Quality.clearBit(tmp, 2);
        tmp = Quality.clearBit(tmp, 4);
        tmp = Quality.clearBit(tmp, 3);
        return Quality.setBit(tmp, 1);
    }

    public static int setReject_int(int intQuality) {
        int tmp = Quality.setBit_int(intQuality, 5);
        tmp = Quality.clearBit_int(tmp, 2);
        tmp = Quality.clearBit_int(tmp, 4);
        tmp = Quality.clearBit_int(tmp, 3);
        return Quality.setBit_int(tmp, 1);
    }

    public static byte[] clearRange(byte[] bytes) {
        byte[] tmp = Quality.clearBit(bytes, 6);
        return Quality.clearBit(tmp, 7);
    }

    public static int clearRange_int(int intQuality) {
        return Quality.clearBit_int(Quality.clearBit_int(intQuality, 6), 7);
    }

    public static byte[] setRange0(byte[] bytes) {
        byte[] tmp = Quality.clearBit(bytes, 6);
        return Quality.clearBit(tmp, 7);
    }

    public static int setRange0_int(int intQuality) {
        return Quality.clearBit_int(Quality.clearBit_int(intQuality, 6), 7);
    }

    public static boolean isRange1(byte[] bytes) {
        return Quality.isBitSet(bytes, 6) && Quality.isBitClear(bytes, 7);
    }

    public static boolean isRange1_int(int intQuality) {
        return Quality.isBitSet_int(intQuality, 6) && Quality.isBitClear_int(intQuality, 7);
    }

    public static byte[] setRange1(byte[] bytes) {
        byte[] tmp = Quality.setBit(bytes, 6);
        return Quality.clearBit(tmp, 7);
    }

    public static int setRange1_int(int intQuality) {
        return Quality.clearBit_int(Quality.setBit_int(intQuality, 6), 7);
    }

    public static boolean isRange2(byte[] bytes) {
        return Quality.isBitClear(bytes, 6) && Quality.isBitSet(bytes, 7);
    }

    public static boolean isRange2_int(int intQuality) {
        return Quality.isBitClear_int(intQuality, 6) && Quality.isBitSet_int(intQuality, 7);
    }

    public static byte[] setRange2(byte[] bytes) {
        byte[] tmp = Quality.clearBit(bytes, 6);
        return Quality.setBit(tmp, 7);
    }

    public static int setRange2_int(int intQuality) {
        return Quality.setBit_int(Quality.clearBit_int(intQuality, 6), 7);
    }

    public static boolean isRange3(byte[] bytes) {
        return Quality.isBitSet(bytes, 6) && Quality.isBitSet(bytes, 7);
    }

    public static boolean isRange3_int(int intQuality) {
        return Quality.isBitSet_int(intQuality, 6) && Quality.isBitSet_int(intQuality, 7);
    }

    public static byte[] setRange3(byte[] bytes) {
        byte[] tmp = Quality.setBit(bytes, 6);
        return Quality.setBit(tmp, 7);
    }

    public static int setRange3_int(int intQuality) {
        return Quality.setBit_int(Quality.setBit_int(intQuality, 6), 7);
    }

    public static boolean isDifferentValue(byte[] bytes) {
        return Quality.isBitSet(bytes, 8);
    }

    public static boolean isDifferentValue_int(int intQuality) {
        return Quality.isBitSet_int(intQuality, 8);
    }

    public static boolean isNotDifferentValue(byte[] bytes) {
        return !Quality.isDifferentValue(bytes);
    }

    public static boolean isNotDifferentValue_int(int intQuality) {
        return !Quality.isDifferentValue_int(intQuality);
    }

    public static byte[] clearDifferentValue(byte[] bytes) {
        return Quality.clearBit(bytes, 8);
    }

    public static int clearDifferentValue_int(int intQuality) {
        return Quality.clearBit_int(intQuality, 8);
    }

    private static byte[] setDifferentValue(byte[] bytes) {
        return Quality.setBit(bytes, 8);
    }

    private static int setDifferentValue_int(int intQuality) {
        return Quality.setBit_int(intQuality, 8);
    }

    public static boolean isRevised(byte[] bytes) {
        return Quality.isDifferentValue(bytes) || Quality.isBitSet(bytes, 9) && Quality.isBitSet(bytes, 10) && !Quality.isBitSet(bytes, 11) || Quality.isBitSet(bytes, 12) || Quality.isBitSet(bytes, 13) || Quality.isBitSet(bytes, 14) || Quality.isBitSet(bytes, 15);
    }

    public static boolean isRevised_int(int intQuality) {
        return Quality.isDifferentValue_int(intQuality) || Quality.isBitSet_int(intQuality, 9) && Quality.isBitSet_int(intQuality, 10) && !Quality.isBitSet_int(intQuality, 11) || Quality.isBitSet_int(intQuality, 12) || Quality.isBitSet_int(intQuality, 13) || Quality.isBitSet_int(intQuality, 14) || Quality.isBitSet_int(intQuality, 15);
    }

    public boolean isNotRevised(byte[] bytes) {
        return !Quality.isRevised(bytes);
    }

    public boolean isNotRevised_int(int intQuality) {
        return !Quality.isRevised_int(intQuality);
    }

    public static byte[] clearHowRevised(byte[] bytes) {
        byte[] tmp = Quality.clearBit(bytes, 9);
        tmp = Quality.clearBit(tmp, 10);
        return Quality.clearBit(tmp, 11);
    }

    public static int clearHowRevised_int(int intQuality) {
        int tmp = Quality.clearBit_int(intQuality, 9);
        tmp = Quality.clearBit_int(tmp, 10);
        return Quality.clearBit_int(tmp, 11);
    }

    public static byte[] clearReplaceMethod(byte[] bytes) {
        byte[] tmp = Quality.clearBit(bytes, 12);
        tmp = Quality.clearBit(tmp, 13);
        tmp = Quality.clearBit(tmp, 14);
        return Quality.clearBit(tmp, 15);
    }

    public static int clearReplaceMethod_int(int intQuality) {
        int tmp = Quality.clearBit_int(intQuality, 12);
        tmp = Quality.clearBit_int(tmp, 13);
        tmp = Quality.clearBit_int(tmp, 14);
        return Quality.clearBit_int(tmp, 15);
    }

    public static byte[] setReplaceNoRevision(byte[] bytes) {
        return Quality.clearReplaceMethod(bytes);
    }

    public static int setReplaceNoRevision_int(int intQuality) {
        return Quality.clearReplaceMethod_int(intQuality);
    }

    public static byte[] setNoRevision(byte[] bytes) {
        byte[] tmp = Quality.clearHowRevised(bytes);
        return Quality.clearReplaceMethod(tmp);
    }

    public static int setNoRevision_int(int intQuality) {
        int tmp = Quality.clearHowRevised_int(intQuality);
        return Quality.clearReplaceMethod_int(tmp);
    }

    public static byte[] setRevisedAutomatically(byte[] bytes) {
        Quality.setOkay(bytes);
        Quality.setDifferentValue(bytes);
        byte[] tmp = Quality.setBit(bytes, 9);
        tmp = Quality.clearBit(tmp, 10);
        return Quality.clearBit(tmp, 11);
    }

    public static int setRevisedAutomatically_int(int intQuality) {
        int tmp = Quality.setOkay_int(intQuality);
        tmp = Quality.setDifferentValue_int(tmp);
        tmp = Quality.setBit_int(intQuality, 9);
        tmp = Quality.clearBit_int(tmp, 10);
        return Quality.clearBit_int(tmp, 11);
    }

    public static boolean isRevisedAutomaticallyCheckAllBits(byte[] bytes) {
        return Quality.isBitSet(bytes, 1) && Quality.isBitSet(bytes, 2) && Quality.isBitClear(bytes, 3) && Quality.isBitClear(bytes, 4) && Quality.isBitClear(bytes, 5) && Quality.isBitSet(bytes, 8) && Quality.isRevisedAutomatically(bytes);
    }

    public static boolean isRevisedAutomaticallyCheckAllBits_int(int intQuality) {
        return Quality.isBitSet_int(intQuality, 1) && Quality.isBitSet_int(intQuality, 2) && Quality.isBitClear_int(intQuality, 3) && Quality.isBitClear_int(intQuality, 4) && Quality.isBitClear_int(intQuality, 5) && Quality.isBitSet_int(intQuality, 8) && Quality.isRevisedAutomatically_int(intQuality);
    }

    public static boolean isRevisedAutomatically(byte[] bytes) {
        return Quality.isBitSet(bytes, 9) && Quality.isBitClear(bytes, 10) && Quality.isBitClear(bytes, 11);
    }

    public static boolean isRevisedAutomatically_int(int intQuality) {
        return Quality.isBitSet_int(intQuality, 9) && Quality.isBitClear_int(intQuality, 10) && Quality.isBitClear_int(intQuality, 11);
    }

    public static byte[] setRevisedInteractively(byte[] bytes) {
        Quality.setOkay(bytes);
        Quality.setDifferentValue(bytes);
        byte[] tmp = Quality.clearBit(bytes, 9);
        tmp = Quality.setBit(tmp, 10);
        return Quality.clearBit(tmp, 11);
    }

    public static int setRevisedInteractively_int(int intQuality) {
        int tmp = Quality.setOkay_int(intQuality);
        tmp = Quality.setDifferentValue_int(intQuality);
        tmp = Quality.clearBit_int(intQuality, 9);
        tmp = Quality.setBit_int(tmp, 10);
        return Quality.clearBit_int(tmp, 11);
    }

    public static boolean isRevisedManuallyCheckAllBits(byte[] bytes) {
        return Quality.isBitSet(bytes, 1) && Quality.isBitSet(bytes, 2) && Quality.isBitClear(bytes, 3) && Quality.isBitClear(bytes, 4) && Quality.isBitClear(bytes, 5) && Quality.isBitSet(bytes, 8) && Quality.isRevisedManually(bytes);
    }

    public static boolean isRevisedManually(byte[] bytes) {
        return Quality.isBitSet(bytes, 9) && Quality.isBitSet(bytes, 10) && Quality.isBitClear(bytes, 11);
    }

    public static boolean isRevisedManuallyCheckAllBits_int(int intQuality) {
        return Quality.isBitSet_int(intQuality, 1) && Quality.isBitSet_int(intQuality, 2) && Quality.isBitClear_int(intQuality, 3) && Quality.isBitClear_int(intQuality, 4) && Quality.isBitClear_int(intQuality, 5) && Quality.isBitSet_int(intQuality, 8) && Quality.isRevisedManually_int(intQuality);
    }

    public static boolean isRevisedManually_int(int intQuality) {
        return Quality.isBitSet_int(intQuality, 9) && Quality.isBitSet_int(intQuality, 10) && Quality.isBitClear_int(intQuality, 11);
    }

    public static byte[] setRevisedManually(byte[] bytes) {
        Quality.setOkay(bytes);
        Quality.setDifferentValue(bytes);
        byte[] tmp = Quality.setBit(bytes, 9);
        tmp = Quality.setBit(tmp, 10);
        return Quality.clearBit(tmp, 11);
    }

    public static int setRevisedManually_int(int intQuality) {
        int tmp = Quality.setOkay_int(intQuality);
        tmp = Quality.setDifferentValue_int(intQuality);
        tmp = Quality.setBit_int(intQuality, 9);
        tmp = Quality.setBit_int(tmp, 10);
        return Quality.clearBit_int(tmp, 11);
    }

    public void setUsingQualityFlags(byte[] originalBytes, int elementIndex, String qualFlag, boolean isValueRevised) {
        byte[] qual = Quality.getQualUsingFlags(originalBytes, qualFlag, isValueRevised);
        this.setElementAt(qual, elementIndex);
    }

    public static byte[] getQualUsingFlags(byte[] originalBytes, String qualFlag, boolean isValueRevised) {
        byte[] newbytes = new byte[4];
        System.arraycopy(originalBytes, 0, newbytes, 0, 4);
        if (qualFlag.indexOf("A") > -1) {
            if (isValueRevised) {
                Quality.setRevisedManually(newbytes);
            }
            if (!Quality.isDifferentValue(newbytes)) {
                Quality.setRevisedToOriginalAccepted(newbytes);
            }
            Quality.setOkay(newbytes);
        } else if (qualFlag.indexOf("M") > -1) {
            if (isValueRevised) {
                Quality.setRevisedManually(newbytes);
            }
            Quality.setMissing(newbytes);
        } else if (qualFlag.indexOf("Q") > -1) {
            if (isValueRevised) {
                Quality.setRevisedManually(newbytes);
            }
            Quality.setQuestion(newbytes);
        } else if (qualFlag.indexOf("R") > -1) {
            if (isValueRevised) {
                Quality.setRevisedManually(newbytes);
            }
            Quality.setReject(newbytes);
        }
        return Quality.getQualUsingReviseReplaceFlags(newbytes, qualFlag, isValueRevised);
    }

    private void setUsingReviseReplaceFlags(byte[] originalBytes, int elementIndex, String qualFlag, boolean isValueRevised) {
        byte[] newbytes = Quality.getQualUsingReviseReplaceFlags(originalBytes, qualFlag, isValueRevised);
        this.setElementAt(newbytes, elementIndex);
    }

    private static byte[] getQualUsingReviseReplaceFlags(byte[] originalBytes, String qualFlag, boolean isValueRevised) {
        byte[] newBytes = new byte[4];
        System.arraycopy(originalBytes, 0, newBytes, 0, 4);
        if (qualFlag.indexOf("E") > -1) {
            Quality.setRevisedManually(newBytes);
            Quality.setReplaceGraphicalChange(newBytes);
        } else if (qualFlag.indexOf("I") > -1) {
            Quality.setRevisedInteractively(newBytes);
            Quality.setReplaceLinearInterpolation(newBytes);
        } else if (qualFlag.indexOf("K") > -1) {
            Quality.setRevisedManually(newBytes);
            Quality.setReplaceManualChange(newBytes);
        }
        if (qualFlag.indexOf("P") > -1) {
            Quality.setProtected(newBytes);
        } else if (qualFlag.indexOf("U") > -1) {
            Quality.clearProtected(newBytes);
        }
        return newBytes;
    }

    public static byte[] setRevisedToOriginalAccepted(byte[] bytes) {
        Quality.setOkay(bytes);
        byte[] tmp = Quality.clearBit(bytes, 9);
        tmp = Quality.clearBit(tmp, 10);
        tmp = Quality.setBit(tmp, 11);
        return Quality.setReplaceNoRevision(tmp);
    }

    public static int setRevisedToOriginalAccepted_int(int intQuality) {
        int tmp = Quality.setOkay_int(intQuality);
        tmp = Quality.clearBit_int(intQuality, 9);
        tmp = Quality.clearBit_int(tmp, 10);
        tmp = Quality.setBit_int(tmp, 11);
        return Quality.setReplaceNoRevision_int(tmp);
    }

    public static boolean isRevisedToOriginalAccepted(byte[] bytes) {
        return Quality.isBitClear(bytes, 9) && Quality.isBitClear(bytes, 10) && Quality.isBitSet(bytes, 11);
    }

    public static boolean isRevisedToOriginalAccepted_int(int intQuality) {
        return Quality.isBitClear_int(intQuality, 9) && Quality.isBitClear_int(intQuality, 10) && Quality.isBitSet_int(intQuality, 11);
    }

    public static boolean isReplaceLinearInterpolation(byte[] bytes) {
        return Quality.isBitSet(bytes, 12) && Quality.isBitClear(bytes, 13) && Quality.isBitClear(bytes, 14) && Quality.isBitClear(bytes, 15);
    }

    public static boolean isReplaceLinearInterpolation_int(int intQuality) {
        return Quality.isBitSet_int(intQuality, 12) && Quality.isBitClear_int(intQuality, 13) && Quality.isBitClear_int(intQuality, 14) && Quality.isBitClear_int(intQuality, 15);
    }

    public static byte[] setReplaceLinearInterpolation(byte[] bytes) {
        Quality.setOkay(bytes);
        Quality.setDifferentValue(bytes);
        byte[] tmp = Quality.setBit(bytes, 12);
        tmp = Quality.clearBit(tmp, 13);
        tmp = Quality.clearBit(tmp, 14);
        return Quality.clearBit(tmp, 15);
    }

    public static int setReplaceLinearInterpolation_int(int intQuality) {
        int tmp = Quality.setOkay_int(intQuality);
        tmp = Quality.setDifferentValue_int(intQuality);
        tmp = Quality.setBit_int(intQuality, 12);
        tmp = Quality.clearBit_int(tmp, 13);
        tmp = Quality.clearBit_int(tmp, 14);
        return Quality.clearBit_int(tmp, 15);
    }

    public static boolean isReplaceManualChange(byte[] bytes) {
        return Quality.isBitClear(bytes, 12) && Quality.isBitSet(bytes, 13) && Quality.isBitClear(bytes, 14) && Quality.isBitClear(bytes, 15);
    }

    public static boolean isReplaceManualChange_int(int intQuality) {
        return Quality.isBitClear_int(intQuality, 12) && Quality.isBitSet_int(intQuality, 13) && Quality.isBitClear_int(intQuality, 14) && Quality.isBitClear_int(intQuality, 15);
    }

    public static byte[] setReplaceManualChange(byte[] bytes) {
        Quality.setOkay(bytes);
        Quality.setDifferentValue(bytes);
        byte[] tmp = Quality.clearBit(bytes, 12);
        tmp = Quality.setBit(tmp, 13);
        tmp = Quality.clearBit(tmp, 14);
        return Quality.clearBit(tmp, 15);
    }

    public static int setReplaceManualChange_int(int intQuality) {
        int tmp = Quality.setOkay_int(intQuality);
        tmp = Quality.setDifferentValue_int(intQuality);
        tmp = Quality.clearBit_int(intQuality, 12);
        tmp = Quality.setBit_int(tmp, 13);
        tmp = Quality.clearBit_int(tmp, 14);
        return Quality.clearBit_int(tmp, 15);
    }

    public static boolean isReplaceGraphicalChange(byte[] bytes) {
        return Quality.isBitClear(bytes, 12) && Quality.isBitClear(bytes, 13) && Quality.isBitSet(bytes, 14) && Quality.isBitClear(bytes, 15);
    }

    public static boolean isReplaceGraphicalChange_int(int intQuality) {
        return Quality.isBitClear_int(intQuality, 12) && Quality.isBitClear_int(intQuality, 13) && Quality.isBitSet_int(intQuality, 14) && Quality.isBitClear_int(intQuality, 15);
    }

    public static byte[] setReplaceGraphicalChange(byte[] bytes) {
        Quality.setOkay(bytes);
        Quality.setDifferentValue(bytes);
        byte[] tmp = Quality.clearBit(bytes, 12);
        tmp = Quality.clearBit(tmp, 13);
        tmp = Quality.setBit(tmp, 14);
        return Quality.clearBit(tmp, 15);
    }

    public static int setReplaceGraphicalChange_int(int intQuality) {
        int tmp = Quality.setOkay_int(intQuality);
        tmp = Quality.setDifferentValue_int(intQuality);
        tmp = Quality.clearBit_int(intQuality, 12);
        tmp = Quality.clearBit_int(tmp, 13);
        tmp = Quality.setBit_int(tmp, 14);
        return Quality.clearBit_int(tmp, 15);
    }

    public static boolean isReplaceWithMissing(byte[] bytes) {
        return Quality.isBitSet(bytes, 12) && Quality.isBitSet(bytes, 13) && Quality.isBitClear(bytes, 14) && Quality.isBitClear(bytes, 15);
    }

    public static boolean isReplaceWithMissing_int(int intQuality) {
        return Quality.isBitSet_int(intQuality, 12) && Quality.isBitSet_int(intQuality, 13) && Quality.isBitClear_int(intQuality, 14) && Quality.isBitClear_int(intQuality, 15);
    }

    public static byte[] setReplaceWithMissing(byte[] bytes) {
        Quality.setMissing(bytes);
        Quality.setDifferentValue(bytes);
        byte[] tmp = Quality.setBit(bytes, 12);
        tmp = Quality.setBit(tmp, 13);
        tmp = Quality.clearBit(tmp, 14);
        return Quality.clearBit(tmp, 15);
    }

    public static int setReplaceWithMissing_int(int intQuality) {
        int tmp = Quality.setMissing_int(intQuality);
        tmp = Quality.setDifferentValue_int(intQuality);
        tmp = Quality.setBit_int(intQuality, 12);
        tmp = Quality.setBit_int(tmp, 13);
        tmp = Quality.clearBit_int(tmp, 14);
        return Quality.clearBit_int(tmp, 15);
    }

    public boolean isOkay(int elementIndex) {
        return this.isBitSet(elementIndex, 2);
    }

    public boolean isNotOkay(int elementIndex) {
        return !this.isOkay(elementIndex);
    }

    public void clearOkay(int elementIndex) {
        this.clearBit(elementIndex, 2);
        this.setBit(elementIndex, 1);
    }

    public void setOkay(int elementIndex) {
        this.setBit(elementIndex, 2);
        this.clearBit(elementIndex, 5);
        this.clearBit(elementIndex, 4);
        this.clearBit(elementIndex, 3);
        this.setBit(elementIndex, 1);
    }

    public static boolean isOkay(byte[] bytes) {
        return Quality.isBitSet(bytes, 2);
    }

    public static boolean isOkay_int(int intQuality) {
        return Quality.isBitSet_int(intQuality, 1) && Quality.isBitSet_int(intQuality, 2);
    }

    public static boolean isNotOkay(byte[] bytes) {
        return !Quality.isOkay(bytes);
    }

    public static boolean isNotOkay_int(int intQuality) {
        return !Quality.isOkay_int(intQuality);
    }

    public static byte[] clearOkay(byte[] bytes) {
        byte[] tmp = Quality.clearBit(bytes, 2);
        return Quality.setBit(tmp, 1);
    }

    public static int clearOkay_int(int intQuality) {
        return Quality.setBit_int(Quality.clearBit_int(intQuality, 2), 1);
    }

    public static byte[] setOkay(byte[] bytes) {
        byte[] tmp = Quality.setBit(bytes, 2);
        tmp = Quality.clearBit(tmp, 3);
        tmp = Quality.clearBit(tmp, 4);
        tmp = Quality.clearBit(tmp, 5);
        return Quality.setBit(tmp, 1);
    }

    public static int setOkay_int(int intQuality) {
        int tmp = Quality.setBit_int(intQuality, 2);
        tmp = Quality.clearBit_int(tmp, 3);
        tmp = Quality.clearBit_int(tmp, 4);
        tmp = Quality.clearBit_int(tmp, 5);
        return Quality.setBit_int(tmp, 1);
    }

    public static byte[] clearAllBits(byte[] bytes) {
        for (int ii = 0; ii < bytes.length; ++ii) {
            bytes[ii] = 0;
        }
        return bytes;
    }

    public boolean isAbsoluteMagnitude(int elementIndex) {
        return this.isBitSet(elementIndex, 16);
    }

    public boolean isNotAbsoluteMagnitude(int elementIndex) {
        return !this.isAbsoluteMagnitude(elementIndex);
    }

    public void clearAbsoluteMagnitude(int elementIndex) {
        this.clearBit(elementIndex, 16);
    }

    public void setAbsoluteMagnitude(int elementIndex) {
        this.setBit(elementIndex, 16);
    }

    public static boolean isAbsoluteMagnitude(byte[] bytes) {
        return Quality.isBitSet(bytes, 16);
    }

    public static boolean isAbsoluteMagnitude_int(int intQuality) {
        return Quality.isBitSet_int(intQuality, 16);
    }

    public static boolean isNotAbsoluteMagnitude(byte[] bytes) {
        return !Quality.isAbsoluteMagnitude(bytes);
    }

    public static boolean isNotAbsoluteMagnitude_int(int intQuality) {
        return !Quality.isAbsoluteMagnitude_int(intQuality);
    }

    public static byte[] clearAbsoluteMagnitude(byte[] bytes) {
        return Quality.clearBit(bytes, 16);
    }

    public static int clearAbsoluteMagnitude_int(int intQuality) {
        return Quality.clearBit_int(intQuality, 16);
    }

    public static byte[] setAbsoluteMagnitude(byte[] bytes) {
        return Quality.setBit(bytes, 16);
    }

    public static int setAbsoluteMagnitude_int(int intQuality) {
        return Quality.setBit_int(intQuality, 16);
    }

    public boolean isConstantValue(int elementIndex) {
        return this.isBitSet(elementIndex, 17);
    }

    public boolean isNotConstantValue(int elementIndex) {
        return !this.isConstantValue(elementIndex);
    }

    public void clearConstantValue(int elementIndex) {
        this.clearBit(elementIndex, 17);
    }

    public void setConstantValue(int elementIndex) {
        this.setBit(elementIndex, 17);
    }

    public static boolean isConstantValue(byte[] bytes) {
        return Quality.isBitSet(bytes, 17);
    }

    public static boolean isConstantValue_int(int intQuality) {
        return Quality.isBitSet_int(intQuality, 17);
    }

    public static boolean isNotConstantValue(byte[] bytes) {
        return !Quality.isConstantValue(bytes);
    }

    public static boolean isNotConstantValue_int(int intQuality) {
        return !Quality.isConstantValue_int(intQuality);
    }

    public static byte[] clearConstantValue(byte[] bytes) {
        return Quality.clearBit(bytes, 17);
    }

    public static int clearConstantValue_int(int intQuality) {
        return Quality.clearBit_int(intQuality, 17);
    }

    public static byte[] setConstantValue(byte[] bytes) {
        return Quality.setBit(bytes, 17);
    }

    public static int setConstantValue_int(int intQuality) {
        return Quality.setBit_int(intQuality, 17);
    }

    public boolean isRateOfChange(int elementIndex) {
        return this.isBitSet(elementIndex, 18);
    }

    public boolean isNotRateOfChange(int elementIndex) {
        return !this.isRateOfChange(elementIndex);
    }

    public void clearRateOfChange(int elementIndex) {
        this.clearBit(elementIndex, 18);
    }

    public void setRateOfChange(int elementIndex) {
        this.setBit(elementIndex, 18);
    }

    public static boolean isRateOfChange(byte[] bytes) {
        return Quality.isBitSet(bytes, 18);
    }

    public static boolean isRateOfChange_int(int intQuality) {
        return Quality.isBitSet_int(intQuality, 18);
    }

    public static boolean isNotRateOfChange(byte[] bytes) {
        return !Quality.isRateOfChange(bytes);
    }

    public static boolean isNotRateOfChange_int(int intQuality) {
        return !Quality.isRateOfChange_int(intQuality);
    }

    public static byte[] clearRateOfChange(byte[] bytes) {
        return Quality.clearBit(bytes, 18);
    }

    public static int clearRateOfChange_int(int intQuality) {
        return Quality.clearBit_int(intQuality, 18);
    }

    public static byte[] setRateOfChange(byte[] bytes) {
        return Quality.setBit(bytes, 18);
    }

    public static int setRateOfChange_int(int intQuality) {
        return Quality.setBit_int(intQuality, 18);
    }

    public boolean isRelativeMagnitude(int elementIndex) {
        return this.isBitSet(elementIndex, 19);
    }

    public boolean isNotRelativeMagnitude(int elementIndex) {
        return !this.isRelativeMagnitude(elementIndex);
    }

    public void clearRelativeMagnitude(int elementIndex) {
        this.clearBit(elementIndex, 19);
    }

    public void setRelativeMagnitude(int elementIndex) {
        this.setBit(elementIndex, 19);
    }

    public static boolean isRelativeMagnitude(byte[] bytes) {
        return Quality.isBitSet(bytes, 19);
    }

    public static boolean isRelativeMagnitude_int(int intQuality) {
        return Quality.isBitSet_int(intQuality, 19);
    }

    public static boolean isNotRelativeMagnitude(byte[] bytes) {
        return !Quality.isRelativeMagnitude(bytes);
    }

    public static boolean isNotRelativeMagnitude_int(int intQuality) {
        return !Quality.isRelativeMagnitude_int(intQuality);
    }

    public static byte[] clearRelativeMagnitude(byte[] bytes) {
        return Quality.clearBit(bytes, 19);
    }

    public static int clearRelativeMagnitude_int(int intQuality) {
        return Quality.clearBit_int(intQuality, 19);
    }

    public static byte[] setRelativeMagnitude(byte[] bytes) {
        return Quality.setBit(bytes, 19);
    }

    public static int setRelativeMagnitude_int(int intQuality) {
        return Quality.setBit_int(intQuality, 19);
    }

    public boolean isDurationMagnitude(int elementIndex) {
        return this.isBitSet(elementIndex, 20);
    }

    public boolean isNotDurationMagnitude(int elementIndex) {
        return !this.isDurationMagnitude(elementIndex);
    }

    public void clearDurationMagnitude(int elementIndex) {
        this.clearBit(elementIndex, 20);
    }

    public void setDurationMagnitude(int elementIndex) {
        this.setBit(elementIndex, 20);
    }

    public static boolean isDurationMagnitude(byte[] bytes) {
        return Quality.isBitSet(bytes, 20);
    }

    public static boolean isDurationMagnitude_int(int intQuality) {
        return Quality.isBitSet_int(intQuality, 20);
    }

    public static boolean isNotDurationMagnitude(byte[] bytes) {
        return !Quality.isDurationMagnitude(bytes);
    }

    public static boolean isNotDurationMagnitude_int(int intQuality) {
        return !Quality.isDurationMagnitude_int(intQuality);
    }

    public static byte[] clearDurationMagnitude(byte[] bytes) {
        return Quality.clearBit(bytes, 20);
    }

    public static int clearDurationMagnitude_int(int intQuality) {
        return Quality.clearBit_int(intQuality, 20);
    }

    public static byte[] setDurationMagnitude(byte[] bytes) {
        return Quality.setBit(bytes, 20);
    }

    public static int setDurationMagnitude_int(int intQuality) {
        return Quality.setBit_int(intQuality, 20);
    }

    public boolean isNegativeIncremental(int elementIndex) {
        return this.isBitSet(elementIndex, 21);
    }

    public boolean isNotNegativeIncremental(int elementIndex) {
        return !this.isNegativeIncremental(elementIndex);
    }

    public void clearNegativeIncremental(int elementIndex) {
        this.clearBit(elementIndex, 21);
    }

    public void setNegativeIncremental(int elementIndex) {
        this.setBit(elementIndex, 21);
    }

    public static boolean isNegativeIncremental(byte[] bytes) {
        return Quality.isBitSet(bytes, 21);
    }

    public static boolean isNegativeIncremental_int(int intQuality) {
        return Quality.isBitSet_int(intQuality, 21);
    }

    public static boolean isNotNegativeIncremental(byte[] bytes) {
        return !Quality.isNegativeIncremental(bytes);
    }

    public static boolean isNotNegativeIncremental_int(int intQuality) {
        return !Quality.isNegativeIncremental_int(intQuality);
    }

    public static byte[] clearNegativeIncremental(byte[] bytes) {
        return Quality.clearBit(bytes, 21);
    }

    public static int clearNegativeIncremental_int(int intQuality) {
        return Quality.clearBit_int(intQuality, 21);
    }

    public static byte[] setNegativeIncremental(byte[] bytes) {
        return Quality.setBit(bytes, 21);
    }

    public static int setNegativeIncremental_int(int intQuality) {
        return Quality.setBit_int(intQuality, 21);
    }

    public boolean isUserDefinedTest(int elementIndex) {
        return this.isBitSet(elementIndex, 25);
    }

    public boolean isNotUserDefinedTest(int elementIndex) {
        return !this.isUserDefinedTest(elementIndex);
    }

    public void clearUserDefinedTest(int elementIndex) {
        this.clearBit(elementIndex, 25);
    }

    public void setUserDefinedTest(int elementIndex) {
        this.setBit(elementIndex, 25);
    }

    public static boolean isUserDefinedTest(byte[] bytes) {
        return Quality.isBitSet(bytes, 25);
    }

    public static boolean isUserDefinedTest_int(int intQuality) {
        return Quality.isBitSet_int(intQuality, 25);
    }

    public static boolean isNotUserDefinedTest(byte[] bytes) {
        return !Quality.isUserDefinedTest(bytes);
    }

    public static boolean isNotUserDefinedTest_int(int intQuality) {
        return !Quality.isUserDefinedTest_int(intQuality);
    }

    public static byte[] clearUserDefinedTest(byte[] bytes) {
        return Quality.clearBit(bytes, 25);
    }

    public static int clearUserDefinedTest_int(int intQuality) {
        return Quality.clearBit_int(intQuality, 25);
    }

    public static byte[] setUserDefinedTest(byte[] bytes) {
        return Quality.setBit(bytes, 25);
    }

    public static int setUserDefinedTest_int(int intQuality) {
        return Quality.setBit_int(intQuality, 25);
    }

    public boolean isDistributionTest(int elementIndex) {
        return this.isBitSet(elementIndex, 26);
    }

    public boolean isNotDistributionTest(int elementIndex) {
        return !this.isDistributionTest(elementIndex);
    }

    public void clearDistributionTest(int elementIndex) {
        this.clearBit(elementIndex, 26);
    }

    public void setDistributionTest(int elementIndex) {
        this.setBit(elementIndex, 26);
    }

    public static boolean isDistributionTest(byte[] bytes) {
        return Quality.isBitSet(bytes, 26);
    }

    public static boolean isDistributionTest_int(int intQuality) {
        return Quality.isBitSet_int(intQuality, 26);
    }

    public static boolean isNotDistributionTest(byte[] bytes) {
        return !Quality.isDistributionTest(bytes);
    }

    public static boolean isNotDistributionTest_int(int intQuality) {
        return !Quality.isDistributionTest_int(intQuality);
    }

    public static byte[] clearDistributionTest(byte[] bytes) {
        return Quality.clearBit(bytes, 26);
    }

    public static int clearDistributionTest_int(int intQuality) {
        return Quality.clearBit_int(intQuality, 26);
    }

    public static byte[] setDistributionTest(byte[] bytes) {
        return Quality.setBit(bytes, 26);
    }

    public static int setDistributionTest_int(int intQuality) {
        return Quality.setBit_int(intQuality, 26);
    }

    public boolean isGageList(int elementIndex) {
        return this.isBitSet(elementIndex, 23);
    }

    public boolean isNotGageList(int elementIndex) {
        return !this.isGageList(elementIndex);
    }

    public void clearGageList(int elementIndex) {
        this.clearBit(elementIndex, 23);
    }

    public void setGageList(int elementIndex) {
        this.setBit(elementIndex, 23);
    }

    public static boolean isGageList(byte[] bytes) {
        return Quality.isBitSet(bytes, 23);
    }

    public static boolean isGageList_int(int intQuality) {
        return Quality.isBitSet_int(intQuality, 23);
    }

    public static boolean isNotGageList(byte[] bytes) {
        return !Quality.isGageList(bytes);
    }

    public static boolean isNotGageList_int(int intQuality) {
        return !Quality.isGageList_int(intQuality);
    }

    public static byte[] clearGageList(byte[] bytes) {
        return Quality.clearBit(bytes, 23);
    }

    public static int clearGageList_int(int intQuality) {
        return Quality.clearBit_int(intQuality, 23);
    }

    public static byte[] setGageList(byte[] bytes) {
        return Quality.setBit(bytes, 23);
    }

    public static int setGageList_int(int intQuality) {
        return Quality.setBit_int(intQuality, 23);
    }

    public int[] getIntQuality() {
        int[] iqual = new int[this._size];
        for (int ii = 0; ii < this._size; ++ii) {
            int byteIndex = ii * 4;
            int i0 = this._elementData[byteIndex + 0] & 0xFF;
            int i1 = this._elementData[byteIndex + 1] & 0xFF;
            int i2 = this._elementData[byteIndex + 2] & 0xFF;
            int i3 = this._elementData[byteIndex + 3] & 0xFF;
            iqual[ii] = i3 | i2 << 8 | i1 << 16 | i0 << 24;
        }
        return iqual;
    }

    public static boolean isEmpty(byte[] bytes) {
        int iqual = Quality.getInteger(bytes);
        return iqual == 0;
    }

    private static Preferences getQualityPrefs(Preferences rootNode) {
        return rootNode.node(Quality.class.getSimpleName());
    }

    private static Preferences getQualityColorPrefs(Preferences rootNode) {
        return rootNode.node(Quality.class.getSimpleName()).node("color");
    }

    public static boolean canEditQuality(Preferences appSpecificRootNode) {
        Preferences qualNode = Quality.getQualityPrefs(appSpecificRootNode);
        return qualNode.getBoolean(QUALITY_FLAGS_EDITABLE, true);
    }

    public static boolean canShowQuality(Preferences appSpecificRootNode) {
        Preferences qualNode = Quality.getQualityPrefs(appSpecificRootNode);
        return qualNode.getBoolean(SHOW_QUALITY_FLAGS, true);
    }

    public static void setShowQuality(Preferences appSpecificRootNode, boolean showQuality) {
        Preferences qualNode = Quality.getQualityPrefs(appSpecificRootNode);
        qualNode.putBoolean(SHOW_QUALITY_FLAGS, showQuality);
    }

    public static void setCanEditQuality(Preferences appSpecificRootNode, boolean editQuality) {
        Preferences qualNode = Quality.getQualityPrefs(appSpecificRootNode);
        qualNode.putBoolean(QUALITY_FLAGS_EDITABLE, editQuality);
    }

    public static void addQualityPreferencesListener(Preferences appSpecificRootNode, PreferenceChangeListener listener) {
        Preferences qualNode = Quality.getQualityPrefs(appSpecificRootNode);
        qualNode.removePreferenceChangeListener(listener);
        qualNode.addPreferenceChangeListener(listener);
    }

    public static void removeQualityPreferencesListener(Preferences appSpecificRootNode, PreferenceChangeListener listener) {
        Preferences qualNode = Quality.getQualityPrefs(appSpecificRootNode);
        qualNode.removePreferenceChangeListener(listener);
    }

    public final NavigableMap<Date, String> getQualitySymbols(long[] timesArray) {
        return this.getDateQualityMap(i -> QualityStringRenderer.getSymbolicString(this.getIntegerAt(i)), timesArray);
    }

    public final NavigableMap<Date, Integer> getQualityIntegers(long[] timesArray) {
        return this.getDateQualityMap(this::getIntegerAt, timesArray);
    }

    public final NavigableMap<ZonedDateTime, Integer> getQualityIntegers(long[] timesArray, ZoneId zonedId) {
        return this.getZonedDateTimeQualityMap(this::getIntegerAt, timesArray, zonedId);
    }

    private <V> NavigableMap<ZonedDateTime, V> getZonedDateTimeQualityMap(IntFunction<V> qualityExtractor, long[] timesArray, ZoneId zoneId) {
        TreeMap<ZonedDateTime, V> retval = new TreeMap<ZonedDateTime, V>();
        for (int i = 0; i < timesArray.length; ++i) {
            ZonedDateTime date = ZonedDateTime.ofInstant(Instant.ofEpochMilli(timesArray[i]), zoneId);
            retval.put(date, qualityExtractor.apply(i));
        }
        return retval;
    }

    private <V> NavigableMap<Date, V> getDateQualityMap(IntFunction<V> qualityExtractor, long[] timesArray) {
        TreeMap<Date, V> retval = new TreeMap<Date, V>();
        for (int i = 0; i < timesArray.length; ++i) {
            Date date = new Date(timesArray[i]);
            retval.put(date, qualityExtractor.apply(i));
        }
        return retval;
    }

    private String toStringElement(int elementIndex, int stringType) {
        return QualityStringRenderer.getString(this.getIntegerAt(elementIndex), stringType);
    }

    public String toBinaryString() {
        return this.toString(0);
    }

    public String toOctalString() {
        return this.toString(1);
    }

    public String toSymbolicString() {
        return this.toString(4);
    }

    public String toSymbolicRevisedString() {
        return this.toString(5);
    }

    public String toSymbolicTestsString() {
        return this.toString(6);
    }

    public String toHexString() {
        return this.toString(2);
    }

    public String toIntegerString() {
        return this.toString(3);
    }

    public String toIntegerStringElementAt(int elementIndex) {
        return Integer.toString(this.getIntegerAt(elementIndex));
    }

    public String toBinaryStringElementAt(int elementIndex) {
        return QualityStringRenderer.pad(Integer.toBinaryString(this.getIntegerAt(elementIndex)), 0);
    }

    public String toOctalStringElementAt(int elementIndex) {
        return QualityStringRenderer.pad(Integer.toOctalString(this.getIntegerAt(elementIndex)), 1);
    }

    public String toSymbolicStringElementAt(int elementIndex) {
        return this.toStringElement(elementIndex, 4);
    }

    public String toSymbolicTestsStringElementAt(int elementIndex) {
        return this.toStringElement(elementIndex, 6);
    }

    public String toSymbolicRevisedStringElementAt(int elementIndex) {
        return this.toStringElement(elementIndex, 5);
    }

    public String toHexStringElementAt(int elementIndex) {
        return QualityStringRenderer.pad(Integer.toHexString(this.getIntegerAt(elementIndex)), 2);
    }

    public String toString() {
        return this.toString(2);
    }

    private String toString(int stringType) {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        for (int i = 0; i < this._size; ++i) {
            String s = this.toStringElement(i, stringType);
            buf.append(s);
            if (i >= this._size - 1) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }
}

