/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries;

import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import mil.army.usace.hec.data.timeseries.Quality;

public final class QualityStringRenderer {
    public static final String FG_COLOR_PREFIX = "qf_color_";
    public static final String BG_COLOR_PREFIX = "qf_bg_color_";
    private static final Map<String, String> SYMBOL_TO_COLORED_HTML_CACHE = new HashMap<String, String>();
    private static final Map<String, String> SYMBOLIC_BG_COLOR_MAP;
    private static final Map<String, String> symbolicFgColorMap;
    private static final Color LIGHT_RED;
    private static final Color LIGHT_BLUE;
    private static final Color LIGHT_CYAN;
    private static final Color LIGHT_GREEN;
    private static final Color LIGHT_MAGENTA;
    private static final Color LIGHT_PINK;
    private static final Color LIGHT_YELLOW;
    private static final Color LIGHT_ORANGE;
    private static final Color PURPLE;
    static final int BINARY_STRING = 0;
    static final int OCTAL_STRING = 1;
    static final int HEX_STRING = 2;
    static final int INTEGER_STRING = 3;
    static final int SYMBOLIC_STRING = 4;
    static final int SYMBOLIC_REVISED_STRING = 5;
    static final int SYMBOLIC_TESTS_STRING = 6;
    private static Map<String, String> previousColorMap;

    private QualityStringRenderer() {
        throw new AssertionError((Object)"Utility class");
    }

    public static Map<String, String> getDefaultSymbolicFgColorMap() {
        return symbolicFgColorMap;
    }

    static Map<String, String> generateColorPrefMap() {
        HashMap<String, String> output = new HashMap<String, String>();
        Preferences prefs = Preferences.userRoot();
        Map<String, String> defBgColorMap = QualityStringRenderer.getDefaultSymbolicBgColorMap();
        Map<String, String> defFgColorMap = QualityStringRenderer.getDefaultSymbolicFgColorMap();
        for (String s : defBgColorMap.keySet()) {
            StringBuilder fgSb = new StringBuilder(FG_COLOR_PREFIX);
            StringBuilder bgSb = new StringBuilder(BG_COLOR_PREFIX);
            fgSb.append(s);
            bgSb.append(s);
            output.put(fgSb.toString(), prefs.get(fgSb.toString(), defFgColorMap.get(s)));
            output.put(bgSb.toString(), prefs.get(bgSb.toString(), defBgColorMap.get(s)));
        }
        return output;
    }

    static String convertToColoredHtml(String input, Map<String, String> map) {
        StringBuilder output = new StringBuilder();
        StringBuilder newInputSb = new StringBuilder();
        if (previousColorMap == null) {
            previousColorMap = map;
        } else {
            boolean containsDifferentColors = false;
            for (String s : previousColorMap.keySet()) {
                String prevColor;
                String color = map.get(s);
                if (color.equals(prevColor = previousColorMap.get(s))) continue;
                containsDifferentColors = true;
                break;
            }
            if (containsDifferentColors) {
                SYMBOL_TO_COLORED_HTML_CACHE.clear();
                previousColorMap = map;
            }
        }
        String cache = SYMBOL_TO_COLORED_HTML_CACHE.get(input);
        if (cache == null) {
            for (int i = 0; i < input.length() - 1; ++i) {
                char c1 = input.charAt(i);
                newInputSb.append(c1);
                newInputSb.append(' ');
            }
            newInputSb.append(input.charAt(input.length() - 1));
            String newInput = newInputSb.toString();
            for (int i = 0; i < newInput.length(); ++i) {
                char c = newInput.charAt(i);
                output.append((CharSequence)QualityStringRenderer.getColorLineForChar(c, map));
            }
            SYMBOL_TO_COLORED_HTML_CACHE.put(input, output.toString());
        } else {
            output = new StringBuilder(cache);
        }
        return output.toString();
    }

    public static Map<String, String> getDefaultSymbolicBgColorMap() {
        return SYMBOLIC_BG_COLOR_MAP;
    }

    static StringBuilder getColorLineForChar(char c, Map<String, String> map) {
        if (c == ' ') {
            return new StringBuilder("&nbsp;");
        }
        StringBuilder output = new StringBuilder();
        StringBuilder colorPref = new StringBuilder(FG_COLOR_PREFIX);
        colorPref.append(c);
        StringBuilder bgColorPref = new StringBuilder(BG_COLOR_PREFIX);
        bgColorPref.append(c);
        Color bgColor = QualityStringRenderer.parseColorString(map.get(bgColorPref.toString()));
        if (bgColor != null) {
            int bgColorVal = bgColor.getRGB() & 0xFFFFFF;
            Color fgColor = QualityStringRenderer.parseColorString(map.get(colorPref.toString()));
            if (fgColor != null) {
                int fgColorVal = fgColor.getRGB() & 0xFFFFFF;
                output.append("<font bgColor= \"#");
                output.append(Integer.toHexString(bgColorVal));
                output.append("\" color= \"#");
                output.append(Integer.toHexString(fgColorVal));
                output.append("\">");
                output.append(c);
                output.append("</font>");
            }
        }
        return output;
    }

    private static Color parseColorString(String colorString) {
        if (colorString == null) {
            return null;
        }
        colorString = colorString.toLowerCase();
        Color color = null;
        if ("darkGray".equalsIgnoreCase(colorString)) {
            return Color.darkGray;
        }
        if ("gray".equalsIgnoreCase(colorString)) {
            return Color.gray;
        }
        if ("lightGray".equalsIgnoreCase(colorString)) {
            return Color.lightGray;
        }
        if ("lightred".equalsIgnoreCase(colorString)) {
            return LIGHT_RED;
        }
        if ("lightblue".equalsIgnoreCase(colorString)) {
            return LIGHT_BLUE;
        }
        if ("lightcyan".equalsIgnoreCase(colorString)) {
            return LIGHT_CYAN;
        }
        if ("lightgreen".equalsIgnoreCase(colorString)) {
            return LIGHT_GREEN;
        }
        if ("lightmagenta".equalsIgnoreCase(colorString)) {
            return LIGHT_MAGENTA;
        }
        if ("lightyellow".equalsIgnoreCase(colorString)) {
            return LIGHT_YELLOW;
        }
        if ("lightorange".equalsIgnoreCase(colorString)) {
            return LIGHT_ORANGE;
        }
        if ("lightpink".equalsIgnoreCase(colorString)) {
            return LIGHT_PINK;
        }
        if ("purple".equalsIgnoreCase(colorString)) {
            color = PURPLE;
        } else if (colorString.indexOf("blue") > -1) {
            color = Color.blue;
        } else if (colorString.indexOf("black") > -1) {
            color = Color.black;
        } else if (colorString.indexOf("cyan") > -1) {
            color = Color.cyan;
        } else if (colorString.indexOf("green") > -1) {
            color = Color.green;
        } else if (colorString.indexOf("magenta") > -1) {
            color = Color.magenta;
        } else if (colorString.indexOf("pink") > -1) {
            color = Color.pink;
        } else if (colorString.indexOf("red") > -1) {
            color = Color.red;
        } else if (colorString.indexOf("white") > -1) {
            color = Color.white;
        } else if (colorString.indexOf("yellow") > -1) {
            color = Color.yellow;
        } else if (colorString.indexOf("orange") > -1) {
            color = Color.orange;
        } else if (colorString.indexOf("purple") > -1) {
            color = PURPLE;
        } else {
            if (colorString.indexOf(44) > -1) {
                return QualityStringRenderer.parseRGBString(colorString);
            }
            try {
                Integer.parseInt(colorString);
                color = Color.decode(colorString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (color != null) {
            if (colorString.startsWith("dark")) {
                color = color.darker();
            } else if (colorString.startsWith("bright") || colorString.startsWith("light")) {
                color = color.brighter();
            }
        }
        return color;
    }

    private static Color parseRGBString(String rgbaStr) {
        if (rgbaStr == null) {
            return Color.black;
        }
        StringTokenizer strTok = new StringTokenizer(rgbaStr, ",", false);
        int a = 255;
        if (strTok.countTokens() < 3) {
            return Color.black;
        }
        int r = QualityStringRenderer.parseInt(strTok.nextToken());
        int g = QualityStringRenderer.parseInt(strTok.nextToken());
        int b = QualityStringRenderer.parseInt(strTok.nextToken());
        if (strTok.hasMoreTokens()) {
            a = QualityStringRenderer.parseInt(strTok.nextToken());
        }
        return new Color(r, g, b, a);
    }

    private static int parseInt(String str) {
        int val;
        if (str == null) {
            return Integer.MIN_VALUE;
        }
        int idx = (str = str.trim()).indexOf(44);
        if (idx >= 0) {
            str = QualityStringRenderer.removeChar(str, ',');
        }
        try {
            val = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            val = Integer.MIN_VALUE;
        }
        return val;
    }

    private static String removeChar(String s, char c) {
        if (s == null) {
            return s;
        }
        StringBuilder buf = new StringBuilder(s.length());
        buf.setLength(s.length());
        int current = 0;
        int cnt = 0;
        for (int i = 0; i < s.length(); ++i) {
            char cur = s.charAt(i);
            if (cur != c) {
                buf.setCharAt(current++, cur);
                continue;
            }
            ++cnt;
        }
        buf.setLength(buf.length() - cnt);
        return buf.toString();
    }

    public static String getSymbolicString(int intQuality) {
        return QualityStringRenderer.getString(intQuality, 4);
    }

    public static String getSymbolicRevisedString(int intQuality) {
        return QualityStringRenderer.getString(intQuality, 5);
    }

    public static String getColoredHtmlSymbolicString(int intQuality) {
        return QualityStringRenderer.getColoredHtmlSymbolicString(intQuality, QualityStringRenderer.generateColorPrefMap());
    }

    public static String getColoredHtmlSymbolicString(int intQuality, Map<String, String> colorMap) {
        return QualityStringRenderer.convertToColoredHtml(QualityStringRenderer.getSymbolicString(intQuality) + QualityStringRenderer.getSymbolicRevisedString(intQuality), colorMap);
    }

    public static String getSymbolicTestsString(int intQuality) {
        return QualityStringRenderer.getString(intQuality, 6);
    }

    public static String getString(int intQuality, int stringType) {
        int n = intQuality;
        byte[] bytes = new byte[4];
        bytes[3] = (byte)(n & 0xFF);
        bytes[2] = (byte)(n >> 8 & 0xFF);
        bytes[1] = (byte)(n >> 16 & 0xFF);
        bytes[0] = (byte)(n >> 24 & 0xFF);
        if (stringType == 0) {
            return QualityStringRenderer.pad(Integer.toBinaryString(n), 0);
        }
        if (stringType == 2) {
            return QualityStringRenderer.pad(Integer.toHexString(n), 2);
        }
        if (stringType == 1) {
            return QualityStringRenderer.pad(Integer.toOctalString(n), 1);
        }
        if (stringType == 3) {
            return Integer.toString(n);
        }
        if (stringType == 4) {
            StringBuffer qualString = new StringBuffer();
            if (Quality.isQualityClear(bytes)) {
                qualString.append(" * ");
            } else {
                if (Quality.isProtected(bytes)) {
                    qualString.append("P");
                } else {
                    qualString.append(" ");
                }
                if (Quality.isMissing(bytes)) {
                    qualString.append("M");
                }
                if (Quality.isReject(bytes)) {
                    qualString.append("R");
                }
                if (Quality.isQuestion(bytes)) {
                    qualString.append("Q");
                }
                if (qualString.length() == 1) {
                    qualString.append(" ");
                }
            }
            return qualString.toString();
        }
        if (stringType == 5) {
            StringBuilder qualString = new StringBuilder();
            if (Quality.isAccepted(bytes)) {
                qualString.append("A");
            } else if (Quality.isInterpolated(bytes)) {
                qualString.append("I");
            } else if (Quality.isKeyboardInput(bytes)) {
                qualString.append("K");
            } else if (Quality.isGraphicalEstimate(bytes)) {
                qualString.append("E");
            } else {
                qualString.append(" ");
            }
            return qualString.toString();
        }
        if (stringType == 6) {
            StringBuilder qualString = new StringBuilder();
            if (Quality.isAbsoluteMagnitude(bytes)) {
                qualString.append("AM");
            }
            if (Quality.isConstantValue(bytes)) {
                if (qualString.length() > 0) {
                    qualString.append(",");
                }
                qualString.append("CV");
            }
            if (Quality.isRateOfChange(bytes)) {
                if (qualString.length() > 0) {
                    qualString.append(",");
                }
                qualString.append("RC");
            }
            if (Quality.isRelativeMagnitude(bytes)) {
                if (qualString.length() > 0) {
                    qualString.append(",");
                }
                qualString.append("RM");
            }
            if (Quality.isDurationMagnitude(bytes)) {
                if (qualString.length() > 0) {
                    qualString.append(",");
                }
                qualString.append("DM");
            }
            if (Quality.isNegativeIncremental(bytes)) {
                if (qualString.length() > 0) {
                    qualString.append(",");
                }
                qualString.append("NI");
            }
            if (Quality.isGageList(bytes)) {
                if (qualString.length() > 0) {
                    qualString.append(",");
                }
                qualString.append("GL");
            }
            if (Quality.isUserDefinedTest(bytes)) {
                if (qualString.length() > 0) {
                    qualString.append(",");
                }
                qualString.append("UD");
            }
            if (Quality.isDistributionTest(bytes)) {
                if (qualString.length() > 0) {
                    qualString.append(",");
                }
                qualString.append("DS");
            }
            return qualString.toString();
        }
        return Integer.toHexString(n);
    }

    public static String toBinaryStringFromBytes(byte[] bytes) {
        int i = Quality.getInteger(bytes);
        return QualityStringRenderer.pad(Integer.toBinaryString(i), 0);
    }

    static String pad(String string, int stringType) {
        int[] shouldBe = new int[]{32, 11, 8};
        if (stringType == 3) {
            return string;
        }
        int have = string.length();
        int need = shouldBe[stringType] - have;
        return Quality.PADDING[need] + string;
    }

    public static String getHtmlStringDescription(int intQuality) {
        return QualityStringRenderer.getStringDescription(intQuality, ", ", "<br>");
    }

    public static String getStringDescription(int intQuality) {
        return QualityStringRenderer.getStringDescription(intQuality, ", ", "\n");
    }

    private static String getStringDescription(int intQuality, String delimiter, String linebreak) {
        byte[] bytes = new byte[4];
        bytes[3] = (byte)(intQuality & 0xFF);
        bytes[2] = (byte)(intQuality >> 8 & 0xFF);
        bytes[1] = (byte)(intQuality >> 16 & 0xFF);
        bytes[0] = (byte)(intQuality >> 24 & 0xFF);
        if (Quality.isQualityClear(bytes)) {
            return "Quality is not set";
        }
        StringBuilder sb = new StringBuilder();
        QualityStringRenderer.checkPrimaryBits(sb, bytes, delimiter);
        QualityStringRenderer.checkRevisionBits(sb, bytes, linebreak);
        QualityStringRenderer.checkTestBits(sb, bytes, linebreak);
        if (Quality.isProtected(bytes)) {
            if (sb.length() > 0) {
                sb.append(linebreak);
            }
            sb.append("PROTECTED from change or replacement");
        }
        return sb.toString();
    }

    private static void appendTextWithDelimeter(StringBuilder sb, String delimeter, String text) {
        if (sb.length() > 0) {
            sb.append(delimeter);
        }
        sb.append(text);
    }

    private static void checkPrimaryBits(StringBuilder sb, byte[] bytes, String delimiter) {
        if (Quality.isScreened(bytes)) {
            sb.append("Screened");
        } else {
            sb.append("Not Screened");
        }
        if (Quality.isOkay(bytes)) {
            QualityStringRenderer.appendTextWithDelimeter(sb, delimiter, "Passed tests OK");
        }
        if (Quality.isMissing(bytes)) {
            QualityStringRenderer.appendTextWithDelimeter(sb, delimiter, "Set to Missing");
        }
        if (Quality.isQuestion(bytes)) {
            QualityStringRenderer.appendTextWithDelimeter(sb, delimiter, "Questionable Quality");
        }
        if (Quality.isReject(bytes)) {
            QualityStringRenderer.appendTextWithDelimeter(sb, delimiter, "Rejected Quality");
        }
    }

    private static void checkRevisionBits(StringBuilder sb, byte[] bytes, String linebreak) {
        if (Quality.isRange1(bytes)) {
            QualityStringRenderer.appendTextWithDelimeter(sb, linebreak, "Value is between first and second range limit");
        }
        if (Quality.isRange2(bytes)) {
            QualityStringRenderer.appendTextWithDelimeter(sb, linebreak, "Value is between second and third range limit");
        }
        if (Quality.isRange3(bytes)) {
            QualityStringRenderer.appendTextWithDelimeter(sb, linebreak, "Value is above third range limit");
        }
        if (Quality.isDifferentValue(bytes)) {
            QualityStringRenderer.appendTextWithDelimeter(sb, linebreak, "Current value is different from original value");
        }
        if (Quality.isRevisedAutomatically(bytes)) {
            QualityStringRenderer.appendTextWithDelimeter(sb, linebreak, "Revised automatically by DATCHK or other Process");
        }
        if (Quality.isRevisedInteractively(bytes)) {
            QualityStringRenderer.appendTextWithDelimeter(sb, linebreak, "Revised interactively with DATVUE or CWMS Verification Editor");
        }
        if (Quality.isRevisedManually(bytes)) {
            QualityStringRenderer.appendTextWithDelimeter(sb, linebreak, "Manual entry with DATVUE or CWMS Verification Editor");
        }
        if (Quality.isRevisedToOriginalAccepted(bytes)) {
            QualityStringRenderer.appendTextWithDelimeter(sb, linebreak, "Original value accepted in DATVUE or CWMS Verification Editor");
        }
        if (Quality.isReplaceLinearInterpolation(bytes)) {
            QualityStringRenderer.appendTextWithDelimeter(sb, linebreak, "Replacement method: linear interpolation");
        }
        if (Quality.isReplaceManualChange(bytes)) {
            QualityStringRenderer.appendTextWithDelimeter(sb, linebreak, "Replacement method: manual change");
        }
        if (Quality.isReplaceWithMissing(bytes)) {
            QualityStringRenderer.appendTextWithDelimeter(sb, linebreak, "Replacement method: replace with missing value");
        }
        if (Quality.isReplaceGraphicalChange(bytes)) {
            QualityStringRenderer.appendTextWithDelimeter(sb, linebreak, "Replacement method: graphical change");
        }
    }

    private static void checkTestBits(StringBuilder sb, byte[] bytes, String linebreak) {
        if (Quality.isAbsoluteMagnitude(bytes)) {
            QualityStringRenderer.appendTextWithDelimeter(sb, linebreak, "Failed Test: Absolute Magnitude");
        }
        if (Quality.isConstantValue(bytes)) {
            QualityStringRenderer.appendTextWithDelimeter(sb, linebreak, "Failed Test: Constant Value");
        }
        if (Quality.isRateOfChange(bytes)) {
            QualityStringRenderer.appendTextWithDelimeter(sb, linebreak, "Failed Test: Rate-of-change");
        }
        if (Quality.isRelativeMagnitude(bytes)) {
            QualityStringRenderer.appendTextWithDelimeter(sb, linebreak, "Failed Test: Relative Magnitude");
        }
        if (Quality.isDurationMagnitude(bytes)) {
            QualityStringRenderer.appendTextWithDelimeter(sb, linebreak, "Failed Test: Duration-magnitude");
        }
        if (Quality.isNegativeIncremental(bytes)) {
            QualityStringRenderer.appendTextWithDelimeter(sb, linebreak, "Failed Test: Negative Incremental Value");
        }
        if (Quality.isGageList(bytes)) {
            QualityStringRenderer.appendTextWithDelimeter(sb, linebreak, "Failed Test: On GAGE list as faulty gage");
        }
        if (Quality.isUserDefinedTest(bytes)) {
            QualityStringRenderer.appendTextWithDelimeter(sb, linebreak, "Failed Test: User-defined Test");
        }
        if (Quality.isDistributionTest(bytes)) {
            QualityStringRenderer.appendTextWithDelimeter(sb, linebreak, "Failed Test: Distribution Test");
        }
    }

    static {
        LIGHT_RED = new Color(255, 90, 90);
        LIGHT_BLUE = new Color(0, 200, 255);
        LIGHT_CYAN = new Color(150, 255, 255);
        LIGHT_GREEN = new Color(150, 255, 150);
        LIGHT_MAGENTA = new Color(255, 125, 255);
        LIGHT_PINK = new Color(255, 210, 210);
        LIGHT_YELLOW = new Color(255, 255, 150);
        LIGHT_ORANGE = new Color(255, 200, 125);
        PURPLE = new Color(128, 0, 128);
        previousColorMap = null;
        HashMap<String, String> bgColorMap = new HashMap<String, String>();
        bgColorMap.put("A", "darkgreen");
        bgColorMap.put("*", "blue");
        bgColorMap.put("Q", "yellow");
        bgColorMap.put("R", "red");
        bgColorMap.put("M", "black");
        bgColorMap.put("P", "cyan");
        bgColorMap.put("I", "lightpurple");
        bgColorMap.put("K", "purple");
        bgColorMap.put("E", "darkpurple");
        SYMBOLIC_BG_COLOR_MAP = Collections.unmodifiableMap(bgColorMap);
        HashMap<String, String> fgColorMap = new HashMap<String, String>();
        fgColorMap.put("A", "white");
        fgColorMap.put("*", "white");
        fgColorMap.put("Q", "black");
        fgColorMap.put("R", "white");
        fgColorMap.put("M", "white");
        fgColorMap.put("P", "black");
        fgColorMap.put("I", "white");
        fgColorMap.put("K", "white");
        fgColorMap.put("E", "white");
        symbolicFgColorMap = Collections.unmodifiableMap(fgColorMap);
    }
}

